
/* Generated by Interface Builder */

#import <appkit/View.h>
#import <appkit/Application.h>
#import <appkit/PrintInfo.h>
#import <dpsclient/wraps.h>
#import <appkit/Font.h>
#import <appkit/FontManager.h>
#import <appkit/publicWraps.h>  /* for NXBeep */

@interface PlotView:View
{
  id     plotParam;
  id     theFontManager;
  id     newLegendFont;
  id     newLegendTitleFont;
  id     newXTitleFont;
  id     newYTitleFont;
  id     newMainTitleFont;
  id     newTicLabelFont;
  float  ppxunit, ppyunit;	/* pixels per xunit, pixels per y unit */
  float  xlegend[2], **ylegend;	/* for legend drawing (fixed dimension here) */
  BOOL   drawingLegendLines;
  NXRect legendbox;
}

- initializeLegendBox;
- clear:sender;
- initPlot:sender;
- setDrawColor:(float) color;
- drawLines:sender :(BOOL)xaxislog :(BOOL)yaxislog;
- drawSymbols:sender :(BOOL)xaxislog :(BOOL)yaxislog;
- drawLegend:sender;
- drawTicMarks:(float)xmin :(float)xmax :(float)ymin :(float)ymax;
- initLegend:sender;
- doPrinting:sender;
- (NXCoord *)xdata:(int)n;	/* provide data for drawing the curves */
- (NXCoord **)ydata:(int)n;	/* and symbols in the legend box       */
- (int)nPoints:(int)n;		/* provide no. of points to use in legend drawing */
- (int)nCurves:(int)n;
- (int)nFiles;

- provideMainTitleFont;
- provideXTitleFont;
- provideYTitleFont;
- provideLegendFont;
- provideLegendTitleFont;
- provideTicLabelFont;
- (NXPoint) provideLegendBoxOrigin;
- provideWindowFrame:(NXRect *)windowframe;
- forceWindowFrame:(NXRect *)windowframe;

- forceLegendBoxOrigin: (NXPoint)point;

- forceMainTitleFont:(char *)fontname :(float)fontsize;
- forceXTitleFont:(char *)fontname :(float)fontsize;
- forceYTitleFont:(char *)fontname :(float)fontsize;
- forceLegendFont:(char *)fontname :(float)fontsize;
- forceLegendTitleFont:(char *)fontname :(float)fontsize;
- forceTicLabelFont:(char *)fontname :(float)fontsize;

// Any subclass of View needs to implement its own drawSelf method
- drawSelf: (const NXRect *)rects :(int)rectCount;

/*
 * We implement the mouseDown method to allow zooming and also to allow
 * moving the legend box.  We lean heavily on the code in the
 * /NextDeveloper/Examples/Mandelbrot directory.
 */
- mouseDown:(NXEvent *)e;

- savePSCode:(char *)aFile;

@end
