/*	deobjc - remove the call to objc-init from the header of a Mach program.

	Written by Bill Spitzak.

	Current algorithim is to search for the first arrangmement of:

   		beq +6
		bsrl _objcInit
		clrl _errno

   replaces the beq and bsrl with nop's.  Of course the locations of
   _objcInit and _errno can change, so only the instructions are looked
   for.
*/

#include "port.h"

#define NOP 0x4e71

#define BUFFSIZE 0x1000	/* must be big enough to contain pointer */
char buf[BUFFSIZE];

main(argc,argv)
	int argc;
	char *argv[];
	{
	int fd,len;
	short unsigned *ptr;

	if (argc < 2) {
		puts("Remove call to _objcInit from a compiled program.\n");
		exit(1);
		}

	fd = open(argv[1],UPDATE);
	if (fd < 0) {
		printf("Can't open '%s' for read/write\n",argv[1]);
		exit(1);
		}

	len = read(fd,buf,BUFFSIZE);
	ptr = (short unsigned *)(buf+0x200); /* skip Mach header */
	for (;;) {
		if (ptr >= (short unsigned *)(buf+len)) {
			printf("No match for the code found.\n");
			break;
			}
		if (*ptr==0x6706 && *(ptr+1)==0x61FF && *(ptr+4)==0x42B9) {
			*ptr = *(ptr+1) = *(ptr+2) = *(ptr+3) = NOP;
			printf("Patching at 0x%x\n",(void *)ptr-(void *)buf);
			lseek(fd,0,0);
			write(fd,buf,len);
			break;
			}
		ptr++;
		}
	close(fd);
	}
