/* EPS file previewer using the DPS library */

#include <dpsclient/dpsclient.h>

void printjunk(DPSContext ctxt, const char *buf, long unsigned int count)
	{
	unsigned char c;
	while (count--) {
		c = *buf++;
		if (c < ' ' && c != '\n') {putchar('^'); c ^= 0x40;}
		putchar(c);
		}
	putchar('\n');
	}

void myerrorproc(
	DPSContext ctxt,
	DPSErrorCode errorCode,
	long unsigned int arg1,
	long unsigned int arg2)
	{
	printf("Error %d",errorCode);
	printjunk(ctxt,(char *)arg1,(long unsigned)arg2);
	}

main(argc,argv)
	int argc;
	char **argv;
	{
	DPSContext d;
	int fd,l,x,llx,lly,urx,ury,inches,i,windows;
	char *p, *e, buf[129], *fname;
	float scale;
	NXEvent event;
	if (argv[1] && argv[1][0] == '-') {i=2; inches=atoi(argv[1]+1);}
	else {i=1; inches=0;}
	if (i>=argc) {
		printf("Display postscript in window:\n%s [-inches] <files>\n",argv[0]); exit(1);}
	d = DPSCreateContext(0,0,printjunk,myerrorproc);
	DPSPrintf(d,"/showpage {initgraphics} bind def\n"
	"/WDICT true setshared 1 dict dup /level 0 put false setshared def\n");
	windows = 0;
	for (; i < argc; i++) {
	fname = argv[i];
	fd = open(fname,0);
	if (fd<0) {printf("Can't open %s\n",fname); continue;}
	printf("%s - ",fname);
	e = buf+read(fd,buf,128);
	llx=lly=0; urx=612; ury=792;
	if (buf[0] != '%' || buf[1] != '!') {
		printf("not an EPS file.\n");
		goto DONE;
		}
	p = buf;
	while(1) {
		while (p<e && *p != '%') p++;
		if (p > e-80) {
			x = e-p;
			memmove(buf,p,x);
			e = buf+x+read(fd,buf+x,128-x); *e = 0;
			p = buf;
			if (p >= e) {printf("missing %%BoundingBox.\n"); goto DONE;}
			}
		if (strisub("%%boundingbox:",p)) break;
		p++;
		}
	while ((*p < '0' || *p > '9') && *p != '-') p++;
	e = p; while (*p > ' ') p++; *p = 0;
	llx = atoi(e);
	while ((*p < '0' || *p > '9') && *p != '-') p++;
	e = p; while (*p > ' ') p++; *p = 0;
	lly = atoi(e);
	while ((*p < '0' || *p > '9') && *p != '-') p++;
	e = p; while (*p > ' ') p++; *p = 0;
	urx = atoi(e);
	while ((*p < '0' || *p > '9') && *p != '-') p++;
	e = p; while (*p > ' ') p++; *p = 0;
	ury = atoi(e);
	printf("%%BoundingBox %d %d %d %d\n",llx,lly,urx,ury);
	if (urx<=llx) urx = llx+612;
	if (ury<=lly) ury = lly+792;
DONE:
	urx-=llx; ury-=lly;
	scale = inches ? (float)(72*inches)/(float)max(urx,ury) : 1.0;
	lseek(fd,0L,0);
	windows++;
	DPSPrintf(d,"%d dup %f %f 0 window\n"
			"dup WDICT exch setwindowdict\n"
			"windowdeviceround\n"
			"1 0 currentwindow orderwindow\n",
			windows*20,urx*scale,ury*scale);
	DPSPrintf(d,"0 1 %f %f rectstroke\n",urx*scale-1,ury*scale-1);
	DPSPrintf(d,"%f dup scale\n",scale);
	DPSPrintf(d,"%d currentwindow seteventmask\n",
		NX_LMOUSEDOWNMASK+NX_RMOUSEDOWNMASK);
	DPSPrintf(d,"%d %d translate\n",-llx,-lly);
	while ((l=read(fd,buf,128))>0) DPSWriteData(d,buf,l);
	DPSPrintf(d,"\n"); /* fix files that don't end with whitespace */
	close(fd);
	}
	while (windows) {
		DPSFlushContext(d);
		DPSGetEvent(d,&event,-1,NX_FOREVER,0);
		if (event.type == NX_RMOUSEDOWN) {
			DPSPrintf(d,"%d termwindow\n",event.window);
			windows--;
			}
		else if (event.type == NX_LMOUSEDOWN) {
			DPSPrintf(d,
			"1 0 %d orderwindow\n"
			"{%d stilldown not {exit} if\n"
			"deskWin currentmouse %g sub exch %g sub exch\n"
			"%d movewindow} loop\n",
			event.window,event.data.mouse.eventNum,
			event.location.y,event.location.x,event.window);
			}
		}
	DPSDestroyContext(d);
	}

tolower(c) {return ((c>='A' && c<='Z') ? c+'a'-'A' : c);}

strisub(a,b)			/* Check for substring, case independent */
	char *a, *b;
	{
	while (*a) {
		if (!*b || tolower(*a)!=tolower(*b)) return(0);
		++a;
		++b;
		}
	return(1);
	}

max(a,b) {return(a>b?a:b);}
