/*	PostScript tester using the DPS library */

/*	If you want to test drawing, first type
	"x y width height newwindow".
	This will make a movable, orderable window, placed below
	everything else.  The window is "retained" and thus all drawing
	appears in it immediately.
*/

#include <dpsclient/dpsclient.h>

void printjunk(DPSContext ctxt, const char *buf, long unsigned int count)
{
	unsigned char c;
	while (count--) {
		c = *buf++;
		if (c < ' ' && c != '\n') {putchar('^'); c ^= 0x40;}
		putchar(c);
		}
	}

void myerrorproc(
  DPSContext ctxt,
  DPSErrorCode errorCode,
  long unsigned int arg1,
  long unsigned int arg2 )
{
	printf("Error %d",errorCode);
	printjunk(ctxt,(char *)arg1,(long unsigned)arg2);
	putchar('\n');
	}

const char *enames[] = {
	"NULLEVENT",
	"LMOUSEDOWN",
	"LMOUSEUP",
	"RMOUSEDOWN",
	"RMOUSEUP",
	"MOUSEMOVED",
	"LMOUSEDRAGGED",
	"RMOUSEDRAGGED",
	"MOUSEENTERED",
	"MOUSEEXITED",
	"KEYDOWN",
	"KEYUP",
	"FLAGSCHANGED",
	"KITDEFINED",
	"SYSDEFINED",
	"APPDEFINED",
	"TIMER",
	"CURSORUPDATE",
	"RESERVEDEVENT3",
	"RESERVEDEVENT4",
	"RESERVEDEVENT5",
	"RESERVEDEVENT6",
	"RESERVEDEVENT7",
	"RESERVEDEVENT8",
	"RESERVEDEVENT9",
	"RESERVEDEVENT10",
	"RESERVEDEVENT11",
	"RESERVEDEVENT12",
	"RESERVEDEVENT13",
	"RESERVEDEVENT14",
	"RESERVEDEVENT15",
	"RESERVEDEVENT16"};

void reportevent(NXEvent *e)
{
	char *c;
	if (e->type < 0 || e->type > 31)
		{printf("Event # %d, ",e->type); c="UNKNOWN";}
	else c = enames[e->type];
	printf("%s at %g %g, flags %x, window %d, ",
		  c,e->location.x,e->location.y,e->flags,e->window);
	switch(e->type) {
	case NX_NULLEVENT : break;
	case NX_LMOUSEDOWN :
	case NX_LMOUSEUP :
	case NX_RMOUSEDOWN :
	case NX_RMOUSEUP :
	case NX_MOUSEMOVED :
	case NX_LMOUSEDRAGGED :
	case NX_RMOUSEDRAGGED :
		printf("ev# %d, click %d",
			  e->data.mouse.eventNum,e->data.mouse.click);
		break;
	case NX_KEYDOWN :
	case NX_KEYUP :
	case NX_FLAGSCHANGED :
		printf("repeat %d, set %x, code %x, key %x",
			  e->data.key.repeat,e->data.key.charSet,e->data.key.charCode,e->data.key.keyCode);
		break;
	case NX_MOUSEENTERED :
	case NX_MOUSEEXITED :
		printf("ev# %d, trackingNum %d, userData %d",
			  e->data.tracking.eventNum,e->data.tracking.trackingNum,e->data.tracking.userData);
		break;
	default:
		printf("%g %g (%lX %lX)",
			  e->data.compound.misc.F[0],
			  e->data.compound.misc.F[1],
			  e->data.compound.misc.L[0],
			  e->data.compound.misc.L[1]);
		break;
		}
	printf(".\n");
	}

DPSContext d;

void typedtext(int fd, void *userData) {
	char line[128];
	if (!gets(line)) {DPSDestroyContext(d); exit(0);}
	DPSWriteData(d,line,strlen(line));
	DPSWriteData(d,"\n",1);
	DPSFlushContext(d);
	}

main() {
	NXEvent e;
	d = DPSCreateContext(0,0,printjunk,myerrorproc);

	DPSPrintf(d,
	/* WindowPackage1.0 redefines orderwindow.  Fix it, and others they
	   may try to patch: */
	"/FIX {dup systemdict exch get def} bind def\n"
	"/orderwindow FIX\n"
	"/seteventmask FIX\n"
	"/setwindowdict FIX\n"
	"/termwindow FIX\n"
	"/window FIX\n"
	/* A "windowdict" to use.  Without this, due to bugs in the WindowPackage
	   code, AppKit programs will reorder unpredictably! */
	"/WDICT true setshared 1 dict dup /level 0 put false setshared def\n"
			);

	/* Define useful procedure to make a sketching window: */
	DPSPrintf(d,"/newwindow {0 window windowdeviceround\n"
			"1 0 currentwindow orderwindow\n"
			"%d currentwindow seteventmask\n"
			"0 1 currentwindow currentwindowbounds\n"
			"4 -2 roll pop pop exch 1 sub exch 1 sub rectstroke\n"
			"} bind def\n",
			NX_LMOUSEDOWNMASK);

	DPSFlushContext(d);
	DPSAddFD(1,typedtext,0,0);

	for (;;) {
		DPSGetEvent(d,&e,-1,NX_FOREVER,0);
		if (e.type == NX_LMOUSEDOWN) {
			DPSPrintf(d,"1 0 %d orderwindow "
					"{%d stilldown not {exit} if\n"
					"deskWin currentmouse %g sub exch %g sub exch\n"
					"%d movewindow} loop\n",
					e.window,e.data.mouse.eventNum,
					e.location.y,e.location.x,e.window);
			}
		else reportevent(&e);
		}
/*	DPSDestroyContext(d); */
	}
