#import <objc/Object.h>

#define NUMNOTES 4

@interface SoundGenerator : Object
{
   id orchestra, instrument, ampEnvelope, notes[NUMNOTES];
   int currentNote;
   double freqMultiplier;
   id soundSettingsPanel;

   // Connect the following through IB to target-action objects.
   id ratioOutput;
   id indexOutput;
   id decayOutput;
   id attackOutput;
   id freqMulOutput;
   id ratioInput;
   id indexInput;
   id decayInput;
   id attackInput;
   id freqMulInput;
}

- init;
-(BOOL) enable;
- disable;
- free;
- shutUp;

- changeAttackParameter:(double)newAttack;
- changeDecayParameter:(double)newDecay;
- changeFreqMultiplierParameter:(double)newMultiplier;
- changeParameter:(int)param toDouble:(double)value;
- playNoteAtFreq:(double)freq;

// Connected to target-action input devices (sliders, perhaps?)
- play:sender;          // Plays a note at sender's double value
- changeState:sender;   // Calls enable or disable depending on sender state
- changeRatio:sender;   
- changeIndex:sender;
- changeDecay:sender;
- changeAttack:sender;
- changeFreqMul:sender;

- showSoundSettings:sender;

@end

