
/* Generated by Interface Builder */

#import <libc.h>

#import "LockMgr.h"
#import "ScreenLock.h"

#import <appkit/defaults.h>
#import <appkit/Panel.h>
#import <appkit/Control.h>
#import <appkit/Application.h>

// Problem:  I can't seem to put this header file anywhere but the end!

#import <nextdev/evsio.h>


void idleTimerProc ( DPSTimedEntry teNumber, double now, char *userData )
{
	[ (id) userData idle ] ;
	return ;
}


@implementation LockMgr

- init
{
	static NXDefaultsVector	SentinelDefaults =
							{
								{ "DimTime", "5" },
								{ "AutoLock", "NO" },
								{ "RequirePassword", "YES" },
								{ NULL }
							} ;

	NXRegisterDefaults ( "Sentinel", SentinelDefaults ) ;
	maxIdleTime = atoi ( NXGetDefaultValue ( "Sentinel", "DimTime" ) ) ;
	autoLock = ! strcmp ( NXGetDefaultValue ( "Sentinel", "AutoLock" ), "YES" ) ;
	requirePassword = ! strcmp ( NXGetDefaultValue ( "Sentinel", "RequirePassword" ), "YES" ) ;
	lastDimDestiny = 0 ;

	evsDriver = open ( "/dev/evs0", O_RDONLY ) ;
	timedEntry = DPSAddTimedEntry ( 60.0, (DPSTimedEntryProc) idleTimerProc, (void *) self,
			NX_MODALRESPTHRESHOLD ) ;

	return [ super init ] ;
}


- free
{
	close ( evsDriver ) ;
	DPSRemoveTimedEntry ( timedEntry ) ;
	return [ super free ] ;
}


- ok: sender
{
	char				idleString [ 4 ] ;
	char				autoString [ 4 ] ;
	char				pwordString [ 4 ] ;
	NXDefaultsVector	SentinelDefaults =
					{
						{ "DimTime", idleString },
						{ "AutoLock", autoString },
						{ "RequirePassword", pwordString },
						{ NULL }
					} ;

	autoLock = [ NXGetNamedObject ( "AutoLock", prefsPanel ) intValue ] ;
	requirePassword = [ NXGetNamedObject ( "RequirePassword", prefsPanel ) intValue ] ;
	maxIdleTime = [ NXGetNamedObject ( "Box_IdleSlider", prefsPanel ) intValue ] ;

	sprintf ( idleString, "%d", maxIdleTime ) ;
	strcpy ( autoString, autoLock ? "YES" : "NO" ) ;
	strcpy ( pwordString, requirePassword ? "YES" : "NO" ) ;
	NXWriteDefaults ( "Sentinel", SentinelDefaults ) ;

	[ NXGetNamedObject ( "Revert", prefsPanel ) setEnabled: NO ] ;
	[ NXGetNamedObject ( "OK", prefsPanel ) setEnabled: NO ] ;
	[ prefsPanel orderOut: self ] ;

	lastDimDestiny = 0 ;

	return self ;
}


- revert: sender
{
	[ NXGetNamedObject ( "AutoLock", prefsPanel ) setIntValue: autoLock ] ;
	[ NXGetNamedObject ( "RequirePassword", prefsPanel ) setIntValue: requirePassword ] ;
	[ NXGetNamedObject ( "Box_IdleSlider", prefsPanel ) setIntValue: maxIdleTime ] ;
	[ NXGetNamedObject ( "Box_IdleField", prefsPanel ) setIntValue: maxIdleTime ] ;

	[ NXGetNamedObject ( "Revert", prefsPanel ) setEnabled: NO ] ;
	[ NXGetNamedObject ( "OK", prefsPanel ) setEnabled: NO ] ;
	[ prefsPanel makeKeyAndOrderFront: self ] ;

	lastDimDestiny = 0 ;

	return self ;
}

- changeSetting: sender
{
	switch ( [ sender tag ] )
	{
		case 1:
		{
			[ NXGetNamedObject ( "Box_IdleField", prefsPanel ) setIntValue:
					[ NXGetNamedObject ( "Box_IdleSlider", prefsPanel ) intValue ] ] ;
			break ;
		}
		
		case 2:
		{
			[ NXGetNamedObject ( "Box_IdleSlider", prefsPanel ) setIntValue:
					[ NXGetNamedObject ( "Box_IdleField", prefsPanel ) intValue ] ] ;
			break ;
		}
	}
	[ NXGetNamedObject ( "Revert", prefsPanel ) setEnabled: YES ] ;
	[ NXGetNamedObject ( "OK", prefsPanel ) setEnabled: YES ] ;
	return self ;
}


- idle
{
	int	currentDimDestiny ;

	if ( [ screenLock isLocked ] )
	{
		idleTime = 0 ;
		return self ;
	}
	
	ioctl ( evsDriver, EVSIOGADT, &currentDimDestiny ) ;
	if ( currentDimDestiny == lastDimDestiny )
	{
		idleTime++ ;
	}
	else
	{
		idleTime = 0 ;
	}
	if ( ( autoLock ) && ( idleTime >= maxIdleTime ) )
	{
		[ screenLock lock: self ] ;
	}
	lastDimDestiny = currentDimDestiny ;
	return self ;
}


- (BOOL) requirePassword
{
	return requirePassword ;
}

@end
