
/* Generated by Interface Builder */

#import <libc.h>
#import <pwd.h>
#import <time.h>

#import <appkit/publicWraps.h>
#import <appkit/MenuCell.h>
#import <appkit/Panel.h>
#import <appkit/Application.h>

#import "LockMgr.h"
#import "ScreenLock.h"
#import "ScreenLockPS.h"
#import "nppow.h"

void fadeTimerProc ( DPSTimedEntry teNumber, double now, char *userData )
{
	[ (id) userData timer ] ;
	return ;
}


@implementation ScreenLock

- lock: sender
{
	struct tm			* theTime ;
	time_t			lowLevelTime ;
	char				subTitle [ 128 ] ;
	char				userTitle [ 128 ] ;
	struct passwd		* userInfo ;

	if ( ! ( userInfo = getpwuid ( getuid ( ) ) ) )
	{
		NXRunAlertPanel ( "FAILED", "Can't get user information", "OK", NULL, NULL ) ;
		return self ;
	}
	lowLevelTime = time ( 0 ) ;
	srandom ( lowLevelTime ) ;
	theTime = localtime ( &lowLevelTime ) ;

	sprintf ( subTitle, "as of %d:%02d:%02d %cm",
			theTime->tm_hour % 12 ? theTime->tm_hour % 12 : 12,
			theTime->tm_min,
			theTime->tm_sec,
			theTime->tm_hour < 12 ? 'a' : 'p' ) ;
	sprintf ( userTitle, "User %s logged in...", userInfo->pw_gecos ) ;
	PSLockInit ( subTitle, userTitle,
		[ lockMgr requirePassword ] ? "Enter password to unlock system" :
		"Press a key to unlock system" ) ;
	passwordChars = 0 ;
	[ NXApp activateSelf: YES ] ;
	[ waitWindow makeKeyAndOrderFront: self ] ;
	[ waitWindow makeFirstResponder: self ] ;
	
	lastx = 260 ;
	lasty = 376 ;
	PSFadeIn ( lastx, lasty ) ;
	timedEntry = DPSAddTimedEntry ( 5.0, (DPSTimedEntryProc) fadeTimerProc, (void *) self,
			NX_MODALRESPTHRESHOLD ) ;
	[ quitOption setEnabled: NO ] ;
	[ lockOption setEnabled: NO ] ;
	[ hideOption setEnabled: NO ] ;
	isLocked = YES ;
	return self ;
}


- unlock: sender
{
	DPSRemoveTimedEntry ( timedEntry ) ;
	[ waitWindow orderOut: self ] ;
	PSLockEnd ( ) ;
	[ quitOption setEnabled: YES ] ;
	[ lockOption setEnabled: YES ] ;
	[ hideOption setEnabled: YES ] ;
	isLocked = NO ;
	return self ;
}


- (BOOL) isLocked
{
	return isLocked ;
}


- keyDown: (NXEvent *) theEvent
{
	char		theChar = theEvent->data.key.charCode ;

	if ( ! [ lockMgr requirePassword ] )
	{
		[ self unlock: self ] ;
		return self ;
	}
	
	switch ( theChar )
	{
		case 8:
		case 127:
		{
			if ( passwordChars )
			{
				passwordChars-- ;
			} 
			break ;
		}
		
		case 13:
		{
			struct passwd		* userInfo ;
			char				* encoded ;

			if ( userInfo = getpwuid ( getuid ( ) ) )
			{
				password [ passwordChars ] = 0 ;
				encoded = crypt ( password, userInfo->pw_passwd ) ;
				if ( ! strcmp ( encoded, userInfo->pw_passwd ) )
				{
					[ self unlock: self ] ;
				}
				else
				{
					NXBeep ( ) ;
				}
			}
			else
			{
				[ self unlock: self ] ;
				NXRunAlertPanel ( "FAILED", "Can't get user information", "OK", NULL, NULL ) ;
			}
			passwordChars = 0 ;
			break ;
		}
		
		default:
		{
			if ( ( theChar >= 32 ) && ( passwordChars < 127 ) )
			{
				password [ passwordChars++ ] = theChar ;
			}
			break ;
		}
	}
	return self ;
}


- (BOOL) acceptsFirstResponder
{
	return YES ;
}


- timer
{
	[ NXApp activateSelf: YES ] ;
	[ waitWindow makeKeyAndOrderFront: self ] ;
	[ waitWindow makeFirstResponder: self ] ;
	PSFadeOut ( lastx, lasty ) ;
	lastx = random ( ) % 520 ;
	lasty = random ( ) % 752 ;
	PSFadeIn ( lastx, lasty ) ;
	return self ;
}

- printerOFF:sender
{
    nppoweroff();
    return self;
}
@end
