/*	$NetBSD: crl.c,v 1.2 2021/08/14 16:14:51 christos Exp $	*/

/*
 *    crl.c
 *    "CertificateRevokationList" ASN.1 module encode/decode/extracting/matching/free C src.
 *    This file was generated by modified eSMACC compiler Fri Jan 21 11:25:24 2005
 *    The generated files are supposed to be compiled as a module for OpenLDAP Software
 */

#include "crl.h"

BDecComponentCertificateListTop( void* mem_op, GenBuf* b, void *v, AsnLen* bytesDecoded,int mode) {
	AsnTag tag;
	AsnLen elmtLen;

	tag = BDecTag ( b, bytesDecoded );
	elmtLen = BDecLen ( b, bytesDecoded );
	if ( elmtLen <= 0 ) return (-1);
	if ( tag != MAKE_TAG_ID (UNIV, CONS, SEQ_TAG_CODE) ) {
		return (-1);
	}
		
	return BDecComponentCertificateList( mem_op, b, tag, elmtLen, ( ComponentCertificateList**)v, (AsnLen*)bytesDecoded, mode );
}


void init_module_CertificateRevokationList() {
	InstallOidDecoderMapping( "2.5.4.39", NULL,
		GDecComponentCertificateList,
		BDecComponentCertificateListTop,
		ExtractingComponentCertificateList,
		MatchingComponentCertificateList);
}

int
MatchingComponentTBSCertListSeqOfSeq ( char* oid, ComponentSyntaxInfo* csi_attr, ComponentSyntaxInfo* csi_assert ) {
	int rc;
	MatchingRule* mr;

	if ( oid ) {
		mr = retrieve_matching_rule( oid, csi_attr->csi_comp_desc->cd_type_id);
		if ( mr ) return component_value_match( mr, csi_attr, csi_assert );
	}

	rc = 1;
	rc =	MatchingComponentCertificateSerialNumber ( oid, (ComponentSyntaxInfo*)&((ComponentTBSCertListSeqOfSeq*)csi_attr)->userCertificate, (ComponentSyntaxInfo*)&((ComponentTBSCertListSeqOfSeq*)csi_assert)->userCertificate );
	if ( rc != LDAP_COMPARE_TRUE )
		return rc;
	rc =	MatchingComponentTime ( oid, (ComponentSyntaxInfo*)((ComponentTBSCertListSeqOfSeq*)csi_attr)->revocationDate, (ComponentSyntaxInfo*)((ComponentTBSCertListSeqOfSeq*)csi_assert)->revocationDate );
	if ( rc != LDAP_COMPARE_TRUE )
		return rc;
	if(COMPONENTNOT_NULL( ((ComponentTBSCertListSeqOfSeq*)csi_attr)->crlEntryExtensions ) ) {
	rc =	MatchingComponentExtensions ( oid, (ComponentSyntaxInfo*)((ComponentTBSCertListSeqOfSeq*)csi_attr)->crlEntryExtensions, (ComponentSyntaxInfo*)((ComponentTBSCertListSeqOfSeq*)csi_assert)->crlEntryExtensions );
	if ( rc != LDAP_COMPARE_TRUE )
		return rc;
	}
	return LDAP_COMPARE_TRUE;
}  /* BMatchingComponentTBSCertListSeqOfSeq */

void*
ExtractingComponentTBSCertListSeqOfSeq ( void* mem_op, ComponentReference* cr, ComponentTBSCertListSeqOfSeq *comp )
{

	if ( ( comp->userCertificate.identifier.bv_val && strncmp(comp->userCertificate.identifier.bv_val, cr->cr_curr->ci_val.ci_identifier.bv_val,cr->cr_curr->ci_val.ci_identifier.bv_len) == 0 ) || ( strncmp(comp->userCertificate.id_buf, cr->cr_curr->ci_val.ci_identifier.bv_val,cr->cr_curr->ci_val.ci_identifier.bv_len) == 0 ) ) {
		if ( cr->cr_curr->ci_next == NULL )
		return &comp->userCertificate;
		else
		return NULL;
	}
	if ( ( comp->revocationDate->identifier.bv_val && strncmp(comp->revocationDate->identifier.bv_val, cr->cr_curr->ci_val.ci_identifier.bv_val,cr->cr_curr->ci_val.ci_identifier.bv_len) == 0 ) || ( strncmp(comp->revocationDate->id_buf, cr->cr_curr->ci_val.ci_identifier.bv_val,cr->cr_curr->ci_val.ci_identifier.bv_len) == 0 ) ) {
		if ( cr->cr_curr->ci_next == NULL )
			return comp->revocationDate;
		else {
			cr->cr_curr = cr->cr_curr->ci_next;
			return 	ExtractingComponentTime ( mem_op, cr, comp->revocationDate );
		}
	}
	if ( ( comp->crlEntryExtensions->identifier.bv_val && strncmp(comp->crlEntryExtensions->identifier.bv_val, cr->cr_curr->ci_val.ci_identifier.bv_val,cr->cr_curr->ci_val.ci_identifier.bv_len) == 0 ) || ( strncmp(comp->crlEntryExtensions->id_buf, cr->cr_curr->ci_val.ci_identifier.bv_val,cr->cr_curr->ci_val.ci_identifier.bv_len) == 0 ) ) {
		if ( cr->cr_curr->ci_next == NULL )
			return comp->crlEntryExtensions;
		else {
			cr->cr_curr = cr->cr_curr->ci_next;
			return 	ExtractingComponentExtensions ( mem_op, cr, comp->crlEntryExtensions );
		}
	}
	return NULL;
}  /* ExtractingComponentTBSCertListSeqOfSeq */

int
BDecComponentTBSCertListSeqOfSeq PARAMS ((b, tagId0, elmtLen0, v, bytesDecoded, mode),
void* mem_op _AND_
GenBuf * b _AND_
AsnTag tagId0 _AND_
AsnLen elmtLen0 _AND_
ComponentTBSCertListSeqOfSeq **v _AND_
AsnLen *bytesDecoded _AND_
int mode)
{
	int seqDone = FALSE;
	AsnLen totalElmtsLen1 = 0;
	AsnLen elmtLen1;
	AsnTag tagId1;
	int mandatoryElmtCount1 = 0;
	AsnLen totalElmtsLen2 = 0;
	AsnLen elmtLen2;
	AsnTag tagId2;
	int old_mode = mode;
	int rc;
	ComponentTBSCertListSeqOfSeq *k, *t, c_temp;


	if ( !(mode & DEC_ALLOC_MODE_1) ) {
		memset(&c_temp,0,sizeof(c_temp));
		 k = &c_temp;
	} else
		 k = t = *v;
	mode = DEC_ALLOC_MODE_2;
    tagId1 = BDecTag (b, &totalElmtsLen1 );

    if (((tagId1 == MAKE_TAG_ID (UNIV, PRIM, INTEGER_TAG_CODE))))
    {
    elmtLen1 = BDecLen (b, &totalElmtsLen1 );
	rc = BDecComponentCertificateSerialNumber (mem_op, b, tagId1, elmtLen1, (&k->userCertificate), &totalElmtsLen1, mode);
		if ( rc != LDAP_SUCCESS ) return rc;
		(&k->userCertificate)->identifier.bv_val = (&k->userCertificate)->id_buf;
		(&k->userCertificate)->identifier.bv_len = strlen("userCertificate");
		strcpy( (&k->userCertificate)->identifier.bv_val, "userCertificate");
    tagId1 = BDecTag (b, &totalElmtsLen1);
    }
    else
        return -1;



    if (((tagId1 == MAKE_TAG_ID (UNIV, PRIM, UTCTIME_TAG_CODE)) ||
(tagId1 == MAKE_TAG_ID (UNIV, CONS, UTCTIME_TAG_CODE)) ||
     (tagId1 ==MAKE_TAG_ID (UNIV, PRIM, GENERALIZEDTIME_TAG_CODE))||
    (tagId1 == MAKE_TAG_ID (UNIV, CONS, GENERALIZEDTIME_TAG_CODE))))
    {
        elmtLen1 = BDecLen (b, &totalElmtsLen1 );
	rc = BDecComponentTime (mem_op, b, tagId1, elmtLen1, (&k->revocationDate), &totalElmtsLen1, mode);
		if ( rc != LDAP_SUCCESS ) return rc;
		(k->revocationDate)->identifier.bv_val = (k->revocationDate)->id_buf;
		(k->revocationDate)->identifier.bv_len = strlen("revocationDate");
		strcpy( (k->revocationDate)->identifier.bv_val, "revocationDate");
    if ((elmtLen0 != INDEFINITE_LEN) && (totalElmtsLen1 == elmtLen0))
        seqDone = TRUE;
    else
    {
        tagId1 = BDecTag (b, &totalElmtsLen1 );

         if ((elmtLen0 == INDEFINITE_LEN) && (tagId1 == EOC_TAG_ID))
        {
            BDEC_2ND_EOC_OCTET (b, &totalElmtsLen1 )
            seqDone = TRUE;
        }
    }
    }
    else
        return -1;



    if ((!seqDone) && ((tagId1 == MAKE_TAG_ID (UNIV, CONS, SEQ_TAG_CODE))))
    {
    elmtLen1 = BDecLen (b, &totalElmtsLen1 );
	rc = BDecComponentExtensions (mem_op, b, tagId1, elmtLen1, (&k->crlEntryExtensions), &totalElmtsLen1, mode);
		if ( rc != LDAP_SUCCESS ) return rc;
		(k->crlEntryExtensions)->identifier.bv_val = (k->crlEntryExtensions)->id_buf;
		(k->crlEntryExtensions)->identifier.bv_len = strlen("crlEntryExtensions");
		strcpy( (k->crlEntryExtensions)->identifier.bv_val, "crlEntryExtensions");
        seqDone = TRUE;
        if (elmtLen0 == INDEFINITE_LEN)
            BDecEoc (b, &totalElmtsLen1 );
        else if (totalElmtsLen1 != elmtLen0)
        return -1;

    }


    if (!seqDone)
        return -1;

	if( !(old_mode & DEC_ALLOC_MODE_1) ) {
	*v = t = (ComponentTBSCertListSeqOfSeq*) CompAlloc( mem_op, sizeof(ComponentTBSCertListSeqOfSeq) );
	if ( !t ) return -1;
	*t = *k;
	}
	t->syntax = (Syntax*)NULL;
	t->comp_desc = CompAlloc( mem_op, sizeof( ComponentDesc ) );
	if ( !t->comp_desc ) {
		free ( t );
		return -1;
	}
	t->comp_desc->cd_ldap_encoder = (encoder_func*)NULL;
	t->comp_desc->cd_gser_encoder = (encoder_func*)NULL;
	t->comp_desc->cd_ber_encoder = (encoder_func*)NULL;
	t->comp_desc->cd_gser_decoder = (gser_decoder_func*)GDecComponentTBSCertListSeqOfSeq ;
	t->comp_desc->cd_ber_decoder = (ber_decoder_func*)BDecComponentTBSCertListSeqOfSeq ;
	t->comp_desc->cd_free = (comp_free_func*)NULL;
	t->comp_desc->cd_extract_i = (extract_component_from_id_func*)ExtractingComponentTBSCertListSeqOfSeq;
	t->comp_desc->cd_type = ASN_COMPOSITE;
	t->comp_desc->cd_type_id = COMPOSITE_ASN1_TYPE;
	t->comp_desc->cd_all_match = (allcomponent_matching_func*)MatchingComponentTBSCertListSeqOfSeq;
    (*bytesDecoded) += totalElmtsLen1;
	return LDAP_SUCCESS;
}  /* BDecTBSCertListSeqOfSeq*/

int
GDecComponentTBSCertListSeqOfSeq PARAMS (( mem_op,b, v, bytesDecoded, mode),
void* mem_op _AND_
GenBuf * b _AND_
ComponentTBSCertListSeqOfSeq **v _AND_
AsnLen *bytesDecoded _AND_
int mode)
{
	char* peek_head,*peek_head2;
	int i, strLen,strLen2, rc, old_mode = mode;
	ComponentTBSCertListSeqOfSeq *k,*t, c_temp;


	if ( !(mode & DEC_ALLOC_MODE_1) ) {
		memset(&c_temp,0,sizeof(c_temp));
		 k = &c_temp;
	} else
		 k = t = *v;
	mode = DEC_ALLOC_MODE_2;
	*bytesDecoded = 0;
	if( !(strLen = LocateNextGSERToken(mem_op,b,&peek_head,GSER_NO_COPY)) ){
		Asn1Error("Error during Reading { in encoded data");
		return LDAP_PROTOCOL_ERROR;
	}
	if(*peek_head != '{'){
		Asn1Error("Missing { in encoded data");
		return LDAP_PROTOCOL_ERROR;
	}

	if( !(strLen = LocateNextGSERToken(mem_op,b,&peek_head,GSER_NO_COPY)) ){
		Asn1Error("Error during Reading identifier");
		return LDAP_PROTOCOL_ERROR;
	}
	if ( strncmp( peek_head, "userCertificate", strlen("userCertificate") ) == 0 ) {
		rc = 	GDecComponentCertificateSerialNumber (mem_op, b, (&k->userCertificate), bytesDecoded, mode);
		if ( rc != LDAP_SUCCESS ) return rc;
	(&k->userCertificate)->identifier.bv_val = peek_head;
	(&k->userCertificate)->identifier.bv_len = strLen;
	if( !(strLen = LocateNextGSERToken(mem_op,b,&peek_head,GSER_NO_COPY)) ){
		Asn1Error("Error during Reading , ");
		return LDAP_PROTOCOL_ERROR;
	}
	if(*peek_head != ','){
		Asn1Error("Missing , in encoding");
		return LDAP_PROTOCOL_ERROR;
	}
	if( !(strLen = LocateNextGSERToken(mem_op,b,&peek_head,GSER_NO_COPY)) ){
	  Asn1Error("Error during Reading identifier");
		return LDAP_PROTOCOL_ERROR;
	}
	}
	if ( strncmp( peek_head, "revocationDate", strlen("revocationDate") ) == 0 ) {
		rc = 	GDecComponentTime (mem_op, b, (&k->revocationDate), bytesDecoded, mode);
		if ( rc != LDAP_SUCCESS ) return rc;
	( k->revocationDate)->identifier.bv_val = peek_head;
	( k->revocationDate)->identifier.bv_len = strLen;
	if( !(strLen = LocateNextGSERToken(mem_op,b,&peek_head,GSER_NO_COPY)) ){
		Asn1Error("Error during Reading , ");
		return LDAP_PROTOCOL_ERROR;
	}
	if(*peek_head != ','){
		Asn1Error("Missing , in encoding");
		return LDAP_PROTOCOL_ERROR;
	}
	if( !(strLen = LocateNextGSERToken(mem_op,b,&peek_head,GSER_NO_COPY)) ){
	  Asn1Error("Error during Reading identifier");
		return LDAP_PROTOCOL_ERROR;
	}
	}
	if ( strncmp( peek_head, "crlEntryExtensions", strlen("crlEntryExtensions") ) == 0 ) {
		rc = 	GDecComponentExtensions (mem_op, b, (&k->crlEntryExtensions), bytesDecoded, mode);
		if ( rc != LDAP_SUCCESS ) return rc;
	( k->crlEntryExtensions)->identifier.bv_val = peek_head;
	( k->crlEntryExtensions)->identifier.bv_len = strLen;
	}
	if( !(strLen = LocateNextGSERToken(mem_op,b,&peek_head,GSER_NO_COPY)) ) {
		Asn1Error("Error during Reading } in encoding");
		return LDAP_PROTOCOL_ERROR;
	}
	if(*peek_head != '}'){
		Asn1Error("Missing } in encoding");
		return LDAP_PROTOCOL_ERROR;
	}
	if( !(old_mode & DEC_ALLOC_MODE_1) ) {
	*v = t = (ComponentTBSCertListSeqOfSeq*) CompAlloc( mem_op, sizeof(ComponentTBSCertListSeqOfSeq) );
	if ( !t ) return -1;
	*t = *k;
	}
	t->syntax = (Syntax*)NULL;
	t->comp_desc = CompAlloc( mem_op, sizeof( ComponentDesc ) );
	if ( !t->comp_desc ) {
		free ( t );
		return -1;
	}
	t->comp_desc->cd_ldap_encoder = (encoder_func*)NULL;
	t->comp_desc->cd_gser_encoder = (encoder_func*)NULL;
	t->comp_desc->cd_ber_encoder = (encoder_func*)NULL;
	t->comp_desc->cd_gser_decoder = (gser_decoder_func*)GDecComponentTBSCertListSeqOfSeq ;
	t->comp_desc->cd_ber_decoder = (ber_decoder_func*)BDecComponentTBSCertListSeqOfSeq ;
	t->comp_desc->cd_free = (comp_free_func*)NULL;
	t->comp_desc->cd_extract_i = (extract_component_from_id_func*)ExtractingComponentTBSCertListSeqOfSeq;
	t->comp_desc->cd_type = ASN_COMPOSITE;
	t->comp_desc->cd_type_id = COMPOSITE_ASN1_TYPE;
	t->comp_desc->cd_all_match = (allcomponent_matching_func*)MatchingComponentTBSCertListSeqOfSeq;
	return LDAP_SUCCESS;
}  /* GDecTBSCertListSeqOfSeq*/


int
MatchingComponentTBSCertListSeqOf ( char* oid, ComponentSyntaxInfo* csi_attr, ComponentSyntaxInfo* csi_assert ) {
	int rc;
	MatchingRule* mr;
	void* component1, *component2;
	AsnList *v1, *v2, t_list;


	if ( oid ) {
		mr = retrieve_matching_rule( oid, csi_attr->csi_comp_desc->cd_type_id);
		if ( mr ) return component_value_match( mr, csi_attr, csi_assert );
	}

	v1 = &((ComponentTBSCertListSeqOf*)csi_attr)->comp_list;
	v2 = &((ComponentTBSCertListSeqOf*)csi_assert)->comp_list;
	FOR_EACH_LIST_PAIR_ELMT(component1, component2, v1, v2)
	{
		if( MatchingComponentTBSCertListSeqOfSeq(oid, (ComponentSyntaxInfo*)component1, (ComponentSyntaxInfo*)component2) == LDAP_COMPARE_FALSE) {
			return LDAP_COMPARE_FALSE;
		}
	} /* end of for */

	AsnListFirst( v1 );
	AsnListFirst( v2 );
	if( (!component1 && component2) || (component1 && !component2))
		return LDAP_COMPARE_FALSE;
	else
		return LDAP_COMPARE_TRUE;
}  /* BMatchingComponentTBSCertListSeqOfContent */

void*
ExtractingComponentTBSCertListSeqOf ( void* mem_op, ComponentReference* cr, ComponentTBSCertListSeqOf *comp )
{
	int count = 0;
	int total;
	AsnList *v = &comp->comp_list;
	ComponentInt *k;
	ComponentTBSCertListSeqOfSeq *component;


	switch ( cr->cr_curr->ci_type ) {
	case LDAP_COMPREF_FROM_BEGINNING :
		count = cr->cr_curr->ci_val.ci_from_beginning;
		FOR_EACH_LIST_ELMT( component , v ) {
			if( --count == 0 ) {
				if( cr->cr_curr->ci_next == NULL )
					return component;
				else {
					cr->cr_curr = cr->cr_curr->ci_next;
					return 	ExtractingComponentTBSCertListSeqOfSeq ( mem_op, cr, component );
				}
			}
		}
		break;
	case LDAP_COMPREF_FROM_END :
		total = AsnListCount ( v );
		count = cr->cr_curr->ci_val.ci_from_end;
		count = total + count +1;
		FOR_EACH_LIST_ELMT ( component, v ) {
			if( --count == 0 ) {
				if( cr->cr_curr->ci_next == NULL ) 
					return component;
				else {
					cr->cr_curr = cr->cr_curr->ci_next;
					return 	ExtractingComponentTBSCertListSeqOfSeq ( mem_op, cr, component );
				}
			}
		}
		break;
	case LDAP_COMPREF_ALL :
		return comp;
	case LDAP_COMPREF_COUNT :
		k = (ComponentInt*)CompAlloc( mem_op, sizeof(ComponentInt));
		k->comp_desc = CompAlloc( mem_op, sizeof( ComponentDesc ) );
		k->comp_desc->cd_tag = (-1);
		k->comp_desc->cd_gser_decoder = (gser_decoder_func*)GDecComponentInt;
		k->comp_desc->cd_ber_decoder = (ber_decoder_func*)BDecComponentInt;
		k->comp_desc->cd_extract_i = (extract_component_from_id_func*)NULL;
		k->comp_desc->cd_type = ASN_BASIC;
		k->comp_desc->cd_type_id = BASICTYPE_INTEGER;
		k->comp_desc->cd_all_match = (allcomponent_matching_func*)MatchingComponentInt;
		k->value = AsnListCount(v);
		return k;
	default :
		return NULL;
	}
}  /* ExtractingComponentTBSCertListSeqOf */

int
BDecComponentTBSCertListSeqOf PARAMS ((b, tagId0, elmtLen0, v, bytesDecoded, mode),
void* mem_op _AND_
GenBuf * b _AND_
AsnTag tagId0 _AND_
AsnLen elmtLen0 _AND_
ComponentTBSCertListSeqOf **v _AND_
AsnLen *bytesDecoded _AND_
int mode)
{
	int seqDone = FALSE;
	AsnLen totalElmtsLen1 = 0;
	AsnLen elmtLen1;
	AsnTag tagId1;
	int mandatoryElmtCount1 = 0;
	int old_mode = mode;
	int rc;
	ComponentTBSCertListSeqOf *k, *t, c_temp;


	if ( !(mode & DEC_ALLOC_MODE_1) ) {
		memset(&c_temp,0,sizeof(c_temp));
		 k = &c_temp;
	} else
		 k = t = *v;
	mode = DEC_ALLOC_MODE_2;
	AsnListInit(&k->comp_list,sizeof(ComponentTBSCertListSeqOfSeq));
    for (totalElmtsLen1 = 0; (totalElmtsLen1 < elmtLen0) || (elmtLen0 == INDEFINITE_LEN);)
    {
        ComponentTBSCertListSeqOfSeq **tmpVar;
    tagId1 = BDecTag (b, &totalElmtsLen1 );

    if ((tagId1 == EOC_TAG_ID) && (elmtLen0 == INDEFINITE_LEN))
    {
        BDEC_2ND_EOC_OCTET (b, &totalElmtsLen1 )
        break; /* got EOC so can exit this SET OF/SEQ OF's for loop*/
    }
    if ((tagId1 == MAKE_TAG_ID (UNIV, CONS, SEQ_TAG_CODE)))
    {
        elmtLen1 = BDecLen (b, &totalElmtsLen1 );
    tmpVar = (ComponentTBSCertListSeqOfSeq**) CompAsnListAppend (mem_op,&k->comp_list);
	rc = BDecComponentTBSCertListSeqOfSeq (mem_op, b, tagId1, elmtLen1, tmpVar, &totalElmtsLen1, mode);
		if ( rc != LDAP_SUCCESS ) return rc;
    }  /* end of tag check if */
    else  /* wrong tag */
    {
         Asn1Error ("Unexpected Tag\n");
         return -1;
    }
    } /* end of for */

	if( !(old_mode & DEC_ALLOC_MODE_1) ) {
	*v = t = (ComponentTBSCertListSeqOf*) CompAlloc( mem_op, sizeof(ComponentTBSCertListSeqOf) );
	if ( !t ) return -1;
	*t = *k;
	}
	t->syntax = (Syntax*)NULL;
	t->comp_desc = CompAlloc( mem_op, sizeof( ComponentDesc ) );
	if ( !t->comp_desc ) {
		free ( t );
		return -1;
	}
	t->comp_desc->cd_ldap_encoder = (encoder_func*)NULL;
	t->comp_desc->cd_gser_encoder = (encoder_func*)NULL;
	t->comp_desc->cd_ber_encoder = (encoder_func*)NULL;
	t->comp_desc->cd_gser_decoder = (gser_decoder_func*)GDecComponentTBSCertListSeqOf ;
	t->comp_desc->cd_ber_decoder = (ber_decoder_func*)BDecComponentTBSCertListSeqOf ;
	t->comp_desc->cd_free = (comp_free_func*)NULL;
	t->comp_desc->cd_extract_i = (extract_component_from_id_func*)ExtractingComponentTBSCertListSeqOf;
	t->comp_desc->cd_type = ASN_COMPOSITE;
	t->comp_desc->cd_type_id = COMPOSITE_ASN1_TYPE;
	t->comp_desc->cd_all_match = (allcomponent_matching_func*)MatchingComponentTBSCertListSeqOf;
    (*bytesDecoded) += totalElmtsLen1;
	return LDAP_SUCCESS;
}  /* BDecTBSCertListSeqOfContent */

int
GDecComponentTBSCertListSeqOf PARAMS (( mem_op,b, v, bytesDecoded, mode),
void* mem_op _AND_
GenBuf * b _AND_
ComponentTBSCertListSeqOf **v _AND_
AsnLen *bytesDecoded _AND_
int mode)
{
	char* peek_head,*peek_head2;
	int i, strLen,strLen2, rc, old_mode = mode;
	ComponentTBSCertListSeqOf *k,*t, c_temp;


	int ElmtsLen1;
	if ( !(mode & DEC_ALLOC_MODE_1) ) {
		memset(&c_temp,0,sizeof(c_temp));
		 k = &c_temp;
	} else
		 k = t = *v;
	mode = DEC_ALLOC_MODE_2;
	AsnListInit( &k->comp_list, sizeof( ComponentTBSCertListSeqOfSeq ) );
	*bytesDecoded = 0;
	if( !(strLen = LocateNextGSERToken(mem_op,b, &peek_head, GSER_PEEK)) ){
		Asn1Error("Error during Reading { in encoding");
		return LDAP_PROTOCOL_ERROR;
	}
	if(*peek_head != '{'){
		Asn1Error("Missing { in encoded data");
		return LDAP_PROTOCOL_ERROR;
	}

	for (ElmtsLen1 = 0; ElmtsLen1 >= INDEFINITE_LEN; ElmtsLen1++)
	{
		ComponentTBSCertListSeqOfSeq **tmpVar;
		if( !(strLen = LocateNextGSERToken(mem_op,b, &peek_head, GSER_NO_COPY)) ){
			Asn1Error("Error during Reading{ in encoding");
			return LDAP_PROTOCOL_ERROR;
		}
		if(*peek_head == '}') break;
		if( !(*peek_head == '{' || *peek_head ==',') ) {
			return LDAP_PROTOCOL_ERROR;
		}
		tmpVar = (ComponentTBSCertListSeqOfSeq**) CompAsnListAppend (mem_op, &k->comp_list);
		if ( tmpVar == NULL ) {
			Asn1Error("Error during Reading{ in encoding");
			return LDAP_PROTOCOL_ERROR;
		}
		rc = 	GDecComponentTBSCertListSeqOfSeq (mem_op, b, tmpVar, bytesDecoded, mode);
		if ( rc != LDAP_SUCCESS ) return rc;
	} /* end of for */

	if( !(old_mode & DEC_ALLOC_MODE_1) ) {
	*v = t = (ComponentTBSCertListSeqOf*) CompAlloc( mem_op, sizeof(ComponentTBSCertListSeqOf) );
	if ( !t ) return -1;
	*t = *k;
	}
	t->syntax = (Syntax*)NULL;
	t->comp_desc = CompAlloc( mem_op, sizeof( ComponentDesc ) );
	if ( !t->comp_desc ) {
		free ( t );
		return -1;
	}
	t->comp_desc->cd_ldap_encoder = (encoder_func*)NULL;
	t->comp_desc->cd_gser_encoder = (encoder_func*)NULL;
	t->comp_desc->cd_ber_encoder = (encoder_func*)NULL;
	t->comp_desc->cd_gser_decoder = (gser_decoder_func*)GDecComponentTBSCertListSeqOf ;
	t->comp_desc->cd_ber_decoder = (ber_decoder_func*)BDecComponentTBSCertListSeqOf ;
	t->comp_desc->cd_free = (comp_free_func*)NULL;
	t->comp_desc->cd_extract_i = (extract_component_from_id_func*)ExtractingComponentTBSCertListSeqOf;
	t->comp_desc->cd_type = ASN_COMPOSITE;
	t->comp_desc->cd_type_id = COMPOSITE_ASN1_TYPE;
	t->comp_desc->cd_all_match = (allcomponent_matching_func*)MatchingComponentTBSCertListSeqOf;
	return LDAP_SUCCESS;
}  /* GDecTBSCertListSeqOfContent */

int
MatchingComponentTBSCertList ( char* oid, ComponentSyntaxInfo* csi_attr, ComponentSyntaxInfo* csi_assert ) {
	int rc;
	MatchingRule* mr;

	if ( oid ) {
		mr = retrieve_matching_rule( oid, csi_attr->csi_comp_desc->cd_type_id);
		if ( mr ) return component_value_match( mr, csi_attr, csi_assert );
	}

	rc = 1;
	if(COMPONENTNOT_NULL( ((ComponentTBSCertList*)csi_attr)->version ) ) {
	rc =	MatchingComponentVersion ( oid, (ComponentSyntaxInfo*)((ComponentTBSCertList*)csi_attr)->version, (ComponentSyntaxInfo*)((ComponentTBSCertList*)csi_assert)->version );
	if ( rc != LDAP_COMPARE_TRUE )
		return rc;
	}
	rc =	MatchingComponentAlgorithmIdentifier ( oid, (ComponentSyntaxInfo*)((ComponentTBSCertList*)csi_attr)->signature, (ComponentSyntaxInfo*)((ComponentTBSCertList*)csi_assert)->signature );
	if ( rc != LDAP_COMPARE_TRUE )
		return rc;
	rc =	MatchingComponentName ( oid, (ComponentSyntaxInfo*)((ComponentTBSCertList*)csi_attr)->issuer, (ComponentSyntaxInfo*)((ComponentTBSCertList*)csi_assert)->issuer );
	if ( rc != LDAP_COMPARE_TRUE )
		return rc;
	rc =	MatchingComponentTime ( oid, (ComponentSyntaxInfo*)((ComponentTBSCertList*)csi_attr)->thisUpdate, (ComponentSyntaxInfo*)((ComponentTBSCertList*)csi_assert)->thisUpdate );
	if ( rc != LDAP_COMPARE_TRUE )
		return rc;
	if(COMPONENTNOT_NULL( ((ComponentTBSCertList*)csi_attr)->nextUpdate ) ) {
	rc =	MatchingComponentTime ( oid, (ComponentSyntaxInfo*)((ComponentTBSCertList*)csi_attr)->nextUpdate, (ComponentSyntaxInfo*)((ComponentTBSCertList*)csi_assert)->nextUpdate );
	if ( rc != LDAP_COMPARE_TRUE )
		return rc;
	}
	rc =	MatchingComponentTBSCertListSeqOf ( oid, (ComponentSyntaxInfo*)((ComponentTBSCertList*)csi_attr)->revokedCertificates, (ComponentSyntaxInfo*)((ComponentTBSCertList*)csi_assert)->revokedCertificates );
	if ( rc != LDAP_COMPARE_TRUE )
		return rc;
	if(COMPONENTNOT_NULL( ((ComponentTBSCertList*)csi_attr)->crlExtensions ) ) {
	rc =	MatchingComponentExtensions ( oid, (ComponentSyntaxInfo*)((ComponentTBSCertList*)csi_attr)->crlExtensions, (ComponentSyntaxInfo*)((ComponentTBSCertList*)csi_assert)->crlExtensions );
	if ( rc != LDAP_COMPARE_TRUE )
		return rc;
	}
	return LDAP_COMPARE_TRUE;
}  /* BMatchingComponentTBSCertList */

void*
ExtractingComponentTBSCertList ( void* mem_op, ComponentReference* cr, ComponentTBSCertList *comp )
{

	if ( ( comp->version->identifier.bv_val && strncmp(comp->version->identifier.bv_val, cr->cr_curr->ci_val.ci_identifier.bv_val,cr->cr_curr->ci_val.ci_identifier.bv_len) == 0 ) || ( strncmp(comp->version->id_buf, cr->cr_curr->ci_val.ci_identifier.bv_val,cr->cr_curr->ci_val.ci_identifier.bv_len) == 0 ) ) {
		if ( cr->cr_curr->ci_next == NULL )
			return comp->version;
		else {
			cr->cr_curr = cr->cr_curr->ci_next;
			return 	ExtractingComponentVersion ( mem_op, cr, comp->version );
		}
	}
	if ( ( comp->signature->identifier.bv_val && strncmp(comp->signature->identifier.bv_val, cr->cr_curr->ci_val.ci_identifier.bv_val,cr->cr_curr->ci_val.ci_identifier.bv_len) == 0 ) || ( strncmp(comp->signature->id_buf, cr->cr_curr->ci_val.ci_identifier.bv_val,cr->cr_curr->ci_val.ci_identifier.bv_len) == 0 ) ) {
		if ( cr->cr_curr->ci_next == NULL )
			return comp->signature;
		else {
			cr->cr_curr = cr->cr_curr->ci_next;
			return 	ExtractingComponentAlgorithmIdentifier ( mem_op, cr, comp->signature );
		}
	}
	if ( ( comp->issuer->identifier.bv_val && strncmp(comp->issuer->identifier.bv_val, cr->cr_curr->ci_val.ci_identifier.bv_val,cr->cr_curr->ci_val.ci_identifier.bv_len) == 0 ) || ( strncmp(comp->issuer->id_buf, cr->cr_curr->ci_val.ci_identifier.bv_val,cr->cr_curr->ci_val.ci_identifier.bv_len) == 0 ) ) {
		if ( cr->cr_curr->ci_next == NULL )
			return comp->issuer;
		else {
			cr->cr_curr = cr->cr_curr->ci_next;
			return 	ExtractingComponentName ( mem_op, cr, comp->issuer );
		}
	}
	if ( ( comp->thisUpdate->identifier.bv_val && strncmp(comp->thisUpdate->identifier.bv_val, cr->cr_curr->ci_val.ci_identifier.bv_val,cr->cr_curr->ci_val.ci_identifier.bv_len) == 0 ) || ( strncmp(comp->thisUpdate->id_buf, cr->cr_curr->ci_val.ci_identifier.bv_val,cr->cr_curr->ci_val.ci_identifier.bv_len) == 0 ) ) {
		if ( cr->cr_curr->ci_next == NULL )
			return comp->thisUpdate;
		else {
			cr->cr_curr = cr->cr_curr->ci_next;
			return 	ExtractingComponentTime ( mem_op, cr, comp->thisUpdate );
		}
	}
	if ( ( comp->nextUpdate->identifier.bv_val && strncmp(comp->nextUpdate->identifier.bv_val, cr->cr_curr->ci_val.ci_identifier.bv_val,cr->cr_curr->ci_val.ci_identifier.bv_len) == 0 ) || ( strncmp(comp->nextUpdate->id_buf, cr->cr_curr->ci_val.ci_identifier.bv_val,cr->cr_curr->ci_val.ci_identifier.bv_len) == 0 ) ) {
		if ( cr->cr_curr->ci_next == NULL )
			return comp->nextUpdate;
		else {
			cr->cr_curr = cr->cr_curr->ci_next;
			return 	ExtractingComponentTime ( mem_op, cr, comp->nextUpdate );
		}
	}
	if ( ( comp->revokedCertificates->identifier.bv_val && strncmp(comp->revokedCertificates->identifier.bv_val, cr->cr_curr->ci_val.ci_identifier.bv_val,cr->cr_curr->ci_val.ci_identifier.bv_len) == 0 ) || ( strncmp(comp->revokedCertificates->id_buf, cr->cr_curr->ci_val.ci_identifier.bv_val,cr->cr_curr->ci_val.ci_identifier.bv_len) == 0 ) ) {
		if ( cr->cr_curr->ci_next == NULL )
			return comp->revokedCertificates;
		else {
			cr->cr_curr = cr->cr_curr->ci_next;
			return 	ExtractingComponentTBSCertListSeqOf ( mem_op, cr, comp->revokedCertificates );
		}
	}
	if ( ( comp->crlExtensions->identifier.bv_val && strncmp(comp->crlExtensions->identifier.bv_val, cr->cr_curr->ci_val.ci_identifier.bv_val,cr->cr_curr->ci_val.ci_identifier.bv_len) == 0 ) || ( strncmp(comp->crlExtensions->id_buf, cr->cr_curr->ci_val.ci_identifier.bv_val,cr->cr_curr->ci_val.ci_identifier.bv_len) == 0 ) ) {
		if ( cr->cr_curr->ci_next == NULL )
			return comp->crlExtensions;
		else {
			cr->cr_curr = cr->cr_curr->ci_next;
			return 	ExtractingComponentExtensions ( mem_op, cr, comp->crlExtensions );
		}
	}
	return NULL;
}  /* ExtractingComponentTBSCertList */

int
BDecComponentTBSCertList PARAMS ((b, tagId0, elmtLen0, v, bytesDecoded, mode),
void* mem_op _AND_
GenBuf * b _AND_
AsnTag tagId0 _AND_
AsnLen elmtLen0 _AND_
ComponentTBSCertList **v _AND_
AsnLen *bytesDecoded _AND_
int mode)
{
	int seqDone = FALSE;
	AsnLen totalElmtsLen1 = 0;
	AsnLen elmtLen1;
	AsnTag tagId1;
	int mandatoryElmtCount1 = 0;
	AsnLen totalElmtsLen2 = 0;
	AsnLen elmtLen2;
	AsnTag tagId2;
	int old_mode = mode;
	int rc;
	ComponentTBSCertList *k, *t, c_temp;


	if ( !(mode & DEC_ALLOC_MODE_1) ) {
		memset(&c_temp,0,sizeof(c_temp));
		 k = &c_temp;
	} else
		 k = t = *v;
	mode = DEC_ALLOC_MODE_2;
    tagId1 = BDecTag (b, &totalElmtsLen1 );

    if (((tagId1 == MAKE_TAG_ID (UNIV, PRIM, INTEGER_TAG_CODE))))
    {
    elmtLen1 = BDecLen (b, &totalElmtsLen1 );
	rc = BDecComponentVersion (mem_op, b, tagId1, elmtLen1, (&k->version), &totalElmtsLen1, DEC_ALLOC_MODE_0 );
		if ( rc != LDAP_SUCCESS ) return rc;
		(k->version)->identifier.bv_val = (k->version)->id_buf;
		(k->version)->identifier.bv_len = strlen("version");
		strcpy( (k->version)->identifier.bv_val, "version");
    tagId1 = BDecTag (b, &totalElmtsLen1);
    }


    if (((tagId1 == MAKE_TAG_ID (UNIV, CONS, SEQ_TAG_CODE))))
    {
    elmtLen1 = BDecLen (b, &totalElmtsLen1 );
	rc = BDecComponentAlgorithmIdentifier (mem_op, b, tagId1, elmtLen1, (&k->signature), &totalElmtsLen1, mode);
		if ( rc != LDAP_SUCCESS ) return rc;
		(k->signature)->identifier.bv_val = (k->signature)->id_buf;
		(k->signature)->identifier.bv_len = strlen("signature");
		strcpy( (k->signature)->identifier.bv_val, "signature");
    tagId1 = BDecTag (b, &totalElmtsLen1);
    }
    else
        return -1;



    if (((tagId1 == MAKE_TAG_ID (UNIV, CONS, SEQ_TAG_CODE))))
    {
        elmtLen1 = BDecLen (b, &totalElmtsLen1 );
	rc = BDecComponentName (mem_op, b, tagId1, elmtLen1, (&k->issuer), &totalElmtsLen1, mode);
		if ( rc != LDAP_SUCCESS ) return rc;
		(k->issuer)->identifier.bv_val = (k->issuer)->id_buf;
		(k->issuer)->identifier.bv_len = strlen("issuer");
		strcpy( (k->issuer)->identifier.bv_val, "issuer");
    tagId1 = BDecTag (b, &totalElmtsLen1);
    }
    else
        return -1;



    if (((tagId1 == MAKE_TAG_ID (UNIV, PRIM, UTCTIME_TAG_CODE)) ||
(tagId1 == MAKE_TAG_ID (UNIV, CONS, UTCTIME_TAG_CODE)) ||
     (tagId1 ==MAKE_TAG_ID (UNIV, PRIM, GENERALIZEDTIME_TAG_CODE))||
    (tagId1 == MAKE_TAG_ID (UNIV, CONS, GENERALIZEDTIME_TAG_CODE))))
    {
        elmtLen1 = BDecLen (b, &totalElmtsLen1 );
	rc = BDecComponentTime (mem_op, b, tagId1, elmtLen1, (&k->thisUpdate), &totalElmtsLen1, mode);
		if ( rc != LDAP_SUCCESS ) return rc;
		(k->thisUpdate)->identifier.bv_val = (k->thisUpdate)->id_buf;
		(k->thisUpdate)->identifier.bv_len = strlen("thisUpdate");
		strcpy( (k->thisUpdate)->identifier.bv_val, "thisUpdate");
    tagId1 = BDecTag (b, &totalElmtsLen1);
    }
    else
        return -1;



    if (((tagId1 == MAKE_TAG_ID (UNIV, PRIM, UTCTIME_TAG_CODE)) ||
(tagId1 == MAKE_TAG_ID (UNIV, CONS, UTCTIME_TAG_CODE)) ||
     (tagId1 ==MAKE_TAG_ID (UNIV, PRIM, GENERALIZEDTIME_TAG_CODE))||
    (tagId1 == MAKE_TAG_ID (UNIV, CONS, GENERALIZEDTIME_TAG_CODE))))
    {
        elmtLen1 = BDecLen (b, &totalElmtsLen1 );
	rc = BDecComponentTime (mem_op, b, tagId1, elmtLen1, (&k->nextUpdate), &totalElmtsLen1, mode);
		if ( rc != LDAP_SUCCESS ) return rc;
		(k->nextUpdate)->identifier.bv_val = (k->nextUpdate)->id_buf;
		(k->nextUpdate)->identifier.bv_len = strlen("nextUpdate");
		strcpy( (k->nextUpdate)->identifier.bv_val, "nextUpdate");
    tagId1 = BDecTag (b, &totalElmtsLen1);
    }


    if (((tagId1 == MAKE_TAG_ID (UNIV, CONS, SEQ_TAG_CODE))))
    {
    elmtLen1 = BDecLen (b, &totalElmtsLen1 );
	rc = BDecComponentTBSCertListSeqOf (mem_op, b, tagId1, elmtLen1, (&k->revokedCertificates), &totalElmtsLen1, mode);
		if ( rc != LDAP_SUCCESS ) return rc;
		(k->revokedCertificates)->identifier.bv_val = (k->revokedCertificates)->id_buf;
		(k->revokedCertificates)->identifier.bv_len = strlen("revokedCertificates");
		strcpy( (k->revokedCertificates)->identifier.bv_val, "revokedCertificates");
    if ((elmtLen0 != INDEFINITE_LEN) && (totalElmtsLen1 == elmtLen0))
        seqDone = TRUE;
    else
    {
        tagId1 = BDecTag (b, &totalElmtsLen1 );

         if ((elmtLen0 == INDEFINITE_LEN) && (tagId1 == EOC_TAG_ID))
        {
            BDEC_2ND_EOC_OCTET (b, &totalElmtsLen1 )
            seqDone = TRUE;
        }
    }
    }
    else
        return -1;



    if ((!seqDone) && ((tagId1 == MAKE_TAG_ID (CNTX, CONS, 0))))
    {
    elmtLen1 = BDecLen (b, &totalElmtsLen1 );
        tagId2 = BDecTag (b, &totalElmtsLen1 );

    if (tagId2 != MAKE_TAG_ID (UNIV, CONS, SEQ_TAG_CODE))
    {
         Asn1Error ("Unexpected Tag\n");
         return -1;
    }

    elmtLen2 = BDecLen (b, &totalElmtsLen1 );
	rc = BDecComponentExtensions (mem_op, b, tagId2, elmtLen2, (&k->crlExtensions), &totalElmtsLen1, mode);
		if ( rc != LDAP_SUCCESS ) return rc;
		(k->crlExtensions)->identifier.bv_val = (k->crlExtensions)->id_buf;
		(k->crlExtensions)->identifier.bv_len = strlen("crlExtensions");
		strcpy( (k->crlExtensions)->identifier.bv_val, "crlExtensions");
	if (elmtLen1 == INDEFINITE_LEN)
        BDecEoc (b, &totalElmtsLen1 );
        seqDone = TRUE;
        if (elmtLen0 == INDEFINITE_LEN)
            BDecEoc (b, &totalElmtsLen1 );
        else if (totalElmtsLen1 != elmtLen0)
        return -1;

    }


    if (!seqDone)
        return -1;

	if( !(old_mode & DEC_ALLOC_MODE_1) ) {
	*v = t = (ComponentTBSCertList*) CompAlloc( mem_op, sizeof(ComponentTBSCertList) );
	if ( !t ) return -1;
	*t = *k;
	}
	t->syntax = (Syntax*)NULL;
	t->comp_desc = CompAlloc( mem_op, sizeof( ComponentDesc ) );
	if ( !t->comp_desc ) {
		free ( t );
		return -1;
	}
	t->comp_desc->cd_ldap_encoder = (encoder_func*)NULL;
	t->comp_desc->cd_gser_encoder = (encoder_func*)NULL;
	t->comp_desc->cd_ber_encoder = (encoder_func*)NULL;
	t->comp_desc->cd_gser_decoder = (gser_decoder_func*)GDecComponentTBSCertList ;
	t->comp_desc->cd_ber_decoder = (ber_decoder_func*)BDecComponentTBSCertList ;
	t->comp_desc->cd_free = (comp_free_func*)NULL;
	t->comp_desc->cd_extract_i = (extract_component_from_id_func*)ExtractingComponentTBSCertList;
	t->comp_desc->cd_type = ASN_COMPOSITE;
	t->comp_desc->cd_type_id = COMPOSITE_ASN1_TYPE;
	t->comp_desc->cd_all_match = (allcomponent_matching_func*)MatchingComponentTBSCertList;
    (*bytesDecoded) += totalElmtsLen1;
	return LDAP_SUCCESS;
}  /* BDecTBSCertList*/

int
GDecComponentTBSCertList PARAMS (( mem_op,b, v, bytesDecoded, mode),
void* mem_op _AND_
GenBuf * b _AND_
ComponentTBSCertList **v _AND_
AsnLen *bytesDecoded _AND_
int mode)
{
	char* peek_head,*peek_head2;
	int i, strLen,strLen2, rc, old_mode = mode;
	ComponentTBSCertList *k,*t, c_temp;


	if ( !(mode & DEC_ALLOC_MODE_1) ) {
		memset(&c_temp,0,sizeof(c_temp));
		 k = &c_temp;
	} else
		 k = t = *v;
	mode = DEC_ALLOC_MODE_2;
	*bytesDecoded = 0;
	if( !(strLen = LocateNextGSERToken(mem_op,b,&peek_head,GSER_NO_COPY)) ){
		Asn1Error("Error during Reading { in encoded data");
		return LDAP_PROTOCOL_ERROR;
	}
	if(*peek_head != '{'){
		Asn1Error("Missing { in encoded data");
		return LDAP_PROTOCOL_ERROR;
	}

	if( !(strLen = LocateNextGSERToken(mem_op,b,&peek_head,GSER_NO_COPY)) ){
		Asn1Error("Error during Reading identifier");
		return LDAP_PROTOCOL_ERROR;
	}
	if ( strncmp( peek_head, "version", strlen("version") ) == 0 ) {
		rc = 	GDecComponentVersion (mem_op, b, (&k->version), bytesDecoded, DEC_ALLOC_MODE_0 );
		if ( rc != LDAP_SUCCESS ) return rc;
	( k->version)->identifier.bv_val = peek_head;
	( k->version)->identifier.bv_len = strLen;
	if( !(strLen = LocateNextGSERToken(mem_op,b,&peek_head,GSER_NO_COPY)) ){
		Asn1Error("Error during Reading , ");
		return LDAP_PROTOCOL_ERROR;
	}
	if(*peek_head != ','){
		Asn1Error("Missing , in encoding");
		return LDAP_PROTOCOL_ERROR;
	}
	if( !(strLen = LocateNextGSERToken(mem_op,b,&peek_head,GSER_NO_COPY)) ){
	  Asn1Error("Error during Reading identifier");
		return LDAP_PROTOCOL_ERROR;
	}
	}
	if ( strncmp( peek_head, "signature", strlen("signature") ) == 0 ) {
		rc = 	GDecComponentAlgorithmIdentifier (mem_op, b, (&k->signature), bytesDecoded, mode);
		if ( rc != LDAP_SUCCESS ) return rc;
	( k->signature)->identifier.bv_val = peek_head;
	( k->signature)->identifier.bv_len = strLen;
	if( !(strLen = LocateNextGSERToken(mem_op,b,&peek_head,GSER_NO_COPY)) ){
		Asn1Error("Error during Reading , ");
		return LDAP_PROTOCOL_ERROR;
	}
	if(*peek_head != ','){
		Asn1Error("Missing , in encoding");
		return LDAP_PROTOCOL_ERROR;
	}
	if( !(strLen = LocateNextGSERToken(mem_op,b,&peek_head,GSER_NO_COPY)) ){
	  Asn1Error("Error during Reading identifier");
		return LDAP_PROTOCOL_ERROR;
	}
	}
	if ( strncmp( peek_head, "issuer", strlen("issuer") ) == 0 ) {
		rc = 	GDecComponentName (mem_op, b, (&k->issuer), bytesDecoded, mode);
		if ( rc != LDAP_SUCCESS ) return rc;
	( k->issuer)->identifier.bv_val = peek_head;
	( k->issuer)->identifier.bv_len = strLen;
	if( !(strLen = LocateNextGSERToken(mem_op,b,&peek_head,GSER_NO_COPY)) ){
		Asn1Error("Error during Reading , ");
		return LDAP_PROTOCOL_ERROR;
	}
	if(*peek_head != ','){
		Asn1Error("Missing , in encoding");
		return LDAP_PROTOCOL_ERROR;
	}
	if( !(strLen = LocateNextGSERToken(mem_op,b,&peek_head,GSER_NO_COPY)) ){
	  Asn1Error("Error during Reading identifier");
		return LDAP_PROTOCOL_ERROR;
	}
	}
	if ( strncmp( peek_head, "thisUpdate", strlen("thisUpdate") ) == 0 ) {
		rc = 	GDecComponentTime (mem_op, b, (&k->thisUpdate), bytesDecoded, mode);
		if ( rc != LDAP_SUCCESS ) return rc;
	( k->thisUpdate)->identifier.bv_val = peek_head;
	( k->thisUpdate)->identifier.bv_len = strLen;
	if( !(strLen = LocateNextGSERToken(mem_op,b,&peek_head,GSER_NO_COPY)) ){
		Asn1Error("Error during Reading , ");
		return LDAP_PROTOCOL_ERROR;
	}
	if(*peek_head != ','){
		Asn1Error("Missing , in encoding");
		return LDAP_PROTOCOL_ERROR;
	}
	if( !(strLen = LocateNextGSERToken(mem_op,b,&peek_head,GSER_NO_COPY)) ){
	  Asn1Error("Error during Reading identifier");
		return LDAP_PROTOCOL_ERROR;
	}
	}
	if ( strncmp( peek_head, "nextUpdate", strlen("nextUpdate") ) == 0 ) {
		rc = 	GDecComponentTime (mem_op, b, (&k->nextUpdate), bytesDecoded, mode);
		if ( rc != LDAP_SUCCESS ) return rc;
	( k->nextUpdate)->identifier.bv_val = peek_head;
	( k->nextUpdate)->identifier.bv_len = strLen;
	if( !(strLen = LocateNextGSERToken(mem_op,b,&peek_head,GSER_NO_COPY)) ){
		Asn1Error("Error during Reading , ");
		return LDAP_PROTOCOL_ERROR;
	}
	if(*peek_head != ','){
		Asn1Error("Missing , in encoding");
		return LDAP_PROTOCOL_ERROR;
	}
	if( !(strLen = LocateNextGSERToken(mem_op,b,&peek_head,GSER_NO_COPY)) ){
	  Asn1Error("Error during Reading identifier");
		return LDAP_PROTOCOL_ERROR;
	}
	}
	if ( strncmp( peek_head, "revokedCertificates", strlen("revokedCertificates") ) == 0 ) {
		rc = 	GDecComponentTBSCertListSeqOf (mem_op, b, (&k->revokedCertificates), bytesDecoded, mode);
		if ( rc != LDAP_SUCCESS ) return rc;
	( k->revokedCertificates)->identifier.bv_val = peek_head;
	( k->revokedCertificates)->identifier.bv_len = strLen;
	if( !(strLen = LocateNextGSERToken(mem_op,b,&peek_head,GSER_NO_COPY)) ){
		Asn1Error("Error during Reading , ");
		return LDAP_PROTOCOL_ERROR;
	}
	if(*peek_head != ','){
		Asn1Error("Missing , in encoding");
		return LDAP_PROTOCOL_ERROR;
	}
	if( !(strLen = LocateNextGSERToken(mem_op,b,&peek_head,GSER_NO_COPY)) ){
	  Asn1Error("Error during Reading identifier");
		return LDAP_PROTOCOL_ERROR;
	}
	}
	if ( strncmp( peek_head, "crlExtensions", strlen("crlExtensions") ) == 0 ) {
		rc = 	GDecComponentExtensions (mem_op, b, (&k->crlExtensions), bytesDecoded, mode);
		if ( rc != LDAP_SUCCESS ) return rc;
	( k->crlExtensions)->identifier.bv_val = peek_head;
	( k->crlExtensions)->identifier.bv_len = strLen;
	}
	if( !(strLen = LocateNextGSERToken(mem_op,b,&peek_head,GSER_NO_COPY)) ) {
		Asn1Error("Error during Reading } in encoding");
		return LDAP_PROTOCOL_ERROR;
	}
	if(*peek_head != '}'){
		Asn1Error("Missing } in encoding");
		return LDAP_PROTOCOL_ERROR;
	}
	if( !(old_mode & DEC_ALLOC_MODE_1) ) {
	*v = t = (ComponentTBSCertList*) CompAlloc( mem_op, sizeof(ComponentTBSCertList) );
	if ( !t ) return -1;
	*t = *k;
	}
	t->syntax = (Syntax*)NULL;
	t->comp_desc = CompAlloc( mem_op, sizeof( ComponentDesc ) );
	if ( !t->comp_desc ) {
		free ( t );
		return -1;
	}
	t->comp_desc->cd_ldap_encoder = (encoder_func*)NULL;
	t->comp_desc->cd_gser_encoder = (encoder_func*)NULL;
	t->comp_desc->cd_ber_encoder = (encoder_func*)NULL;
	t->comp_desc->cd_gser_decoder = (gser_decoder_func*)GDecComponentTBSCertList ;
	t->comp_desc->cd_ber_decoder = (ber_decoder_func*)BDecComponentTBSCertList ;
	t->comp_desc->cd_free = (comp_free_func*)NULL;
	t->comp_desc->cd_extract_i = (extract_component_from_id_func*)ExtractingComponentTBSCertList;
	t->comp_desc->cd_type = ASN_COMPOSITE;
	t->comp_desc->cd_type_id = COMPOSITE_ASN1_TYPE;
	t->comp_desc->cd_all_match = (allcomponent_matching_func*)MatchingComponentTBSCertList;
	return LDAP_SUCCESS;
}  /* GDecTBSCertList*/


int
MatchingComponentCertificateList ( char* oid, ComponentSyntaxInfo* csi_attr, ComponentSyntaxInfo* csi_assert ) {
	int rc;
	MatchingRule* mr;

	if ( oid ) {
		mr = retrieve_matching_rule( oid, csi_attr->csi_comp_desc->cd_type_id);
		if ( mr ) return component_value_match( mr, csi_attr, csi_assert );
	}

	rc = 1;
	rc =	MatchingComponentTBSCertList ( oid, (ComponentSyntaxInfo*)((ComponentCertificateList*)csi_attr)->tbsCertList, (ComponentSyntaxInfo*)((ComponentCertificateList*)csi_assert)->tbsCertList );
	if ( rc != LDAP_COMPARE_TRUE )
		return rc;
	rc =	MatchingComponentAlgorithmIdentifier ( oid, (ComponentSyntaxInfo*)((ComponentCertificateList*)csi_attr)->signatureAlgorithm, (ComponentSyntaxInfo*)((ComponentCertificateList*)csi_assert)->signatureAlgorithm );
	if ( rc != LDAP_COMPARE_TRUE )
		return rc;
	rc =	MatchingComponentBits ( oid, (ComponentSyntaxInfo*)&((ComponentCertificateList*)csi_attr)->signature, (ComponentSyntaxInfo*)&((ComponentCertificateList*)csi_assert)->signature );
	if ( rc != LDAP_COMPARE_TRUE )
		return rc;
	return LDAP_COMPARE_TRUE;
}  /* BMatchingComponentCertificateList */

void*
ExtractingComponentCertificateList ( void* mem_op, ComponentReference* cr, ComponentCertificateList *comp )
{

	if ( ( comp->tbsCertList->identifier.bv_val && strncmp(comp->tbsCertList->identifier.bv_val, cr->cr_curr->ci_val.ci_identifier.bv_val,cr->cr_curr->ci_val.ci_identifier.bv_len) == 0 ) || ( strncmp(comp->tbsCertList->id_buf, cr->cr_curr->ci_val.ci_identifier.bv_val,cr->cr_curr->ci_val.ci_identifier.bv_len) == 0 ) ) {
		if ( cr->cr_curr->ci_next == NULL )
			return comp->tbsCertList;
		else {
			cr->cr_curr = cr->cr_curr->ci_next;
			return 	ExtractingComponentTBSCertList ( mem_op, cr, comp->tbsCertList );
		}
	}
	if ( ( comp->signatureAlgorithm->identifier.bv_val && strncmp(comp->signatureAlgorithm->identifier.bv_val, cr->cr_curr->ci_val.ci_identifier.bv_val,cr->cr_curr->ci_val.ci_identifier.bv_len) == 0 ) || ( strncmp(comp->signatureAlgorithm->id_buf, cr->cr_curr->ci_val.ci_identifier.bv_val,cr->cr_curr->ci_val.ci_identifier.bv_len) == 0 ) ) {
		if ( cr->cr_curr->ci_next == NULL )
			return comp->signatureAlgorithm;
		else {
			cr->cr_curr = cr->cr_curr->ci_next;
			return 	ExtractingComponentAlgorithmIdentifier ( mem_op, cr, comp->signatureAlgorithm );
		}
	}
	if ( ( comp->signature.identifier.bv_val && strncmp(comp->signature.identifier.bv_val, cr->cr_curr->ci_val.ci_identifier.bv_val,cr->cr_curr->ci_val.ci_identifier.bv_len) == 0 ) || ( strncmp(comp->signature.id_buf, cr->cr_curr->ci_val.ci_identifier.bv_val,cr->cr_curr->ci_val.ci_identifier.bv_len) == 0 ) ) {
		if ( cr->cr_curr->ci_next == NULL )
		return &comp->signature;
	else if ( cr->cr_curr->ci_next->ci_type == LDAP_COMPREF_CONTENT) {
			cr->cr_curr = cr->cr_curr->ci_next;
		return &comp->signature;
	 } else {
		return NULL;
		}
	}
	return NULL;
}  /* ExtractingComponentCertificateList */

int
BDecComponentCertificateList PARAMS ((b, tagId0, elmtLen0, v, bytesDecoded, mode),
void* mem_op _AND_
GenBuf * b _AND_
AsnTag tagId0 _AND_
AsnLen elmtLen0 _AND_
ComponentCertificateList **v _AND_
AsnLen *bytesDecoded _AND_
int mode)
{
	int seqDone = FALSE;
	AsnLen totalElmtsLen1 = 0;
	AsnLen elmtLen1;
	AsnTag tagId1;
	int mandatoryElmtCount1 = 0;
	int old_mode = mode;
	int rc;
	ComponentCertificateList *k, *t, c_temp;


	if ( !(mode & DEC_ALLOC_MODE_1) ) {
		memset(&c_temp,0,sizeof(c_temp));
		 k = &c_temp;
	} else
		 k = t = *v;
	mode = DEC_ALLOC_MODE_2;
    tagId1 = BDecTag (b, &totalElmtsLen1 );

    if (((tagId1 == MAKE_TAG_ID (UNIV, CONS, SEQ_TAG_CODE))))
    {
    elmtLen1 = BDecLen (b, &totalElmtsLen1 );
	rc = BDecComponentTBSCertList (mem_op, b, tagId1, elmtLen1, (&k->tbsCertList), &totalElmtsLen1, mode);
		if ( rc != LDAP_SUCCESS ) return rc;
		(k->tbsCertList)->identifier.bv_val = (k->tbsCertList)->id_buf;
		(k->tbsCertList)->identifier.bv_len = strlen("tbsCertList");
		strcpy( (k->tbsCertList)->identifier.bv_val, "tbsCertList");
    tagId1 = BDecTag (b, &totalElmtsLen1);
    }
    else
        return -1;



    if (((tagId1 == MAKE_TAG_ID (UNIV, CONS, SEQ_TAG_CODE))))
    {
    elmtLen1 = BDecLen (b, &totalElmtsLen1 );
	rc = BDecComponentAlgorithmIdentifier (mem_op, b, tagId1, elmtLen1, (&k->signatureAlgorithm), &totalElmtsLen1, mode);
		if ( rc != LDAP_SUCCESS ) return rc;
		(k->signatureAlgorithm)->identifier.bv_val = (k->signatureAlgorithm)->id_buf;
		(k->signatureAlgorithm)->identifier.bv_len = strlen("signatureAlgorithm");
		strcpy( (k->signatureAlgorithm)->identifier.bv_val, "signatureAlgorithm");
    tagId1 = BDecTag (b, &totalElmtsLen1);
    }
    else
        return -1;



    if (((tagId1 == MAKE_TAG_ID (UNIV, PRIM, BITSTRING_TAG_CODE)) ||
(tagId1 == MAKE_TAG_ID (UNIV, CONS, BITSTRING_TAG_CODE))))
    {
    elmtLen1 = BDecLen (b, &totalElmtsLen1 );
	rc = BDecComponentBits (mem_op, b, tagId1, elmtLen1, (&k->signature), &totalElmtsLen1, mode);
		if ( rc != LDAP_SUCCESS ) return rc;
		(&k->signature)->identifier.bv_val = (&k->signature)->id_buf;
		(&k->signature)->identifier.bv_len = strlen("signature");
		strcpy( (&k->signature)->identifier.bv_val, "signature");
        seqDone = TRUE;
        if (elmtLen0 == INDEFINITE_LEN)
            BDecEoc (b, &totalElmtsLen1 );
        else if (totalElmtsLen1 != elmtLen0)
        return -1;

    }
    else
        return -1;



    if (!seqDone)
        return -1;

	if( !(old_mode & DEC_ALLOC_MODE_1) ) {
	*v = t = (ComponentCertificateList*) CompAlloc( mem_op, sizeof(ComponentCertificateList) );
	if ( !t ) return -1;
	*t = *k;
	}
	t->syntax = (Syntax*)NULL;
	t->comp_desc = CompAlloc( mem_op, sizeof( ComponentDesc ) );
	if ( !t->comp_desc ) {
		free ( t );
		return -1;
	}
	t->comp_desc->cd_ldap_encoder = (encoder_func*)NULL;
	t->comp_desc->cd_gser_encoder = (encoder_func*)NULL;
	t->comp_desc->cd_ber_encoder = (encoder_func*)NULL;
	t->comp_desc->cd_gser_decoder = (gser_decoder_func*)GDecComponentCertificateList ;
	t->comp_desc->cd_ber_decoder = (ber_decoder_func*)BDecComponentCertificateList ;
	t->comp_desc->cd_free = (comp_free_func*)NULL;
	t->comp_desc->cd_extract_i = (extract_component_from_id_func*)ExtractingComponentCertificateList;
	t->comp_desc->cd_type = ASN_COMPOSITE;
	t->comp_desc->cd_type_id = COMPOSITE_ASN1_TYPE;
	t->comp_desc->cd_all_match = (allcomponent_matching_func*)MatchingComponentCertificateList;
    (*bytesDecoded) += totalElmtsLen1;
	return LDAP_SUCCESS;
}  /* BDecCertificateList*/

int
GDecComponentCertificateList PARAMS (( mem_op,b, v, bytesDecoded, mode),
void* mem_op _AND_
GenBuf * b _AND_
ComponentCertificateList **v _AND_
AsnLen *bytesDecoded _AND_
int mode)
{
	char* peek_head,*peek_head2;
	int i, strLen,strLen2, rc, old_mode = mode;
	ComponentCertificateList *k,*t, c_temp;


	if ( !(mode & DEC_ALLOC_MODE_1) ) {
		memset(&c_temp,0,sizeof(c_temp));
		 k = &c_temp;
	} else
		 k = t = *v;
	mode = DEC_ALLOC_MODE_2;
	*bytesDecoded = 0;
	if( !(strLen = LocateNextGSERToken(mem_op,b,&peek_head,GSER_NO_COPY)) ){
		Asn1Error("Error during Reading { in encoded data");
		return LDAP_PROTOCOL_ERROR;
	}
	if(*peek_head != '{'){
		Asn1Error("Missing { in encoded data");
		return LDAP_PROTOCOL_ERROR;
	}

	if( !(strLen = LocateNextGSERToken(mem_op,b,&peek_head,GSER_NO_COPY)) ){
		Asn1Error("Error during Reading identifier");
		return LDAP_PROTOCOL_ERROR;
	}
	if ( strncmp( peek_head, "tbsCertList", strlen("tbsCertList") ) == 0 ) {
		rc = 	GDecComponentTBSCertList (mem_op, b, (&k->tbsCertList), bytesDecoded, mode);
		if ( rc != LDAP_SUCCESS ) return rc;
	( k->tbsCertList)->identifier.bv_val = peek_head;
	( k->tbsCertList)->identifier.bv_len = strLen;
	if( !(strLen = LocateNextGSERToken(mem_op,b,&peek_head,GSER_NO_COPY)) ){
		Asn1Error("Error during Reading , ");
		return LDAP_PROTOCOL_ERROR;
	}
	if(*peek_head != ','){
		Asn1Error("Missing , in encoding");
		return LDAP_PROTOCOL_ERROR;
	}
	if( !(strLen = LocateNextGSERToken(mem_op,b,&peek_head,GSER_NO_COPY)) ){
	  Asn1Error("Error during Reading identifier");
		return LDAP_PROTOCOL_ERROR;
	}
	}
	if ( strncmp( peek_head, "signatureAlgorithm", strlen("signatureAlgorithm") ) == 0 ) {
		rc = 	GDecComponentAlgorithmIdentifier (mem_op, b, (&k->signatureAlgorithm), bytesDecoded, mode);
		if ( rc != LDAP_SUCCESS ) return rc;
	( k->signatureAlgorithm)->identifier.bv_val = peek_head;
	( k->signatureAlgorithm)->identifier.bv_len = strLen;
	if( !(strLen = LocateNextGSERToken(mem_op,b,&peek_head,GSER_NO_COPY)) ){
		Asn1Error("Error during Reading , ");
		return LDAP_PROTOCOL_ERROR;
	}
	if(*peek_head != ','){
		Asn1Error("Missing , in encoding");
		return LDAP_PROTOCOL_ERROR;
	}
	if( !(strLen = LocateNextGSERToken(mem_op,b,&peek_head,GSER_NO_COPY)) ){
	  Asn1Error("Error during Reading identifier");
		return LDAP_PROTOCOL_ERROR;
	}
	}
	if ( strncmp( peek_head, "signature", strlen("signature") ) == 0 ) {
		rc = 	GDecComponentBits (mem_op, b, (&k->signature), bytesDecoded, mode);
		if ( rc != LDAP_SUCCESS ) return rc;
	(&k->signature)->identifier.bv_val = peek_head;
	(&k->signature)->identifier.bv_len = strLen;
	}
	if( !(strLen = LocateNextGSERToken(mem_op,b,&peek_head,GSER_NO_COPY)) ) {
		Asn1Error("Error during Reading } in encoding");
		return LDAP_PROTOCOL_ERROR;
	}
	if(*peek_head != '}'){
		Asn1Error("Missing } in encoding");
		return LDAP_PROTOCOL_ERROR;
	}
	if( !(old_mode & DEC_ALLOC_MODE_1) ) {
	*v = t = (ComponentCertificateList*) CompAlloc( mem_op, sizeof(ComponentCertificateList) );
	if ( !t ) return -1;
	*t = *k;
	}
	t->syntax = (Syntax*)NULL;
	t->comp_desc = CompAlloc( mem_op, sizeof( ComponentDesc ) );
	if ( !t->comp_desc ) {
		free ( t );
		return -1;
	}
	t->comp_desc->cd_ldap_encoder = (encoder_func*)NULL;
	t->comp_desc->cd_gser_encoder = (encoder_func*)NULL;
	t->comp_desc->cd_ber_encoder = (encoder_func*)NULL;
	t->comp_desc->cd_gser_decoder = (gser_decoder_func*)GDecComponentCertificateList ;
	t->comp_desc->cd_ber_decoder = (ber_decoder_func*)BDecComponentCertificateList ;
	t->comp_desc->cd_free = (comp_free_func*)NULL;
	t->comp_desc->cd_extract_i = (extract_component_from_id_func*)ExtractingComponentCertificateList;
	t->comp_desc->cd_type = ASN_COMPOSITE;
	t->comp_desc->cd_type_id = COMPOSITE_ASN1_TYPE;
	t->comp_desc->cd_all_match = (allcomponent_matching_func*)MatchingComponentCertificateList;
	return LDAP_SUCCESS;
}  /* GDecCertificateList*/
