/* program to print the headers on a series of soundfiles stored on a mag
tape */

#include "../H/sfheader.h"
#include <stdio.h>
#include "nlabel.h"
#include <sys/file.h>
#include <sys/types.h>
#include <sys/mtio.h>
#include <sys/ioctl.h>
#include <sys/stat.h>
#include <signal.h>
#include <errno.h>
#include <strings.h>
#include <sys/time.h>
#include <pwd.h>
static SFCODE	ampcode = {
	SF_MAXAMP,
	sizeof(SFMAXAMP) + sizeof(SFCODE)
}; 

char tapename[16] = NEW_TAPE_DEVICE;
char *usefile;
#define BUFFER 65536

	char buffer[BUFFER];

main(argc,argv)

int argc;
char *argv[];

{
	SFHEADER sfh1;
	SFMAXAMP sfm;
	SFCODE *sizer;
	SFCOMMENT sfcm;
	struct stat sfst1;
	struct mtget mtget ;
	struct mtop mtop ;
	struct label label;
/*	char buffer[BUFFER]; */
	extern int errno;

	char *cp,*sfin,*getsfcode();
	int i,number,tapeunit,tapefile,tapenumber;
	float duration;
	struct passwd *pwst,*getpwuid();
	int totalbytes,inbytes,allbytes,allt,j,l,restore,tint;

	char *catname,catholder[128],*chbptr,charbuff[500];
	char *tmpname,tmpholder[14],*sfcname,sfcnholder[17];
	char *getenv(),*ctime();
	FILE *fdcat,*fdtmp;
	struct tm *tmm,*localtime();

	if(argc == 1) {
usage:		printf("Usage: -s [files to skip] -f [device to use] -n [number of files to scan] -l [tapenumber] -c <to create new catalog>\nDefaults: skip over label only, device=/dev/rsmt0, scan one file\n");
		exit(1);
	}

	catname = catholder;
	tmpname = getenv("HOME");
	catname = strcpy(catname,tmpname);
	catname = strcat(catname,"/.catalogs/");
	tmpname = tmpholder;
	tmpname = strcpy(tmpname,"/tmp/");
	sfcname = sfcnholder;

	usefile = tapename;
	tapenumber = tapefile = restore = allbytes = 0;
	system("date");
	number = 1; /* default number of files to scan */
	argc--;
	while(argc) {
		++argv;
		argc -= 2; /* Take away two args */
		for(cp = argv[0]+1; *cp; cp++) {
			switch(*cp) { /* Grap options */
			case 'f': 
				usefile = *++argv;
				break;
			case 's':
				tapefile = atoi(*++argv);
				/* skip this number of files before reading*/
				break;
			case 'n':
				number = atoi(*++argv);
				break;
			case 'l':
				tapenumber = atoi(*++argv);
				catname = strcat(catname,*argv);
				catname = strcat(catname,".catlg");
				tmpname = strcat(tmpname,*argv);
				break;
			case 'c':
				restore = 1;
				break;
			default :
				printf("Unknown option\n");
				goto usage;
			}
		}
	}

	if (restore) {
		chbptr = charbuff;
		chbptr = strcpy(chbptr,"test -d ");
		chbptr = strcat(chbptr,getenv("HOME"));
		chbptr = strcat(chbptr,"/.catalogs");
		if (system(chbptr) != 0) {
			fprintf(stderr,
	"\n\nShame on you! You need a directory called '.catalogs' in\n");
			fprintf(stderr,
		"your home directory to run this program! Sorry.....\n\n\n");
			exit(-3);
			}
		}

	if((tapeunit = open(usefile,0)) < 0) {
		printf("trouble opening tape unit\n");
		exit(tapeunit);
	}
	if(!tapenumber) {
		printf("You didn't specify a tape number with -l flag\n");
		exit(-1);
	}
	if(read(tapeunit,&label,SIZEOFLABEL) != SIZEOFLABEL) {
		printf("Can't seem to read the label on this tape\n");
		exit(tapeunit);
	}
	if(label.tapenumber != tapenumber) {
		printf
		("this is tape number %d, you are asking for tape number %d\n"
		,label.tapenumber,tapenumber);
		exit(tapeunit);
	}
	mtop.mt_op = MTFSF;
	mtop.mt_count = 1;
	if((ioctl(tapeunit,MTIOCTOP,&mtop)) == -1) {
		printf("error forward spacing tape past label eof\n");
		exit(-2);
	}
	printf("Comment on tape %d: %s\n",label.tapenumber,label.comment);

	if (restore) {
		if ((fdtmp = fopen(tmpname,"w")) == NULL) {
			fprintf(stderr,"uh-oh, can't make the temp catalog!\n");
			exit(-3);
			}

		pwst = getpwuid(label.owner_uid);
		fprintf(fdtmp,
	"TAPE NUMBER: %d\t\tOwner: %s\n",label.tapenumber,pwst->pw_name);
		fprintf(fdtmp,
"Initialization date: %sComment: %s\n\n",ctime(&label.date),label.comment);

		fputs("file# dur\t chans class   nbytes\t  creation date     name\n",fdtmp);
		}

	if(tapefile) {
		mtop.mt_op = MTFSF;
		mtop.mt_count = tapefile;
		if((ioctl(tapeunit,MTIOCTOP,&mtop)) == -1) {
			printf("error forward spacing tape\n");
			exit(-2);
		}

		if (restore) {
			if ((fdcat = fopen(catname,"r")) != NULL) {
				for (j = 0; j < 5; j++) /* get past old hdr */
					fgets(chbptr,500,fdcat); 
				for (j = 0; j < tapefile; j++) {
					if (fgets(chbptr,128,fdcat) == NULL) {
						chbptr = strcpy(chbptr,"0 0 0 0 0 a MYSTERY file ???????\n");
						}
					else {
						sscanf(chbptr, 
						"%*d %*f %*d %*d %d",&allt);
						allbytes += allt;
						}
					fputs(chbptr,fdtmp);
					}
				fclose(fdcat);
				}
			else {
				fprintf(stderr,
					"Can't open the old catalog!\n");
				exit(-3);
				}
			}
	}

	for(i=0; i<number; i++) {
		if((inbytes = read(tapeunit,buffer,BUFFER)) != BUFFER) { 
			printf("Bad read on tape file\n");
			exit(-2);
		}
		bcopy(buffer,(char *)&sfh1,SIZEOF_HEADER);
		tapefile++;

		totalbytes = inbytes;
		while(inbytes == BUFFER) {
			if ((inbytes = read(tapeunit,buffer,BUFFER)) < 0) {
				printf("Bad forward space read on tape file\n");
				exit(-2);
				}
			totalbytes += inbytes;
			}
		allbytes += totalbytes;

		printf("--------------------------------------------------\n");
		if(!ismagic(&sfh1)) {
			printf("This doesn't look like a bsd soundfile\n");
		}
		else {
			printf("--------------->File number %d\n",tapefile);
			printsf(&sfh1);

			if (restore) {
				duration = 
					(float)totalbytes/(float)sfclass(&sfh1)/
					(float)sfchans(&sfh1)/sfsrate(&sfh1);

				if ((cp = getsfcode(&sfh1,SF_MAXAMP))!=NULL) {
					bcopy(cp + sizeof(SFCODE), (char *) &sfm, sizeof(SFMAXAMP));
					if(sfmaxamptime(&sfm)) {
						tmm = localtime(&sfmaxamptime(&sfm));
						}
					else {
						tint = time(0);
						tmm = localtime(&tint);
						}
					}
				else {
					tint = time(0);
					tmm = localtime(&tint);
					}
				if ((cp=getsfcode(&sfh1,SF_COMMENT)) != NULL) {
					sizer = (SFCODE *) cp;
					bcopy(cp + sizeof(SFCODE) , (char *) &sfcm, sizer->bsize);
					sfcname = strncpy(sfcname,&sfcomm(&sfcm,0),16);
					for (l = 0; l < 17; l++) {
						if (sfcnholder[l] == '\n')
							sfcnholder[l] = '\ ';
						}
					}
				else {
					sfcname = strcpy(sfcname,"???????");
					}

			fprintf(fdtmp,
"%3d   %.4f\t   %d     %d   %9d\t%02d:%02d:%02d %2d/%02d/%2d  %s\n",tapefile,duration,sfchans(&sfh1),sfclass(&sfh1),totalbytes,tmm->tm_hour,tmm->tm_min,tmm->tm_sec,tmm->tm_mon,tmm->tm_mday,tmm->tm_year,sfcname);

			if (i < number) {
				fclose(fdtmp);
				chbptr = strcpy(chbptr,"cp ");
				chbptr = strcat(chbptr,tmpname);
				chbptr = strcat(chbptr," ");
				chbptr = strcat(chbptr,catname);
				system(chbptr);
				if ((fdtmp = fopen(tmpname,"a")) == NULL) {
					fprintf(stderr,"Can't reopen tmp catalog!\n");
					exit(-3);
					}
				}
			}
		}

		fflush(stdout);

	}

	if (restore) {
		fprintf(fdtmp,
			"Total bytes used on this tape: %d\n",allbytes);
		fclose(fdtmp);
		chbptr = strcpy(chbptr,"mv ");
		chbptr = strcat(chbptr,tmpname);
		chbptr = strcat(chbptr," ");
		chbptr = strcat(chbptr,catname);
		system(chbptr);
		}

}
