/* sfbackup will not allow anyone else to access tape, sfrestore and tapescan
   will  (except root for sfbackup)*/
#include "../H/sfheader.h"
#include <stdio.h>
#include <sys/file.h>
#include <sys/types.h>
#include <sys/mtio.h>
#include <sys/ioctl.h>
#include <sys/stat.h>
#include <signal.h>
#include <errno.h>
#include <sys/time.h>
#include "nlabel.h"

char tapename[16] = NEW_TAPE_DEVICE;

main(argc,argv)
int argc;
char *argv[];
{
	struct label label;
	char date[26];
	int now,file,i;
	struct mtget mtget ;
	struct mtop mtop ;

	if(argc < 2) {
		printf("usage: writelabel tape#\n");
		exit(1);
	}
	label.date = time(0);
	printf("Enter comment, terminated by CR\n");
	gets(label.comment); /* LF/CR terminates comment */
	label.tapenumber = atoi(argv[1]);
	label.owner_uid = getuid();
	file = open(tapename,2); 
	write(file,&label,1024);
	mtop.mt_op = MTWEOF;
	mtop.mt_count = 1;
	if((ioctl(file,MTIOCTOP,&mtop)) == -1) {
		printf("error writing eof on tape\n");
		exit(-2);
	}
	mtop.mt_op = MTREW;
	mtop.mt_count = 1;
	if((ioctl(file,MTIOCTOP,&mtop)) == -1) {
		printf("error rewinding tape\n");
		exit(-2);
	}
	if(read(file,&label,SIZEOFLABEL) != SIZEOFLABEL) {
		printf("trouble reading back label from tape\n");
		exit(-2);
	}
	strcpy(date,ctime(&label.date));
	printf("\nContents of label, as read from tape:\n");
	printf("uid = %d\ntapenumber = %d\ndate = %scomment = %s\n",label.owner_uid,label.tapenumber,date,label.comment);
}
