#include <iostream.h>
#include "../../sys/mixerr.h"
#include "../../rtstuff/Instrument.h"
#include "FRET.h"
#include "../../rtstuff/rt.h"
#include "../../rtstuff/rtdefs.h"

extern strumq *curstrumq[6];

extern "C" {
	#include "../../H/ugens.h"
	void sset(float, float, float, strumq*);
	float strum(float, strumq*);
}

FRET::FRET() : Instrument()
{
	// future setup here?
}

int FRET::init(float p[], short n_args)
{
// p0 = start; p1 = dur; p2 = pitch(oct.pc); p3 = fundamental decay time;
// p4 = nyquist decay time; p5 = stereo spread [optional]

	start = p[0];
	dur = p[1];

	strumq1 = curstrumq[0];
	freq = cpspch(p[2]);
	tf0 = p[3];
	tfN = p[4];

	spread = p[5];
	firsttime = 1;
}

int FRET::run()
{
	int i;
	float out[2];

	if (firsttime) {
		sset(freq, tf0, tfN, strumq1);
		firsttime = 0;
		}

	for (i = 0; i < chunksamps; i++) {
		out[0] = strum(0.,strumq1);

		if (NCHANS == 2) { /* split stereo files between the channels */
			out[1] = (1.0 - spread) * out[0];
			out[0] *= spread;
			}

		rtaddout(out);
		cursamp++;
	}
	return i;
}



Instrument*
makeFRET()
{
	FRET *inst;

	inst = new FRET();
	return inst;
}
