#include "../../H/ugens.h"
#include "../../H/sfheader.h"
#include <stdio.h>
#include <sys/file.h>
#include <sys/types.h>
#include <sys/stat.h>

#define ARRSIZE 16384
#define SIZE 512

extern SFHEADER      sfdesc[NFILES];

/* combit --  comb filter instrument
*
* p0 = input skip
* p1 = output skip
* p2 = input duration
* p3 = amplitude multiplier
* p4 = pitch (cps)
* p5 = reverb time
* p6 = input channel [optional]
* p7 = stereo spread [optional]
*
*/
 

double
combit(p,n_args)
float *p;
{
        long i,nsamps,nend,n,smps=0;
        float loopt,xin[2],out[2];
	float amp,val,combarr[10000];
        int j, skip, chans, inchan;
        extern int lineset;
        extern float array[SIZE],tabs[2];
        extern struct stat sfst[NFILES];
	extern int resetval;
        
        if (p[2] == 0) /* old feature -- if p2 is 0 will do the whole file */
                p[2] = ((float)(sfst[0].st_size - SIZEOF_BSD_HEADER)/(float)sfclass(&sfdesc[0])/(float)sfchans(&sfdesc[0])
                         /sfsrate(&sfdesc[0])) - p[0];
        nsamps = setnote(p[0],p[2],0);
        setnote(p[1],p[2],1);
        loopt = 1.0/p[4];
        combset(loopt,p[5],0,combarr);

        if(!lineset) {
                for(j = 0; j < SIZE; j++) array[j] = 1;
                fprintf(stderr,"Set phrase curve to all 1's\n");
                lineset = 1;
                }
        tableset(p[2] + p[5], SIZE, tabs);

        amp = p[3];
        skip = SR/(float)resetval;
	inchan = p[6];
        j = 0;
        for (i = 0; i < nsamps; i++) {
                GETIN(xin,0);
                while (!j--) {
                         val = tablei(smps,array,tabs) * amp;
                         j = skip;
                         smps += skip;
                         }
                out[0] = comb(xin[inchan],combarr) * val;
		if (sfchans(&sfdesc[1]) == 2)  {
			out[1] = out[0] * (1.0 - p[7]);
			out[0] *= p[7];
			}
                ADDOUT(out,1);
                }

        nend = p[5] * SR;
        for (i = 0; i < nend; i++) {
                xin[inchan] = 0.0;
                while (!j--) {
                         val = tablei(smps,array,tabs) * amp;
                         j = skip;
                         smps += skip;
                         }
                out[0] = comb(xin[inchan],combarr) * val;
		if (sfchans(&sfdesc[1]) == 2) {
			out[1] = out[0] * (1.0 - p[7]);
			out[0] *= p[7];
			}
                ADDOUT(out,1);
                }
       endnote(1);
}


int NBYTES = 16384;
 
profile()
{
	UG_INTRO("combit",combit);
	UG_INTRO("setline",setline);
	UG_INTRO("reset",reset);
}

