#define maxdl 14000
#include "../../H/ugens.h"
#include "../../H/sfheader.h"
#include "strums.h"
extern  strumq strumq1;
extern  strumq strumq2;
extern  strumq strumq3;
extern   strumq strumq4;
typedef struct {
        int p,del;
        float d[maxdl],c1,c2;
        } delayq;
extern  delayq dq;

bend4(p,n_args)
 float *p;
 int n_args;

/* 4-string guitar with delay and distortion
   Part of a set of 4 programs--see start4.c for more info.
   bend4(star, dur, pitch0,pitch1,p0,p1,p0,p1,p0,p1,glissfcn
   decay time, Ny freq decayt, dist gain,loop gain, loop pitch
   premonitor, postmonitor)    */

  {
  float out[4],strum(),dist(),delay(),tabe,tags[2];
  float freq1a,freq2a,freq3a,freq4a,a,b,d,dgain,fbgain;
  float freq1b,freq2b,freq3b,freq4b,diff1,diff2,diff3,diff4;
  float *glissf,freq;
  int gliss,leng,j;
  long i,nsamps;

  out[0]=out[1]=out[2]=out[3]=0.0;
  d = 0;

  nsamps=setnote(p[0],p[1],1);

  freq1a=cpspch(p[2]);
  freq2a=cpspch(p[4]);
  freq3a=cpspch(p[6]);
  freq4a=cpspch(p[8]);
   
  freq1b=cpspch(p[3]);
  freq2b=cpspch(p[5]);
  freq3b=cpspch(p[7]);
  freq4b=cpspch(p[9]);

  diff1 = freq1b - freq1a;
  diff2 = freq2b - freq2a;
  diff3 = freq3b - freq3a;
  diff4 = freq4b - freq4a;

  dgain = p[13];
  fbgain = p[14]/dgain;
  sset(freq1a,p[11],p[12],&strumq1);
  sset(freq2a,p[11],p[12],&strumq2);
  sset(freq3a,p[11],p[12],&strumq3);
  sset(freq4a,p[11],p[12],&strumq4);
  delayset(cpspch(p[15]),&dq);

  gliss = p[10];
  glissf = (float *)floc(gliss);
  leng = fsize (gliss);
  tableset(p[1],leng,tags);
  leng = fsize (gliss);

  j= (float)SR/freq1a;



  printf("set completed\n");
         i = 0;


  for (i=0;i<nsamps;i++) {

    if(!--j) {
          tabe = tablei(i,glissf,tags);
          freq = diff1*tabe+freq1a;
          j = (float)SR/freq;
          sset(freq,p[11],p[12],&strumq1);

          freq = diff2*tabe+freq2a;
          sset(freq,p[11],p[12],&strumq2);
          freq = diff3*tabe+freq3a;
          sset(freq,p[11],p[12],&strumq3);
          freq = diff4*tabe+freq4a;
          sset(freq,p[11],p[12],&strumq4);
          }

           
      a = strum(d,&strumq1);
      a += strum(d,&strumq2);
      a += strum(d,&strumq3);
      a += strum(d,&strumq4);

      b = dist(dgain*a);
      d = fbgain*delay(b,&dq);
      out[0] = p[16]*a + p[17]*b;
      ADDOUT(out,1);
      }
      printf("loopcompleted\n");
  
  endnote(1);
}
