#define maxdl 14000
#include "../../H/ugens.h"
#include "../../H/sfheader.h"
#include "strums.h"
extern  strumq strumq1;
extern  strumq strumq2;
extern  strumq strumq3;
extern  strumq strumq4;
typedef struct {
        int p,del;
        float d[maxdl],c1,c2;
        } delayq;
extern  delayq dq;

start4(p,n_args)
 float *p;
 int n_args;

/* 4-string guitar with delay, feedback, and distortion.
   Uses strum (plucked string), delay (delay line), dist (distortion).
   One of set of 4 programs.

   Start4 starts a note by plucking all the strings simultaneously.
   Fret4 changes any or all of the parameters of the system during the
         course of a note.
   Pick4 is like start4, except that the sound from the last note is left
         in the delay line, whereas start4 cleans out the delay line.
   Bend4 is like fret4 except that the pitch follows a curve (set up by a 
         gen routine). 

   There are also 1-string and six string versions of some of these around.

   start4(star, dur, pitch, pitch, pitch, pitch, decay time, Ny freq decayt,
   dist gain, loop gain, loop pitch, premonitor, postmonitor, plamp,squish)   

   fret4(star, dur, pitch, pitch, pitch, pitch, decay time, Ny freq decayt,
   dist gain, loop gain, loop pitch, premonitor, postmonitor)   

   pick4(star, dur, pitch, pitch, pitch, pitch, decay time, Ny freq decayt,
   dist gain, loop gain, loop pitch, premonitor, postmonitor,plamp,squish)   

   bend4(star, dur, p0,p1,p0,p1,p0,p1,p0,p1,pitch, decay time, Ny freq decayt,
   dist gain, loop gain, loop pitch, premonitor, postmonitor)   

   Uses strum (plucked string), delay (delay line), dist (distortion).

   Each string may have a different pitch, but must have the same decay times.
   (Decay time is the decay time at the fundamental frequency of the note, and
   Ny decay time is the decay time at the Nyquist frequency. )
   Dist gain is the gain before the distortion unit.  More or less controls the
      amount of distortion without affecting much else.  For plamp = 1., 
      below .5 gives very little distortion.
      15 a good place to start if you want a lot.
   Loop gain is the gain of the feedback loop, excluding the gain of the
      string itself, which varies over different frequencies and different
      string parameters.  Something in the range of .01 to .06 will give
      a noticeable amount of feedback while remaining somewhat under control.
   Loop pitch sets the length of the delay (distance from guitar to amp) so
      the delay time equals the period of the pitch you specified.  In general,
      feedback will be possible at this pitch and its harmonics.  However, if
      a lot of distortion is used intially, the odd harmonics that are produced
      by the distortion are much easier to get feedback at than the even
      harmonics.
   Premonitor--output can be either the output of the string before distortion
      or after distortion.  Premonitor is the amount before.
   Postmonitor is the amount after distortion.
   Plamp is the amplitude of the pluck.  Although you can get the same effect
      by changing Dist gain and the monitor values, it may be easiest to
      vary this insted.
   Squish is an integer, 0 to about 10, indicating how soft an implement the
      strings are to be plucked with.  0 is hard, 10 is very soft.\
   p0 is pitch (of bend4) when function is at zero.
   p1 is pitch (of bend4) when function is at one.

       To end a note gracefully, make a call to fret4 with short decay times
   and little or no feedback so it dies out by itself.

       Use lots of reverb and phasing.  Try reverse-time reverb effects too.

   Things to try:
       The distortion curve used in dist (see) is symetric and so "transistor-
       like.  Try a more quadratic "tube like" curve.   Be careful that DC 
       problems don't result.

       Add a wah-wah pedal, either inside or outside the feedback loop.
       A swept single-pole bandpass filter should work well.

                                       Charlie Sullivan
                                       1/87
*/

   

  {
  float out[4],strum(),dist(),delay();
  float freq1,freq2,freq3,freq4,a,b,d,dgain,fbgain;
  int squish;
  long i,nsamps;

  out[0]=out[1]=out[2]=out[3]=0.0;
  d = 0;

  nsamps=setnote(p[0],p[1],1);

  freq1=cpspch(p[2]);
  freq2=cpspch(p[3]);
  freq3=cpspch(p[4]);
  freq4=cpspch(p[5]);
   
  dgain = p[8];
  fbgain = p[9]/dgain;
  sset(freq1,p[6],p[7],&strumq1);
  sset(freq2,p[6],p[7],&strumq2);
  sset(freq3,p[6],p[7],&strumq3);
  sset(freq4,p[6],p[7],&strumq4);

  squish = p[14];
  randfill(p[13],squish,&strumq1);
  randfill(p[13],squish,&strumq2);
  randfill(p[13],squish,&strumq3);
  randfill(p[13],squish,&strumq4);
  delayset(cpspch(p[10]),&dq);
  delayclean(&dq);
  printf("set completed\n");


  for (i=0;i<nsamps;i++) {
      a = strum(d,&strumq1);
      a += strum(d,&strumq2);
      a += strum(d,&strumq3);
      a += strum(d,&strumq4);

      b = dist(dgain*a);
      d = fbgain*delay(b,&dq);
      out[0] = p[11]*a + p[12]*b;
      ADDOUT(out,1);
      }
      printf("loopcompleted\n");
  
  endnote(1);
}
