#include "../../H/ugens.h"
#include "../../H/sfheader.h"

extern SFHEADER      sfdesc[NFILES];

/* waveshaping instrument
*  p0 = start
*  p1 = duration
*  p2 = pitch (hz or oct.pc)
*  p3 = index low point
*  p4 = index high point
*  p5 = amp
*  p6 = stereo spread (0-1) <optional>
*  function slot 1 is waveform to be shaped (generally sine)
*  slot 2 is amp envelope
*  slot 3 is the transfer function
*  slot 4 is the index envelope
*/


double
wsh(p,n_args)
float *p;
{

	float si,val,val2,val3;
	float *waveform, *ampenv, *xfer, *indenv;
	float amptabs[2],indtabs[2];
	int lenwave, lenamp, lenxfer, lenind;
	float phs,out[2],a0,a1,b1,c,z1,ampi;
	float index,amp,diff;
	int z,j;
	long nsamps,i;
	int chans;

	nsamps = setnote(p[0],p[1],1);

	waveform = floc(1);    /* function 1 is waveform */
	lenwave = fsize(1);
	if (p[2] < 15.0) p[2] = cpspch(p[2]);
	si = p[2] * (float)(lenwave/SR);

	ampenv = floc(2);
	lenamp = fsize(2);
	tableset(p[1], lenamp, amptabs);

	xfer = floc(3);
	lenxfer = fsize(3);

	indenv = floc(4);  /* function 4 is index guide */
	lenind = fsize(4);
	tableset(p[1],lenind,indtabs);

	diff = p[4] - p[3];

	/*initialize dc blocking filter*/
	c=PI*(float)(p[2]/2./SR);  /*cutoff frequency at pitch/2 */
	a0=1./(1.+c);
	a1= -a0;
	b1=a0*(1-c);
	z1=0;

	chans = sfchans(&sfdesc[1]);

	phs = 0.0;
	z = 1; /* interrupt once per cycle */
	j = 0;
	for(i = 0; i<nsamps; i++) {
	  	if(!j--) {  
			amp = table(i, ampenv, amptabs) * p[5];
			index = diff * tablei(i,indenv,indtabs) + p[3];
			ampi = amp/index;
			j = z;
	  		}

		val = oscili(1.0,si,waveform,lenwave,&phs);  /* wave */
		val2 = wshape(val*index,xfer,lenxfer); /* waveshape */
		/*dc blocking filter*/
		val3 = a1*z1;
		z1 = b1*z1+val2;
		val3 += a0*z1;
		val3 *= ampi;
		out[0] = val3;

		if (chans > 1) {
			out[1] = (1.0 - p[6]) * out[0];
			out[0] *= p[6];
			}

		ADDOUT(out,1);
		}

	endnote(1);
}


int NBYTES = 32768;
 
profile()
{
	UG_INTRO("wsh",wsh);
}
