#include <stdio.h>
#include <sys/soundcard.h>
#include <unistd.h>  /* DT maybe don't need this? */
#include <fcntl.h>
#include "../rtstuff/rtdefs.h"


/* DT:  1/5/96 TODO - fix all this ifdef stuff */
#ifdef SGI
#include <audio.h>
ALport out_port;
#endif

/* the descriptor for the audio port (LINUX and other OS's) */
int out_port;

extern int rtInteractive;  /* This is set to 0 in main.C and modified by resetparams */

double rtsetparams(float *p, short n_args)
{
 
  /* DT:  ALconfig out_port_config; */
  /* DT:  int pvbuf[2],buflen; */

  /* p0 = sampling rate, p1 = number of channels */
  
  /* Variables needed to set the audio port */
  int len,format,stereo,speed,cycle,frag_size,arg;

  SR = p[0];
  NCHANS = p[1];
  rtInteractive = p[2];
  
  /* configure and open output audio port */

  /* DT:  out_port_config = ALnewconfig(); 
     DT:  the rest was done by me for Linux and differs quite a bit
     from the SGI version here ... mostly in ioclt calls and such.
     the structure is similar

     TO DO:  makefile should compile either rtsetparams.linux or .sgi */

  /* Open the audio port */
  if ((out_port = open("/dev/dsp", O_WRONLY, 0)) == -1) { 
    perror("/dev/dsp");
    exit(1);
  }

  /* Set the fragment size */
  arg = 0x000e000e;
  if (ioctl(out_port, SNDCTL_DSP_SETFRAGMENT, &arg)==-1) {
    perror("incorrect fragment size");
    exit(1);
  }

  /* Get the size of the audio buffer */
  /* Note that the driver computes this optimally */
  if (ioctl(out_port, SNDCTL_DSP_GETBLKSIZE, &frag_size) == -1) {
    exit(1);
  }
  printf("Audio buffer:  %d\n",frag_size);

  /* Put the audio port in "sync" mode */
  /* No effect ? */
  ioctl(out_port, SNDCTL_DSP_SYNC, 0);

  /* Set the format for output samples */
  format = AFMT_S16_LE;
  if (ioctl(out_port, SNDCTL_DSP_SETFMT, &format)==-1) { 
    perror("SNDCTL_DSP_SETFMT");
    exit(1);
  }

  /* Set stereo / mono (1/0) */
  stereo = NCHANS-1;
  if (ioctl(out_port, SNDCTL_DSP_STEREO, &stereo)==-1) { 
    perror("SNDCTL_DSP_STEREO");
    exit(1);
  }

  /* Set sample rate */
  speed = SR;
  if (ioctl(out_port, SNDCTL_DSP_SPEED, &speed)==-1)
    { /* Fatal error */
      perror("SNDCTL_DSP_SPEED");
      exit(1);
    }
  
  if (!out_port) {
    fprintf(stderr, "could not open output audio port\n");
    return -1;
  }

  printf("audio set:  %f sampling rate, %d channels\n",SR,NCHANS);
  if (rtInteractive)
    printf("rtInteractive mode set.\n");
  else
    printf("rtInteractive mode NOT set.\n");

  return 1;
}






