#include <iostream.h>
#include "../rtstuff/Instrument.h"
#include "../rtstuff/rtdefs.h"
#include <fcntl.h>
#include <stdio.h>
#include <sys/types.h>
#include <unistd.h>
#include "../H/sfheader.h"

extern char *rtsfname;

int setinput(float start, Instrument *theInst)
{
	int i,sf,result,headersize;
	struct stat sfst;
	float dur;
	SFHEADER sfh;
	long seekbytes,seeked;

	/* open the file */
	/* using the built-in cmix macros in sfheader.h */
	readopensf(rtsfname,sf,sfh,sfst,"head",result);
	
	theInst->inputsr = sfsrate(&sfh);
	theInst->inputchans = sfchans(&sfh);

	/* use a unix fd for future porting to other platforms
 	   need to do a reset of the fd if we plan to do any more
	   with SGI AF lib stuff... */

	theInst->inputfd = sf;

	seekbytes = ((int)(start * SR)) * theInst->inputchans * sizeof(short);

	seeked = lseek(theInst->inputfd, seekbytes, SEEK_CUR);
	if (seeked == -1) {
		fprintf(stderr, "bad seek setting up the input soundfile\n");
		return(-1);
		}

	close(sf);
	return(seeked);
}
