head	1.10;
access;
symbols
	FTZ_05:1.9.1.1
	Distribution_06:1.9
	M_FTZ_04_Philips_01:1.8.3.2
	Philips_01:1.8.2.1
	FTZ_04:1.8.1.1
	D6Base:1.8
	Distribution_05:1.7.1.2
	FTZ_03:1.7.1.1
	Distribution_04:1.7
	Distribution_03:1.6
	FTZ_02:1.5.1.1
	Samsung_01:1.3.3.1
	IRT_01:1.3
	TI_01:1.3.1.1
	Distribution_01a:1.4
	Dist02_Sam_Merge:1.3.3.2
	Distribution_02:1.5
	IRT_TI_Merge:1.3.1.1
	Distribution_00:1.1
	Distribution_01:1.3;
locks; strict;
comment	@ * @;


1.10
date	96.02.12.07.13.06;	author rowlands;	state Exp;
branches;
next	1.9;

1.9
date	96.01.20.17.02.20;	author rowlands;	state Exp;
branches
	1.9.1.1;
next	1.8;

1.8
date	95.11.05.17.42.05;	author rowlands;	state Exp;
branches
	1.8.1.0
	1.8.2.0
	1.8.3.0;
next	1.7;

1.7
date	95.06.22.01.23.00;	author rowlands;	state Exp;
branches
	1.7.1.0;
next	1.6;

1.6
date	95.06.19.03.14.11;	author rowlands;	state Exp;
branches;
next	1.5;

1.5
date	95.06.16.08.49.22;	author rowlands;	state Exp;
branches
	1.5.1.0;
next	1.4;

1.4
date	95.06.16.06.19.08;	author rowlands;	state Exp;
branches;
next	1.3;

1.3
date	95.04.06.05.01.42;	author rowlands;	state Exp;
branches
	1.3.1.0
	1.3.3.0;
next	1.2;

1.2
date	95.04.06.04.56.00;	author rowlands;	state Exp;
branches;
next	1.1;

1.1
date	95.04.06.04.33.53;	author rowlands;	state Exp;
branches;
next	;

1.3.1.0
date	95.05.23.04.36.43;	author rowlands;	state Exp;
branches;
next	1.3.1.1;

1.3.1.1
date	95.06.14.04.36.30;	author rowlands;	state Exp;
branches;
next	;

1.3.3.0
date	95.06.16.07.56.38;	author rowlands;	state Exp;
branches;
next	1.3.3.1;

1.3.3.1
date	95.06.16.08.00.46;	author rowlands;	state Exp;
branches;
next	1.3.3.2;

1.3.3.2
date	95.06.16.08.44.58;	author rowlands;	state Exp;
branches;
next	;

1.5.1.0
date	95.06.17.21.22.51;	author rowlands;	state Exp;
branches;
next	1.5.1.1;

1.5.1.1
date	95.06.17.21.23.56;	author rowlands;	state Exp;
branches;
next	1.5.1.2;

1.5.1.2
date	95.06.17.21.27.02;	author rowlands;	state Exp;
branches;
next	1.5.1.3;

1.5.1.3
date	95.06.19.00.44.31;	author rowlands;	state Exp;
branches;
next	;

1.7.1.0
date	95.07.14.00.24.00;	author rowlands;	state Exp;
branches;
next	1.7.1.1;

1.7.1.1
date	95.07.14.06.12.46;	author rowlands;	state Exp;
branches;
next	1.7.1.2;

1.7.1.2
date	95.07.14.06.17.20;	author rowlands;	state Exp;
branches;
next	;

1.8.1.0
date	95.11.05.19.20.32;	author rowlands;	state Exp;
branches;
next	1.8.1.1;

1.8.1.1
date	95.11.05.19.24.24;	author rowlands;	state Exp;
branches;
next	;

1.8.2.0
date	95.11.05.19.26.32;	author rowlands;	state Exp;
branches;
next	1.8.2.1;

1.8.2.1
date	95.11.05.19.28.58;	author rowlands;	state Exp;
branches;
next	;

1.8.3.0
date	95.11.05.22.35.40;	author rowlands;	state Exp;
branches;
next	1.8.3.1;

1.8.3.1
date	95.11.05.22.50.42;	author rowlands;	state Exp;
branches;
next	1.8.3.2;

1.8.3.2
date	95.11.06.04.04.21;	author rowlands;	state Exp;
branches;
next	;

1.9.1.1
date	96.01.20.17.28.45;	author rowlands;	state Exp;
branches;
next	1.9.1.2;

1.9.1.2
date	96.01.20.20.11.31;	author rowlands;	state Exp;
branches;
next	;


desc
@MPEG-2 public C decoder
@


1.10
log
@Release following Munich meeting
@
text
@/**********************************************************************
 * ISO MPEG Audio Subgroup Software Simulation Group (1996)
 * ISO 13818-3 MPEG-2 Audio Multichannel Decoder
 *
 * $Id: musicout.c 1.9.1.2 1996/01/20 20:11:31 rowlands Exp $
 *
 * $Log: musicout.c $
 * Revision 1.9.1.1  1996/01/20  17:28:45  rowlands
 * Received from Ralf Schwalbe (Telekom FTZ) - includes prediction
 *
 * Revision 1.7.1.3  1995/08/14  08:13:37  tenkate
 * ML-LSF added Warner ten Kate 7/8/95 (Philips)
 * debugging
 * change "alloc" and "sblimit" into "allocml" and
 * "mlsblimit" where appropriate.
 * adapt sample-loops to 6 or 12 depending on half or full ML rate.
 *
 * Revision 1.7.1.1  1995/07/14  06:12:46  rowlands
 * Updated dynamic crosstalk from FTZ: revision FTZ_03
 *
 * Revision 1.3.3.1  1995/06/16  08:00:46  rowlands
 * Input from Sang Wook Kim (Samsung AIT)
 *
 * Revision 1.3.1.1  1995/06/14  04:36:30  rowlands
 * Added support for dematrixing procedure 2.
 *
 **********************************************************************/

/**********************************************************************
 *   date   programmers                comment                        *
 * 2/25/91  Douglas Wong        start of version 1.0 records          *
 * 3/06/91  Douglas Wong        rename setup.h to dedef.h             *
 *                              removed extraneous variables          *
 *                              removed window_samples (now part of   *
 *                              filter_samples)                       *
 * 3/07/91  Davis Pan           changed output file to "codmusic"     *
 * 5/10/91  Vish (PRISM)        Ported to Macintosh and Unix.         *
 *                              Incorporated new "out_fifo()" which   *
 *                              writes out last incomplete buffer.    *
 *                              Incorporated all AIFF routines which  *
 *                              are also compatible with SUN.         *
 *                              Incorporated user interface for       *
 *                              specifying sound file names.          *
 *                              Also incorporated user interface for  *
 *                              writing AIFF compatible sound files.  *
 * 27jun91  dpwe (Aware)        Added musicout and &sample_frames as  *
 *                              args to out_fifo (were glob refs).    *
 *                              Used new 'frame_params' struct.       *
 *                              Clean,simplify, track clipped output  *
 *                              and total bits/frame received.        *
 * 7/10/91  Earle Jennings      changed to floats to FLOAT            *
 *10/ 1/91  S.I. Sudharsanan,   Ported to IBM AIX platform.           *
 *          Don H. Lee,                                               *
 *          Peter W. Farrett                                          *
 *10/ 3/91  Don H. Lee          implemented CRC-16 error protection   *
 *                              newly introduced functions are        *
 *                              buffer_CRC and recover_CRC_error      *
 *                              Additions and revisions are marked    *
 *                              with "dhl" for clarity                *
 * 2/11/92  W. Joseph Carter    Ported new code to Macintosh.  Most   *
 *                              important fixes involved changing     *
 *                              16-bit ints to long or unsigned in    *
 *                              bit alloc routines for quant of 65535 *
 *                              and passing proper function args.     *
 *                              Removed "Other Joint Stereo" option   *
 *                              and made bitrate be total channel     *
 *                              bitrate, irrespective of the mode.    *
 *                              Fixed many small bugs & reorganized.  *
 **********************************************************************
 *                                                                    *
 *                                                                    *
 *  MPEG/audio Phase 2 coding/decoding multichannel                   *
 *                                                                    *
 *  Version 1.0                                                       *
 *                                                                    *
 *  7/27/93        Susanne Ritscher,  IRT Munich                      *
 *                                                                    *
 *                  thanks to                                         *
 *                  Ralf Schwalbe,    Telekom FTZ Berlin              *
 *                  Heiko Purnhagen,  Uni Hannover                    *
 *                                                                    *
 *  Version 2.0                                                       *
 *                                                                    *
 *  8/27/93        Susanne Ritscher, IRT Munich                       *
 *                 Channel-Switching is working                       *
 *                                                                    *
 *  Version 2.1                                                       *
 *                                                                    *
 *  9/1/93         Susanne Ritscher,  IRT Munich                      *
 *                 all channels normalized                            *
 *                                                                    *
 *  Version 3.0                                                       *
 *                                                                    *
 *  06/16/94       Ralf Schwalbe, Telekom FTZ Berlin                  *
 *                 all sources and variables adapted due to MPEG-2 -  *
 *                 DIS from March 1994                                *
 *                  - dematrix and denormalize procedure              *
 *                  - new tc - allocation (0-7)                       *
 *                  - some new structures and variables as a basis    *
 *                    for further decoding modes                      *
 **********************************************************************
 *								      *
 *  Version 1.0                                                       *
 *                                                                    *
 *  11/04/94       Ralf Schwalbe,  Telekom FTZ Berlin                 *
 *                  - decoding tc-allocation                          *
 *                  - some new subroutines, globale variables and     *
 *                    structures (important to handle the ext. bitst.)*
 *                  - changed all functions to ANSI-C funktion header *
 *		    - corrected some bugs to decode bitstreams > 512kB*
 *								      *
 *  Version 1.1                                                       *
 *                                                                    *
 *  12/07/94       Ralf Schwalbe,  Telekom FTZ Berlin                 *
 *                  - decoding extension bitstream                    *
 *                                                                    *
 *  Version 1.1.1                                                     *
 *                 Ralf Schwalbe, Telekom FTZ Berlin                  *
 *                  - fixed some bugs                                 *
 *                                                                    *
 *  Version 1.2                                                       *
 *                                                                    *
 *  6/21/95       Ralf Schwalbe, Deutsche Telekom FTZ Berlin          *
 *            	    - decoding dynamic crosstalk                      *
 *                  - decoding phantom center                         * 
 *                  - decoding MPEG1 compatible part only (stereo)    *
 *                  - corrected some settings and bugs                *
 * 								      *
 *  7/12/95	  Ralf Schwalbe, Deutsche Telekom FTZ Berlin          *
 *		    - corrected dynamic crosstalk 		      *
 *		    - 3/2,3/1,3/0,2/1, channel configurations         *
 *                    are working                                     *
 *		  						      *
 * 10/31/95	  Ralf Schwalbe, Deutsche Telekom FTZ Berlin	      *
 *		    - decoding of LFE-channel is working  	      *
 *		    - corrected any settings and bugs		      *
 *		    - corrected table-switch for channel mode < 3/2   *
 *		      and tc-allocation / dyn-crosstalk		      *
 *		    - still a problem with compl. bitstream 18/19     *
 * 01/12/96	  Ralf Schwalbe, Deutsche Telekom TZ Darmstadt	      *
 *		    - decoder prediction installed		      *
 *		    - problem with compl. bitstream 19 solved,        *
 *		    - still a problem with compl. bitstream 19        *
 *								      *		    
 **********************************************************************/
/**********************************************************************
 *                                                                    *
 *  06/06/95       Yeon Bae Thomas Kim,  Samsung AIT                  *
 *                 ancillary data is working                          *
 *								      *
 *  06/06/95       Sang Wook Kim,  Samsung AIT                        *
 *                 corrected some bugs                                *
 *								      *
 **********************************************************************/

#include        "common.h"
#include        "decoder.h"

/********************************************************************
*
*        This part contains the MPEG I / II decoder for Layers II.
*
*        Core of the Layer II decoder.  Default layer is Layer II.
*
*********************************************************************/

/* Global variable definitions for "musicout.c" */

char 		   *programName;
int 		   bits_in_frame = 0,Frame_Bits,Bitrate,channels=2,mc_channel=0;
int		   read_ext_header = 0,read_mpeg2_part = 0, only_1_bit = 0;
int		   read_from_ext = 0,ext_error=0, mpeg = 2; /* R.S. mpeg default for mc*/
unsigned long	   frameNum = 0L;
unsigned char	   bs_tmp_buf[50];
double		   S_freq;
layer 		   info;
int		   anc_index; /* ancillary data */
Bit_stream_struc   bs_ext;
int		   prog_mode = 0;    /*7/4/95 Ralf Schwalbe decision for prediction */
int		   lfe_sampling = 0; /*10/31/95 Ralf Schwalbe output LFE with 12 spl/frame */

/* Implementations */

main(int argc, char **argv)
{
typedef long PCM[5][3][SBLIMIT];		
	PCM  *pcm_sample;
	PCM  *pcm_sample_ml;			/* 10/03/1995 JMZ Multilingual*/
typedef unsigned int SAM[5][3][SBLIMIT];	
	SAM  *sample;
	SAM  *sample_ml;			/* 10/03/1995 JMZ Multilingual*/
typedef double FRA[5][SBLIMIT][3][12];		/* 7.10.93 R.S. mem - alloc for DOS */ 
	FRA  *fraction;
	FRA  *fraction_ml;			/*JMZ 09/03/1995 Multilingual */
typedef double FRA_HELP[12][5][3][SBLIMIT];	/* 10/03/1995 JMZ Multilingual*/
	FRA_HELP *fraction_help;
	FRA_HELP *fraction_help_ml;
typedef double FRA_BUF[2][8][36+PREDDEL];   
	FRA_BUF  *pred_buf; 
typedef double VE[5][HAN_SIZE];		
	VE  *w;

	Bit_stream_struc  bs;
	frame_params      fr_ps;
	FILE              *musicout, *lfe;
	FILE              *musicout_ml;			/* 10/03/1995 JMZ Multilingual*/
	unsigned long     sample_frames;
	unsigned long     sample_frames_ml;
	int		  i,jj, j, k, ii, stereo, done=FALSE, clip, sync,f;
	int               error_protection, crc_error_count, total_error_count;
	int               crc_check = 1,crc_error_countmc, total_error_countmc;
	unsigned int      old_crc, new_crc;
	unsigned int      bit_alloc[5][SBLIMIT], scfsi[5][SBLIMIT],
			  scale_index[5][3][SBLIMIT]; 
	unsigned int      bit_alloc_ml[5][SBLIMIT], scfsi_ml[5][SBLIMIT],
			  scale_index_ml[5][3][SBLIMIT]; /* 09/03/1995 JMZ Multilingual */
	unsigned long     bitsPerSlot, samplesPerFrame;
	unsigned long     frameBits, gotBits = 0;
	double		  dematrix2_filter_state[3];
	IFF_AIFF          pcm_aiff_data;
	char 	      	  encoded_file_name[MAX_NAME_SIZE];
	char 	      	  encoded_file_name1[MAX_NAME_SIZE]; /* 8/11/92.sr*/
	char              decoded_file_name[MAX_NAME_SIZE];
	char              decoded_file_name_ml[MAX_NAME_SIZE];/* 10/03/1995 JMZ Multilingual*/
	char		  ext_bitstream_name[MAX_NAME_SIZE];
	char		  frame_name[MAX_NAME_SIZE];
	char		  lfe_file_name[MAX_NAME_SIZE];
	char              t[50];
	int               need_aiff;
	int		  topSb = 0;
	int		  l, m, print_out = 0, ml =0;
	long		  pp; /* ancillary */
	int		  ch_start,lfe_init = 1; 
	short int	  lfe_tmp[12];
	
/*****************************************************************************/
	int hi, hu, ho;
	FILE *fp1;
	FILE *fp2;
	FILE *fp3;
	FILE *fp4;
	FILE *fp5;
/******************************************************************************/

#ifdef  MACINTOSH
	console_options.nrows = MAC_WINDOW_SIZE;
	argc = ccommand(&argv);
#endif
	/* Most large variables are declared dynamically to ensure
	   compatibility with smaller machines */

	pcm_sample = (PCM *) mem_alloc((long) sizeof(PCM), "PCM Samp");
	pcm_sample_ml = (PCM *) mem_alloc((long) sizeof(PCM), "PCM Samp");
	sample 	   = (SAM *) mem_alloc((long) sizeof(SAM), "Sample");
	sample_ml   = (SAM *) mem_alloc((long) sizeof(SAM), "Sample");
	fraction   = (FRA *) mem_alloc((long) sizeof(FRA), "fraction");  /* R.S. */
	fraction_ml   = (FRA *) mem_alloc((long) sizeof(FRA), "fraction");  /* R.S. */
	fraction_help = (FRA_HELP *) mem_alloc((long) sizeof(FRA_HELP), "fraction");
	fraction_help_ml = (FRA_HELP *) mem_alloc((long) sizeof(FRA_HELP), "fraction");
	pred_buf  = (FRA_BUF *) mem_alloc((long) sizeof(FRA_BUF), "pred_buf");
				
	w = (VE *) mem_alloc((long) sizeof(VE), "w");

	fr_ps.header = &info;
	fr_ps.tab_num = -1;                /* no table loaded */
	fr_ps.tab_num_ml = -1;
	fr_ps.alloc = NULL;
	fr_ps.allocml = NULL;

	info.mode_ext = 0;
	info.version = MPEG_AUDIO_ID;
	info.bitrate_index = 0;
	info.bitrate_index1 = 0;
	info.bitrate_index2 = 0;
	info.lfe = 0;	    		   /* no low frequency effect channel present! */

	info.no_of_multi_lingual_ch = 0;
	info.multi_lingual_fs = 0;
	info.multi_lingual_layer = 0;

	info.ext_bit_stream_present = 0;
	info.n_ad_bytes = info.ad_bytes_crc_info = 0;    /* 7.12.94 R.S. */

	info.lfe = 0;

	init_dematrix2_filter_state(dematrix2_filter_state);

	for (i=0;i<HAN_SIZE;i++) for (j=0;j<5;j++) (*w)[j][i] = 0.0;

#ifdef CONCAT
/* 23/03/1995 JMZ Concat */
    open_bit_stream_w(&bs_concat, "toto.mpg", BUFFER_SIZE);
#endif 	

	program_information();
	programName = argv[0];
	if(argc==1)
	{        /* no command line args -> interact */
	   do
	   {
		  printf ("Enter encoded file name <required>: ");
		  gets (encoded_file_name);
		  f = strlen(encoded_file_name)-4;	  /*cut off extension.8/11/92.sr*/
		  if (encoded_file_name[0] == NULL_CHAR)
			 printf ("Encoded file name is required. \n");
	   } while (encoded_file_name[0] == NULL_CHAR);

	   printf (">>> Encoded file name is: %s \n", encoded_file_name);
	   strcpy(encoded_file_name1, encoded_file_name);  /*8/11/92.sr*/
	   strcpy(&encoded_file_name1[f], DFLT_OPEXT);	  /*.dec-extension.8/11/92.sr*/
	   printf ("Enter MPEG decoded file name <%s>: ", encoded_file_name1);
	   gets (decoded_file_name);
	   if (decoded_file_name[0] == NULL_CHAR)
		strcpy(decoded_file_name, encoded_file_name1);

/* JMZ 10/03/1995 Multilingual */

	   printf (">>> MPEG decoded file name is: %s \n", decoded_file_name);

           /* encoded_file_name1 only for help */
	   strcpy(encoded_file_name1, encoded_file_name);
	   strcpy(&encoded_file_name1[f], DFLT_OPEXT_EXT);	  /* .ext */
	   printf (">>> Enter MPEG 2 decoded extension filename <%s>: ", encoded_file_name1);
	   gets(ext_bitstream_name);
	   if( ext_bitstream_name[0] == NULL_CHAR )
		strcpy(ext_bitstream_name, encoded_file_name1);
	   printf("Extension bitstream <%s> will be decoded \n",ext_bitstream_name);
	   /* 6/21/95 Ralf Schwalbe: stand a chance to decode MPEG1 compatible part */
	   if((open_bit_stream_r(&bs_ext, ext_bitstream_name, BUFFER_SIZE))==0)
	   { 	
		printf("No extension bitstream <%s> present \n",ext_bitstream_name);
		printf("Do you want to decode an MPEG 2 bitstream ? (<y>/n) : ");
		gets(t);
	   	if (*t == 'N' || *t == 'n') 
		{
			mpeg = 1;
			printf("An MPEG-1 Layer II bitstream will be decoded \n");
		}
	   	else
		{
			mpeg = 2;
			printf("An MPEG-2 Layer II bitstream will be decoded \n");
		}
	   } 
	   printf("Do you wish to write an AIFF compatible sound file ? (<y>/n) : ");
	   gets(t);
	   if (*t == 'N' || *t == 'n') need_aiff = FALSE;
	   else                        need_aiff = TRUE;
	   if (need_aiff)
		printf(">>> An AIFF compatible sound file will be written\n");
	   else printf(">>> A non-headered PCM sound file will be written\n");
	   
	   printf("Do you want to print out all decoding information ? (y/<n>) :");
	   gets(t);
	   if( *t == 'y' || *t == 'Y' ) print_out = 1;
	   else		      		print_out = 0;

	   printf(
		  "Do you wish to exit (last chance before decoding) ? (y/<n>) : ");
	   gets(t);
	   if (*t == 'y' || *t == 'Y') exit(0);
	}

	else	/************** interpret CL Args *****************/
		/* default: -write an AIFF file
	 		    -print encoded bitstream information  */
	{        
	   int i=0, err=0;

#ifdef UNIX /* default values */
	   need_aiff = TRUE;
	   print_out = 0;   /* 10/31/95 Ralf Schwalbe: set print_out off in CL Args */
	   mpeg = 2;
#else
	   need_aiff = FALSE;
#endif
	   encoded_file_name[0] = '\0';
	   decoded_file_name[0] = '\0';
	   ext_bitstream_name[0] = '\0';

	   while(++i<argc && err == 0)
	   {
		  char c, *token, *arg, *nextArg;
		  int  argUsed;

		  token = argv[i];
		  if(*token++ == '-')
		  {
			 if(i+1 < argc) nextArg = argv[i+1];
			 else           nextArg = "";
			 argUsed = 0;
			 while((c = *token++) != 0)
			 {
				if(*token /* NumericQ(token) */) arg = token;
				else                             arg = nextArg;
				switch(c)
				{
				   case 'i':  print_out = 1; break;
					    			
				   case 'a':  need_aiff = FALSE; break;
				   
				   case 'm':  mpeg = 1;break;

				   default:   fprintf(stderr,"%s: unrecognized option %c\n",
							  programName, c);
					      err = 1; break;
				}
				if(argUsed)
				{
					if(arg == token) token = ""; /* no more from token */
					else  ++i; /* skip arg we used */
					arg = ""; argUsed = 0;
				}
			 }
	  }
	  else
	  {
	     if(encoded_file_name[0] == '\0')
		strcpy(encoded_file_name, argv[i]);
	     else
		if(decoded_file_name[0] == '\0')
		   strcpy(decoded_file_name, argv[i]);
		else
		{
		   fprintf(stderr,"%s: excess arg %s\n", programName, argv[i]);
		   err = 1;
		}
	  }
       } /* end while argc */

       if(err || encoded_file_name[0] == '\0') usage();  /* never returns */
       if(ext_bitstream_name[0] == '\0')
       {
	  f = strlen(encoded_file_name)-4;
	  strcpy(ext_bitstream_name, encoded_file_name);
	  strcpy(&ext_bitstream_name[f], DFLT_OPEXT_EXT);
	  if((open_bit_stream_r(&bs_ext, ext_bitstream_name, BUFFER_SIZE))==0)
		printf("No extension bitstream <%s> present \n",ext_bitstream_name);
       }

       if(decoded_file_name[0] == '\0')
       {
	  f = strlen(encoded_file_name)-4;
	  strcpy(decoded_file_name, encoded_file_name);
	  strcpy(&decoded_file_name[f], DFLT_OPEXT);
       }

    }  /* else arg-line end */

    /* JMZ 10/03/1995 Multilingual */
    strcpy(decoded_file_name_ml, decoded_file_name);
    strcat(decoded_file_name_ml, DFLT_OPEXT_ML);

	/* report results of dialog / command line */
    printf("Input file = '%s' \nOutput file = '%s' ",
		   encoded_file_name, decoded_file_name);
    if(ext_bitstream_name[0] == '\0')
    	printf("Ext_bitstream = '%s'\n", ext_bitstream_name);
    if(mpeg == 1)
	   	printf(">>>\nA MPEG 1 Layer-2 bitstream will be decoded\n");
	   else
		printf(">>>\nA MPEG 2 Layer-2 bitstream will be decoded\n");  
	  
    if(need_aiff) printf("Output file written in AIFF format\n");

    if ((musicout = fopen(decoded_file_name, "w+b")) == NULL)
    {
	   printf ("Could not create \"%s\".\n", decoded_file_name);
	   exit(0);
    }
    total_error_countmc = 0;
    if(open_bit_stream_r(&bs, encoded_file_name, BUFFER_SIZE) == 0)
	exit(0);

    if (need_aiff)
	  if (aiff_seek_to_sound_data(musicout) == -1)
	  {
		  printf("Could not seek to PCM sound data in \"%s\".\n",
				 decoded_file_name);
		  exit(0);
	   }

    sample_frames = 0;
    sample_frames_ml = 0;

    while (!end_bs(&bs))
    {
    /****************************************************************/
    /*                                                              */
    /*                  START OF FRAME LOOP                         */
    /*                                                              */
    /****************************************************************/

#ifdef CONCAT    
/*		strcpy(frame_name, "frame.");
		sprintf(frame_name_ext, frameNum);
		strcat(frame_name, frame_name_ext);
    open_bit_stream_w(&bs_concat, frame_name, BUFFER_SIZE);*/
#endif 

	   sync = seek_sync(&bs, SYNC_WORD, SYNC_WORD_LNGTH);
	   frameBits = sstell(&bs) - gotBits;
	   if(frameNum > 0)        /* don't want to print on 1st loop; no lay */
		  if(frameBits%bitsPerSlot)
			 fprintf(stderr,"Got %ld bits = %ld slots plus %ld\n",
					 frameBits, frameBits/bitsPerSlot, frameBits%bitsPerSlot);
	   gotBits += frameBits;

	   if ( (info.lay==2) && 
                ((int)s_freq[info.sampling_frequency]==48) && 
	        (frameBits != 24*bitrate[info.lay-1][info.bitrate_index]) 
	      ) /* for debugging purposes WtK */
	      fprintf(stderr,"\n***Error. %d bits have been read instead of %d bits.\n",
	                     frameBits,24*bitrate[info.lay-1][info.bitrate_index]);
		  
	   if (!sync)
	   {
		  printf("\nFrame cannot be located, end of input stream \n");
		  done = TRUE;
		  /* finally write out the buffer */
		  if (info.lay == 2) 
			{
		  			out_fifo(*pcm_sample, 3, &fr_ps, done,
					      musicout, &sample_frames, channels);
					out_fifo_ml(*pcm_sample_ml, 3, &fr_ps, done, musicout_ml, &sample_frames_ml);
			}
		  else               out_fifo(*pcm_sample, 1, &fr_ps, done,
					      musicout, &sample_frames, channels);
		  break;
	   }
	   /* YBKim060695 ancillary */
	   else 
	   {
		pp = sstell(&bs) - 12;
	   }
	   info.lfe = 0;  		/* R.S. ! */
	   decode_info(&bs, &fr_ps);
	   hdr_to_frps(&fr_ps);

	   stereo = fr_ps.stereo;
	   error_protection = info.error_protection;
	   crc_error_count = 0;
	   total_error_count = 0;
	   if(frameNum == 0) WriteHdr(&fr_ps, stdout);  /* printout layer/mode */
	   if(frameNum == 1) 
	   	if(info.lfe)
		    printf("\nmc-channel=%d, MPEG2-ext-length=%d kbit/s lfe-channel present\n", mc_channel, info.ext_length*8/24);
		else
		    printf("\nmc-channel=%d, MPEG2-ext-length=%d kbit/s\n", mc_channel, info.ext_length*8/24);

	   fprintf(stderr, "{%4lu}\r", frameNum++); fflush(stderr);

	   Frame_Bits = 144*Bitrate/S_freq; 
	   if(info.padding)
		Frame_Bits++;    /* R.Schwalbe add a padding byte */
	   Frame_Bits*=8;	 /* R.Schwalbe to get bits per frame *8 */
	   if (error_protection) buffer_CRC(&bs, &old_crc);
          

           /* 7/8/95 added message WtK 7/8/95 */
	   if (info.lay != 2) {
	     switch (info.lay) {
	       case 1 : 
	       case 3 : printf("\nLayer = %d, not supported.\nexit.\n\n",info.lay); break;
	       default: printf("\n***Error. Layer = %d.\nexit.\n\n",info.lay); 
	       break;
	     }  
	     exit(1);
	   }
	   
	   if (info.lay == 2 )
	   {
			 bitsPerSlot = 8;        samplesPerFrame = 1152;
			 ch_start = 0;                  channels = stereo;
			 II_decode_bitalloc(&bs, bit_alloc, &fr_ps, &ch_start, &channels);
			 II_decode_scale(&bs, scfsi, bit_alloc, scale_index, &fr_ps, &ch_start, &channels);

			 if (error_protection) {
				II_CRC_calc(&fr_ps, bit_alloc, scfsi, &new_crc);
				if (new_crc != old_crc)
				{
				   printf(" \n ERROR in LAYER 2 - CRC! \n");
				   crc_error_count++;
				   total_error_count++;
				   recover_CRC_error(*pcm_sample, crc_error_count,
						 &fr_ps, musicout, &sample_frames, channels);
				}
				else crc_error_count = 0;
			 }

			 clip = 0;

			 for (i=0;i<12;i++)
			 {
				II_buffer_sample(&bs,(*sample),bit_alloc,&fr_ps);
				II_dequantize_sample((*sample),bit_alloc,*fraction,&fr_ps, &i);
				II_denormalize_sample(*fraction,scale_index,&fr_ps,i>>2, &i);

				if(topSb>0)         /*debug : clear channels to 0  */
				   for(j=topSb; j<fr_ps.sblimit; ++j)
					  for(k=0; k<stereo; ++k)
						 (*fraction)[i][k][0][j] =
						 (*fraction)[i][k][1][j] =
						 (*fraction)[i][k][2][j] = 0;

			 }   /* end of for loop */

		 /**********************************************************/
		 /*     	multichannel - decoding    	           */
		 /*             7.07.93 Susanne Ritscher                   */
		 /*            13.10.93 Ralf Schwalbe                      */
		 /*	       30.05.94 Ralf Schwalbe			   */
		 /**********************************************************/
		if(mpeg == 2)
		{	
		  mc_header(&bs, &fr_ps);

		  hdr_to_frps(&fr_ps);

		  if ( (frameNum==1) && (fr_ps.header->no_of_multi_lingual_ch>0) ) {
                    /*frameNum==1 NOT frameNum==0*/
		    if (fr_ps.header->no_of_multi_lingual_ch>5) {
		      printf("\n\n***Warning. There are %d multilingual channels.\n");
		      printf    ("            This decoder supports only upto 5 channels.\n\n");
		    }
		    printf("There are %d multilingual channels, coded at ",fr_ps.header->no_of_multi_lingual_ch);
		    if (fr_ps.header->multi_lingual_fs==0) printf("full"); else printf("half");
		    printf(" sampling rate.\n They are outputted in \"%s\".\n",decoded_file_name_ml);
		    if ((musicout_ml = fopen(decoded_file_name_ml, "w+b")) == NULL) {
    	              printf ("***Error. Could not create \"%s\".\nExit\n", decoded_file_name_ml);
	              exit(0);
                    }
		    if(need_aiff) {
		      printf("Multilingual file written in AIFF format\n");
                      if (aiff_seek_to_sound_data(musicout_ml) == -1) {
		         printf("Could not seek to PCM sound data in \"%s\".\n",
				 decoded_file_name_ml);
		         exit(0);
	              }  
    	            }
		  }

		  mc_channel = fr_ps.mc_channel;
		  crc_error_count = 0;
		  total_error_count = 0;
		  buffer_CRC(&bs, &old_crc);   /* read CRC - check from header */
		  mc_composite_status_info(&bs, &fr_ps);
		  
		  /* Achtung: fr_ps.jsbound = 27; wird in Abhngikeit von fs gesetzt*/
		  ch_start = 2;
		  channels = stereo + mc_channel;

		  /* decoding bitallocation's */
		
		  II_decode_bitalloc(&bs, bit_alloc, &fr_ps, &ch_start, &channels);
		  II_decode_scale(&bs, scfsi, bit_alloc, scale_index, &fr_ps, &ch_start, &channels);

		  /* mandatory CRC check is set */
		  if (crc_check)
		  {
		  	mc_error_check(&fr_ps, bit_alloc, scfsi, &new_crc);
			if (new_crc != old_crc)
			{
				crc_error_count++;
				total_error_countmc++;
				for( i = 0; i < SBLIMIT; i ++)
					for(ii = 2; ii < channels; ++ii)
						bit_alloc[ii][i] = 0;

				printf("\nERROR in MC-CRC -> mc frame can't be decoded !\n");
			}
			else
				crc_error_count = 0;
		  }  /* endif crc_check */

			  clip = 0;
			  for (i=0;i<12;i++)
			  {
				II_buffer_samplemc(&bs,(*sample),bit_alloc,&fr_ps,i);
				II_dequantize_samplemc((*sample),bit_alloc,*fraction,&fr_ps, &i);
				II_denormalize_samplemc(*fraction,scale_index,&fr_ps,i>>2, &i);

				if(topSb>0)        /* debug : clear channels to 0 */
				   for(j=topSb; j<fr_ps.sblimit; ++j)
					  for(k= l; k < m; ++k)
						 (*fraction)[k][j][0][i] =
						 (*fraction)[k][j][1][i] =
						 (*fraction)[k][j][2][i] = 0;
			   }

			/* 10/31/95 Ralf Schwalbe LFE */
			if( info.lfe ) 
			{ 
				if(lfe_init)
				{
	   				f = strlen(encoded_file_name)-4;
	   				strcpy(lfe_file_name, encoded_file_name);
	  				strcpy(&lfe_file_name[f], DFLT_OPEXT_LFE);
					if ((lfe = fopen(lfe_file_name, "w+b")) == NULL)
    					{
	  					printf ("Could not create \"%s\".\n",lfe_file_name );
	   					exit(0);
    					}
				}
				lfe_init = 0; /* R.S. only one time */	
				II_lfe_calc(&fr_ps);  
			}
/*********************************************************************/
/* JMZ 09/03/1995 Multilingual , WtK 7/8/95 */

if (info.no_of_multi_lingual_ch>0) 
	{
		  /* SWKim060695 add the condion with 32, 44.1kHz case */
		  if(info.sampling_frequency ==1) fr_ps.jsbound = 27;
	          			     else fr_ps.jsbound = 30;

		  m = info.no_of_multi_lingual_ch;

		  II_decode_bitalloc_ml(&bs, bit_alloc_ml, &fr_ps, &m);
		  II_decode_scale_ml(&bs, scfsi_ml, bit_alloc_ml, scale_index_ml, &fr_ps, &m);


			  clip = 0;
			  for (i=0;i<( (info.multi_lingual_fs==0) ? 12 : 6 );i++) /* ngr : n_of_granules loop */
			  {
				II_buffer_sample_ml(&bs, (*sample_ml), bit_alloc_ml, &fr_ps, &m);
				II_dequantize_sample_ml((*sample_ml), bit_alloc_ml, *fraction_ml, &fr_ps, &m, &i);
				II_denormalize_sample_ml(*fraction_ml, scale_index_ml, &fr_ps,
				                        ( (info.multi_lingual_fs==0) ? (i>>2) : (i>>1) ), &m, &i);
				
				if(topSb>0) 
				   for(j=topSb; j<fr_ps.mlsblimit; ++j)
					  for(k= 0; k < info.no_of_multi_lingual_ch; ++k)
						 (*fraction_ml)[k][j][0][i] =
						 (*fraction_ml)[k][j][1][i] =
						 (*fraction_ml)[k][j][2][i] = 0.0;
			   }
	}

/* JMZ 09/03/1995 Multilingual */
/*********************************************************************/

			if(info.mc_prediction_on)
			   for(k=0; k<2; k++)
			   	for(ii=0; ii<8; ii++) 
			   	{
			   	    for (j=0; j<PREDDEL; j++)
			       	    	(*pred_buf)[k][ii][j] = (*pred_buf)[k][ii][j+36];
			     	    for(j =0; j <3; j++)
			       	    	for(jj=0;jj<12;jj++)
				 	    (*pred_buf)[k][ii][PREDDEL+j+3*jj] = (*fraction)[k][ii][j][jj];
			   	}

			/* prediction & dematricing */
			if(crc_error_count == 0)
			    dematricing(*fraction, &fr_ps, dematrix2_filter_state, *pred_buf);

		      }   /* endif mpeg == 2 */	

			   for(jj=0;jj<12;jj++)
			      for(k=0; k < channels; k++)
				  for(j =0; j <3; j++)
				     for(ii=0; ii< SBLIMIT; ii++)
				(*fraction_help)[jj][k][j][ii] = (*fraction)[k][ii][j][jj];

			for (i=0;i<12;i++)
			{			  
			  for (j=0;j<3;j++) 
			    for (k=0; k < channels; k++)
				clip += SubBandSynthesis(&((*fraction_help)[i][k][j][0]), k,
							 &((*pcm_sample)[k][j][0]));

				out_fifo(*pcm_sample, 3, &fr_ps, done, musicout,
						 &sample_frames, channels);
			}

			/* 31/10/95 Ralf Schwalbe LFE output */
			if(info.lfe) 
		    	{
				for(jj = 0; jj < 12; jj++)
			     		lfe_tmp[jj] = (short int)(info.lfe_spl_fraction[jj] * SCALE);
				fwrite(&lfe_tmp[0],2,12,lfe); 
		    	}
			if(clip > 0) printf("\n%d samples clipped\n", clip);
			
/***************************************************************/
/* 10/03/1995 JMZ Multilingual , WtK 7/8/95 */
if(info.no_of_multi_lingual_ch>0) 
	{
			dematricing_ml(*fraction_ml, &fr_ps);
			
			for(jj=0;jj<( (info.multi_lingual_fs==0) ? 12 : 6 );jj++)
			   for(k=0; k<info.no_of_multi_lingual_ch; k++)
			       for(j =0; j <3; j++)
				  for(ii=0; ii< SBLIMIT; ii++)
			(*fraction_help_ml)[jj][k][j][ii] = (*fraction_ml)[k][ii][j][jj];

			clip = 0;
			for (i=0;i<( (info.multi_lingual_fs==0) ? 12 : 6 );i++)
			{			  
			  for (j=0;j<3;j++) 
			    for (k=0; k<info.no_of_multi_lingual_ch; k++)
				clip += SubBandSynthesis_ml(&((*fraction_help_ml)[i][k][j][0]), k,
							 &((*pcm_sample_ml)[k][j][0]));

			  out_fifo_ml(*pcm_sample_ml, 3, &fr_ps, done, musicout_ml, &sample_frames_ml);
			}
			if(clip > 0) printf("\n%d MultiLingual samples clipped\n", clip);
	}
/* 10/03/1995 JMZ Multilingual */
/**************************************************************/
		
		if(mpeg == 2) /* 10/31/95 R.S. */ 
			/* YBKim060695 ancillary decode */
			ancillaryDecode(&fr_ps,&bs,pp);

	    }		/*end of layer 2*/
	    else
		printf(" Layer Error: Decoding layer %d is not included in this program ", info.lay);

			
	
if( print_out == 1)
{
	if(frameNum == 1) 
	{
		fp5 = fopen("DYN_CROSS","w+");
		fp4 = fopen("INFODEC", "w+");
		fp2 = fopen("BALDEC", "w+");
		fp3 = fopen("SCFSIDEC", "w+");
		fp1 = fopen("SCFDEC", "w+");
	}
/*********************Ausgabe***************************************************/
fprintf(fp1, "******************** FRAME %d *****************************\n", frameNum-1);
fprintf(fp2, "\n******************** FRAME %d *****************************\n", frameNum-1);
fprintf(fp3, "\n******************** FRAME %d *****************************\n", frameNum-1);
fprintf(fp4, "******************** FRAME %d *****************************\n", frameNum-1);

fprintf(fp4, "version = %d, ", info.version);
fprintf(fp4, "lay = %d, ", info.lay);
fprintf(fp4, "error_protection = %d\n", info.error_protection);

fprintf(fp4, "bitrate_index = %d, ", info.bitrate_index);
fprintf(fp4, "bitrate_index1 = %d, ", info.bitrate_index1);
fprintf(fp4, "bitrate_index2 = %d\n", info.bitrate_index2);

fprintf(fp4, "sampling_frequency = %d,", info.sampling_frequency);
fprintf(fp4, "padding = %d, ", info.padding);
fprintf(fp4, "extension = %d\n", info.extension);

fprintf(fp4, "mode = %d, ", info.mode);
fprintf(fp4, "mode_ext = %d,", info.mode_ext);
fprintf(fp4, "copyright = %d, ", info.copyright);
fprintf(fp4, "original = %d, ", info.original);
fprintf(fp4, "emphasis = %d\n", info.emphasis);

fprintf(fp4, "center = %d, ", info.center);
fprintf(fp4, "surround = %d, ", info.surround);
fprintf(fp4, "dematrix_procedure = %d, ", info.dematrix_procedure);
fprintf(fp4, "lfe = %d\n", info.lfe);

fprintf(fp4, "no_of_multi_lingual_ch = %d, ", info.no_of_multi_lingual_ch);
fprintf(fp4, "multi_lingual_fs = %d, ", info.multi_lingual_fs);
fprintf(fp4, "multi_lingual_layer = %d\n", info.multi_lingual_layer);

fprintf(fp4, "dyn_cross_on = %d\n", info.dyn_cross_on);
fprintf(fp4, "mc_prediction_on = %d\n", info.mc_prediction_on);

#ifdef	DEBUG_PREDICTION
if(info.mc_prediction_on == 1)
   for(hu = 0; hu < 8; ++ hu)
   {
	fprintf(fp4, "mc_prediction[%d] = %d ", hu, info.mc_prediction[hu]);
	for(ho = 0; ho < 4; ho++)
	{
		fprintf(fp4, "mc_predsi[%d][%d] = %d  ", hu,ho, info.mc_predsi[hu][ho]);
		fprintf(fp4, "mc_delay[%d][%d] = %d  ", hu,ho, info.mc_delay_comp[hu][ho]);
		fprintf(fp4, " \n");
		for(hi = 0;hi <3; hi++)
		fprintf(fp4, "pred_coeff[%d][%d][%d] = %d ",hu,ho,hi,info.mc_pred_coeff[hu][ho][hi]);
		fprintf(fp4, " \n");
	}
   }
#endif

if(info.dyn_cross_on == 1)
{
	fprintf(fp5, "\n******************** FRAME %d *****************************\n", frameNum-1);
	fprintf(fp5,"dyn_cross_LR = %d\n",info.dyn_cross_LR);
	for(ho = 0; ho < 12; ho ++)
	{
		fprintf(fp5,"dyn_cross[%d] = %d   ",ho,info.dyn_cross_mode[ho]);
		if((ho+1)%4 == 0) fprintf(fp5,"\n");
	}
}

fprintf(fp4, "tc_sbgr_select = %d\n", info.tc_sbgr_select);
if(info.tc_sbgr_select == 1)
  fprintf(fp4, "tc_allocation = %d\n", info.tc_allocation);
else
	{
		for(ho = 0; ho < 12; ho ++)
	{
		if(info.mc_prediction[ho] == 0)
		fprintf(fp4, "tc_alloc[%d] = %d\n", ho, info.tc_alloc[ho]);
		else{
		for(hu = 0; hu < 4; hu++)
				fprintf(fp4, "predsi[%d][%d] = %d\n", ho, hu, info.mc_predsi[ho][hu]);
		}
	}
	fprintf(fp4, "\n");
	}

for(hu = 0; hu < SBLIMIT; ++hu)
{
	fprintf(fp2, "\n");
	fprintf(fp3, "\n");

	for(hi = 0; hi < 5; hi ++)
	{
	fprintf(fp1, "\n");
	fprintf(fp2, "BAL[%d][%d] = %d\t", hi, hu, bit_alloc[hi][hu]);
	fprintf(fp3, "SCFSI[%d][%d] = %d   ", hi, hu, scfsi[hi][hu]);

	for( ho = 0; ho < 3; ho ++)
	{
	   fprintf(fp1, "SCF[%d][%d][%d] = %d\t", hi, ho, hu, scale_index[hi][ho][hu]);
	}
	}
	fprintf(fp1, "\n");
}
/*******************************************************************************/

} /* endif of print_out == 1 */

    /****************************************************************/
    /*                                                              */
    /*                   END OF FRAME LOOP                          */
    /*                                                              */
    /****************************************************************/

}/*end of while(!endof(bs)) - loop */

	if (need_aiff) {
	   pcm_aiff_data.numChannels       = stereo + mc_channel;
	   pcm_aiff_data.numSampleFrames   = sample_frames;
	   pcm_aiff_data.sampleSize        = 16;
	   pcm_aiff_data.sampleRate        = s_freq[info.sampling_frequency]*1000;
	   strcpy(pcm_aiff_data.sampleType, IFF_ID_SSND);
	   pcm_aiff_data.blkAlgn.offset    = 0;
	   pcm_aiff_data.blkAlgn.blockSize = 0;

	   if (aiff_write_headers(musicout, &pcm_aiff_data) == -1) {
		  printf("Could not write AIFF headers to \"%s\"\n",
				 decoded_file_name);
		  exit(2);
           }

           if (fr_ps.header->no_of_multi_lingual_ch>0) {
	     pcm_aiff_data.numChannels       = fr_ps.header->no_of_multi_lingual_ch;
	     pcm_aiff_data.numSampleFrames   = sample_frames;
	     pcm_aiff_data.sampleSize        = 16;
	     pcm_aiff_data.sampleRate        = s_freq[info.sampling_frequency]*1000;
	     if (fr_ps.header->multi_lingual_fs==1) pcm_aiff_data.sampleRate *= 0.5;
	     strcpy(pcm_aiff_data.sampleType, IFF_ID_SSND);
	     pcm_aiff_data.blkAlgn.offset    = 0;
	     pcm_aiff_data.blkAlgn.blockSize = 0;
  
	     if (aiff_write_headers(musicout_ml, &pcm_aiff_data) == -1) {
		    printf("Could not write AIFF headers to \"%s\"\n",
				   decoded_file_name_ml);
		    exit(2);
	     }
	   }
	 }

	printf("Avg slots/frame = %.3f; b/smp = %.2f; br = %.3f kbps\n",
		   (FLOAT) gotBits / (frameNum * bitsPerSlot),
		   (FLOAT) gotBits / (frameNum * samplesPerFrame),
		   (FLOAT) gotBits / (frameNum * samplesPerFrame) *
		   s_freq[info.sampling_frequency]);

	close_bit_stream_r(&bs);
#ifdef CONCAT
close_bit_stream_w_concat(&bs_concat);	/* 23/03/1995 JMZ Concat */
#endif 
	if (info.ext_bit_stream_present)
	{
	     close_bit_stream_r(&bs_ext);

	}
	fclose(musicout);
	if(info.lfe) fclose(lfe);


#ifdef  MACINTOSH
	if (need_aiff) set_mac_file_attr(decoded_file_name, VOL_REF_NUM,
									 CREATR_DEC_AIFF, FILTYP_DEC_AIFF);
	else           set_mac_file_attr(decoded_file_name, VOL_REF_NUM,
									 CREATR_DEC_BNRY, FILTYP_DEC_BNRY);
#endif

	printf("Decoding of \"%s\" with %lu frames is finished\n", encoded_file_name, frameNum);
	printf("The decoded PCM output file name is \"%s\"\n", decoded_file_name);
	if (need_aiff)
	   printf("\"%s\" has been written with AIFF header information\n",
			  decoded_file_name);

	if (fr_ps.header->no_of_multi_lingual_ch>0) {
          printf("There are %d multilingual channels, coded at ",fr_ps.header->no_of_multi_lingual_ch);
          if (fr_ps.header->multi_lingual_fs==0) printf("full"); else printf("half");
          printf(" sampling rate.\n They are outputted in \"%s\".\n",decoded_file_name_ml);
          if (need_aiff)
	   printf("Multilingual file has been written with AIFF header information\n");
	}

	if(total_error_countmc != 0)
	printf("There were %d frames,  which were not in multichannel!!\n", total_error_countmc);

if(print_out ==1)
{
	fclose(fp1);
	fclose(fp2);
	fclose(fp3);
	fclose(fp4);
}
return(1);
}


void usage(void)  /* print syntax & exit */
{
   fprintf(stderr,
      "usage: %s                         queries for all arguments, or\n",
	   programName);
   fprintf(stderr,
      "       %s [-a] [-i] [-m] inputBS [outPCM]\n", programName);
   fprintf(stderr,"where\n");
   fprintf(stderr," -a       write a RAW data sound file  (default: write an AIFF sound file)\n");
   fprintf(stderr," -i       write decoded bitstream-information in a file\n"); 
   		     /* default: write encoded information */
   fprintf(stderr," -m       encoded bitstream is a MPEG 1 Layer-2 file\n"); 
   		     /* default: decode a MPEG 2 Layer-2 bitstream */
   fprintf(stderr," inputBS  input bit stream of encoded audio\n");
   fprintf(stderr," outPCM   output PCM sound file (dflt inName+%s)\n",
           DFLT_OPEXT);
   exit(1);
}
@


1.9
log
@Moved merged FTZ_04 and Philips_01 into main trunk
@
text
@d2 2
a3 3
 * Copyright (c) 1995 MPEG/audio software simulation group
 * All Rights Reserved
 * $Id: musicout.c 1.8.3.2 1995/11/06 04:04:21 rowlands Exp $
d5 1
a5 3
 * MPEG/audio coding/decoding software, work in progress
 *   NOT for public distribution until verified and approved by the
 *   MPEG/audio committee.
d8 2
a9 2
 * Revision 1.8.3.2  1995/11/06  04:04:21  rowlands
 * Merged FTZ_04 and Philips_01
a10 3
 * Revision 1.8.3.1  1995/11/05  22:50:42  rowlands
 * Merged FTZ_04 and Philips_01 using #ifdefs
 *
d12 1
a12 1
 * ML-LSF added WtK 7/8/95
a17 3
 * Revision 1.7.1.2  1995/07/14  06:17:20  rowlands
 * Merged changes in FTZ_03 and Distribution_04.
 *
a20 21
 * Revision 1.7.1.0  1995/07/14  00:24:00  rowlands
 * Branch for FTZ dynamic crosstalk
 *
 * Revision 1.7  1995/06/22  01:23:00  rowlands
 * Merged FTZ dynamic crosstalk
 *
 * Revision 1.6  1995/06/19  03:14:11  rowlands
 * Moved merged FTZ/Distribution_02 into main RC trunk.
 *
 * Revision 1.5.1.3  1995/06/19  00:44:31  rowlands
 * Merged old and new functionality.
 *
 * Revision 1.5.1.2  1995/06/17  21:27:02  rowlands
 * Merged with Distribution_02, marked by flag _FTZ
 *
 * Revision 1.5  1995/06/16  08:49:22  rowlands
 * Moved merged IRT/Samsung/TI into main revision control trunk.
 *
 * Revision 1.3.3.2  1995/06/16  08:44:58  rowlands
 * Merged and tested revisions 1.4 and 1.3.3.1
 *
d22 1
a22 1
 * Input from Samsung AIT.
a23 3
 * Revision 1.4  1995/06/16  06:19:08  rowlands
 * Moved merged IRT/TI into main revision control trunk.
 *
a26 9
 * Revision 1.3.1.0  1995/05/23  04:36:43  rowlands
 * Created branch for TI
 *
 * Revision 1.3  1995/04/06  05:01:42  rowlands
 * Ran decoder through protoize to convert to ANSI C.
 *
 * Revision 1.2  1995/04/06  04:56:00  rowlands
 * Added header, RCS info and cleaned up prototypes in initial revision.
 *
a29 2
 * VERSION 2.5                                                        *
 *   changes made since last update:                                  *
d103 1
a103 1
 *  Version 1.0 Shareware                                             *
d112 1
a112 1
 *  Version 1.1 Shareware                                             *
d117 1
a117 1
 *  Version 1.1.1 Shareware                                           *
d121 1
a121 1
 *  Version 1.2 Shareware                                             *
d140 4
d179 2
a180 1
int		   lfe_sampling = 0; /*10/31/95 Ralf Schwalbe output LFE in 12 spl/frame */
d188 1
a188 1
	PCM  *pcm_sample_ml;					/* 10/03/1995 JMZ Multilingual*/
d191 2
a192 2
	SAM  *sample_ml;						/* 10/03/1995 JMZ Multilingual*/
typedef double FRA[5][SBLIMIT][3][12];      /* 7.10.93 R.S. mem - alloc for DOS */ 
d194 1
a194 1
	FRA  *fraction_ml;					/*JMZ 09/03/1995 Multilingual */
d205 1
a205 1
	FILE              *musicout,*lfe;
d372 1
a372 1
	   print_out = 0;
d460 1
a460 1
	   	printf(">>>\nAn MPEG-1 Layer-2 bitstream will be decoded\n");
d462 1
a462 1
		printf(">>> \nAn MPEG-2 Layer-2 bitstream will be decoded\n");  
d486 1
a486 2

    while ( !end_bs(&bs) ) 
a506 1

d532 2
a533 1
	   else {
a535 1

d558 1
d564 1
a564 1
	       case 3 : printf("\nLayer = %d, not supported yet.\nexit.\n\n",info.lay); break;
d654 1
d669 1
d679 3
a681 3
				II_buffer_samplemc(&bs,(*sample),bit_alloc,&fr_ps, &channels, i);
				II_dequantize_samplemc((*sample),bit_alloc,*fraction,&fr_ps, &channels, &i);
				II_denormalize_samplemc(*fraction,scale_index,&fr_ps,i>>2, &channels, &i);
d743 14
a756 5
			 /*if(fr_ps.header->mc_prediction_on)*/   /* R.S. */
			
			 /* prediction & dematricing */
			 if(crc_error_count == 0)
			   dematricing(*fraction, &fr_ps, dematrix2_filter_state);
a783 1

a809 1

d812 1
d1041 1
a1041 1
   		     /* default: don't write encoded information */
@


1.9.1.1
log
@Received from Ralf Schwalbe - includes prediction
@
text
@d4 1
a4 1
 * $Id: musicout.c 1.7.1.2 1995/07/14 06:17:20 rowlands Exp $
d11 13
a183 4
 * 01/12/96	  Ralf Schwalbe, Deutsche Telekom TZ Darmstadt	      *
 *		    - decoder prediction installed		      *
 *		    - problem with compl. bitstream 19 solved,        *
 *		    - still a problem with compl. bitstream 19        *
d219 1
a219 2
int		   prog_mode = 0;    /*7/4/95 Ralf Schwalbe decision for prediction */
int		   lfe_sampling = 0; /*10/31/95 Ralf Schwalbe output LFE with 12 spl/frame */
d227 1
a227 1
	PCM  *pcm_sample_test;			/* 10/03/1995 JMZ Multilingual*/
d230 2
a231 2
	SAM  *sample_test;			/* 10/03/1995 JMZ Multilingual*/
typedef double FRA[5][SBLIMIT][3][12];      	/* 7.10.93 R.S. mem - alloc for DOS */ 
d233 1
a233 1
	FRA  *fraction_test;			/*JMZ 09/03/1995 Multilingual */
d236 1
a236 1
	FRA_HELP *fraction_help_test;
d247 1
a247 1
	unsigned long     sample_frames_test;
d254 2
a255 2
	unsigned int      bit_alloc_test[5][SBLIMIT], scfsi_test[5][SBLIMIT],
			  scale_index_test[5][3][SBLIMIT]; /* 09/03/1995 JMZ Multilingual */
d292 1
a292 1
	pcm_sample_test = (PCM *) mem_alloc((long) sizeof(PCM), "PCM Samp");
d294 1
a294 1
	sample_test   = (SAM *) mem_alloc((long) sizeof(SAM), "Sample");
d296 1
a296 1
	fraction_test   = (FRA *) mem_alloc((long) sizeof(FRA), "fraction");  /* R.S. */
d298 1
a298 1
	fraction_help_test = (FRA_HELP *) mem_alloc((long) sizeof(FRA_HELP), "fraction");
d305 1
d307 2
d315 5
a319 3
	info.no_of_multi_lingual_ch = 0;   /* not done yet */
	info.multi_lingual_fs = 0;         /* dto */
	info.multi_lingual_layer = 0;      /* dto */
d322 1
d324 1
d411 1
a411 1
	   print_out = 0;   /* 10/31/95 Ralf Schwalbe: set print_out off in CL Args */
a412 1
	   ml = 0;   /* 6/21/95 Ralf Schwalbe: set multi-lingual off in CL Args */
d491 1
a491 1
    strcat(decoded_file_name_ml, ".ml");
d499 1
a499 1
	   	printf(">>>\nA MPEG 1 Layer-2 bitstream will be decoded\n");
d501 1
a501 1
		printf(">>> \nA MPEG 2 Layer-2 bitstream will be decoded\n");  
a509 6
    if(ml)
    	if ((musicout_ml = fopen(decoded_file_name_ml, "w+b")) == NULL)
    	{
	   printf ("Could not create \"%s\".\n", decoded_file_name_ml);
	   exit(0);
    	}
d523 1
a523 1
    sample_frames_test = 0;
d525 2
a526 1
    while (!end_bs(&bs))
d528 5
d547 1
d550 7
d566 1
a566 1
					out_fifo_test(*pcm_sample_test, 3, &fr_ps, done, musicout_ml, &sample_frames_test);
d573 1
a573 2
	   else 
	   {
d576 1
d580 1
a598 1
          
d600 11
d659 24
a693 1
		
a707 1
				
d717 3
a719 3
				II_buffer_samplemc(&bs,(*sample),bit_alloc,&fr_ps,i);
				II_dequantize_samplemc((*sample),bit_alloc,*fraction,&fr_ps, &i);
				II_denormalize_samplemc(*fraction,scale_index,&fr_ps,i>>2, &i);
d747 1
a747 1
/* JMZ 09/03/1995 Multilingual */
a754 1
		  l = 5;
d757 2
a758 2
		  II_decode_bitalloc_test(&bs, bit_alloc_test, &fr_ps, &l, &m);
		  II_decode_scale_test(&bs, scfsi_test, bit_alloc_test, scale_index_test, &fr_ps, &l, &m);
d762 1
a762 1
			  for (i=0;i<12;i++)
d764 4
a767 1
				II_buffer_sample_test(&bs, (*sample_test), bit_alloc_test, &fr_ps,&m);
d769 6
a774 11
				II_dequantize_sample_test((*sample_test), bit_alloc_test, *fraction_test, &fr_ps, &m, &i);

				II_denormalize_sample_test(*fraction_test, scale_index_test, &fr_ps,i>>2, &m, &i);

				if(topSb>0)        /* debug : clear channels to 0 */
				   for(j=topSb; j<fr_ps.sblimit; ++j)
					  for(k= channels; k < channels; ++k)
						 (*fraction)[k][j][0][i] =
						 (*fraction)[k][j][1][i] =
						 (*fraction)[k][j][2][i] = 0;

d781 5
a785 10
			if(info.mc_prediction_on)
			   for(k=0; k<2; k++)
			   	for(ii=0; ii<8; ii++) 
			   	{
			   	    for (j=0; j<PREDDEL; j++)
			       	    	(*pred_buf)[k][ii][j] = (*pred_buf)[k][ii][j+36];
			     	    for(j =0; j <3; j++)
			       	    	for(jj=0;jj<12;jj++)
				 	    (*pred_buf)[k][ii][PREDDEL+j+3*jj] = (*fraction)[k][ii][j][jj];
			   	}
a786 4
			/* prediction & dematricing */
			if(crc_error_count == 0)
			    dematricing(*fraction, &fr_ps, dematrix2_filter_state, *pred_buf);

d805 1
d813 1
d817 2
a818 2
/* 10/03/1995 JMZ Multilingual */
if(info.no_of_multi_lingual_ch>0) /*15/03/1995 TEST*/
d820 7
a826 7
			   dematricing_test(*fraction_test, &fr_ps, *pred_buf);
			   
			   for(jj=0;jj<12;jj++)
			      for(k=0; k<info.no_of_multi_lingual_ch; k++)
				  for(j =0; j <3; j++)
				     for(ii=0; ii< SBLIMIT; ii++)
				(*fraction_help_test)[jj][k][j][ii] = (*fraction_test)[k][ii][j][jj];
d828 2
a829 1
			for (i=0;i<12;i++)
d833 2
a834 2
				clip += SubBandSynthesis_test(&((*fraction_help_test)[i][k][j][0]), k,
							 &((*pcm_sample_test)[k][j][0]));
d836 1
a836 1
				out_fifo_test(*pcm_sample_test, 3, &fr_ps, done, musicout_ml, &sample_frames_test);
d838 3
a840 2
			
		}
a842 1
		
d966 5
a970 1
	}/*end of while(!endof(bs)) - loop */
d972 2
d987 17
d1038 9
d1071 1
a1071 1
   		     /* default: write encoded information */
@


1.9.1.2
log
@Merged Distribution_06 and FTZ_05
@
text
@d4 1
a4 1
 * $Id: musicout.c 1.9.1.1 1996/01/20 17:28:45 rowlands Exp $
a10 19
 * Revision 1.9.1.1  1996/01/20  17:28:45  rowlands
 * Received from Ralf Schwalbe - includes prediction
 *
 * Revision 1.9  1996/01/20  17:02:20  rowlands
 * Moved merged FTZ_04 and Philips_01 into main trunk
 *
 * Revision 1.8.3.2  1995/11/06  04:04:21  rowlands
 * Merged FTZ_04 and Philips_01
 *
 * Revision 1.8.3.1  1995/11/05  22:50:42  rowlands
 * Merged FTZ_04 and Philips_01 using #ifdefs
 *
 * Revision 1.7.1.3  1995/08/14  08:13:37  tenkate
 * ML-LSF added WtK 7/8/95
 * debugging
 * change "alloc" and "sblimit" into "allocml" and
 * "mlsblimit" where appropriate.
 * adapt sample-loops to 6 or 12 depending on half or full ML rate.
 *
d219 1
a219 1
	PCM  *pcm_sample_ml;			/* 10/03/1995 JMZ Multilingual*/
d222 2
a223 2
	SAM  *sample_ml;			/* 10/03/1995 JMZ Multilingual*/
typedef double FRA[5][SBLIMIT][3][12];		/* 7.10.93 R.S. mem - alloc for DOS */ 
d225 1
a225 1
	FRA  *fraction_ml;			/*JMZ 09/03/1995 Multilingual */
d228 1
a228 1
	FRA_HELP *fraction_help_ml;
d236 1
a236 1
	FILE              *musicout, *lfe;
d239 1
a239 1
	unsigned long     sample_frames_ml;
d246 2
a247 2
	unsigned int      bit_alloc_ml[5][SBLIMIT], scfsi_ml[5][SBLIMIT],
			  scale_index_ml[5][3][SBLIMIT]; /* 09/03/1995 JMZ Multilingual */
d284 1
a284 1
	pcm_sample_ml = (PCM *) mem_alloc((long) sizeof(PCM), "PCM Samp");
d286 1
a286 1
	sample_ml   = (SAM *) mem_alloc((long) sizeof(SAM), "Sample");
d288 1
a288 1
	fraction_ml   = (FRA *) mem_alloc((long) sizeof(FRA), "fraction");  /* R.S. */
d290 1
a290 1
	fraction_help_ml = (FRA_HELP *) mem_alloc((long) sizeof(FRA_HELP), "fraction");
a296 1
	fr_ps.tab_num_ml = -1;
a297 2
	fr_ps.allocml = NULL;

d304 3
a306 5

	info.no_of_multi_lingual_ch = 0;
	info.multi_lingual_fs = 0;
	info.multi_lingual_layer = 0;

a308 1

a309 1

d398 1
d477 1
a477 1
    strcat(decoded_file_name_ml, DFLT_OPEXT_ML);
d487 1
a487 1
		printf(">>>\nA MPEG 2 Layer-2 bitstream will be decoded\n");  
d496 6
d515 1
a515 1
    sample_frames_ml = 0;
a518 5
    /****************************************************************/
    /*                                                              */
    /*                  START OF FRAME LOOP                         */
    /*                                                              */
    /****************************************************************/
a534 7
	   if ( (info.lay==2) && 
                ((int)s_freq[info.sampling_frequency]==48) && 
	        (frameBits != 24*bitrate[info.lay-1][info.bitrate_index]) 
	      ) /* for debugging purposes WtK */
	      fprintf(stderr,"\n***Error. %d bits have been read instead of %d bits.\n",
	                     frameBits,24*bitrate[info.lay-1][info.bitrate_index]);
		  
d544 1
a544 1
					out_fifo_ml(*pcm_sample_ml, 3, &fr_ps, done, musicout_ml, &sample_frames_ml);
a557 1

a577 11
           /* 7/8/95 added message WtK 7/8/95 */
	   if (info.lay != 2) {
	     switch (info.lay) {
	       case 1 : 
	       case 3 : printf("\nLayer = %d, not supported.\nexit.\n\n",info.lay); break;
	       default: printf("\n***Error. Layer = %d.\nexit.\n\n",info.lay); 
	       break;
	     }  
	     exit(1);
	   }
	   
a625 24

		  if ( (frameNum==1) && (fr_ps.header->no_of_multi_lingual_ch>0) ) {
                    /*frameNum==1 NOT frameNum==0*/
		    if (fr_ps.header->no_of_multi_lingual_ch>5) {
		      printf("\n\n***Warning. There are %d multilingual channels.\n");
		      printf    ("            This decoder supports only upto 5 channels.\n\n");
		    }
		    printf("There are %d multilingual channels, coded at ",fr_ps.header->no_of_multi_lingual_ch);
		    if (fr_ps.header->multi_lingual_fs==0) printf("full"); else printf("half");
		    printf(" sampling rate.\n They are outputted in \"%s\".\n",decoded_file_name_ml);
		    if ((musicout_ml = fopen(decoded_file_name_ml, "w+b")) == NULL) {
    	              printf ("***Error. Could not create \"%s\".\nExit\n", decoded_file_name_ml);
	              exit(0);
                    }
		    if(need_aiff) {
		      printf("Multilingual file written in AIFF format\n");
                      if (aiff_seek_to_sound_data(musicout_ml) == -1) {
		         printf("Could not seek to PCM sound data in \"%s\".\n",
				 decoded_file_name_ml);
		         exit(0);
	              }  
    	            }
		  }

d652 1
a652 1

d692 1
a692 1
/* JMZ 09/03/1995 Multilingual , WtK 7/8/95 */
d700 1
d703 2
a704 2
		  II_decode_bitalloc_ml(&bs, bit_alloc_ml, &fr_ps, &m);
		  II_decode_scale_ml(&bs, scfsi_ml, bit_alloc_ml, scale_index_ml, &fr_ps, &m);
d708 1
a708 1
			  for (i=0;i<( (info.multi_lingual_fs==0) ? 12 : 6 );i++) /* ngr : n_of_granules loop */
d710 1
a710 4
				II_buffer_sample_ml(&bs, (*sample_ml), bit_alloc_ml, &fr_ps, &m);
				II_dequantize_sample_ml((*sample_ml), bit_alloc_ml, *fraction_ml, &fr_ps, &m, &i);
				II_denormalize_sample_ml(*fraction_ml, scale_index_ml, &fr_ps,
				                        ( (info.multi_lingual_fs==0) ? (i>>2) : (i>>1) ), &m, &i);
d712 11
a722 6
				if(topSb>0) 
				   for(j=topSb; j<fr_ps.mlsblimit; ++j)
					  for(k= 0; k < info.no_of_multi_lingual_ch; ++k)
						 (*fraction_ml)[k][j][0][i] =
						 (*fraction_ml)[k][j][1][i] =
						 (*fraction_ml)[k][j][2][i] = 0.0;
a761 1

d772 2
a773 2
/* 10/03/1995 JMZ Multilingual , WtK 7/8/95 */
if(info.no_of_multi_lingual_ch>0) 
d775 7
a781 7
			dematricing_ml(*fraction_ml, &fr_ps);
			
			for(jj=0;jj<( (info.multi_lingual_fs==0) ? 12 : 6 );jj++)
			   for(k=0; k<info.no_of_multi_lingual_ch; k++)
			       for(j =0; j <3; j++)
				  for(ii=0; ii< SBLIMIT; ii++)
			(*fraction_help_ml)[jj][k][j][ii] = (*fraction_ml)[k][ii][j][jj];
d783 1
a783 2
			clip = 0;
			for (i=0;i<( (info.multi_lingual_fs==0) ? 12 : 6 );i++)
d787 2
a788 2
				clip += SubBandSynthesis_ml(&((*fraction_help_ml)[i][k][j][0]), k,
							 &((*pcm_sample_ml)[k][j][0]));
d790 1
a790 1
			  out_fifo_ml(*pcm_sample_ml, 3, &fr_ps, done, musicout_ml, &sample_frames_ml);
d792 2
a793 2
			if(clip > 0) printf("\n%d MultiLingual samples clipped\n", clip);
	}
d920 1
a920 5
    /****************************************************************/
    /*                                                              */
    /*                   END OF FRAME LOOP                          */
    /*                                                              */
    /****************************************************************/
a921 2
}/*end of while(!endof(bs)) - loop */

a934 17
           }

           if (fr_ps.header->no_of_multi_lingual_ch>0) {
	     pcm_aiff_data.numChannels       = fr_ps.header->no_of_multi_lingual_ch;
	     pcm_aiff_data.numSampleFrames   = sample_frames;
	     pcm_aiff_data.sampleSize        = 16;
	     pcm_aiff_data.sampleRate        = s_freq[info.sampling_frequency]*1000;
	     if (fr_ps.header->multi_lingual_fs==1) pcm_aiff_data.sampleRate *= 0.5;
	     strcpy(pcm_aiff_data.sampleType, IFF_ID_SSND);
	     pcm_aiff_data.blkAlgn.offset    = 0;
	     pcm_aiff_data.blkAlgn.blockSize = 0;
  
	     if (aiff_write_headers(musicout_ml, &pcm_aiff_data) == -1) {
		    printf("Could not write AIFF headers to \"%s\"\n",
				   decoded_file_name_ml);
		    exit(2);
	     }
a968 9

	if (fr_ps.header->no_of_multi_lingual_ch>0) {
          printf("There are %d multilingual channels, coded at ",fr_ps.header->no_of_multi_lingual_ch);
          if (fr_ps.header->multi_lingual_fs==0) printf("full"); else printf("half");
          printf(" sampling rate.\n They are outputted in \"%s\".\n",decoded_file_name_ml);
          if (need_aiff)
	   printf("Multilingual file has been written with AIFF header information\n");
	}

@


1.8
log
@Distribution_06 base
@
text
@d4 1
a4 1
 * $Id: musicout.c 1.7.1.2 1995/07/14 06:17:20 rowlands Exp $
d11 13
d178 7
d219 1
a220 1

d227 1
a227 1
	PCM  *pcm_sample_test;					/* 10/03/1995 JMZ Multilingual*/
d230 1
a230 1
	SAM  *sample_test;						/* 10/03/1995 JMZ Multilingual*/
d233 1
a233 1
	FRA  *fraction_test;					/*JMZ 09/03/1995 Multilingual */
d236 1
a236 1
	FRA_HELP *fraction_help_test;
d244 1
a244 1
	FILE              *musicout;
d247 1
a247 1
	unsigned long     sample_frames_test;
d254 2
a255 2
	unsigned int      bit_alloc_test[5][SBLIMIT], scfsi_test[5][SBLIMIT],
			  scale_index_test[5][3][SBLIMIT]; /* 09/03/1995 JMZ Multilingual */
d266 1
d272 2
a273 1
	int		  ch_start; 
d292 1
a292 1
	pcm_sample_test = (PCM *) mem_alloc((long) sizeof(PCM), "PCM Samp");
d294 1
a294 1
	sample_test   = (SAM *) mem_alloc((long) sizeof(SAM), "Sample");
d296 1
a296 1
	fraction_test   = (FRA *) mem_alloc((long) sizeof(FRA), "fraction");  /* R.S. */
d298 1
a298 1
	fraction_help_test = (FRA_HELP *) mem_alloc((long) sizeof(FRA_HELP), "fraction");
d305 1
d307 2
d315 5
a319 3
	info.no_of_multi_lingual_ch = 0;   /* not done yet */
	info.multi_lingual_fs = 0;         /* dto */
	info.multi_lingual_layer = 0;      /* dto */
d323 2
d392 1
a392 1
	   printf("Do you want to print out all decoding information ? (<y>/n) :");
d394 2
a395 2
	   if( *t == 'n' || *t == 'N' ) print_out = 0;
	   else		      		print_out = 1;
a396 7
	   printf("Decode with CRC - Check ? (<y>/n) :");
	   gets(t);
	   if( *t == 'n' || *t == 'N')
			crc_check = 0;
	   else
			crc_check = 1;         /*mc-crc is not ignored*/

d411 1
a411 1
	   print_out = 1;
a412 1
	   ml = 0;   /* 6/21/95 Ralf Schwalbe: set multi-lingual off in CL Args */
d437 1
a437 1
				   case 'i':  print_out = 0; break;
d491 1
a491 1
    strcat(decoded_file_name_ml, ".ml");
d499 1
a499 1
	   	printf(">>>\nAn MPEG 1 Layer-2 bitstream will be decoded\n");
d501 1
a501 1
		printf(">>> \nAn MPEG 2 Layer-2 bitstream will be decoded\n");  
a509 7
    if(ml)
    	if ((musicout_ml = fopen(decoded_file_name_ml, "w+b")) == NULL)
    	{
	   printf ("Could not create \"%s\".\n", decoded_file_name_ml);
	   exit(0);
    	}

d523 1
a523 1
    sample_frames_test = 0;
d525 2
a526 1
    while (!end_bs(&bs))
d528 5
d547 1
d550 7
d566 1
a566 1
					out_fifo_test(*pcm_sample_test, 3, &fr_ps, done, musicout_ml, &sample_frames_test);
d577 1
d580 1
d586 6
a591 1
	   if(frameNum == 1) printf(" mc-channel=%d, MPEG2-ext-length=%d \n", mc_channel, info.ext_length*8/24);
a598 1
           /* 6/21/95 Ralf Schwalbe: only layerII decoding (canceled switch layer)*/
d600 11
d659 24
a693 2
		  /* II_decode_bitalloc_lfe(&bs ....); */

a696 1

d706 1
a706 1
					for(ii = 2; ii < 5; ++ii)
a707 2
				mc_channel = 3;
				fr_ps.mc_channel = 3;
d717 1
a717 1
				II_buffer_samplemc(&bs,(*sample),bit_alloc,&fr_ps,&channels);
d729 17
d747 1
a747 1
/* JMZ 09/03/1995 Multilingual */
a754 1
		  l = 5;
d757 2
a758 2
		  II_decode_bitalloc_test(&bs, bit_alloc_test, &fr_ps, &l, &m);
		  II_decode_scale_test(&bs, scfsi_test, bit_alloc_test, scale_index_test, &fr_ps, &l, &m);
d762 1
a762 1
			  for (i=0;i<12;i++)
d764 4
a767 1
				II_buffer_sample_test(&bs, (*sample_test), bit_alloc_test, &fr_ps,&m);
d769 6
a774 11
				II_dequantize_sample_test((*sample_test), bit_alloc_test, *fraction_test, &fr_ps, &m, &i);

				II_denormalize_sample_test(*fraction_test, scale_index_test, &fr_ps,i>>2, &m, &i);

				if(topSb>0)        /* debug : clear channels to 0 */
				   for(j=topSb; j<fr_ps.sblimit; ++j)
					  for(k= channels; k < channels; ++k)
						 (*fraction)[k][j][0][i] =
						 (*fraction)[k][j][1][i] =
						 (*fraction)[k][j][2][i] = 0;

d785 1
a785 1
			   dematricing(*fraction, &fr_ps, dematrix2_filter_state, *pred_buf);
d805 9
d817 2
a818 2
/* 10/03/1995 JMZ Multilingual */
if(info.no_of_multi_lingual_ch>0) /*15/03/1995 TEST*/
d820 7
a826 7
			   dematricing_test(*fraction_test, &fr_ps, *pred_buf);
			   
			   for(jj=0;jj<12;jj++)
			      for(k=0; k<info.no_of_multi_lingual_ch; k++)
				  for(j =0; j <3; j++)
				     for(ii=0; ii< SBLIMIT; ii++)
				(*fraction_help_test)[jj][k][j][ii] = (*fraction_test)[k][ii][j][jj];
d828 2
a829 1
			for (i=0;i<12;i++)
d833 2
a834 2
				clip += SubBandSynthesis_test(&((*fraction_help_test)[i][k][j][0]), k,
							 &((*pcm_sample_test)[k][j][0]));
d836 1
a836 1
				out_fifo_test(*pcm_sample_test, 3, &fr_ps, done, musicout_ml, &sample_frames_test);
d838 3
a840 1
		}
d843 1
a843 1

d966 5
a970 1
	}/*end of while(!endof(bs)) - loop */
d972 2
d987 17
d1023 1
d1038 9
d1070 2
a1071 2
   fprintf(stderr," -i       don't write encoded bitstream-information in a file\n"); 
   		     /* default: write encoded information */
@


1.8.3.0
log
@Branch for merging FTZ_04 and Philips_01
@
text
@d4 1
a4 1
 * $Id: musicout.c 1.8 1995/11/05 17:42:05 rowlands Exp $
a10 3
 * Revision 1.8  1995/11/05  17:42:05  rowlands
 * Distribution_06 base
 *
@


1.8.3.1
log
@Merged FTZ_04 and Philips_01 using #ifdefs
@
text
@d4 1
a4 1
 * $Id: musicout.c,v 1.7.1.3 1995/08/14 08:13:37 tenkate Exp $
d10 3
a12 7
 * $Log: musicout.c,v $
 * Revision 1.7.1.3  1995/08/14  08:13:37  tenkate
 * ML-LSF added WtK 7/8/95
 * debugging
 * change "alloc" and "sblimit" into "allocml" and
 * "mlsblimit" where appropriate.
 * adapt sample-loops to 6 or 12 depending on half or full ML rate.
a167 9
#if	defined(DIFF_2)				/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
 * 10/31/95	  Ralf Schwalbe, Deutsche Telekom FTZ Berlin	      *
 *		    - decoding of LFE-channel is working  	      *
 *		    - corrected any settings and bugs		      *
 *		    - corrected table-switch for channel mode < 3/2   *
 *		      and tc-allocation / dyn-crosstalk		      *
 *		    - still a problem with compl. bitstream 18/19     *
 *								      *		    
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a201 1
#if	defined(DIFF_1) || defined(DIFF_3)	/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a202 3
#elif	defined(DIFF_2)				/* =========================== */
int		   lfe_sampling = 0; /*10/31/95 Ralf Schwalbe output LFE in 12 spl/frame */
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a205 3
#if	defined(DIFF_3)				/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */

#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a209 1
#if	defined(DIFF_1) || defined(DIFF_2)	/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a210 3
#elif	defined(DIFF_3)				/* =========================== */
	PCM  *pcm_sample_ml;					/* 10/03/1995 JMZ Multilingual*/
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a212 1
#if	defined(DIFF_1) || defined(DIFF_2)	/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a213 3
#elif	defined(DIFF_3)				/* =========================== */
	SAM  *sample_ml;						/* 10/03/1995 JMZ Multilingual*/
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a215 1
#if	defined(DIFF_1) || defined(DIFF_2)	/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a216 3
#elif	defined(DIFF_3)				/* =========================== */
	FRA  *fraction_ml;					/*JMZ 09/03/1995 Multilingual */
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a218 1
#if	defined(DIFF_1) || defined(DIFF_2)	/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a219 3
#elif	defined(DIFF_3)				/* =========================== */
	FRA_HELP *fraction_help_ml;
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a226 1
#if	defined(DIFF_1) || defined(DIFF_3)	/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a227 3
#elif	defined(DIFF_2)				/* =========================== */
	FILE              *musicout,*lfe;
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a229 1
#if	defined(DIFF_1) || defined(DIFF_2)	/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a230 3
#elif	defined(DIFF_3)				/* =========================== */
	unsigned long     sample_frames_ml;
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a236 1
#if	defined(DIFF_1) || defined(DIFF_2)	/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a238 4
#elif	defined(DIFF_3)				/* =========================== */
	unsigned int      bit_alloc_ml[5][SBLIMIT], scfsi_ml[5][SBLIMIT],
			  scale_index_ml[5][3][SBLIMIT]; /* 09/03/1995 JMZ Multilingual */
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a248 3
#if	defined(DIFF_2)				/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
	char		  lfe_file_name[MAX_NAME_SIZE];
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a251 1
#if	defined(DIFF_1) || defined(DIFF_2)	/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a252 3
#elif	defined(DIFF_3)				/* =========================== */
	int		  l, m, print_out = 0;
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a253 1
#if	defined(DIFF_1) || defined(DIFF_3)	/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a254 4
#elif	defined(DIFF_2)				/* =========================== */
	int		  ch_start,lfe_init = 1; 
	short int	  lfe_tmp[12];
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a272 1
#if	defined(DIFF_1) || defined(DIFF_2)	/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a273 3
#elif	defined(DIFF_3)				/* =========================== */
	pcm_sample_ml = (PCM *) mem_alloc((long) sizeof(PCM), "PCM Samp");
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a274 1
#if	defined(DIFF_1) || defined(DIFF_2)	/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a275 3
#elif	defined(DIFF_3)				/* =========================== */
	sample_ml   = (SAM *) mem_alloc((long) sizeof(SAM), "Sample");
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a276 1
#if	defined(DIFF_1) || defined(DIFF_2)	/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a277 3
#elif	defined(DIFF_3)				/* =========================== */
	fraction_ml   = (FRA *) mem_alloc((long) sizeof(FRA), "fraction");  /* R.S. */
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a278 1
#if	defined(DIFF_1) || defined(DIFF_2)	/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a279 3
#elif	defined(DIFF_3)				/* =========================== */
	fraction_help_ml = (FRA_HELP *) mem_alloc((long) sizeof(FRA_HELP), "fraction");
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a285 3
#if	defined(DIFF_3)				/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
	fr_ps.tab_num_ml = -1;
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a286 3
#if	defined(DIFF_3)				/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
	fr_ps.allocml = NULL;
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a292 1
#if	defined(DIFF_1) || defined(DIFF_2)	/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a295 5
#elif	defined(DIFF_3)				/* =========================== */
	info.no_of_multi_lingual_ch = 0;
	info.multi_lingual_fs = 0;
	info.multi_lingual_layer = 0;
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a297 1
#if	defined(DIFF_1) || defined(DIFF_3)	/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a298 3
#elif	defined(DIFF_2)				/* =========================== */
	info.lfe = 0;
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a365 1
#if	defined(DIFF_1)				/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a366 3
#elif	defined(DIFF_2) || defined(DIFF_3)	/* =========================== */
	   printf("Do you want to print out all decoding information ? (y/<n>) :");
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a367 1
#if	defined(DIFF_1)				/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a369 4
#elif	defined(DIFF_2) || defined(DIFF_3)	/* =========================== */
	   if( *t == 'y' || *t == 'Y' ) print_out = 1;
	   else		      		print_out = 0;
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a370 1
#if	defined(DIFF_1) || defined(DIFF_3)	/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a377 1
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a391 1
#if	defined(DIFF_1)				/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a392 5
#elif	defined(DIFF_2)				/* =========================== */
	   print_out = 0;   /* 10/31/95 Ralf Schwalbe: set print_out off in CL Args */
#elif	defined(DIFF_3)				/* =========================== */
	   print_out = 0;
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a393 1
#if	defined(DIFF_1) || defined(DIFF_2)	/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a394 1
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a418 1
#if	defined(DIFF_1)				/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a419 3
#elif	defined(DIFF_2) || defined(DIFF_3)	/* =========================== */
				   case 'i':  print_out = 1; break;
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a472 1
#if	defined(DIFF_1) || defined(DIFF_2)	/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a473 3
#elif	defined(DIFF_3)				/* =========================== */
    strcat(decoded_file_name_ml, DFLT_OPEXT_ML);
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a480 1
#if	defined(DIFF_1) || defined(DIFF_3)	/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a481 3
#elif	defined(DIFF_2)				/* =========================== */
	   	printf(">>>\nA MPEG 1 Layer-2 bitstream will be decoded\n");
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a482 1
#if	defined(DIFF_1) || defined(DIFF_3)	/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a483 3
#elif	defined(DIFF_2)				/* =========================== */
		printf(">>> \nA MPEG 2 Layer-2 bitstream will be decoded\n");  
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a491 1
#if	defined(DIFF_1)				/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a498 8
#elif	defined(DIFF_2)				/* =========================== */
    if(ml)
    	if ((musicout_ml = fopen(decoded_file_name_ml, "w+b")) == NULL)
    	{
	   printf ("Could not create \"%s\".\n", decoded_file_name_ml);
	   exit(0);
    	}
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a511 1
#if	defined(DIFF_1) || defined(DIFF_2)	/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a514 6
#elif	defined(DIFF_3)				/* =========================== */
    sample_frames_ml = 0;


    while ( !end_bs(&bs) ) 
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a515 7
#if	defined(DIFF_3)				/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
    /****************************************************************/
    /*                                                              */
    /*                  START OF FRAME LOOP                         */
    /*                                                              */
    /****************************************************************/
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a529 3
#if	defined(DIFF_3)				/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */

#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a531 9
#if	defined(DIFF_3)				/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
	   if ( (info.lay==2) && 
                ((int)s_freq[info.sampling_frequency]==48) && 
	        (frameBits != 24*bitrate[info.lay-1][info.bitrate_index]) 
	      ) /* for debugging purposes WtK */
	      fprintf(stderr,"\n***Error. %d bits have been read instead of %d bits.\n",
	                     frameBits,24*bitrate[info.lay-1][info.bitrate_index]);
		  
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a540 1
#if	defined(DIFF_1) || defined(DIFF_2)	/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a541 3
#elif	defined(DIFF_3)				/* =========================== */
					out_fifo_ml(*pcm_sample_ml, 3, &fr_ps, done, musicout_ml, &sample_frames_ml);
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a547 1
#if	defined(DIFF_1) || defined(DIFF_3)	/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a548 4
#elif	defined(DIFF_2)				/* =========================== */
	   else 
	   {
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a550 1
#if	defined(DIFF_1) || defined(DIFF_3)	/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a551 3
#elif	defined(DIFF_2)				/* =========================== */
	   info.lfe = 0;  		/* R.S. ! */
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a558 1
#if	defined(DIFF_1) || defined(DIFF_3)	/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a559 8
#elif	defined(DIFF_2)				/* =========================== */
	   if(frameNum == 1) 
	   	if(info.lfe)
		    printf("\nmc-channel=%d, MPEG2-ext-length=%d kbit/s lfe-channel present\n", mc_channel, info.ext_length*8/24);
		else
		    printf("\nmc-channel=%d, MPEG2-ext-length=%d kbit/s\n", mc_channel, info.ext_length*8/24);

#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a566 1
#if	defined(DIFF_1)				/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a568 17
#elif	defined(DIFF_2)				/* =========================== */
          

#elif	defined(DIFF_3)				/* =========================== */
           /* 6/21/95 Ralf Schwalbe: only layerII decoding (canceled switch layer)*/
           /* 7/8/95 added message WtK 7/8/95 */
	   if (info.lay != 2) {
	     switch (info.lay) {
	       case 1 : 
	       case 3 : printf("\nLayer = %d, not supported yet.\nexit.\n\n",info.lay); break;
	       default: printf("\n***Error. Layer = %d.\nexit.\n\n",info.lay); 
	       break;
	     }  
	     exit(1);
	   }
	   
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a616 24
#if	defined(DIFF_3)				/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
		  if ( (frameNum==1) && (fr_ps.header->no_of_multi_lingual_ch>0) ) {
                    /*frameNum==1 NOT frameNum==0*/
		    if (fr_ps.header->no_of_multi_lingual_ch>5) {
		      printf("\n\n***Warning. There are %d multilingual channels.\n");
		      printf    ("            This decoder supports only upto 5 channels.\n\n");
		    }
		    printf("There are %d multilingual channels, coded at ",fr_ps.header->no_of_multi_lingual_ch);
		    if (fr_ps.header->multi_lingual_fs==0) printf("full"); else printf("half");
		    printf(" sampling rate.\n They are outputted in \"%s\".\n",decoded_file_name_ml);
		    if ((musicout_ml = fopen(decoded_file_name_ml, "w+b")) == NULL) {
    	              printf ("***Error. Could not create \"%s\".\nExit\n", decoded_file_name_ml);
	              exit(0);
                    }
		    if(need_aiff) {
		      printf("Multilingual file written in AIFF format\n");
                      if (aiff_seek_to_sound_data(musicout_ml) == -1) {
		         printf("Could not seek to PCM sound data in \"%s\".\n",
				 decoded_file_name_ml);
		         exit(0);
	              }  
    	            }
		  }
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a627 1
#if	defined(DIFF_1) || defined(DIFF_3)	/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a629 3
#elif	defined(DIFF_2)				/* =========================== */
		
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a632 1
#if	defined(DIFF_1) || defined(DIFF_3)	/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a633 1
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a642 1
#if	defined(DIFF_1) || defined(DIFF_3)	/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a643 3
#elif	defined(DIFF_2)				/* =========================== */
					for(ii = 2; ii < channels; ++ii)
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a644 1
#if	defined(DIFF_1) || defined(DIFF_3)	/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a646 3
#elif	defined(DIFF_2)				/* =========================== */
				
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a655 1
#if	defined(DIFF_1) || defined(DIFF_3)	/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a658 5
#elif	defined(DIFF_2)				/* =========================== */
				II_buffer_samplemc(&bs,(*sample),bit_alloc,&fr_ps,i);
				II_dequantize_samplemc((*sample),bit_alloc,*fraction,&fr_ps, &i);
				II_denormalize_samplemc(*fraction,scale_index,&fr_ps,i>>2, &i);
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a667 19
#if	defined(DIFF_2)				/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
			/* 10/31/95 Ralf Schwalbe LFE */
			if( info.lfe ) 
			{ 
				if(lfe_init)
				{
	   				f = strlen(encoded_file_name)-4;
	   				strcpy(lfe_file_name, encoded_file_name);
	  				strcpy(&lfe_file_name[f], DFLT_OPEXT_LFE);
					if ((lfe = fopen(lfe_file_name, "w+b")) == NULL)
    					{
	  					printf ("Could not create \"%s\".\n",lfe_file_name );
	   					exit(0);
    					}
				}
				lfe_init = 0; /* R.S. only one time */	
				II_lfe_calc(&fr_ps);  
			}
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a668 1
#if	defined(DIFF_1) || defined(DIFF_2)	/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a669 3
#elif	defined(DIFF_3)				/* =========================== */
/* JMZ 09/03/1995 Multilingual , WtK 7/8/95 */
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a676 1
#if	defined(DIFF_1) || defined(DIFF_2)	/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a677 1
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a679 1
#if	defined(DIFF_1) || defined(DIFF_2)	/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a681 4
#elif	defined(DIFF_3)				/* =========================== */
		  II_decode_bitalloc_ml(&bs, bit_alloc_ml, &fr_ps, &m);
		  II_decode_scale_ml(&bs, scfsi_ml, bit_alloc_ml, scale_index_ml, &fr_ps, &m);
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a684 1
#if	defined(DIFF_1) || defined(DIFF_2)	/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a685 3
#elif	defined(DIFF_3)				/* =========================== */
			  for (i=0;i<( (info.multi_lingual_fs==0) ? 12 : 6 );i++) /* ngr : n_of_granules loop */
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a686 1
#if	defined(DIFF_1) || defined(DIFF_2)	/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a687 6
#elif	defined(DIFF_3)				/* =========================== */
				II_buffer_sample_ml(&bs, (*sample_ml), bit_alloc_ml, &fr_ps, &m);
				II_dequantize_sample_ml((*sample_ml), bit_alloc_ml, *fraction_ml, &fr_ps, &m, &i);
				II_denormalize_sample_ml(*fraction_ml, scale_index_ml, &fr_ps,
				                        ( (info.multi_lingual_fs==0) ? (i>>2) : (i>>1) ), &m, &i);
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a688 1
#if	defined(DIFF_1) || defined(DIFF_2)	/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a698 8
#elif	defined(DIFF_3)				/* =========================== */
				if(topSb>0) 
				   for(j=topSb; j<fr_ps.mlsblimit; ++j)
					  for(k= 0; k < info.no_of_multi_lingual_ch; ++k)
						 (*fraction_ml)[k][j][0][i] =
						 (*fraction_ml)[k][j][1][i] =
						 (*fraction_ml)[k][j][2][i] = 0.0;
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a709 1
#if	defined(DIFF_1) || defined(DIFF_3)	/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a710 3
#elif	defined(DIFF_2)				/* =========================== */
			   dematricing(*fraction, &fr_ps, dematrix2_filter_state);
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a729 9
#if	defined(DIFF_2)				/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
			/* 31/10/95 Ralf Schwalbe LFE output */
			if(info.lfe) 
		    	{
				for(jj = 0; jj < 12; jj++)
			     		lfe_tmp[jj] = (short int)(info.lfe_spl_fraction[jj] * SCALE);
				fwrite(&lfe_tmp[0],2,12,lfe); 
		    	}
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a732 1
#if	defined(DIFF_1) || defined(DIFF_2)	/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a734 4
#elif	defined(DIFF_3)				/* =========================== */
/* 10/03/1995 JMZ Multilingual , WtK 7/8/95 */
if(info.no_of_multi_lingual_ch>0) 
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a735 1
#if	defined(DIFF_1) || defined(DIFF_2)	/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a742 9
#elif	defined(DIFF_3)				/* =========================== */
			dematricing_ml(*fraction_ml, &fr_ps);
			
			for(jj=0;jj<( (info.multi_lingual_fs==0) ? 12 : 6 );jj++)
			   for(k=0; k<info.no_of_multi_lingual_ch; k++)
			       for(j =0; j <3; j++)
				  for(ii=0; ii< SBLIMIT; ii++)
			(*fraction_help_ml)[jj][k][j][ii] = (*fraction_ml)[k][ii][j][jj];
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a743 1
#if	defined(DIFF_1) || defined(DIFF_2)	/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a744 4
#elif	defined(DIFF_3)				/* =========================== */
			clip = 0;
			for (i=0;i<( (info.multi_lingual_fs==0) ? 12 : 6 );i++)
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a747 1
#if	defined(DIFF_1) || defined(DIFF_2)	/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a749 4
#elif	defined(DIFF_3)				/* =========================== */
				clip += SubBandSynthesis_ml(&((*fraction_help_ml)[i][k][j][0]), k,
							 &((*pcm_sample_ml)[k][j][0]));
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a750 1
#if	defined(DIFF_1) || defined(DIFF_2)	/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a751 3
#elif	defined(DIFF_3)				/* =========================== */
			  out_fifo_ml(*pcm_sample_ml, 3, &fr_ps, done, musicout_ml, &sample_frames_ml);
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a752 1
#if	defined(DIFF_1)				/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a753 7
#elif	defined(DIFF_2)				/* =========================== */
			
		}
#elif	defined(DIFF_3)				/* =========================== */
			if(clip > 0) printf("\n%d MultiLingual samples clipped\n", clip);
	}
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a755 1
#if	defined(DIFF_1) || defined(DIFF_3)	/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a756 4
#elif	defined(DIFF_2)				/* =========================== */
		
		if(mpeg == 2) /* 10/31/95 R.S. */ 
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a878 1
#if	defined(DIFF_1) || defined(DIFF_2)	/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a880 10
#elif	defined(DIFF_3)				/* =========================== */
    /****************************************************************/
    /*                                                              */
    /*                   END OF FRAME LOOP                          */
    /*                                                              */
    /****************************************************************/

}/*end of while(!endof(bs)) - loop */

#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a893 18
#if	defined(DIFF_3)				/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
           }
           if (fr_ps.header->no_of_multi_lingual_ch>0) {
	     pcm_aiff_data.numChannels       = fr_ps.header->no_of_multi_lingual_ch;
	     pcm_aiff_data.numSampleFrames   = sample_frames;
	     pcm_aiff_data.sampleSize        = 16;
	     pcm_aiff_data.sampleRate        = s_freq[info.sampling_frequency]*1000;
	     if (fr_ps.header->multi_lingual_fs==1) pcm_aiff_data.sampleRate *= 0.5;
	     strcpy(pcm_aiff_data.sampleType, IFF_ID_SSND);
	     pcm_aiff_data.blkAlgn.offset    = 0;
	     pcm_aiff_data.blkAlgn.blockSize = 0;
  
	     if (aiff_write_headers(musicout_ml, &pcm_aiff_data) == -1) {
		    printf("Could not write AIFF headers to \"%s\"\n",
				   decoded_file_name_ml);
		    exit(2);
	     }
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a912 3
#if	defined(DIFF_2)				/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
	if(info.lfe) fclose(lfe);
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a926 10
#if	defined(DIFF_3)				/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */

	if (fr_ps.header->no_of_multi_lingual_ch>0) {
          printf("There are %d multilingual channels, coded at ",fr_ps.header->no_of_multi_lingual_ch);
          if (fr_ps.header->multi_lingual_fs==0) printf("full"); else printf("half");
          printf(" sampling rate.\n They are outputted in \"%s\".\n",decoded_file_name_ml);
          if (need_aiff)
	   printf("Multilingual file has been written with AIFF header information\n");
	}
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
a949 1
#if	defined(DIFF_1)				/* <<<<<<<<<<<<<<<<<<<<<<<<<<< */
a951 7
#elif	defined(DIFF_2)				/* =========================== */
   fprintf(stderr," -i       write decoded bitstream-information in a file\n"); 
   		     /* default: write encoded information */
#elif	defined(DIFF_3)				/* =========================== */
   fprintf(stderr," -i       do write encoded bitstream-information in a file\n"); 
   		     /* default: don't write encoded information */
#endif						/* >>>>>>>>>>>>>>>>>>>>>>>>>>> */
@


1.8.3.2
log
@Merged FTZ_04 and Philips_01
@
text
@d4 1
a4 1
 * $Id: musicout.c 1.8.3.1 1995/11/05 22:50:42 rowlands Exp rowlands $
d10 1
a10 4
 * $Log: musicout.c $
 * Revision 1.8.3.1  1995/11/05  22:50:42  rowlands
 * Merged FTZ_04 and Philips_01 using #ifdefs
 *
d172 1
d180 1
d215 3
d219 1
d223 3
d230 3
d234 1
d237 3
d241 1
d244 3
d248 1
d251 3
d255 1
d263 3
d267 1
d270 3
d274 1
d281 4
d287 1
d298 1
d300 1
d304 1
d306 3
d310 3
d315 1
d334 3
d338 1
d340 3
d344 1
d346 3
d350 1
d352 3
d356 1
d363 1
d365 1
d367 1
d369 1
a369 1

d376 5
a380 1

d384 1
a384 1

d387 1
d389 1
d391 1
a391 1

d459 3
d463 1
d465 4
d471 1
d473 9
d496 5
d502 1
d504 3
d531 3
d535 1
d589 3
d593 1
d601 5
a605 1
	   	printf(">>>\nAn MPEG-1 Layer-2 bitstream will be decoded\n");
d607 5
a611 1
		printf(">>> \nAn MPEG-2 Layer-2 bitstream will be decoded\n");  
d620 16
d649 5
d658 1
d660 1
d666 1
d681 1
d683 1
d686 1
d694 1
d704 3
d708 1
d715 1
d717 4
d723 1
d725 1
d727 1
a729 1

d735 3
d744 1
d752 2
d755 5
d771 1
d820 1
a820 1

d843 1
a843 1

d855 6
d864 3
d876 3
d880 1
d882 6
d897 2
a898 1
				II_buffer_samplemc(&bs,(*sample),bit_alloc,&fr_ps, &channels, i);
d901 5
d915 1
d933 1
d935 3
d939 1
d947 3
d952 4
d958 1
d962 3
d966 1
d968 3
d975 1
d977 12
d995 2
d1007 3
d1011 1
d1031 1
a1031 1

d1039 1
a1039 1

d1043 4
d1049 1
d1051 9
d1067 1
d1069 3
d1074 1
d1078 4
d1084 1
d1086 3
d1090 1
d1092 6
d1100 1
a1100 1

d1103 4
d1108 1
d1231 4
d1243 1
d1257 1
a1258 1

d1274 1
d1294 1
d1296 1
d1311 1
d1320 1
a1320 1

d1344 4
d1349 3
d1353 1
@


1.8.2.0
log
@Branch for ten Kate
@
text
@d4 1
a4 1
 * $Id: musicout.c 1.8 1995/11/05 17:42:05 rowlands Exp $
a10 3
 * Revision 1.8  1995/11/05  17:42:05  rowlands
 * Distribution_06 base
 *
@


1.8.2.1
log
@Received from Warner ten Kate
@
text
@d4 1
a4 1
 * $Id: musicout.c,v 1.7.1.3 1995/08/14 08:13:37 tenkate Exp $
d10 3
a12 7
 * $Log: musicout.c,v $
 * Revision 1.7.1.3  1995/08/14  08:13:37  tenkate
 * ML-LSF added WtK 7/8/95
 * debugging
 * change "alloc" and "sblimit" into "allocml" and
 * "mlsblimit" where appropriate.
 * adapt sample-loops to 6 or 12 depending on half or full ML rate.
a205 1

d210 1
a210 1
	PCM  *pcm_sample_ml;					/* 10/03/1995 JMZ Multilingual*/
d213 1
a213 1
	SAM  *sample_ml;						/* 10/03/1995 JMZ Multilingual*/
d216 1
a216 1
	FRA  *fraction_ml;					/*JMZ 09/03/1995 Multilingual */
d219 1
a219 1
	FRA_HELP *fraction_help_ml;
d230 1
a230 1
	unsigned long     sample_frames_ml;
d237 2
a238 2
	unsigned int      bit_alloc_ml[5][SBLIMIT], scfsi_ml[5][SBLIMIT],
			  scale_index_ml[5][3][SBLIMIT]; /* 09/03/1995 JMZ Multilingual */
d252 1
a252 1
	int		  l, m, print_out = 0;
d273 1
a273 1
	pcm_sample_ml = (PCM *) mem_alloc((long) sizeof(PCM), "PCM Samp");
d275 1
a275 1
	sample_ml   = (SAM *) mem_alloc((long) sizeof(SAM), "Sample");
d277 1
a277 1
	fraction_ml   = (FRA *) mem_alloc((long) sizeof(FRA), "fraction");  /* R.S. */
d279 1
a279 1
	fraction_help_ml = (FRA_HELP *) mem_alloc((long) sizeof(FRA_HELP), "fraction");
a285 1
	fr_ps.tab_num_ml = -1;
a286 1
	fr_ps.allocml = NULL;
d293 3
a295 3
	info.no_of_multi_lingual_ch = 0;
	info.multi_lingual_fs = 0;
	info.multi_lingual_layer = 0;
d366 1
a366 1
	   printf("Do you want to print out all decoding information ? (y/<n>) :");
d368 2
a369 2
	   if( *t == 'y' || *t == 'Y' ) print_out = 1;
	   else		      		print_out = 0;
d392 1
a392 1
	   print_out = 0;
d394 1
d419 1
a419 1
				   case 'i':  print_out = 1; break;
d473 1
a473 1
    strcat(decoded_file_name_ml, DFLT_OPEXT_ML);
d492 7
d512 1
a512 1
    sample_frames_ml = 0;
d514 1
a514 2

    while ( !end_bs(&bs) ) 
a515 5
    /****************************************************************/
    /*                                                              */
    /*                  START OF FRAME LOOP                         */
    /*                                                              */
    /****************************************************************/
a529 1

a531 7
	   if ( (info.lay==2) && 
                ((int)s_freq[info.sampling_frequency]==48) && 
	        (frameBits != 24*bitrate[info.lay-1][info.bitrate_index]) 
	      ) /* for debugging purposes WtK */
	      fprintf(stderr,"\n***Error. %d bits have been read instead of %d bits.\n",
	                     frameBits,24*bitrate[info.lay-1][info.bitrate_index]);
		  
d541 1
a541 1
					out_fifo_ml(*pcm_sample_ml, 3, &fr_ps, done, musicout_ml, &sample_frames_ml);
d568 1
a568 11
           /* 7/8/95 added message WtK 7/8/95 */
	   if (info.lay != 2) {
	     switch (info.lay) {
	       case 1 : 
	       case 3 : printf("\nLayer = %d, not supported yet.\nexit.\n\n",info.lay); break;
	       default: printf("\n***Error. Layer = %d.\nexit.\n\n",info.lay); 
	       break;
	     }  
	     exit(1);
	   }
	   
a616 22
		  if ( (frameNum==1) && (fr_ps.header->no_of_multi_lingual_ch>0) ) {
                    /*frameNum==1 NOT frameNum==0*/
		    if (fr_ps.header->no_of_multi_lingual_ch>5) {
		      printf("\n\n***Warning. There are %d multilingual channels.\n");
		      printf    ("            This decoder supports only upto 5 channels.\n\n");
		    }
		    printf("There are %d multilingual channels, coded at ",fr_ps.header->no_of_multi_lingual_ch);
		    if (fr_ps.header->multi_lingual_fs==0) printf("full"); else printf("half");
		    printf(" sampling rate.\n They are outputted in \"%s\".\n",decoded_file_name_ml);
		    if ((musicout_ml = fopen(decoded_file_name_ml, "w+b")) == NULL) {
    	              printf ("***Error. Could not create \"%s\".\nExit\n", decoded_file_name_ml);
	              exit(0);
                    }
		    if(need_aiff) {
		      printf("Multilingual file written in AIFF format\n");
                      if (aiff_seek_to_sound_data(musicout_ml) == -1) {
		         printf("Could not seek to PCM sound data in \"%s\".\n",
				 decoded_file_name_ml);
		         exit(0);
	              }  
    	            }
		  }
d669 1
a669 1
/* JMZ 09/03/1995 Multilingual , WtK 7/8/95 */
d677 1
d680 2
a681 2
		  II_decode_bitalloc_ml(&bs, bit_alloc_ml, &fr_ps, &m);
		  II_decode_scale_ml(&bs, scfsi_ml, bit_alloc_ml, scale_index_ml, &fr_ps, &m);
d685 1
a685 1
			  for (i=0;i<( (info.multi_lingual_fs==0) ? 12 : 6 );i++) /* ngr : n_of_granules loop */
d687 1
a687 4
				II_buffer_sample_ml(&bs, (*sample_ml), bit_alloc_ml, &fr_ps, &m);
				II_dequantize_sample_ml((*sample_ml), bit_alloc_ml, *fraction_ml, &fr_ps, &m, &i);
				II_denormalize_sample_ml(*fraction_ml, scale_index_ml, &fr_ps,
				                        ( (info.multi_lingual_fs==0) ? (i>>2) : (i>>1) ), &m, &i);
d689 1
a689 6
				if(topSb>0) 
				   for(j=topSb; j<fr_ps.mlsblimit; ++j)
					  for(k= 0; k < info.no_of_multi_lingual_ch; ++k)
						 (*fraction_ml)[k][j][0][i] =
						 (*fraction_ml)[k][j][1][i] =
						 (*fraction_ml)[k][j][2][i] = 0.0;
d691 9
d733 2
a734 2
/* 10/03/1995 JMZ Multilingual , WtK 7/8/95 */
if(info.no_of_multi_lingual_ch>0) 
d736 7
a742 7
			dematricing_ml(*fraction_ml, &fr_ps);
			
			for(jj=0;jj<( (info.multi_lingual_fs==0) ? 12 : 6 );jj++)
			   for(k=0; k<info.no_of_multi_lingual_ch; k++)
			       for(j =0; j <3; j++)
				  for(ii=0; ii< SBLIMIT; ii++)
			(*fraction_help_ml)[jj][k][j][ii] = (*fraction_ml)[k][ii][j][jj];
d744 1
a744 2
			clip = 0;
			for (i=0;i<( (info.multi_lingual_fs==0) ? 12 : 6 );i++)
d748 2
a749 2
				clip += SubBandSynthesis_ml(&((*fraction_help_ml)[i][k][j][0]), k,
							 &((*pcm_sample_ml)[k][j][0]));
d751 1
a751 1
			  out_fifo_ml(*pcm_sample_ml, 3, &fr_ps, done, musicout_ml, &sample_frames_ml);
d753 1
a753 2
			if(clip > 0) printf("\n%d MultiLingual samples clipped\n", clip);
	}
d879 1
a879 5
    /****************************************************************/
    /*                                                              */
    /*                   END OF FRAME LOOP                          */
    /*                                                              */
    /****************************************************************/
a880 2
}/*end of while(!endof(bs)) - loop */

a893 16
           }
           if (fr_ps.header->no_of_multi_lingual_ch>0) {
	     pcm_aiff_data.numChannels       = fr_ps.header->no_of_multi_lingual_ch;
	     pcm_aiff_data.numSampleFrames   = sample_frames;
	     pcm_aiff_data.sampleSize        = 16;
	     pcm_aiff_data.sampleRate        = s_freq[info.sampling_frequency]*1000;
	     if (fr_ps.header->multi_lingual_fs==1) pcm_aiff_data.sampleRate *= 0.5;
	     strcpy(pcm_aiff_data.sampleType, IFF_ID_SSND);
	     pcm_aiff_data.blkAlgn.offset    = 0;
	     pcm_aiff_data.blkAlgn.blockSize = 0;
  
	     if (aiff_write_headers(musicout_ml, &pcm_aiff_data) == -1) {
		    printf("Could not write AIFF headers to \"%s\"\n",
				   decoded_file_name_ml);
		    exit(2);
	     }
a926 8

	if (fr_ps.header->no_of_multi_lingual_ch>0) {
          printf("There are %d multilingual channels, coded at ",fr_ps.header->no_of_multi_lingual_ch);
          if (fr_ps.header->multi_lingual_fs==0) printf("full"); else printf("half");
          printf(" sampling rate.\n They are outputted in \"%s\".\n",decoded_file_name_ml);
          if (need_aiff)
	   printf("Multilingual file has been written with AIFF header information\n");
	}
d950 2
a951 2
   fprintf(stderr," -i       do write encoded bitstream-information in a file\n"); 
   		     /* default: don't write encoded information */
@


1.8.1.0
log
@Branch for Schwalbe
@
text
@d4 1
a4 1
 * $Id: musicout.c 1.8 1995/11/05 17:42:05 rowlands Exp $
a10 3
 * Revision 1.8  1995/11/05  17:42:05  rowlands
 * Distribution_06 base
 *
@


1.8.1.1
log
@Received from Ralf Schwalbe
@
text
@d4 1
a4 1
 * $Id: musicout.c 1.7.1.2 1995/07/14 06:17:20 rowlands Exp $
d11 3
a167 7
 * 10/31/95	  Ralf Schwalbe, Deutsche Telekom FTZ Berlin	      *
 *		    - decoding of LFE-channel is working  	      *
 *		    - corrected any settings and bugs		      *
 *		    - corrected table-switch for channel mode < 3/2   *
 *		      and tc-allocation / dyn-crosstalk		      *
 *		    - still a problem with compl. bitstream 18/19     *
 *								      *		    
a201 1
int		   lfe_sampling = 0; /*10/31/95 Ralf Schwalbe output LFE in 12 spl/frame */
d203 1
d227 1
a227 1
	FILE              *musicout,*lfe;
a248 1
	char		  lfe_file_name[MAX_NAME_SIZE];
d254 1
a254 2
	int		  ch_start,lfe_init = 1; 
	short int	  lfe_tmp[12];
d298 1
a298 1
	info.lfe = 0;
d366 1
a366 1
	   printf("Do you want to print out all decoding information ? (y/<n>) :");
d368 2
a369 2
	   if( *t == 'y' || *t == 'Y' ) print_out = 1;
	   else		      		print_out = 0;
d371 7
d392 1
a392 1
	   print_out = 0;   /* 10/31/95 Ralf Schwalbe: set print_out off in CL Args */
d419 1
a419 1
				   case 'i':  print_out = 1; break;
d481 1
a481 1
	   	printf(">>>\nA MPEG 1 Layer-2 bitstream will be decoded\n");
d483 1
a483 1
		printf(">>> \nA MPEG 2 Layer-2 bitstream will be decoded\n");  
d498 1
d548 1
a548 2
	   else 
	   {
d551 1
a551 1
	   info.lfe = 0;  		/* R.S. ! */
d559 1
a559 6
	   if(frameNum == 1) 
	   	if(info.lfe)
		    printf("\nmc-channel=%d, MPEG2-ext-length=%d kbit/s lfe-channel present\n", mc_channel, info.ext_length*8/24);
		else
		    printf("\nmc-channel=%d, MPEG2-ext-length=%d kbit/s\n", mc_channel, info.ext_length*8/24);

d567 1
a567 1
          
d628 2
a629 1
		
d633 1
d643 1
a643 1
					for(ii = 2; ii < channels; ++ii)
d645 2
a646 1
				
d656 3
a658 3
				II_buffer_samplemc(&bs,(*sample),bit_alloc,&fr_ps,i);
				II_dequantize_samplemc((*sample),bit_alloc,*fraction,&fr_ps, &i);
				II_denormalize_samplemc(*fraction,scale_index,&fr_ps,i>>2, &i);
a667 17
			/* 10/31/95 Ralf Schwalbe LFE */
			if( info.lfe ) 
			{ 
				if(lfe_init)
				{
	   				f = strlen(encoded_file_name)-4;
	   				strcpy(lfe_file_name, encoded_file_name);
	  				strcpy(&lfe_file_name[f], DFLT_OPEXT_LFE);
					if ((lfe = fopen(lfe_file_name, "w+b")) == NULL)
    					{
	  					printf ("Could not create \"%s\".\n",lfe_file_name );
	   					exit(0);
    					}
				}
				lfe_init = 0; /* R.S. only one time */	
				II_lfe_calc(&fr_ps);  
			}
d710 1
a710 1
			   dematricing(*fraction, &fr_ps, dematrix2_filter_state);
a729 7
			/* 31/10/95 Ralf Schwalbe LFE output */
			if(info.lfe) 
		    	{
				for(jj = 0; jj < 12; jj++)
			     		lfe_tmp[jj] = (short int)(info.lfe_spl_fraction[jj] * SCALE);
				fwrite(&lfe_tmp[0],2,12,lfe); 
		    	}
a752 1
			
d756 1
a756 2
		
		if(mpeg == 2) /* 10/31/95 R.S. */ 
a912 1
	if(info.lfe) fclose(lfe);
d950 1
a950 1
   fprintf(stderr," -i       write decoded bitstream-information in a file\n"); 
@


1.7
log
@Merged FTZ dynamic crosstalk
@
text
@d4 1
a4 1
 * $Id: musicout.c 1.6 1995/06/19 03:14:11 rowlands Exp $
d11 12
d159 5
a163 4
 *                                                                    *     
 *  6/21/95       Ralf Schwalbe, Deutsche Telekom FTZ Berlin/FZ144    *
 *                 Tel: +49 30 6708 2406                              *
 *                 Fax: +49 30 6774 539                               *
d228 1
a228 1
	int		  i,jj, j, k, ii, stereo, done=FALSE, clip, sync,f, mc_channel=0;
a326 3
		strcpy(decoded_file_name_ml, decoded_file_name);
		strcat(decoded_file_name_ml, ".ml");
/* JMZ 10/03/1995 Multilingual */
d467 5
d492 1
a492 1
	   printf ("Could not create \"%s\".\n", decoded_file_name);
d809 1
d824 1
@


1.7.1.0
log
@Branch for FTZ dynamic crosstalk
@
text
@d4 1
a4 1
 * $Id: musicout.c 1.7 1995/06/22 01:23:00 rowlands Exp $
a10 3
 * Revision 1.7  1995/06/22  01:23:00  rowlands
 * Merged FTZ dynamic crosstalk
 *
@


1.7.1.1
log
@Updated dynamic crosstalk from FTZ: revision FTZ_03
@
text
@d4 1
a4 1
 * $Id: musicout.c 1.6 1995/06/19 03:14:11 rowlands Exp $
d11 3
a149 5
 * 								      *
 *  7/12/95	  Ralf Schwalbe, Deutsche Telekom FTZ Berlin          *
 *		    - corrected dynamic crosstalk 		      *
 *		    - 3/2,3/1,3/0,2/1, channel configurations         *
 *                    are working                                     *
d180 1
a180 1
int 		   bits_in_frame = 0,Frame_Bits,Bitrate,channels=2;
d182 1
a182 1
int		   read_from_ext = 0,ext_error=0, mpeg = 2,mc_channel=0; /* R.S. mpeg default for mc*/
d218 1
a218 1
	int		  i,jj, j, k, ii, stereo, done=FALSE, clip, sync,f;
d796 15
@


1.7.1.2
log
@Merged changes in FTZ_03 and Distribution_04.
@
text
@d4 1
a4 1
 * $Id: musicout.c 1.7.1.1 1995/07/14 06:09:48 rowlands Exp $
a10 9
 * Revision 1.7.1.1  1995/07/14  06:12:46  rowlands
 * Updated dynamic crosstalk from FTZ: revision FTZ_03
 *
 * Revision 1.7.1.0  1995/07/14  00:24:00  rowlands
 * Branch for FTZ dynamic crosstalk
 *
 * Revision 1.7  1995/06/22  01:23:00  rowlands
 * Merged FTZ dynamic crosstalk
 *
d152 4
d182 1
a182 1
int 		   bits_in_frame = 0,Frame_Bits,Bitrate,channels=2,mc_channel=0;
d184 1
a184 1
int		   read_from_ext = 0,ext_error=0, mpeg = 2; /* R.S. mpeg default for mc*/
d319 3
a461 5

    /* JMZ 10/03/1995 Multilingual */
    strcpy(decoded_file_name_ml, decoded_file_name);
    strcat(decoded_file_name_ml, ".ml");

d482 1
a482 1
	   printf ("Could not create \"%s\".\n", decoded_file_name_ml);
a797 17

#ifdef	DEBUG_PREDICTION
if(info.mc_prediction_on == 1)
   for(hu = 0; hu < 8; ++ hu)
   {
	fprintf(fp4, "mc_prediction[%d] = %d ", hu, info.mc_prediction[hu]);
	for(ho = 0; ho < 4; ho++)
	{
		fprintf(fp4, "mc_predsi[%d][%d] = %d  ", hu,ho, info.mc_predsi[hu][ho]);
		fprintf(fp4, "mc_delay[%d][%d] = %d  ", hu,ho, info.mc_delay_comp[hu][ho]);
		fprintf(fp4, " \n");
		for(hi = 0;hi <3; hi++)
		fprintf(fp4, "pred_coeff[%d][%d][%d] = %d ",hu,ho,hi,info.mc_pred_coeff[hu][ho][hi]);
		fprintf(fp4, " \n");
	}
   }
#endif
@


1.6
log
@Moved merged FTZ/Distribution_02 into main RC trunk.
@
text
@d4 1
a4 1
 * $Id: musicout.c 1.5.1.3 1995/06/19 00:44:31 rowlands Exp $
d11 3
d124 1
a124 1
 *  04/11/94       Ralf Schwalbe,  Telekom FTZ Berlin                 *
d133 1
a133 1
 *  07/12/94       Ralf Schwalbe,  Telekom FTZ Berlin                 *
d140 9
a148 1
 *  13/05/95       Ralf Schwalbe,  Telekom FTZ Berlin                 *
d151 1
a151 1
 *								      *
d159 1
a159 1
 *                 corrected some bugs                             *
d236 1
a236 1
	int		  l, m, print_out = 0;
a265 5
	for(k=0; k<2; k++)
	  for(ii=0; ii<8; ii++)
	    for(j =0; j <36+PREDDEL; j++)
	      (*pred_buf)[k][ii][j] = 0.0; /* clean field for starting */

d290 1
a290 1
#endif CONCAT	
d328 1
d330 1
d332 13
a344 1

d381 1
d474 2
a475 2

    if ((musicout_ml = fopen(decoded_file_name_ml, "w+b")) == NULL)
d504 1
a504 1
#endif CONCAT
d546 2
a547 2
		Frame_Bits++;    /* R.S. add a padding byte */
	   Frame_Bits*=8;	 /* R.S. to get bits per frame *8 */
d549 1
d551 1
a551 1
	   switch (info.lay)
a552 6

/*         case 1:  Layer I  30.05.1994  Ralf Schwalbe cut out Layer I
			     in case of multi - channel coding */

	   case 2:
		  {
a604 3
		  /* SWKim060695 add the condion with 32, 44.1kHz case */
		  if(info.sampling_frequency ==1) fr_ps.jsbound = 27;
	          			     else fr_ps.jsbound = 30;
d616 1
a616 2
		  /* SWKim060695 mandatory CRC check */
		  /*
d619 1
a619 2
		  */
			mc_error_check(&fr_ps, bit_alloc, scfsi, &new_crc);
d633 1
a633 5
		  /* SWKim060695 mandatory CRC check */
		  /*
		  } 
		  */
		  /* endif crc_check */
d742 2
a743 5
			break;

		  }/*end of layer 2*/

	   default:
a744 1
		break;
d746 2
a747 2
	   }/*end of switch layer - loop*/

d886 1
a886 1
#endif CONCAT
@


1.5
log
@Moved merged IRT/Samsung/TI into main revision control trunk.
@
text
@d4 1
a4 1
 * $Id: musicout.c 1.3.3.2 1995/06/16 08:44:58 rowlands Exp $
d11 9
d121 2
a122 6
 *  07/12/94       Ralf Schwalbe,  Telekom FTZ Berlin                 *
 *                 Tel: +49 30 6708 2406                              *
 *                 Fax: +49 30 6774 539                               *
 *								      *
 *  04/11/94	   Ralf Schwalbe. Telekom FTZ Berlin                  *
 *                  - decoding extension bitstream                    *
d131 7
d166 3
a168 3
int 		   bits_in_frame = 0;
int		   read_ext_header = 0;
int		   read_from_ext = 0,ext_error=0;
d171 1
d227 1
d235 1
d238 4
d353 1
a353 1
	 		    -don't print encoded bitstream information  */
d357 1
d359 5
a363 2
	   print_out = 0;

d385 2
a386 2
				   case 'i':  print_out = 1; break;
					    					      break;
d388 3
d416 2
a417 1
       }
a425 2


d435 1
a435 1
    }
d441 4
a445 1

d501 1
a501 1
					      musicout, &sample_frames);
a503 1

d505 1
a505 1
					      musicout, &sample_frames);
d522 5
d538 3
a540 3
			 l = 0;                  m = stereo;
			 II_decode_bitalloc(&bs, bit_alloc, &fr_ps, &l, &m);
			 II_decode_scale(&bs, scfsi, bit_alloc, scale_index, &fr_ps, &l, &m);
d550 1
a550 1
									 &fr_ps, musicout, &sample_frames);
a572 1
		 /*                                                        */
d578 2
a579 1

a580 1
		  
a587 1
		  /* hdr_to_frps(&fr_ps); */
d592 3
d596 2
a597 2
		  l = 2;
		  m = stereo + mc_channel;
d599 2
a600 2
		  II_decode_bitalloc(&bs, bit_alloc, &fr_ps, &l, &m);
		  II_decode_scale(&bs, scfsi, bit_alloc, scale_index, &fr_ps, &l, &m);
d631 3
a633 3
				II_buffer_samplemc(&bs,(*sample),bit_alloc,&fr_ps,&m);
				II_dequantize_samplemc((*sample),bit_alloc,*fraction,&fr_ps, &m, &i);
				II_denormalize_samplemc(*fraction,scale_index,&fr_ps,i>>2, &m, &i);
a640 1

d670 1
a670 1
					  for(k= l; k < m; ++k)
d687 2
d690 1
a690 1
			      for(k=0; k<5; k++)
d698 1
a698 1
			    for (k=0; k<5; k++)
d703 1
a703 1
						 &sample_frames);
d705 1
a705 1
			if(clip > 0) printf("%d samples clipped\n", clip);
d739 4
d749 1
d757 2
a758 2
fprintf(fp2, "******************** FRAME %d *****************************\n", frameNum-1);
fprintf(fp3, "******************** FRAME %d *****************************\n", frameNum-1);
d761 2
a762 2
fprintf(fp4, "version = %d\n", info.version);
fprintf(fp4, "lay = %d\n", info.lay);
d764 3
a766 2
fprintf(fp4, "bitrate_index = %d\n", info.bitrate_index);
fprintf(fp4, "bitrate_index1 = %d\n", info.bitrate_index1);
d768 3
a770 2
fprintf(fp4, "sampling_frequency = %d\n", info.sampling_frequency);
fprintf(fp4, "padding = %d\n", info.padding);
d772 5
a776 4
fprintf(fp4, "mode = %d\n", info.mode);
fprintf(fp4, "mode_ext = %d\n", info.mode_ext);
fprintf(fp4, "copyright = %d\n", info.copyright);
fprintf(fp4, "original = %d\n", info.original);
d778 4
a781 3
fprintf(fp4, "center = %d\n", info.center);
fprintf(fp4, "surround = %d\n", info.surround);
fprintf(fp4, "dematrix_procedure = %d\n", info.dematrix_procedure);
d783 3
a785 2
fprintf(fp4, "no_of_multi_lingual_ch = %d\n", info.no_of_multi_lingual_ch);
fprintf(fp4, "multi_lingual_fs = %d\n", info.multi_lingual_fs);
d787 2
d790 1
d806 11
a841 2
	fprintf(fp2, "\n");
	fprintf(fp3, "\n");
d843 1
a843 1
	fprintf(fp3, "SCFSI[%d][%d] = %d\t", hi, hu, scfsi[hi][hu]);
d892 7
d924 1
a924 1
      "       %s [-a] [-i] inputBS [outPCM]\n", programName);
d927 4
a930 3
                     /* default: write an AIFF sound file  */
   fprintf(stderr," -i       write encoded bitstream-information in a file\n"); 
   		     /* default: don't write encoded information */
@


1.5.1.0
log
@Created branch for Telekom FTZ
@
text
@d4 1
a4 1
 * $Id: musicout.c 1.5 1995/06/16 08:49:22 rowlands Exp $
a10 3
 * Revision 1.5  1995/06/16  08:49:22  rowlands
 * Moved merged IRT/Samsung/TI into main revision control trunk.
 *
@


1.5.1.1
log
@Input from Telekom FTZ
@
text
@d2 35
a36 3
Copyright (c) 1991 MPEG/audio software simulation group, All Rights Reserved
musicout.c
**********************************************************************/
a37 5
 * MPEG/audio coding/decoding software, work in progress              *
 *   NOT for public distribution until verified and approved by the   *
 *   MPEG/audio committee.  For further information, please contact   *
 *   Davis Pan, 508-493-2241, e-mail: pan@@gauss.enet.dec.com          *
 *                                                                    *
d115 6
a120 2
 *  04/11/94       Ralf Schwalbe,  Telekom FTZ Berlin                 *
 *                  - decoding tc-allocation                          *
a126 2
 *  07/12/94       Ralf Schwalbe, Telekom FTZ Berlin                  *
 *                  - decoding extension bitstream                    *
d128 1
a128 5
 *  Version 1.1.1 Shareware                                           *
 *                 Ralf Schwalbe, Telekom FTZ Berlin                  *
 *                  - fixed some bugs                                 *
 *                                                                    *
 *  13/05/95       Ralf Schwalbe,  Telekom FTZ Berlin                 *
d133 10
d145 1
d157 3
a159 3
int 		   bits_in_frame = 0,Frame_Bits,Bitrate,channels=2,mc_channel=0;
int		   read_ext_header = 0,read_mpeg2_part = 0, only_1_bit = 0;
int		   read_from_ext = 0,ext_error=0, mpeg = 2; /* R.S. mpeg default for mc*/
a161 1
double		   S_freq;
d163 1
d171 1
a171 1
typedef long PCM[5][3][SBLIMIT];
d173 2
a174 1
typedef unsigned int SAM[5][3][SBLIMIT];
d176 2
a177 1
typedef double FRA[5][SBLIMIT][3][12];      /* 7.10.93 R.S. mem - alloc for DOS */
d179 2
a180 1
typedef double FRA_HELP[12][5][3][SBLIMIT];
d182 4
a185 1
typedef double VE[5][HAN_SIZE];
d191 1
d193 2
a194 1
	int		  i,jj, j, k, ii, stereo, done=FALSE, clip, sync,f;
d199 3
a201 1
			  scale_index[5][3][SBLIMIT];
d204 1
d209 1
d211 1
d215 2
a216 1
	int		  ch_start, print_out = 0; 
a223 1
	FILE *fp5;
a225 4
#ifdef  MACINTOSH
	console_options.nrows = MAC_WINDOW_SIZE;
	argc = ccommand(&argv);
#endif
d230 1
d232 1
d234 4
a237 1
	fraction_help = (FRA_HELP *) mem_alloc((long) sizeof(FRA), "fraction");
d239 5
d261 2
d264 6
a269 1
	
d290 6
a306 1
	   { 	
d308 1
a308 13
		printf("Do you want to decode an MPEG 2 bitstream ? (<y>/n) : ");
		gets(t);
	   	if (*t == 'N' || *t == 'n') 
		{
			mpeg = 1;
			printf("An MPEG-1 Layer II bitstream will be decoded \n");
		}
	   	else
		{
			mpeg = 2;
			printf("An MPEG-2 Layer II bitstream will be decoded \n");
		}
	   }
d337 1
a337 1
	 		    -print encoded bitstream information  */
a340 1
#ifdef UNIX /* default values */
d342 1
a342 2
	   print_out = 1;
	   mpeg = 2;
a343 4
#else
	   need_aiff = FALSE;

#endif
d365 2
a366 2
				   case 'i':  print_out = 0; break;
					    			
a367 3
				   
				   case 'm':  mpeg = 1;break;

d379 15
a393 16
	  	  }  
	  	  else
	  	  {
	     		if(encoded_file_name[0] == '\0')
				strcpy(encoded_file_name, argv[i]);
	     		else
				if(decoded_file_name[0] == '\0')
		   			strcpy(decoded_file_name, argv[i]);
				else
				{
		   			fprintf(stderr,"%s: excess arg %s\n", programName, argv[i]);
		   			err = 1;
				}
	  	  }
       } /* end while argc */

d397 7
a403 5
		f = strlen(encoded_file_name)-4;
	  	strcpy(ext_bitstream_name, encoded_file_name);
	  	strcpy(&ext_bitstream_name[f], DFLT_OPEXT_EXT);
	  	if((open_bit_stream_r(&bs_ext, ext_bitstream_name, BUFFER_SIZE))==0)
			printf("No extension bitstream <%s> present \n",ext_bitstream_name);
d405 1
a405 1
       
d408 3
a410 3
	  	f = strlen(encoded_file_name)-4;
	  	strcpy(decoded_file_name, encoded_file_name);
	  	strcpy(&decoded_file_name[f], DFLT_OPEXT);
d413 1
a413 1
    }  /* else arg-line end */
d419 1
a419 4
    if(mpeg == 1)
	   	printf(">>>\nAn MPEG 1 Layer-2 bitstream will be decoded\n");
	   else
		printf(">>> \nAn MPEG 2 Layer-2 bitstream will be decoded\n");  
d429 6
d448 1
d452 8
d473 7
a479 2
		  if (info.lay == 2) out_fifo(*pcm_sample, 3, &fr_ps, done,
					      musicout, &sample_frames,channels);
d481 1
a481 1
					      musicout, &sample_frames,channels);
d484 4
d496 1
a496 1
	   if(frameNum == 1) printf("\nmc-channel=%d, MPEG2-ext-length=%d kbit/s\n", mc_channel, info.ext_length*8/24);
a497 5

	   Frame_Bits = 144*Bitrate/S_freq; 
	   if(info.padding)
		Frame_Bits++;    /* R.S. add a padding byte */
	   Frame_Bits*=8;	 /* R.S. to get bits per frame *8 */
d500 1
a500 1
	   if (info.lay == 2 )
d502 6
d509 3
a511 3
			 ch_start = 0;                  channels = stereo;
			 II_decode_bitalloc(&bs, bit_alloc, &fr_ps, &ch_start, &channels);
			 II_decode_scale(&bs, scfsi, bit_alloc, scale_index, &fr_ps, &ch_start, &channels);
d521 1
a521 1
							 &fr_ps, musicout, &sample_frames, channels);
d544 1
d550 1
a550 2
		if(mpeg == 2)
		{	
d552 2
d560 5
a564 4
	
		  /* Achtung: fr_ps.jsbound = 27; wird in Abhngikeit von fs gesetzt*/
		  ch_start = 2;
		  channels = stereo + mc_channel;
d566 2
a567 2
		  /* decoding bitallocation's */
		  /* II_decode_bitalloc_lfe(&bs ....); */
d569 2
a570 2
		  II_decode_bitalloc(&bs, bit_alloc, &fr_ps, &ch_start, &channels);
		  II_decode_scale(&bs, scfsi, bit_alloc, scale_index, &fr_ps, &ch_start, &channels);
d573 2
d577 1
d586 2
d592 5
a596 1
		  } /* endif crc_check */
d601 3
a603 4
				II_buffer_samplemc(&bs,(*sample),bit_alloc,&fr_ps,&channels);
				II_dequantize_samplemc((*sample),bit_alloc,*fraction,&fr_ps, &channels, &i);
				II_denormalize_samplemc(*fraction,scale_index,&fr_ps,i>>2, &channels, &i);
			  
d607 1
a607 1
					  for(k= channels; k < channels; ++k)
d613 40
d654 1
d656 1
a656 1
			 dematricing(*fraction, &fr_ps);
a657 2
		      }   /* endif mpeg == 2 */	

d659 1
a659 1
			      for(k=0; k < channels; k++)
d663 1
a663 1
		     
d667 1
a667 1
			    for (k=0; k < channels; k++)
d672 1
a672 1
						 &sample_frames, channels);
d674 13
a686 1
			if(clip > 0) printf("\n%d samples clipped\n", clip);
d688 6
a693 3
	    }		/*end of layer 2*/
	    else
		printf(" Layer Error: Decoding layer %d is not included in this program ", info.lay);
d695 15
a713 1
		fp5 = fopen("DYN_CROSS","w+");
d721 2
a722 2
fprintf(fp2, "\n******************** FRAME %d *****************************\n", frameNum-1);
fprintf(fp3, "\n******************** FRAME %d *****************************\n", frameNum-1);
d725 2
a726 2
fprintf(fp4, "version = %d, ", info.version);
fprintf(fp4, "lay = %d, ", info.lay);
d728 2
a729 2
fprintf(fp4, "bitrate_index = %d, ", info.bitrate_index);
fprintf(fp4, "bitrate_index1 = %d, ", info.bitrate_index1);
d731 2
a732 2
fprintf(fp4, "sampling_frequency = %d,", info.sampling_frequency);
fprintf(fp4, "padding = %d, ", info.padding);
d734 4
a737 4
fprintf(fp4, "mode = %d, ", info.mode);
fprintf(fp4, "mode_ext = %d,", info.mode_ext);
fprintf(fp4, "copyright = %d, ", info.copyright);
fprintf(fp4, "original = %d, ", info.original);
d739 3
a741 3
fprintf(fp4, "center = %d, ", info.center);
fprintf(fp4, "surround = %d, ", info.surround);
fprintf(fp4, "dematrix_procedure = %d, ", info.dematrix_procedure);
d743 2
a744 2
fprintf(fp4, "no_of_multi_lingual_ch = %d, ", info.no_of_multi_lingual_ch);
fprintf(fp4, "multi_lingual_fs = %d, ", info.multi_lingual_fs);
a745 1
fprintf(fp4, "dyn_cross_on = %d\n", info.dyn_cross_on);
d761 1
a761 10
if(info.dyn_cross_on == 1)
{
	fprintf(fp5, "\n******************** FRAME %d *****************************\n", frameNum-1);
	fprintf(fp5,"dyn_cross_LR = %d\n",info.dyn_cross_LR);
	for(ho = 0; ho < 12; ho ++)
	{
		fprintf(fp5,"dyn_cross[%d] = %d   ",ho,info.dyn_cross_mode[ho]);
		if((ho+1)%4 == 0) fprintf(fp5,"\n");
	}
}
d787 2
a788 2
	/*fprintf(fp2, "\n");
	fprintf(fp3, "\n");*/
d790 1
a790 1
	fprintf(fp3, "SCFSI[%d][%d] = %d   ", hi, hu, scfsi[hi][hu]);
d828 3
a838 7
#ifdef  MACINTOSH
	if (need_aiff) set_mac_file_attr(decoded_file_name, VOL_REF_NUM,
									 CREATR_DEC_AIFF, FILTYP_DEC_AIFF);
	else           set_mac_file_attr(decoded_file_name, VOL_REF_NUM,
									 CREATR_DEC_BNRY, FILTYP_DEC_BNRY);
#endif

d858 1
a858 1
void usage()  /* print syntax & exit */
d864 1
a864 1
      "       %s [-a] [-i] [-m] inputBS [outPCM]\n", programName);
d866 1
a866 1
   fprintf(stderr," -a       write a RAW data sound file\n");
d868 2
a869 4
   fprintf(stderr," -i       dont write encoded bitstream-information in a file\n"); 
   		     /* default: write encoded information */
   fprintf(stderr," -m       encoded bitstream is a MPEG 1 Layer-2 file\n"); 
   		     /* default: decode a MPEG 2 Layer-2 bitstream */
@


1.5.1.2
log
@Merged with Distribution_02, marked by flag _FTZ
@
text
@a1 35
#ifndef _FTZ
 * Copyright (c) 1995 MPEG/audio software simulation group
 * All Rights Reserved
 * $Id: musicout.c 1.5 1995/06/16 08:49:22 rowlands Exp $
 *
 * MPEG/audio coding/decoding software, work in progress
 *   NOT for public distribution until verified and approved by the
 *   MPEG/audio committee.
 *
 * $Log: musicout.c $
 * Revision 1.5  1995/06/16  08:49:22  rowlands
 * Moved merged IRT/Samsung/TI into main revision control trunk.
 *
 * Revision 1.3.3.2  1995/06/16  08:44:58  rowlands
 * Merged and tested revisions 1.4 and 1.3.3.1
 *
 * Revision 1.3.3.1  1995/06/16  08:00:46  rowlands
 * Input from Samsung AIT.
 *
 * Revision 1.4  1995/06/16  06:19:08  rowlands
 * Moved merged IRT/TI into main revision control trunk.
 *
 * Revision 1.3.1.1  1995/06/14  04:36:30  rowlands
 * Added support for dematrixing procedure 2.
 *
 * Revision 1.3.1.0  1995/05/23  04:36:43  rowlands
 * Created branch for TI
 *
 * Revision 1.3  1995/04/06  05:01:42  rowlands
 * Ran decoder through protoize to convert to ANSI C.
 *
 * Revision 1.2  1995/04/06  04:56:00  rowlands
 * Added header, RCS info and cleaned up prototypes in initial revision.
 *
#else _FTZ
d4 1
a4 5
#endif _FTZ
 **********************************************************************/
#ifndef _FTZ

#endif _FTZ
a5 1
#ifdef _FTZ
a10 1
#endif _FTZ
a87 8
#ifndef _FTZ
 *  07/12/94       Ralf Schwalbe,  Telekom FTZ Berlin                 *
 *                 Tel: +49 30 6708 2406                              *
 *                 Fax: +49 30 6774 539                               *
 *								      *
 *  04/11/94	   Ralf Schwalbe. Telekom FTZ Berlin                  *
 *                  - decoding extension bitstream                    *
#else _FTZ
a89 1
#endif _FTZ
d96 1
a96 5
#ifndef _FTZ
 *                                                                    *
#endif _FTZ
 *  07/12/94       Ralf Schwalbe,  Telekom FTZ Berlin                 *
#ifdef _FTZ
a103 1
#endif _FTZ
a107 12
#ifndef _FTZ
/**********************************************************************
 *                                                                    *
 *  06/06/95       Yeon Bae Thomas Kim,  Samsung AIT                  *
 *                 ancillary data is working                          *
 *								      *
 *  06/06/95       Sang Wook Kim,  Samsung AIT                        *
 *                 corrected some bugs                             *
 *								      *
 **********************************************************************/

#endif _FTZ
a109 3
#ifndef _FTZ

#endif _FTZ
a120 5
#ifndef _FTZ
int 		   bits_in_frame = 0;
int		   read_ext_header = 0;
int		   read_from_ext = 0,ext_error=0;
#else _FTZ
a123 1
#endif _FTZ
a125 1
#ifdef _FTZ
a126 1
#endif _FTZ
a127 3
#ifndef _FTZ
int		   anc_index; /* ancillary data */
#endif _FTZ
d135 1
a135 1
typedef long PCM[5][3][SBLIMIT];		
d137 1
a137 4
#ifndef _FTZ
	PCM  *pcm_sample_test;					/* 10/03/1995 JMZ Multilingual*/
#endif _FTZ
typedef unsigned int SAM[5][3][SBLIMIT];	
d139 1
a139 4
#ifndef _FTZ
	SAM  *sample_test;						/* 10/03/1995 JMZ Multilingual*/
#endif _FTZ
typedef double FRA[5][SBLIMIT][3][12];      /* 7.10.93 R.S. mem - alloc for DOS */ 
a140 4
#ifndef _FTZ
	FRA  *fraction_test;					/*JMZ 09/03/1995 Multilingual */
typedef double FRA_HELP[12][5][3][SBLIMIT];	/* 10/03/1995 JMZ Multilingual*/
#else _FTZ
a141 1
#endif _FTZ
d143 1
a143 6
#ifndef _FTZ
	FRA_HELP *fraction_help_test;
typedef double FRA_BUF[2][8][36+PREDDEL];   
	FRA_BUF  *pred_buf; 
#endif _FTZ
typedef double VE[5][HAN_SIZE];		
a148 3
#ifndef _FTZ
	FILE              *musicout_ml;			/* 10/03/1995 JMZ Multilingual*/
#endif _FTZ
a149 4
#ifndef _FTZ
	unsigned long     sample_frames_test;
	int		  i,jj, j, k, ii, stereo, done=FALSE, clip, sync,f, mc_channel=0;
#else _FTZ
a150 1
#endif _FTZ
d155 1
a155 5
			  scale_index[5][3][SBLIMIT]; 
#ifndef _FTZ
	unsigned int      bit_alloc_test[5][SBLIMIT], scfsi_test[5][SBLIMIT],
			  scale_index_test[5][3][SBLIMIT]; /* 09/03/1995 JMZ Multilingual */
#endif _FTZ
a157 3
#ifndef _FTZ
	double		  dematrix2_filter_state[3];
#endif _FTZ
a161 3
#ifndef _FTZ
	char              decoded_file_name_ml[MAX_NAME_SIZE];/* 10/03/1995 JMZ Multilingual*/
#endif _FTZ
a162 3
#ifndef _FTZ
	char		  frame_name[MAX_NAME_SIZE];
#endif _FTZ
a165 4
#ifndef _FTZ
	int		  l, m, print_out = 0;
	long		  pp; /* ancillary */
#else _FTZ
a166 1
#endif _FTZ
a173 1
#ifdef _FTZ
a174 1
#endif _FTZ
a176 1
#ifdef _FTZ
a180 1
#endif _FTZ
a184 3
#ifndef _FTZ
	pcm_sample_test = (PCM *) mem_alloc((long) sizeof(PCM), "PCM Samp");
#endif _FTZ
a185 3
#ifndef _FTZ
	sample_test   = (SAM *) mem_alloc((long) sizeof(SAM), "Sample");
#endif _FTZ
a186 6
#ifndef _FTZ
	fraction_test   = (FRA *) mem_alloc((long) sizeof(FRA), "fraction");  /* R.S. */
	fraction_help = (FRA_HELP *) mem_alloc((long) sizeof(FRA_HELP), "fraction");
	fraction_help_test = (FRA_HELP *) mem_alloc((long) sizeof(FRA_HELP), "fraction");
	pred_buf  = (FRA_BUF *) mem_alloc((long) sizeof(FRA_BUF), "pred_buf");
#else _FTZ
a187 1
#endif _FTZ
a188 7
#ifndef _FTZ
	for(k=0; k<2; k++)
	  for(ii=0; ii<8; ii++)
	    for(j =0; j <36+PREDDEL; j++)
	      (*pred_buf)[k][ii][j] = 0.0; /* clean field for starting */

#endif _FTZ
a205 4
#ifndef _FTZ
	init_dematrix2_filter_state(dematrix2_filter_state);

#endif _FTZ
d207 1
a207 8

#ifndef _FTZ
#ifdef CONCAT
/* 23/03/1995 JMZ Concat */
    open_bit_stream_w(&bs_concat, "toto.mpg", BUFFER_SIZE);
#endif CONCAT	

#endif _FTZ
a227 8
#ifndef _FTZ

/* JMZ 10/03/1995 Multilingual */
		strcpy(decoded_file_name_ml, decoded_file_name);
		strcat(decoded_file_name_ml, ".ml");
/* JMZ 10/03/1995 Multilingual */

#endif _FTZ
a238 1
#ifdef _FTZ
a239 1
#endif _FTZ
a240 3
#ifndef _FTZ

#else _FTZ
a253 1
#endif _FTZ
a281 3
#ifndef _FTZ
	 		    -don't print encoded bitstream information  */
#else _FTZ
a282 1
#endif _FTZ
a285 1
#ifdef _FTZ
a286 1
#endif _FTZ
a287 3
#ifndef _FTZ
	   print_out = 0;
#else _FTZ
a289 1
#endif _FTZ
a290 1
#ifdef _FTZ
a294 1
#endif _FTZ
a315 4
#ifndef _FTZ
				   case 'i':  print_out = 1; break;
					    					      break;
#else _FTZ
a317 1
#endif _FTZ
a318 1
#ifdef _FTZ
a321 1
#endif _FTZ
d333 14
a346 17
	  }
	  else
	  {
	     if(encoded_file_name[0] == '\0')
		strcpy(encoded_file_name, argv[i]);
	     else
		if(decoded_file_name[0] == '\0')
		   strcpy(decoded_file_name, argv[i]);
		else
		{
		   fprintf(stderr,"%s: excess arg %s\n", programName, argv[i]);
		   err = 1;
		}
	  }
#ifndef _FTZ
       }
#else _FTZ
a348 1
#endif _FTZ
d352 5
a356 9
	  f = strlen(encoded_file_name)-4;
	  strcpy(ext_bitstream_name, encoded_file_name);
	  strcpy(&ext_bitstream_name[f], DFLT_OPEXT_EXT);
	  if((open_bit_stream_r(&bs_ext, ext_bitstream_name, BUFFER_SIZE))==0)
		printf("No extension bitstream <%s> present \n",ext_bitstream_name);
#ifndef _FTZ


#endif _FTZ
d358 1
a358 1

d361 3
a363 3
	  f = strlen(encoded_file_name)-4;
	  strcpy(decoded_file_name, encoded_file_name);
	  strcpy(&decoded_file_name[f], DFLT_OPEXT);
a365 3
#ifndef _FTZ
    }
#else _FTZ
a366 1
#endif _FTZ
a371 1
#ifdef _FTZ
a375 3
#endif _FTZ
	  
#ifndef _FTZ
a376 1
#endif _FTZ
a384 8
#ifndef _FTZ
    if ((musicout_ml = fopen(decoded_file_name_ml, "w+b")) == NULL)
    	{
	   printf ("Could not create \"%s\".\n", decoded_file_name);
	   exit(0);
    	}

#endif _FTZ
a397 3
#ifndef _FTZ
    sample_frames_test = 0;
#endif _FTZ
a400 10
#ifndef _FTZ

#ifdef CONCAT    
/*		strcpy(frame_name, "frame.");
		sprintf(frame_name_ext, frameNum);
		strcat(frame_name, frame_name_ext);
    open_bit_stream_w(&bs_concat, frame_name, BUFFER_SIZE);*/
#endif CONCAT

#endif _FTZ
a413 9
#ifndef _FTZ
		  if (info.lay == 2) 
			{
		  			out_fifo(*pcm_sample, 3, &fr_ps, done,
					      musicout, &sample_frames);
					out_fifo_test(*pcm_sample_test, 3, &fr_ps, done, musicout_ml, &sample_frames_test);
			}

#else _FTZ
a415 1
#endif _FTZ
a416 3
#ifndef _FTZ
					      musicout, &sample_frames);
#else _FTZ
a417 1
#endif _FTZ
a419 6
#ifndef _FTZ
	   /* YBKim060695 ancillary */
	   else {
		pp = sstell(&bs) - 12;
	   }
#endif _FTZ
a427 3
#ifndef _FTZ
	   if(frameNum == 1) printf(" mc-channel=%d, MPEG2-ext-length=%d \n", mc_channel, info.ext_length*8/24);
#else _FTZ
a428 1
#endif _FTZ
a429 1
#ifdef _FTZ
a434 1
#endif _FTZ
a436 3
#ifndef _FTZ
	   switch (info.lay)
#else _FTZ
a437 1
#endif _FTZ
a438 8
#ifndef _FTZ

/*         case 1:  Layer I  30.05.1994  Ralf Schwalbe cut out Layer I
			     in case of multi - channel coding */

	   case 2:
		  {
#endif _FTZ
a439 5
#ifndef _FTZ
			 l = 0;                  m = stereo;
			 II_decode_bitalloc(&bs, bit_alloc, &fr_ps, &l, &m);
			 II_decode_scale(&bs, scfsi, bit_alloc, scale_index, &fr_ps, &l, &m);
#else _FTZ
a442 1
#endif _FTZ
a451 3
#ifndef _FTZ
									 &fr_ps, musicout, &sample_frames);
#else _FTZ
a452 1
#endif _FTZ
a474 3
#ifndef _FTZ
		 /*                                                        */
#endif _FTZ
a479 3
#ifndef _FTZ

#else _FTZ
a481 1
#endif _FTZ
a482 4
#ifndef _FTZ
		  

#endif _FTZ
d489 1
a489 9
#ifndef _FTZ
		  /* hdr_to_frps(&fr_ps); */
#endif _FTZ
		  
#ifndef _FTZ
		  /* SWKim060695 add the condion with 32, 44.1kHz case */
		  if(info.sampling_frequency ==1) fr_ps.jsbound = 27;
	          			     else fr_ps.jsbound = 30;
#else _FTZ
a492 1
#endif _FTZ
a493 4
#ifndef _FTZ
		  l = 2;
		  m = stereo + mc_channel;
#else _FTZ
a495 1
#endif _FTZ
a496 4
#ifndef _FTZ
		  II_decode_bitalloc(&bs, bit_alloc, &fr_ps, &l, &m);
		  II_decode_scale(&bs, scfsi, bit_alloc, scale_index, &fr_ps, &l, &m);
#else _FTZ
a498 1
#endif _FTZ
a500 4
#ifndef _FTZ
		  /* SWKim060695 mandatory CRC check */
		  /*
#endif _FTZ
a502 3
#ifndef _FTZ
		  */
#endif _FTZ
a510 4
#ifndef _FTZ
				mc_channel = 3;
				fr_ps.mc_channel = 3;
#endif _FTZ
a514 7
#ifndef _FTZ
		  /* SWKim060695 mandatory CRC check */
		  /*
		  } 
		  */
		  /* endif crc_check */
#else _FTZ
a515 1
#endif _FTZ
a519 5
#ifndef _FTZ
				II_buffer_samplemc(&bs,(*sample),bit_alloc,&fr_ps,&m);
				II_dequantize_samplemc((*sample),bit_alloc,*fraction,&fr_ps, &m, &i);
				II_denormalize_samplemc(*fraction,scale_index,&fr_ps,i>>2, &m, &i);
#else _FTZ
d523 1
a523 1
#endif _FTZ
a524 1
#ifndef _FTZ
a526 40
					  for(k= l; k < m; ++k)
						 (*fraction)[k][j][0][i] =
						 (*fraction)[k][j][1][i] =
						 (*fraction)[k][j][2][i] = 0;
#endif _FTZ

#ifndef _FTZ
			   }

/*********************************************************************/
/* JMZ 09/03/1995 Multilingual */

if (info.no_of_multi_lingual_ch>0) 
	{
		  /* SWKim060695 add the condion with 32, 44.1kHz case */
		  if(info.sampling_frequency ==1) fr_ps.jsbound = 27;
	          			     else fr_ps.jsbound = 30;

		  l = 5;
		  m = info.no_of_multi_lingual_ch;

		  II_decode_bitalloc_test(&bs, bit_alloc_test, &fr_ps, &l, &m);
		  II_decode_scale_test(&bs, scfsi_test, bit_alloc_test, scale_index_test, &fr_ps, &l, &m);


			  clip = 0;
			  for (i=0;i<12;i++)
			  {
				II_buffer_sample_test(&bs, (*sample_test), bit_alloc_test, &fr_ps,&m);
				
				II_dequantize_sample_test((*sample_test), bit_alloc_test, *fraction_test, &fr_ps, &m, &i);

				II_denormalize_sample_test(*fraction_test, scale_index_test, &fr_ps,i>>2, &m, &i);

#endif _FTZ
				if(topSb>0)        /* debug : clear channels to 0 */
				   for(j=topSb; j<fr_ps.sblimit; ++j)
#ifndef _FTZ
					  for(k= l; k < m; ++k)
#else _FTZ
a527 1
#endif _FTZ
a532 9
#ifndef _FTZ
	}
#endif _FTZ

#ifndef _FTZ
/* JMZ 09/03/1995 Multilingual */
/*********************************************************************/

			 /*if(fr_ps.header->mc_prediction_on)*/   /* R.S. */
a533 2
			 /* prediction & dematricing */
#endif _FTZ
a534 3
#ifndef _FTZ
			   dematricing(*fraction, &fr_ps, dematrix2_filter_state, *pred_buf);
#else _FTZ
a535 1
#endif _FTZ
a536 1
#ifdef _FTZ
a538 1
#endif _FTZ
a539 3
#ifndef _FTZ
			      for(k=0; k<5; k++)
#else _FTZ
a540 1
#endif _FTZ
d544 1
a544 1

a547 3
#ifndef _FTZ
			    for (k=0; k<5; k++)
#else _FTZ
a548 1
#endif _FTZ
a552 3
#ifndef _FTZ
						 &sample_frames);
#else _FTZ
a553 1
#endif _FTZ
a554 3
#ifndef _FTZ
			if(clip > 0) printf("%d samples clipped\n", clip);
#else _FTZ
a555 14
#endif _FTZ
			
#ifndef _FTZ
/***************************************************************/
/* 10/03/1995 JMZ Multilingual */
if(info.no_of_multi_lingual_ch>0) /*15/03/1995 TEST*/
	{
			   dematricing_test(*fraction_test, &fr_ps, *pred_buf);
			   
			   for(jj=0;jj<12;jj++)
			      for(k=0; k<info.no_of_multi_lingual_ch; k++)
				  for(j =0; j <3; j++)
				     for(ii=0; ii< SBLIMIT; ii++)
				(*fraction_help_test)[jj][k][j][ii] = (*fraction_test)[k][ii][j][jj];
d557 1
a557 21
			for (i=0;i<12;i++)
			{			  
			  for (j=0;j<3;j++) 
			    for (k=0; k<info.no_of_multi_lingual_ch; k++)
				clip += SubBandSynthesis_test(&((*fraction_help_test)[i][k][j][0]), k,
							 &((*pcm_sample_test)[k][j][0]));

				out_fifo_test(*pcm_sample_test, 3, &fr_ps, done, musicout_ml, &sample_frames_test);
			}
		}
/* 10/03/1995 JMZ Multilingual */
/**************************************************************/

			/* YBKim060695 ancillary decode */
			ancillaryDecode(&fr_ps,&bs,pp);

			break;

#endif _FTZ
		  }/*end of layer 2*/
#ifdef _FTZ
a559 1
#endif _FTZ
a560 4
#ifndef _FTZ
	   }/*end of switch layer - loop*/

#endif _FTZ
a564 1
#ifdef _FTZ
a565 1
#endif _FTZ
a572 4
#ifndef _FTZ
fprintf(fp2, "******************** FRAME %d *****************************\n", frameNum-1);
fprintf(fp3, "******************** FRAME %d *****************************\n", frameNum-1);
#else _FTZ
a574 1
#endif _FTZ
a576 4
#ifndef _FTZ
fprintf(fp4, "version = %d\n", info.version);
fprintf(fp4, "lay = %d\n", info.lay);
#else _FTZ
a578 1
#endif _FTZ
a579 4
#ifndef _FTZ
fprintf(fp4, "bitrate_index = %d\n", info.bitrate_index);
fprintf(fp4, "bitrate_index1 = %d\n", info.bitrate_index1);
#else _FTZ
a581 1
#endif _FTZ
a582 4
#ifndef _FTZ
fprintf(fp4, "sampling_frequency = %d\n", info.sampling_frequency);
fprintf(fp4, "padding = %d\n", info.padding);
#else _FTZ
a584 1
#endif _FTZ
a585 6
#ifndef _FTZ
fprintf(fp4, "mode = %d\n", info.mode);
fprintf(fp4, "mode_ext = %d\n", info.mode_ext);
fprintf(fp4, "copyright = %d\n", info.copyright);
fprintf(fp4, "original = %d\n", info.original);
#else _FTZ
a589 1
#endif _FTZ
a590 5
#ifndef _FTZ
fprintf(fp4, "center = %d\n", info.center);
fprintf(fp4, "surround = %d\n", info.surround);
fprintf(fp4, "dematrix_procedure = %d\n", info.dematrix_procedure);
#else _FTZ
a593 1
#endif _FTZ
a594 4
#ifndef _FTZ
fprintf(fp4, "no_of_multi_lingual_ch = %d\n", info.no_of_multi_lingual_ch);
fprintf(fp4, "multi_lingual_fs = %d\n", info.multi_lingual_fs);
#else _FTZ
a596 1
#endif _FTZ
a597 1
#ifdef _FTZ
a598 1
#endif _FTZ
a613 3
#ifndef _FTZ

#else _FTZ
a623 1
#endif _FTZ
a648 4
#ifndef _FTZ
	fprintf(fp2, "\n");
	fprintf(fp3, "\n");
#else _FTZ
a650 1
#endif _FTZ
a651 3
#ifndef _FTZ
	fprintf(fp3, "SCFSI[%d][%d] = %d\t", hi, hu, scfsi[hi][hu]);
#else _FTZ
a652 1
#endif _FTZ
a689 5
#ifndef _FTZ
#ifdef CONCAT
close_bit_stream_w_concat(&bs_concat);	/* 23/03/1995 JMZ Concat */
#endif CONCAT
#endif _FTZ
a697 1
#ifdef _FTZ
a704 1
#endif _FTZ
a723 3
#ifndef _FTZ
void usage(void)  /* print syntax & exit */
#else _FTZ
a724 1
#endif _FTZ
a729 3
#ifndef _FTZ
      "       %s [-a] [-i] inputBS [outPCM]\n", programName);
#else _FTZ
a730 1
#endif _FTZ
a731 3
#ifndef _FTZ
   fprintf(stderr," -a       write a RAW data sound file  (default: write an AIFF sound file)\n");
#else _FTZ
a732 1
#endif _FTZ
a733 4
#ifndef _FTZ
   fprintf(stderr," -i       write encoded bitstream-information in a file\n"); 
   		     /* default: don't write encoded information */
#else _FTZ
a737 1
#endif _FTZ
@


1.5.1.3
log
@Merged old and new functionality.
@
text
@d2 1
d5 1
a5 1
 * $Id: musicout.c 1.5.1.2 1995/06/17 21:27:02 rowlands Exp rowlands $
a11 3
 * Revision 1.5.1.2  1995/06/17  21:27:02  rowlands
 * Merged with Distribution_02, marked by flag _FTZ
 *
d36 4
d41 1
d43 1
d45 7
d129 8
d139 1
d146 1
d148 1
d150 1
d158 1
d163 1
d174 1
d177 1
d179 1
d191 5
d199 1
d202 1
d204 1
d206 1
d208 1
d218 1
d220 1
d223 1
d225 1
d228 1
d231 3
d235 1
d239 1
d246 1
d248 1
d250 1
d253 3
d261 1
d264 1
d267 1
d269 1
d274 1
d276 1
d278 1
d280 1
d284 1
d287 3
a289 1
	int		  ch_start; 
d297 1
d299 1
d302 1
d307 1
d312 1
d314 1
d316 1
d318 1
d320 1
d325 3
d329 1
d335 1
d353 1
d356 1
d359 1
d365 1
d386 1
d393 1
d405 3
d409 1
d411 15
d454 3
d458 1
d462 1
d464 1
d466 3
d471 3
d476 1
d478 1
d500 4
d506 1
d508 1
d512 1
d538 3
d543 1
d552 4
d565 3
d569 1
d575 1
d580 1
d582 3
d593 1
d600 1
d614 1
d616 1
d620 1
d629 1
d643 1
d647 1
a647 1
					      musicout, &sample_frames, channels);
d650 5
d656 5
a660 1
					      musicout, &sample_frames, channels);
d663 1
d668 1
d677 1
d679 3
d683 1
d689 1
d692 1
d694 3
d698 1
d705 1
d707 5
d715 1
d725 5
a729 1
						 &fr_ps, musicout, &sample_frames, channels);
d752 3
d760 3
d765 1
d767 2
d770 1
d777 3
d781 1
d785 1
d789 1
d791 4
d797 1
d799 4
d805 1
d808 1
d811 1
d814 1
d816 1
d825 1
d828 1
d833 1
d839 3
d846 5
d854 1
d856 1
d863 3
d893 1
d896 3
d900 1
d906 1
d908 1
d910 1
d917 1
d919 1
d921 3
d925 1
d928 1
d930 3
d934 1
d942 3
d946 1
d951 3
d955 1
d957 3
d961 1
d963 1
d994 1
d996 2
a997 2

	   default:
d999 1
a999 1
		break;
d1001 1
d1004 1
d1009 1
d1011 1
d1019 4
d1025 1
d1028 4
d1034 1
d1036 4
a1039 1

d1042 1
d1044 4
a1047 1

d1050 1
d1052 6
a1057 1

d1062 1
d1064 5
a1068 1

d1072 1
d1074 4
a1077 1

d1080 1
d1082 1
a1082 1

d1084 1
a1085 1

d1100 1
d1102 1
d1113 1
a1113 1

d1139 7
d1147 3
d1151 1
d1189 1
d1193 1
d1202 1
d1210 1
d1230 1
d1232 3
d1240 3
d1244 1
d1246 1
d1248 9
a1256 1
   fprintf(stderr," -i       don't write encoded bitstream-information in a file\n"); 
d1260 1
@


1.4
log
@Moved merged IRT/TI into main revision control trunk.
@
text
@d4 1
a4 1
 * $Id: musicout.c 1.3.1.1 1995/06/14 04:36:30 rowlands Exp $
d11 9
d130 9
d160 1
d213 1
d481 4
d558 4
a562 1
		  fr_ps.jsbound = 27;
d570 2
d574 1
d589 5
a593 1
		  } /* endif crc_check */
d616 4
a619 1
		  fr_ps.jsbound = 27;
d697 4
@


1.3
log
@Ran decoder through protoize to convert to ANSI C.
@
text
@d4 1
a4 1
 * $Id: musicout.c,v 1.2 1995/04/06 04:56:00 rowlands Exp rowlands $
d10 10
a19 1
 * $Log: musicout.c,v $
d182 1
d238 2
d616 1
a616 1
			   dematricing(*fraction, &fr_ps, *pred_buf);
@


1.3.3.0
log
@Created branch for Samsung
@
text
@d4 1
a4 1
 * $Id: musicout.c 1.3 1995/04/06 05:01:42 rowlands Exp $
d10 1
a10 4
 * $Log: musicout.c $
 * Revision 1.3  1995/04/06  05:01:42  rowlands
 * Ran decoder through protoize to convert to ANSI C.
 *
@


1.3.3.1
log
@Input from Samsung AIT.
@
text
@d4 1
a4 1
 * $Id: musicout.c,v 1.3 1995/04/06 05:01:42 rowlands Exp $
d10 1
a10 1
 * $Log: musicout.c,v $
a114 9
/**********************************************************************
 *                                                                    *
 *  06/06/95       Yeon Bae Thomas Kim,  Samsung AIT                  *
 *                 ancillary data is working                          *
 *								      *
 *  06/06/95       Sang Wook Kim,  Samsung AIT                        *
 *                 corrected some bugs                             *
 *								      *
 **********************************************************************/
a135 1
int		   anc_index; /* ancillary data */
a186 1
	long		  pp; /* ancillary */
a451 4
	   /* YBKim060695 ancillary */
	   else {
		pp = sstell(&bs) - 12;
	   }
a524 4
		  
		  /* SWKim060695 add the condion with 32, 44.1kHz case */
		  if(info.sampling_frequency ==1) fr_ps.jsbound = 27;
	          			     else fr_ps.jsbound = 30;
d526 1
a533 2
		  /* SWKim060695 mandatory CRC check */
		  /*
a535 1
		  */
d550 1
a550 5
		  /* SWKim060695 mandatory CRC check */
		  /*
		  } 
		  */
		  /* endif crc_check */
d573 1
a573 4
		  /* SWKim060695 add the condion with 32, 44.1kHz case */
		  if(info.sampling_frequency ==1) fr_ps.jsbound = 27;
	          			     else fr_ps.jsbound = 30;

a650 4

			/* YBKim060695 ancillary decode */
			ancillaryDecode(&fr_ps,&bs,pp);

@


1.3.3.2
log
@Merged and tested revisions 1.4 and 1.3.3.1
@
text
@d4 1
a4 1
 * $Id: musicout.c 1.3.3.2 1995/06/16 08:32:13 rowlands Exp $
d10 1
a10 13
 * $Log: musicout.c $
 * Revision 1.3.3.1  1995/06/16  08:00:46  rowlands
 * Input from Samsung AIT.
 *
 * Revision 1.4  1995/06/16  06:19:08  rowlands
 * Moved merged IRT/TI into main revision control trunk.
 *
 * Revision 1.3.1.1  1995/06/14  04:36:30  rowlands
 * Added support for dematrixing procedure 2.
 *
 * Revision 1.3.1.0  1995/05/23  04:36:43  rowlands
 * Created branch for TI
 *
a185 1
	double		  dematrix2_filter_state[3];
a241 2
	init_dematrix2_filter_state(dematrix2_filter_state);

d635 1
a635 1
			   dematricing(*fraction, &fr_ps, dematrix2_filter_state, *pred_buf);
@


1.3.1.0
log
@Created branch for TI
@
text
@d4 1
a4 1
 * $Id: musicout.c,v 1.3 1995/04/06 05:01:42 rowlands Exp $
a10 3
 * Revision 1.3  1995/04/06  05:01:42  rowlands
 * Ran decoder through protoize to convert to ANSI C.
 *
@


1.3.1.1
log
@Added support for dematrixing procedure 2.
@
text
@d4 1
a4 1
 * $Id: musicout.c,v 1.3.1.0 1995/05/23 04:36:43 rowlands Exp rowlands $
a10 3
 * Revision 1.3.1.0  1995/05/23  04:36:43  rowlands
 * Created branch for TI
 *
a175 1
	double		  dematrix2_filter_state[3];
a230 2
	init_dematrix2_filter_state(dematrix2_filter_state);

d607 1
a607 1
			   dematricing(*fraction, &fr_ps, dematrix2_filter_state, *pred_buf);
@


1.2
log
@Added header, RCS info and cleaned up prototypes in initial revision.
@
text
@d4 1
a4 1
 * $Id$
d10 4
a13 1
 * $Log$
d802 1
a802 1
void usage()  /* print syntax & exit */
@


1.1
log
@Initial revision
@
text
@d2 11
a12 3
Copyright (c) 1991 MPEG/audio software simulation group, All Rights Reserved
musicout.c
**********************************************************************/
a13 5
 * MPEG/audio coding/decoding software, work in progress              *
 *   NOT for public distribution until verified and approved by the   *
 *   MPEG/audio committee.  For further information, please contact   *
 *   Davis Pan, 508-493-2241, e-mail: pan@@gauss.enet.dec.com          *
 *                                                                    *
@
