
/**********************************************************************


This software module was originally developed by

Gerald Schuller (University of Hannover / ACTS-MoMuSys)

and edited by

in the course of development of the MPEG-2 NBC/MPEG-4 Audio standard
ISO/IEC 13818-7, 14496-1,2 and 3. This software module is an
implementation of a part of one or more MPEG-2 NBC/MPEG-4 Audio tools
as specified by the MPEG-2 NBC/MPEG-4 Audio standard. ISO/IEC gives
users of the MPEG-2 NBC/MPEG-4 Audio standards free license to this
software module or modifications thereof for use in hardware or
software products claiming conformance to the MPEG-2 NBC/ MPEG-4 Audio
standards. Those intending to use this software module in hardware or
software products are advised that this use may infringe existing
patents. The original developer of this software module and his/her
company, the subsequent editors and their companies, and ISO/IEC have
no liability for use of this software module or modifications thereof
in an implementation. Copyright is not released for non MPEG-2
NBC/MPEG-4 Audio conforming products. ACTS-MoMuSys partners retain
full right to use the code for his/her own purpose, assign or donate
the code to a third party and to inhibit third party from using the
code for non MPEG-2 NBC/MPEG-4 Audio conforming products. This
copyright notice must be included in all copies or derivative works.

Copyright (c) 1997.


**********************************************************************/

#include <stdio.h>
#include <math.h>
#include <stddef.h>
#include <values.h>
/* #include "dct.h" */

#include "tf_main.h"

#include "ldfb.h"

#define Float double   /*mache alles in double precision*/ 
/*#define double float */       /* mache alles in float precision*/
/*int use_dolby_short_win=0;*/  /* def fuer compatibilitaet */


/***for delay = 2*N  ******/

#define addelay 0 /*additional delay for analysis in blocks */

#define max 2048  /* max size of N, the number of channels */
#define maxm 0 /* maximum number of bi-diagonal matrices C */
#define maxfb 7000 /*maximum number of unknown matrix entries, size(fb) */
#define maxn 4  /*maximum number of low delay matrices G */
#define maxc 1 /*maximum number of channels (stereo) */
#define MAX_CHANNELS 1






#include "fb128.dat"

#include "fb512.dat"

#include "fbiu1_128_512.dat"

#include "fbiu2_128_512.dat"

#include "fbid1_512_128.dat"

#include "fbid2_512_128.dat"

#include "fb2048.dat"

#include "fbiu1_128_2048.dat"

#include "fbiu2_128_2048.dat"

#include "fbid1_2048_128.dat"

#include "fbid2_2048_128.dat"

#include "fbiu1_512_2048.dat"

#include "fbiu2_512_2048.dat"

#include "fbid1_2048_512.dat"

#include "fbid2_2048_512.dat"







/*** Standard Interface ***************/




void time2freqtv(long channel_enable_mask, T2M_CHANNEL_INFO ch_info[MAX_CHANNELS])
{
long i,j,mask;
Float in[2*max],out[max],*inp,*outp,*dp1,*dp2,*yp,*xmemp;
double *timep,*specp;
int ch,N,windowtype,loops,loop;
static int windowtypepre[MAX_CHANNELS]={2}, ort[MAX_CHANNELS]={0},aus[MAX_CHANNELS]={0};
static Float delayline[MAX_CHANNELS][max*(addelay+1)]={0},y[MAX_CHANNELS][2*max];
static Float           z[maxn*max*maxc]={0},xmem[MAX_CHANNELS][max];
static Float count={0};

/*
count=count+1.0;
printf("count= %f \n",count);
*/



/*
printf("N= %d \n",N);
printf("windowtype= %d\n",windowtype);
*/

mask=1;
for(ch=0; ch<MAX_CHANNELS; ch++)
   {
   if( (channel_enable_mask & mask) != 0) 
      {/*printf("channel %d\n ",ch);*/

     
 
      

   
/* 0 normal, 1 start, 2 short , 3 stop window*/

      windowtype=ch_info[ch].window_type;

      /*if(windowtype==1 || windowtype==2)
        {N=128;loops=8}
      else
        {N=1024;loops=1}
	*/
      
/*type conversion to Float */
      timep=ch_info[ch].p_time_signal;
      inp=in;
      if((windowtype==2)/*||(windowtype==3)*/)
        inp=&in[960];  /*16 short in */

      if((windowtype==8) ||(windowtype==4)|| (windowtype==7) )
        inp=&in[768]; /*(N1-N2)/2,  4 med in*/

      for(i=0;i<2048;i++)
         {*inp++ =(Float) *timep++;
         }



      /*
      affbmidv(&delayline[ch][0],affb1024t128b255d,N1,N2,6,in,640,1,ch,z);

      affbmidv(&delayline[ch][0],fb1024,1024,1024,1,in,3072,1,0,&z[max*maxn*ch]);
      affbmidv(&delayline[ch][0],fb128,128,128,1,in,384,1,0,&z[max*maxn*ch]);
switch up window 1
        affbmidv(&delayline[ch][0],fbiu1,128,1024,1,in,3072,1,0,&z[max*maxn*ch]);
switch up window 2
        affbmidv(&delayline[ch][0],fbiu2,1024,1024,1,in,3072,1,0,&z[max*maxn*ch]);
switch down window 1 
        affbmidv(&delayline[ch][0],fbid1,1024,128,1,in,3072,1,0,&z[max*maxn*ch]);
switch down window 2 
        affbmidv(&delayline[ch][0],fbid2,128,128,1,in,384,1,0,&z[max*maxn*ch]);
      */
     


      /*512-128 bands*/
      if (windowtype==8) /*normal 512 bands*/
        {
	  /*printf(" window 8 ");*/
	  /*
        if(windowtypepre[ch]==3)  switch up window 2
          {
          affbmidv(&y[ch][0],fbiu2,1024,1024,1,in,3072,1,0,&z[max*maxn*ch]);
          aus[ch]=0;
          }
        else 
         */ 
           /* normal */
          {
         


	    /*printf(" window 8 ");*/
        xmemp=&xmem[ch][256]; /*N2/2*/
        inp=&in[0];
        for(i=0;i<768;i++)
          *inp++ = *xmemp++;

	
          {
	   
	    /*printf("  wind512  ");*/
          for(i=0;i<4;i++)
            {
            affbmidv(&y[ch][i*512],fb512,512,512,1,&in[i*512],1536,1,0,&z[max*maxn*ch]);
	   
            }
          }
        xmemp=&xmem[ch][0];
        inp=&in[1792]; /*N1-N2/2*/
        for(i=0;i<1024;i++)
          *xmemp++ = *inp++;


          }
        }
      else {if (windowtype==7) /*switch down*/
        {
	  /*printf(" window 7 ");*/

/*weiter*/
        xmemp=&xmem[ch][256]; /*N2/2*/
        inp=&in[0];
        for(i=0;i<768;i++)
          *inp++ = *xmemp++;

        for(i=0;i<3;i++)
            {
            affbmidv(&y[ch][i*512],fb512,512,512,1,&in[i*512],1536,1,0,&z[max*maxn*ch]);
	   
            }

        affbmidv(&y[ch][1536],fbid1_512_128,512,128,1,&in[1536],1536,1,0,&z[max*maxn*ch]);


        xmemp=&xmem[ch][0];
        inp=&in[1792]; /*N1-N2/2*/
        for(i=0;i<1024;i++)
          *xmemp++ = *inp++;

	
        }
      else {if (windowtype==2) /*short 128 bands */
        {
	  /*printf(" window 2 ");*/
        xmemp=&xmem[ch][64];
        inp=&in[0];
        for(i=0;i<960;i++)
          *inp++ = *xmemp++;

        if(windowtypepre[ch]==7)
          {
	    /*printf("  swdown2 ");*/
          affbmidv(&y[ch][0],fbid2_512_128,128,128,1,&in[0],384,1,0,&z[max*maxn*ch]);
          for(i=0;i<15;i++)
            affbmidv(&y[ch][128+i*128],fb128,128,128,1,&in[128+i*128],384,1,0,&z[max*maxn*ch]);
	 
	  }
        else
          {
	   
	    /*printf("  shortw  ");*/
          for(i=0;i<16;i++)
            {
            affbmidv(&y[ch][i*128],fb128,128,128,1,&in[i*128],384,1,0,&z[max*maxn*ch]);
 	   
            }
          }
        xmemp=&xmem[ch][0];
        inp=&in[1984];
        for(i=0;i<1024;i++)
          *xmemp++ = *inp++;
	}
      else {if (windowtype==4) /*switch up */
        {
	  /*printf(" window 4 ");*/

	  /*z mit xmem und 0 auffuellen*/
    {
    Float *zh,*zh2;
    int N1=128,N2=512,m;

    N=N2;
    /*m=(L-(n-1)*N/2-1.5*N)/(N/2);*/ /* # of low del matrices*/
    m=3;
	  /*  if(count<1)*/
        xmemp=&xmem[ch][256]; /*N2/2*/
        inp=&in[0];
        for(i=0;i<768;i++)
          *inp++ = *xmemp++;

      {
      for(j=(m-1);j>=0;j--)
        {
        zh=&z[max*maxn*ch+N1+N1/2+j*N1/2-1];
        zh2=&z[max*maxn*ch+N2+N2/2+j*N2/2-1];
        for(i=0;i<((N2-N1)/2);i++)
          {
          *zh2-- = 0;
          };
        for(i=0;i<(N1/2);i++)
          {
          *zh2-- = *zh--;
          };

        }
      /*
      zh=&z[max*maxn*ch+N1-1];
      zh2=&z[max*maxn*ch+N2-1]; H 
      */

      zh=&z[max*maxn*ch];
      xmemp=&xmem[ch][0];
      for(i=0;i<(N2/2);i++)
        *zh++ = *xmemp++;
     
      }

      

        affbmidv(&y[ch][0],fbiu2_128_512,512,512,1,in,1536,1,0,&z[max*maxn*ch]);

        for(i=0;i<3;i++)
            {
            affbmidv(&y[ch][512+i*512],fb512,512,512,1,&in[512+i*512],1536,1,0,&z[max*maxn*ch]);
	   
            }

        xmemp=&xmem[ch][0];
        inp=&in[1792]; /*N1-N2/2*/
        for(i=0;i<1024;i++)
          *xmemp++ = *inp++;

        }
	}}}}





      /*2048-128 bands*/


 if (windowtype==0) /*normal 1024 bands*/
        {
	  /*printf(" window 0 ");*/
	  /*
        if(windowtypepre[ch]==3)  switch up window 2
          {
          affbmidv(&y[ch][0],fbiu2,1024,1024,1,in,3072,1,0,&z[max*maxn*ch]);
          aus[ch]=0;
          }
        else 
         */ 
           /* normal */
          {
          affbmidv(&y[ch][0],fb2048,2048,2048,1,in,6144,1,0,&z[max*maxn*ch]);
          aus[ch]=0;
          }
        }
      else {if (windowtype==1) /*switch down*/
        {
	  /*printf(" window 1 ");*/
        affbmidv(&y[ch][0],fbid1_2048_128,2048,128,1,in,6144,1,0,&z[max*maxn*ch]);
        xmemp=&xmem[ch][0];
        inp=&in[1024];
        for(i=0;i<1024;i++)
          *xmemp++ = *inp++;
        
	
        }
      else {if (windowtype==2) /*short 128 bands */
        {
 /*
printf(" window 2 ");
        xmemp=&xmem[ch][64];
        inp=&in[0];
        for(i=0;i<960;i++)
          *inp++ = *xmemp++;

        if(windowtypepre[ch]==1)
          {
printf("  swdown2 ");
          affbmidv(&y[ch][0],fbid2_2048_128,128,128,1,&in[0],384,1,0,&z[max*maxn*ch]);
          for(i=0;i<15;i++)
            affbmidv(&y[ch][128+i*128],fb128,128,128,1,&in[128+i*128],384,1,0,&z[max*maxn*ch]);
	 
	  }
        else
          {
	   
printf("  shortw  ");
          for(i=0;i<16;i++)
            {
            affbmidv(&y[ch][i*128],fb128,128,128,1,&in[i*128],384,1,0,&z[max*maxn*ch]);
   
            }
          }
        xmemp=&xmem[ch][0];
        inp=&in[1984];
        for(i=0;i<1024;i++)
          *xmemp++ = *inp++;
  */
        }
      else {if (windowtype==3) /*switch up */
        {
	  /*printf(" window 3 ");*/

	  /*z mit xmem und 0 auffuellen*/
    {
    Float *zh,*zh2;
    int N1=128,N2=2048,m;

    N=N2;
    /*m=(L-(n-1)*N/2-1.5*N)/(N/2);*/ /* # of low del matrices*/
    m=3;
	  /*  if(count<1)*/
      {
      for(j=(m-1);j>=0;j--)
        {
        zh=&z[max*maxn*ch+N1+N1/2+j*N1/2-1];
        zh2=&z[max*maxn*ch+N2+N2/2+j*N2/2-1];
        for(i=0;i<((N2-N1)/2);i++)
          {
          *zh2-- = 0;
          };
        for(i=0;i<(N1/2);i++)
          {
          *zh2-- = *zh--;
          };

        }
      /*
      zh=&z[max*maxn*ch+N1-1];
      zh2=&z[max*maxn*ch+N2-1]; H 
      */

      zh=&z[max*maxn*ch];
      xmemp=&xmem[ch][0];
      for(i=0;i<(N2/2);i++)
        *zh++ = *xmemp++;
     
      }

      

        affbmidv(&y[ch][0],fbiu2_128_2048,2048,2048,1,in,6144,1,0,&z[max*maxn*ch]);

        }
	}}}}


 /*2048-512 bands*/


  if (windowtype==0) /*normal 1024 bands*/
        {
       /*
printf(" window 0 ");
	 
            normal 
          {
          affbmidv(&y[ch][0],fb2048,2048,2048,1,in,6144,1,0,&z[max*maxn*ch]);
          aus[ch]=0;
          }
      */
        }
      else {if (windowtype==6) /*switch down*/
        {
	  /*printf(" window 6 ");*/
        affbmidv(&y[ch][0],fbid1_2048_512,2048,512,1,in,6144,1,0,&z[max*maxn*ch]);
        xmemp=&xmem[ch][0];
        inp=&in[1024];
        for(i=0;i<1024;i++)
          *xmemp++ = *inp++;
        
	
        }
      else {if (windowtype==8) /*short 512 bands */
        {
	  /*
printf(" window 8 ");
        xmemp=&xmem[ch][256];   N2/2
        inp=&in[0];
        for(i=0;i<768;i++)
          *inp++ = *xmemp++;

        if(windowtypepre[ch]==6)
          {
printf("  swdown2 ");
          affbmidv(&y[ch][0],fbid2_2048_512,512,512,1,&in[0],1536,1,0,&z[max*maxn*ch]);
          for(i=0;i<3;i++)
            affbmidv(&y[ch][512+i*512],fb512,512,512,1,&in[512+i*512],1536,1,0,&z[max*maxn*ch]);
	 
	  }
        else
          {
	   
printf("  shortw  ");
          for(i=0;i<4;i++)
            {
            affbmidv(&y[ch][i*512],fb512,512,512,1,&in[i*512],1536,1,0,&z[max*maxn*ch]);
	   
            }
          }
        xmemp=&xmem[ch][0];
        inp=&in[1792]; /*N1-N2/2
        for(i=0;i<1024;i++)
          *xmemp++ = *inp++;
    */
	}
      else {if (windowtype==5) /*switch up */
        {
	  /*printf(" window 5 ");*/

	  /*z mit xmem und 0 auffuellen*/
    {
    Float *zh,*zh2;
    int N1=512,N2=2048,m;

    N=N2;
    /*m=(L-(n-1)*N/2-1.5*N)/(N/2);*/ /* # of low del matrices*/
    m=3;
	  /*  if(count<1)*/
      {
      for(j=(m-1);j>=0;j--)
        {
        zh=&z[max*maxn*ch+N1+N1/2+j*N1/2-1];
        zh2=&z[max*maxn*ch+N2+N2/2+j*N2/2-1];
        for(i=0;i<((N2-N1)/2);i++)
          {
          *zh2-- = 0;
          };
        for(i=0;i<(N1/2);i++)
          {
          *zh2-- = *zh--;
          };

        }
      /*
      zh=&z[max*maxn*ch+N1-1];
      zh2=&z[max*maxn*ch+N2-1]; H 
      */

      zh=&z[max*maxn*ch];
      xmemp=&xmem[ch][0];
      for(i=0;i<(N2/2);i++)
        *zh++ = *xmemp++;
     
      }

      

        affbmidv(&y[ch][0],fbiu2_512_2048,2048,2048,1,in,6144,1,0,&z[max*maxn*ch]);

        }
	}}}}






      windowtypepre[ch]=windowtype;



      /*  
      printf("type conversion \n");
      */
    /*type conversion to double */
      specp=ch_info[ch].p_spectrum;
      
      outp=&y[ch][0];
      for(i=0;i<2048;i++)
         {*specp++ =(double) *outp++;
         }

     
    

      }
   mask=mask<<1;
   }
}





/************** coder MP4 interface ***************** */



void buffer2freqLDTV(double *timeInPtr, /*input: 1/2 block of new time values*/
        	    double *freqOutPtr, /* output: interleaved spectrum */
                    double p_overlap[],
		    WINDOW_TYPE blockType, /* input: block type 0-3 */
                    Window_shape  wfun_select,      /* offers the possibility to select different window functions */
  int              nlong,            /* shift length for long windows   */
  int              nmed,             /* shift length for medium windows */
  int              nshort,           /* shift length for short windows  */
  Mdct_in          overlap_select,  /*not used! */
  int              num_short_win,    /* number of short windows to      */
                                     /* transform: not used!            */
  int              save_window       /* save window information: not used! */

                     ) 
{

T2M_CHANNEL_INFO ch_info[MAX_CHANNELS];
long channel_enable_mask;
double	       transBuff[2048];
int i;
int ch=0;

/*printf("\n varminmp4lm2: buffer2freq, ch= %d, blockType= %d \n",ch,blockType);*/

ch_info[ch].p_time_signal= timeInPtr;
ch_info[ch].p_spectrum= transBuff;
ch_info[ch].window_type=blockType;
channel_enable_mask= 1<<ch;

time2freqtv(channel_enable_mask, ch_info);

/*
if(blockType==2)
  {printf("weaveShort \n");
  weaveShortb( transBuff, freqOutPtr );
  }
else
*/
  for( i= 0; i< 2048;i++ ) 
    {
          freqOutPtr[i] = (double)transBuff[i];
    }


}


