/* $Id: saol_co_imp.h,v 1.5 1997/11/20 18:36:19 eds Exp $ */
/* $Log: saol_co_imp.h,v $
 * Revision 1.5  1997/11/20  18:36:19  eds
 * midicc() core opcode for current SASBF implementation.
 *
 * Revision 1.5  1997/11/15 00:43:15  luked
 * This is the result of the manual merge from the vendor branch for the
 * release tagged Fribourg_after_integration. I (brian) have probably lost
 * some history, but oh well.
 *
 * This contains the integration work by Eric Scheirer (MIT).
 *
 * Revision 1.4  1997/11/10  23:00:05  eds
 * Added fir(), iir(), iirt().
 *
 * Revision 1.3  1997/11/05  20:45:54  eds
 * Added kdump(), adump().
 *
 * Revision 1.2  1997/10/01  15:34:25  eds
 * Added firt() opcode.
 * */
/*********************************************************************

This software module was originally developed by

Eric D. Scheirer (MIT Media Laboratory)

in the course of development of the MPEG-2 NBC/MPEG-4 Audio standard
ISO/IEC 13818-7, 14496-1,2 and 3. This software module is an
implementation of a part of one or more MPEG-2 NBC/MPEG-4 Audio tools
as specified by the MPEG-2 NBC/MPEG-4 Audio standard.  ISO/IEC gives
users of the MPEG-2 NBC/MPEG-4 Audio standards free license to this
software module or modifications thereof for use in hardware or
software products claiming conformance to the MPEG-2 NBC/ MPEG-4 Audio
standards. Those intending to use this software module in hardware or
software products are advised that this use may infringe existing
patents. The original developer of this software module and his/her
company, the subsequent editors and their companies, and ISO/IEC have
no liability for use of this software module or modifications thereof
in an implementation.

This software module is hereby released into the public domain.

***********************************************************************/

#include "saol_interp.h"
#include "fft.h"

struct core_opcode_struct *is_core_opcode(char *name);

typedef struct core_opcode_struct {
  char *name;
  long oprate;  /* rate of the opcode */
  long p1type, p2type, p3type, p4type, p5type, p6type;
  /* rates of the arguments */
  long varargs; /* rate of the terminal vararg sequence */
  long storage; /* local storage needed for each instance of the opcode */
  double (*code)(sa_decoder *sa, opval *,actparam *, int, long rate);
    /* function pointer to the code needed */
} core_opcode;

#define PROT_MAL_CO(op_storage) \
if (!(op->local = (void *)malloc(sizeof(op_storage)))) \
  interror("Couldn't allocate space in co_opcode");

void add_sym_table_core_opcodes(sa_decoder *sa,symtable *t);
int opcode_is_varargs(char *name);
table_storage *co_param_table(actparam *pf, int which);
double co_param(actparam *pf, int which);

typedef struct int_storage_struct { int shold; } int_storage;
double co_int(sa_decoder *, opval *,actparam *, int, long rate); 
typedef struct frac_storage_struct { int shold; } frac_storage;
double co_frac(sa_decoder *, opval *,actparam *, int, long rate); 
typedef struct dbamp_storage_struct { int shold; } dbamp_storage;
double co_dbamp(sa_decoder *, opval *,actparam *, int, long rate); 
typedef struct ampdb_storage_struct { int shold; } ampdb_storage;
double co_ampdb(sa_decoder *, opval *,actparam *, int, long rate); 
typedef struct abs_storage_struct { int shold; } abs_storage;
double co_abs(sa_decoder *, opval *,actparam *, int, long rate); 
typedef struct exp_storage_struct { int shold; } exp_storage;
double co_exp(sa_decoder *, opval *,actparam *, int, long rate); 
typedef struct log_storage_struct { int shold; } log_storage;
double co_log(sa_decoder *, opval *,actparam *, int, long rate); 
typedef struct sqrt_storage_struct { int shold; } sqrt_storage;
double co_sqrt(sa_decoder *, opval *,actparam *, int, long rate); 
typedef struct sin_storage_struct { int shold; } sin_storage;
double co_sin(sa_decoder *, opval *,actparam *, int, long rate); 
typedef struct cos_storage_struct { int shold; } cos_storage;
double co_cos(sa_decoder *, opval *,actparam *, int, long rate); 
typedef struct atan_storage_struct { int shold; } atan_storage;
double co_atan(sa_decoder *, opval *,actparam *, int, long rate);
typedef struct pow_storage_struct { int shold; } pow_storage;
double co_pow(sa_decoder *, opval *,actparam *, int, long rate);
typedef struct log10_storage_struct { int shold; } log10_storage;
double co_log10(sa_decoder *, opval *,actparam *, int, long rate);
typedef struct asin_storage_struct { int shold; } asin_storage;
double co_asin(sa_decoder *, opval *,actparam *, int, long rate);
typedef struct acos_storage_struct { int shold; } acos_storage;
double co_acos(sa_decoder *, opval *,actparam *, int, long rate);
typedef struct floor_storage_struct { int shold; } floor_storage;
double co_floor(sa_decoder *, opval *,actparam *, int, long rate);
typedef struct ceil_storage_struct { int shold; } ceil_storage;
double co_ceil(sa_decoder *, opval *,actparam *, int, long rate);
typedef struct min_storage_struct { int shold; } min_storage;
double co_min(sa_decoder *, opval *,actparam *, int, long rate);
typedef struct max_storage_struct { int shold; } max_storage;
double co_max(sa_decoder *, opval *,actparam *, int, long rate);
typedef struct octpch_storage_struct { int shold; } octpch_storage;
double co_octpch(sa_decoder *, opval *,actparam *, int, long rate); 
typedef struct pchoct_storage_struct { int shold; } pchoct_storage;
double co_pchoct(sa_decoder *, opval *,actparam *, int, long rate); 
typedef struct cpspch_storage_struct { int shold; } cpspch_storage;
double co_cpspch(sa_decoder *, opval *,actparam *, int, long rate); 
typedef struct pchcps_storage_struct { int shold; } pchcps_storage;
double co_pchcps(sa_decoder *, opval *,actparam *, int, long rate); 
typedef struct cpsoct_storage_struct { int shold; } cpsoct_storage;
double co_cpsoct(sa_decoder *, opval *,actparam *, int, long rate); 
typedef struct octcps_storage_struct { int shold; } octcps_storage;
double co_octcps(sa_decoder *, opval *,actparam *, int, long rate); 
typedef struct pchmidi_storage_struct { int shold; } pchmidi_storage;
double co_pchmidi(sa_decoder *, opval *,actparam *, int, long rate); 
typedef struct midipch_storage_struct { int shold; } midipch_storage;
double co_midipch(sa_decoder *, opval *,actparam *, int, long rate); 
typedef struct octmidi_storage_struct { int shold; } octmidi_storage;
double co_octmidi(sa_decoder *, opval *,actparam *, int, long rate); 
typedef struct midioct_storage_struct { int shold; } midioct_storage;
double co_midioct(sa_decoder *, opval *,actparam *, int, long rate); 
typedef struct cpsmidi_storage_struct { int shold; } cpsmidi_storage;
double co_cpsmidi(sa_decoder *, opval *,actparam *, int, long rate); 
typedef struct midicps_storage_struct { int shold; } midicps_storage;
double co_midicps(sa_decoder *, opval *,actparam *, int, long rate); 
typedef struct ftlen_storage_struct { int shold; } ftlen_storage;
double co_ftlen(sa_decoder *, opval *,actparam *, int, long rate); 
typedef struct ftloop_storage_struct { int shold; } ftloop_storage;
double co_ftloop(sa_decoder *, opval *,actparam *, int, long rate); 
typedef struct ftloopend_storage_struct { int shold; } ftloopend_storage;
double co_ftloopend(sa_decoder *, opval *,actparam *, int, long rate); 
typedef struct ftsr_storage_struct { int shold; } ftsr_storage;
double co_ftsr(sa_decoder *, opval *,actparam *, int, long rate);
double co_ftbasecps(sa_decoder *, opval *,actparam *, int, long rate); 
typedef struct tableread_storage_struct { int shold; } tableread_storage;
double co_tableread(sa_decoder *, opval *,actparam *, int, long rate); 
typedef struct tablewrite_storage_struct { int shold; } tablewrite_storage;
double co_tablewrite(sa_decoder *, opval *,actparam *, int, long rate);

typedef struct oscil_storage_struct {
  double ph;
  int loops;
} oscil_storage;

double co_oscil(sa_decoder *, opval *,actparam *, int, long rate);

typedef struct koscil_storage_struct {
  double ph;
  int loops;
} koscil_storage;

double co_koscil(sa_decoder *, opval *,actparam *, int, long rate);

typedef struct loscil_storage_struct {
  double idx;
} loscil_storage;

double co_loscil(sa_decoder *, opval *,actparam *, int, long rate);

typedef struct doscil_storage_struct {
  double idx;
} doscil_storage;

double co_doscil(sa_decoder *, opval *,actparam *, int, long rate);

typedef struct kline_storage_struct {
  double left,right,dur,durtime;
  int done,varargs_pos;
} kline_storage;
double co_kline(sa_decoder *, opval *,actparam *, int, long rate); 

typedef struct aline_storage_struct {
  double left,right,dur,durtime;
  int done,varargs_pos;
} aline_storage;
double co_aline(sa_decoder *, opval *,actparam *, int, long rate);

typedef struct kexpon_storage_struct {
  double left,right,dur,durtime;
  int done,varargs_pos;
 } kexpon_storage;
double co_kexpon(sa_decoder *, opval *,actparam *, int, long rate); 
typedef struct aexpon_storage_struct {
  double left,right,dur,durtime;
  int done,varargs_pos;
} aexpon_storage;

double co_aexpon(sa_decoder *, opval *,actparam *, int, long rate); 
typedef struct kphasor_storage_struct { double ph; } kphasor_storage;
double co_kphasor(sa_decoder *, opval *,actparam *, int, long rate); 
typedef struct aphasor_storage_struct { double ph; } aphasor_storage;
double co_aphasor(sa_decoder *, opval *,actparam *, int, long rate); 
typedef struct pluck_storage_struct { int shold; } pluck_storage;
double co_pluck(sa_decoder *, opval *,actparam *, int, long rate);

typedef struct buzz_storage_struct {
  double ph;
} buzz_storage;
double co_buzz(sa_decoder *, opval *,actparam *, int, long rate);

typedef struct fof_storage_struct { int shold; } fof_storage;
double co_fof(sa_decoder *, opval *,actparam *, int, long rate); 
typedef struct irand_storage_struct { int shold; } irand_storage;
double co_irand(sa_decoder *, opval *,actparam *, int, long rate); 
typedef struct krand_storage_struct { int shold; } krand_storage;
double co_krand(sa_decoder *, opval *,actparam *, int, long rate); 
typedef struct arand_storage_struct { int shold; } arand_storage;
double co_arand(sa_decoder *, opval *,actparam *, int, long rate); 
typedef struct ilinrand_storage_struct { int shold; } ilinrand_storage;
double co_ilinrand(sa_decoder *, opval *,actparam *, int, long rate); 
typedef struct klinrand_storage_struct { int shold; } klinrand_storage;
double co_klinrand(sa_decoder *, opval *,actparam *, int, long rate); 
typedef struct alinrand_storage_struct { int shold; } alinrand_storage;
double co_alinrand(sa_decoder *, opval *,actparam *, int, long rate); 
typedef struct iexprand_storage_struct { int shold; } iexprand_storage;
double co_iexprand(sa_decoder *, opval *,actparam *, int, long rate); 
typedef struct kexprand_storage_struct { int shold; } kexprand_storage;
double co_kexprand(sa_decoder *, opval *,actparam *, int, long rate); 
typedef struct aexprand_storage_struct { int shold; } aexprand_storage;
double co_aexprand(sa_decoder *, opval *,actparam *, int, long rate); 

typedef struct kpoissonrand_storage_struct {
  int wait;
} kpoissonrand_storage;

double co_kpoissonrand(sa_decoder *, opval *,actparam *, int, long rate);

typedef struct apoissonrand_storage_struct {
  int wait;
} apoissonrand_storage;

double co_apoissonrand(sa_decoder *, opval *,actparam *, int, long rate);

typedef struct igaussrand_storage_struct { int shold; } igaussrand_storage;
double co_igaussrand(sa_decoder *, opval *,actparam *, int, long rate); 
typedef struct kgaussrand_storage_struct { int shold; } kgaussrand_storage;
double co_kgaussrand(sa_decoder *, opval *,actparam *, int, long rate); 
typedef struct agaussrand_storage_struct { int shold; } agaussrand_storage;
double co_agaussrand(sa_decoder *, opval *,actparam *, int, long rate); 
typedef struct port_storage_struct { int shold; } port_storage;
double co_port(sa_decoder *, opval *,actparam *, int, long rate); 

typedef struct hipass_storage_struct {
  real oldcut, a1,a2,a0,b1,b2,b0,d1,d2;
} hipass_storage;

double co_hipass(sa_decoder *, opval *,actparam *, int, long rate); 

typedef struct lopass_storage_struct {
  real oldcut, a1,a2,a0,b1,b2,b0,d1,d2;
} lopass_storage;

double co_lopass(sa_decoder *, opval *,actparam *, int, long rate);

typedef struct bandpass_storage_struct {
  real oldcf, oldbw, a1, a2, a0, b1, b2, b0, d1, d2;
} bandpass_storage;

double co_bandpass(sa_decoder *, opval *,actparam *, int, long rate);

typedef struct bandstop_storage_struct {
  real oldcf, oldbw, a1, a2, a0, b1, b2, b0, d1, d2;
} bandstop_storage;

double co_bandstop(sa_decoder *, opval *,actparam *, int, long rate);

typedef struct fft_storage_struct {
  complex *basis;
  real *buf,*inbuf;
  int pt,framept,framect;
  int p2,ready;
} fft_storage;

double co_fft(sa_decoder *, opval *,actparam *, int, long rate);

typedef struct ifft_storage_struct {
  complex *basis;
  real *buf;
  int pt,ct,p2;
} ifft_storage;
double co_ifft(sa_decoder *, opval *,actparam *, int, long rate);

typedef struct rms_storage_struct { 
	double *buf;
	double last;
	int pt;
} rms_storage;
double co_rms(sa_decoder *, opval *,actparam *, int, long rate); 

typedef struct gain_storage_struct {
	double *buf;
	double rms;
	int pt;
} gain_storage;

double co_gain(sa_decoder *, opval *,actparam *, int, long rate); 

typedef struct balance_storage_struct {
	double *inbuf, *refbuf;
	double inrms, refrms;
	int pt;
 } balance_storage;

double co_balance(sa_decoder *, opval *,actparam *, int, long rate); 

typedef struct decimate_storage_struct { double last; } decimate_storage;
double co_decimate(sa_decoder *, opval *,actparam *, int, long rate); 

typedef struct upsamp_storage_struct { 
	double last;
	int ct;
} upsamp_storage;
double co_upsamp(sa_decoder *, opval *,actparam *, int, long rate); 

typedef struct downsamp_storage_struct { 
	double *buf;
	int pt;
 } downsamp_storage;
double co_downsamp(sa_decoder *, opval *,actparam *, int, long rate); 

typedef struct samphold_storage_struct {
	double hold;
	double gate;
 } samphold_storage;
double co_samphold(sa_decoder *, opval *,actparam *, int, long rate);

typedef struct delay_storage_struct {
  double *dline;
  int pt;
} delay_storage;

double co_delay(sa_decoder *, opval *,actparam *, int, long rate);

typedef struct delay1_storage_struct { double last; } delay1_storage;

double co_delay1(sa_decoder *, opval *,actparam *, int, long rate);

typedef struct biquad_storage_struct { 
	double d1,d2;
} biquad_storage;

double co_biquad(sa_decoder *, opval *,actparam *, int, long rate);

typedef struct firt_storage_struct {
  double *dline;
  int pt;
} firt_storage;

double co_firt(sa_decoder *, opval *,actparam *, int, long rate); 

typedef struct fir_storage_struct {
  double *dline;
  int pt;
} fir_storage;

double co_fir(sa_decoder *, opval *,actparam *, int, long rate);

typedef struct iir_storage_struct {
  double *dline;
  int pt;
} iir_storage;

double co_iir(sa_decoder *, opval *,actparam *, int, long rate);

typedef struct iirt_storage_struct {
  double *dline;
  int pt;
} iirt_storage;

double co_iirt(sa_decoder *, opval *,actparam *, int, long rate); 

typedef struct fdelay_storage_struct {
  double *dline;
  int pt;
} fdelay_storage;

double co_fdelay(sa_decoder *, opval *,actparam *, int, long rate); 

typedef struct comb_storage_struct {
  double *dline;
  int pt;
} comb_storage;

double co_comb(sa_decoder *, opval *,actparam *, int, long rate);

typedef struct allpass_storage_struct {
  double *dline;
  int pt;
} allpass_storage;

double co_allpass(sa_decoder *, opval *,actparam *, int, long rate);

typedef struct kdump_storage_struct { int shold; } kdump_storage;
double co_kdump(sa_decoder *, opval *,actparam *, int, long rate);
typedef struct adump_storage_struct { int shold; } adump_storage;
double co_adump(sa_decoder *, opval *,actparam *, int, long rate);
double co_midicc(sa_decoder *sa, opval *op, actparam *pf, int pf_ct, long rate);
