/* $Id */
/* $Log */
/*********************************************************************

This software module was originally developed by

Eric D. Scheirer (MIT Media Laboratory)

in the course of development of the MPEG-2 NBC/MPEG-4 Audio standard
ISO/IEC 13818-7, 14496-1,2 and 3. This software module is an
implementation of a part of one or more MPEG-2 NBC/MPEG-4 Audio tools
as specified by the MPEG-2 NBC/MPEG-4 Audio standard.  ISO/IEC gives
users of the MPEG-2 NBC/MPEG-4 Audio standards free license to this
software module or modifications thereof for use in hardware or
software products claiming conformance to the MPEG-2 NBC/ MPEG-4 Audio
standards. Those intending to use this software module in hardware or
software products are advised that this use may infringe existing
patents. The original developer of this software module and his/her
company, the subsequent editors and their companies, and ISO/IEC have
no liability for use of this software module or modifications thereof
in an implementation.

This software module is hereby released into the public domain.

***********************************************************************/

#include <stdio.h>
#include <stdlib.h>
#ifdef _WIN32
#include "string.h"
#else
#include "strings.h"
#endif

#include "saol_sched.h"

char *getline(FILE *fp);
int split(char *s, char ***words);

int parse_score(sa_decoder *sa,char *fn) {
	FILE *fp;
	
	char *s,**s2;
	char err[1000];
	event *ev;
	int ct=0,num;
	
  if (!(fp = fopen(fn,"r"))) {
		sprintf(err,"Couldn't open score file '%s' for read.",fn);
		runtime(err);
	}
	
	while (!feof(fp)) {
		ct++;
		s = getline(fp);
    num = split(s,&s2);
		if (num) {
			ev = new_event(s2,num);
			schedule_event(sa,ev);
		}
	}
  printf("Read %d score events.\n",ct);
	return(ct);
}

event *new_event(char **words,int num) {
	event *ev;
	int base,i;
	
	ev = (event *)malloc(sizeof(event));
	ev->name = NULL;
	ev->label = NULL;
	ev->val = NULL;
	ev->h = NULL;
	ev->time = ev->dur = ev->numval = ev->type = 0;
	
	if (num > 2 && (!strcmp(words[1],"control") || !strcmp(words[2],"control"))) {
		/* control event */
		ev->type = CONTROL_EVENT;
		ev->time = atof(words[0]);
		if (!strcmp(words[1],"control")) {
			ev->label = NULL;
			base = 2;
		}
		else {
			ev->label = strdup(words[1]);
			base = 3;
		}
		ev->name = strdup(words[base]);
		ev->val = (double *)malloc(sizeof(double));
		ev->val[0] = atof(words[base+1]);
		ev->numval = 1;
		}
	else if (!strcmp(words[1],"tempo")) {
		ev->type = TEMPO_EVENT;
		ev->time = atof(words[0]);
		/* tempo event */
	}
		else if (!strcmp(words[1],"table")) {
			/* table event */
			ev->type = TABLE_EVENT;
			ev->name = words[2];
			ev->time = atof(words[0]);
			ev->label = strdup(words[3]); /* generator */
			ev->val = (double *)malloc(sizeof(double) * (num-4));
			for (i=4;i!=num;i++)
				ev->val[i-4] = atof(words[i]);
			ev->numval = num-4;	
		}
		else if (!strcmp(words[1],"end")) {
			/* end event */
			ev->type = END_EVENT;
			ev->time = atof(words[0]);
		}
		else {
			/* must be an instrument event */
			ev->type = INSTR_EVENT;
			
			base = 0;
			if (words[0][strlen(words[0])-1] == ':') { /* label */
				words[0][strlen(words[0])-1] = 0;
				ev->label = strdup(words[0]);
				base = 1;
			}
			ev->name = strdup(words[base+1]);
			ev->time = atof(words[base]);
			ev->dur = atof(words[base+2]);
			ev->val = (double *)malloc(sizeof(double) * (num - 3 - base));
			for (i=base+3;i!=num;i++)
				ev->val[i-3-base] = atof(words[i]);
			ev->numval = num-3-base;
		}
		return ev;
}

char *getline(FILE *fp) {
	char buf[10000],c; 
	int i=0;

  while (!feof(fp) && (c = getc(fp))) {
		if (c == '\n') break;
		buf[i++] = c;
		buf[i] = 0;
		}
	if (feof(fp))
		buf[i-1] = 0;
	return(strdup(buf));
}

int split(char *s, char ***w) {
	unsigned int i=0,ct=0,first = 0,l=0,j;
	char **words,**nwords;
	char buf[500];

	words = NULL;
	while (i < strlen(s)) {
		if (i < strlen(s)-1 && s[i] == '/' && s[i+1] == '/') /* comment */
			break;
		if (s[i] == ' ' || s[i] == '\t') {
			if (l) {
				nwords = (char **)malloc((ct+1) * sizeof(char *));
				for (j=0;j<ct;j++)
					nwords[j] = words[j];
				nwords[ct++] = strdup(buf);
				if (words) free(words);
				words = nwords;
				l = 0;
			}
		} else {
			buf[l++] = s[i];
			buf[l] = 0;
		}
		i++;
	}
	if (l) {
		nwords = (char **)malloc((ct+1) * sizeof(char *));
		for (j=0;j<ct;j++)
			nwords[j] = words[j];
  	nwords[ct++] = strdup(buf);
		if (words) free(words);
		words = nwords;
		l = 0;
	}
	
	*w = words;
	return ct;
}


