/************************************************************
   Copyright (C) 1993 by The Trustees of Columbia University in the City 
   of New York

   OBJECT-ORIENTED Protein Data Bank Project
   Biochemistry and Molecular Biophysics, Computer Science depts.
 **************************************************************

   File: aa.h
   Responsable: Weider Chang, Ph.D

 **************************************************************/

#ifndef _H_AARESIDUE
#define _H_AARESIDUE

#include "oopdb_setup.h"
#include "i_aa.h"

#define _H_AARESIDUE_LEVEL

class AAResidue : public IntrAAResidue {
 public:
  AAResidue(char* name) : IntrAAResidue(name) {}
};

class Nucleotide : public IntrNucleotide {
 public:
  Nucleotide(char* name) : IntrNucleotide(name) {}
};

class Saccharide : public IntrSaccharide {
 public:
  Saccharide(char* name) : IntrSaccharide(name) {}
};

class HetMonomer : public IntrHetMonomer {
 public:
  HetMonomer(char *name) : IntrHetMonomer(name){}
};

#include "i_aa.h"

#define _H_CAARESIDUE

class CAAResidue : public IntrCAAResidue {
 public:
  CAAResidue(char* name) : IntrCAAResidue(name) {}
};

class NCAAResidue : public IntrNCAAResidue {
 public:
  NCAAResidue(char* name) : IntrNCAAResidue(name) {}
};

class CNucleotide : public IntrCNucleotide {
 public:
  CNucleotide(char* name) : IntrCNucleotide(name) {}
};

class NCNucleotide : public IntrNCNucleotide {
 public:
  NCNucleotide(char* name) : IntrNCNucleotide(name) {}
};

#endif






