/*

  File: contour.h

  $Header$
  
  $Log$
  
  $Author$

*/
/********************************************************************
   Copyright (C) 1993 by The Trustees of Columbia University in the City 
   of New York


   OBJECT-ORIENTED Protein Data Bank Project
   Biochemistry and Molecular Biophysics, Computer Science depts.
 **************************************************************

   File: contour.h
   Responsable: Weider Chang, Ph.D

 **************************************************************/


#ifndef CONTOUR_H
#define CONTOUR_H

#define NUMCONTOURS 7

typedef struct {
double phi, psi;
} torsion;
 
static torsion rcontour1[] = {
-180.0000,-164.1945,
-179.6077,-164.0287,
-178.6672,-163.6364,
-178.3230,-163.4952,
-178.1818,-163.4381,
-177.8779,-163.3325,
-176.9810,-163.0190,
-176.3636,-162.8057,
-175.5992,-162.5826,
-175.1923,-162.4650,
-174.5455,-162.2771,
-174.1754,-162.1882,
-172.7599,-161.8509,
-172.7273,-161.8430,
-172.7064,-161.8390,
-172.5974,-161.8182,
-171.1785,-161.5488,
-170.9091,-161.4978,
-170.5337,-161.4428,
-169.6027,-161.3064,
-169.0909,-161.2315,
-168.4342,-161.1615,
-167.9779,-161.1130,
-167.2727,-161.0378,
-166.4339,-160.9794,
-166.3024,-160.9704,
-165.4545,-160.9112,
-164.5746,-160.8799,
-164.5140,-160.8777,
-163.6364,-160.8464,
-162.7936,-160.8428,
-162.6602,-160.8420,
-161.8182,-160.8384,
-160.9589,-160.8593,
-160.8615,-160.8615,
-160.0000,-160.8825,
-159.1090,-160.9272,
-159.0708,-160.9292,
-158.1818,-160.9740,
-157.3953,-161.0316,
-157.1301,-161.0517,
-156.3636,-161.1081,
-155.7144,-161.1690,
-155.1394,-161.2242,
-154.5455,-161.2802,
-154.0613,-161.3340,
-153.1023,-161.4431,
-152.7273,-161.4851,
-152.4315,-161.5224,
-151.0241,-161.7032,
-150.9091,-161.7178,
-150.8209,-161.7299,
-150.1918,-161.8182,
-149.2265,-161.9538,
-149.0909,-161.9732,
-148.9084,-162.0006,
-147.6439,-162.1894,
-147.2727,-162.2454,
-146.7665,-162.3244,
-146.0688,-162.4324,
-145.4545,-162.5284,
-144.6109,-162.6618,
-144.4978,-162.6796,
-143.6364,-162.8161,
-142.9274,-162.9274,
-142.4523,-163.0022,
-141.8182,-163.1019,
-141.3544,-163.1726,
-140.3033,-163.3331,
-140.0000,-163.3793,
-139.7756,-163.4120,
-138.2249,-163.6364,
-138.1873,-163.6419,
-138.1818,-163.6427,
-138.1745,-163.6436,
-136.5882,-163.8609,
-136.3636,-163.8915,
-136.0716,-163.9284,
-134.9768,-164.0677,
-134.5455,-164.1221,
-133.9960,-164.1858,
-133.3521,-164.2612,
-132.7273,-164.3335,
-131.9482,-164.4155,
-131.7132,-164.4404,
-130.9091,-164.5249,
-130.0593,-164.6048,
-129.9285,-164.6169,
-129.0909,-164.6956,
-128.3898,-164.7535,
-127.9368,-164.7904,
-127.2727,-164.8452,
-126.7036,-164.8855,
-125.9723,-164.9368,
-125.4545,-164.9734,
-125.0000,-165.0000,
-124.0344,-165.0565,
-123.6364,-165.0799,
-123.2782,-165.0964,
-122.1224,-165.1503,
-121.8182,-165.1643,
-121.5373,-165.1737,
-120.2360,-165.2186,
-120.0000,-165.2264,
-119.7765,-165.2311,
-118.3732,-165.2631,
-118.1818,-165.2671,
-117.9967,-165.2694,
-116.5268,-165.2914,
-116.3636,-165.2935,
-116.2039,-165.2948,
-114.6875,-165.3125,
-114.5455,-165.3138,
-114.4061,-165.3152,
-112.8463,-165.3355,
-112.7273,-165.3367,
-112.6113,-165.3386,
-110.9942,-165.3694,
-110.9091,-165.3708,
-110.8276,-165.3731,
-109.1213,-165.4242,
-109.0909,-165.4250,
-109.0626,-165.4263,
-108.4431,-165.4545,
-107.3251,-165.5069,
-107.2727,-165.5095,
-107.2138,-165.5135,
-105.6215,-165.6215,
-105.4546,-165.6329,
-105.2580,-165.6511,
-103.9549,-165.7731,
-103.6364,-165.8025,
-103.2402,-165.8507,
-102.3273,-165.9637,
-101.8182,-166.0253,
-101.1433,-166.1294,
-100.7388,-166.1934,
-100.0000,-166.3064,
-99.18594,-166.4587,
-98.95432,-166.5002,
-98.18182,-166.6429,
-97.65948,-166.7504,
-96.69692,-166.9395,
-96.36364,-167.0070,
-96.14356,-167.0526,
-95.02910,-167.2727,
-94.62730,-167.3546,
-94.54546,-167.3704,
-94.42611,-167.3921,
-93.09791,-167.6434,
-92.72728,-167.7097,
-92.21089,-167.7891,
-91.53407,-167.8977,
-90.90910,-167.9924,
-90.09793,-168.0839,
-89.92279,-168.1046,
-89.09091,-168.1973,
-88.24735,-168.2473,
-88.10861,-168.2550,
-87.27273,-168.3042,
-86.48082,-168.2990,
-86.24818,-168.2973,
-85.45455,-168.2920,
-84.58070,-168.2171,
-84.51562,-168.2117,
-83.63637,-168.1358,
-82.90484,-168.0043,
-82.46715,-167.9217,
-81.81818,-167.8033,
-81.40739,-167.6835,
-80.07476,-167.2727,
-80.01722,-167.2555,
-80.00000,-167.2501,
-79.96001,-167.2327,
-78.73958,-166.7150,
-78.18182,-166.4642,
-77.51424,-166.1221,
-76.45508,-165.5460,
-76.36364,-165.4971,
-76.33563,-165.4826,
-76.28495,-165.4545,
-75.15216,-164.8478,
-74.54546,-164.5052,
-73.95150,-164.2303,
-72.72854,-163.6376,
-72.72728,-163.6370,
-72.72676,-163.6369,
-72.72500,-163.6364,
-71.30898,-163.2365,
-70.90910,-163.1210,
-70.39970,-163.1270,
-69.59589,-163.1314,
-69.09091,-163.1372,
-68.73477,-163.2802,
-67.78143,-163.6364,
-67.41510,-163.7787,
-67.27273,-163.8304,
-66.37591,-164.5577,
-66.27876,-164.6303,
-65.45455,-165.2534,
-65.36533,-165.3653,
-65.28702,-165.4545,
-64.53651,-166.3547,
-64.34009,-166.5690,
-63.69797,-167.2727,
-63.66957,-167.3059,
-63.63637,-167.3412,
-62.95152,-168.4061,
-62.45583,-169.0909,
-62.20031,-169.4730,
-61.81818,-169.9828,
-61.48912,-170.5800,
-61.28149,-170.9091,
-60.81453,-171.7236,
-60.45882,-172.2685,
-60.16776,-172.7273,
-60.10743,-172.8347,
-60.00001,-173.0023,
-59.48606,-174.0315,
-59.18699,-174.5455,
-58.85170,-175.2153,
-58.19558,-176.3499,
-58.18794,-176.3636,
-58.18603,-176.3678,
-58.18182,-176.3758,
-57.63490,-177.6349,
-57.35570,-178.1818,
-57.07627,-178.8944,
-56.74599,-179.6176,
-56.58150,-180.0000,
-180.0000,-180.0000
};

static torsion rcontour2a[] = {
-180.0000,-41.87515,
-37.11211,-50.16064,
-36.85164,-50.90909,
-36.76485,-51.31030,
-36.36365,-52.29936,
-36.25519,-52.61883,
-36.19353,-52.72728,
-36.07967,-53.01126,
-35.80116,-53.98298,
-35.46922,-54.54546,
-35.23871,-55.23871,
-34.54546,-56.24113,
-34.50266,-56.32083,
-34.46056,-56.36364,
-34.35181,-56.55729,
-33.93190,-57.56827,
-33.24294,-58.18182,
-33.15355,-58.60810,
-32.72728,-59.03150,
-32.40617,-59.67890,
-31.99402,-60.00001,
-32.11540,-60.61189,
-32.72728,-61.26137,
-33.38870,-61.15676,
-33.72484,-60.99757,
-34.54546,-60.93853,
-35.21042,-60.66497,
-35.77713,-60.58651,
-36.36365,-60.42342,
-36.67451,-60.31088,
-38.16805,-60.01378,
-38.18182,-60.00986,
-38.18980,-60.00798,
-38.24635,-60.00001,
-39.75063,-59.75062,
-40.00000,-59.74492,
-40.24268,-59.75733,
-41.53236,-59.71418,
-41.81819,-59.72662,
-42.06425,-59.75394,
-43.47691,-59.84055,
-43.63637,-59.85673,
-43.76068,-59.87569,
-44.72403,-60.00001,
-45.37039,-60.08416,
-45.45454,-60.09416,
-45.57065,-60.11610,
-46.90663,-60.36610,
-47.27274,-60.43562,
-47.84933,-60.57661,
-48.38783,-60.70309,
-49.09091,-60.87945,
-49.81834,-61.09076,
-50.35138,-61.26046,
-50.90909,-61.42963,
-51.20177,-61.52551,
-52.00111,-61.81818,
-52.53078,-62.01468,
-52.72728,-62.09370,
-53.19893,-62.28983,
-53.82341,-62.54023,
-54.54546,-62.85622,
-55.09160,-63.09023,
-56.25922,-63.63637,
-56.33092,-63.66910,
-56.36364,-63.68491,
-56.45156,-63.72429,
-57.59358,-64.22460,
-58.18182,-64.49758,
-58.86520,-64.77117,
-59.64886,-65.10339,
-60.00001,-65.24880,
-60.15513,-65.29942,
-60.60265,-65.45455,
-61.52062,-65.75211,
-61.81818,-65.85242,
-62.35181,-65.98818,
-62.95390,-66.13702,
-63.63637,-66.31404,
-64.44525,-66.46385,
-64.69475,-66.51292,
-65.45455,-66.65641,
-66.00312,-66.72416,
-66.83620,-66.83620,
-67.27273,-66.89118,
-67.62937,-66.91609,
-68.83092,-67.01273,
-69.09091,-67.03126,
-69.32657,-67.03707,
-70.72235,-67.08598,
-70.90910,-67.09069,
-71.09322,-67.08861,
-72.54152,-67.08698,
-72.72728,-67.08482,
-72.92254,-67.07747,
-74.31199,-67.03927,
-74.54546,-67.03027,
-74.80170,-67.01649,
-76.05305,-66.96214,
-76.36364,-66.94505,
-76.71185,-66.92452,
-77.78196,-66.87287,
-78.18182,-66.84875,
-78.62930,-66.82526,
-79.51598,-66.78871,
-80.00000,-66.76269,
-80.52911,-66.74363,
-81.27124,-66.72578,
-81.81818,-66.70559,
-82.39645,-66.69447,
-83.05381,-66.69017,
-83.63637,-66.67868,
-84.23322,-66.67588,
-84.86311,-66.68129,
-85.45455,-66.67845,
-86.04445,-66.68283,
-86.69662,-66.69662,
-87.27273,-66.70101,
-87.83493,-66.71053,
-88.55083,-66.73264,
-89.09091,-66.74203,
-89.60941,-66.75423,
-90.42113,-66.78476,
-90.90910,-66.79656,
-91.37274,-66.80909,
-92.30170,-66.84716,
-92.72728,-66.85897,
-93.13013,-66.86987,
-94.18556,-66.91284,
-94.54546,-66.92284,
-94.88734,-66.93085,
-96.06470,-66.97380,
-96.36364,-66.98098,
-96.65087,-66.98550,
-97.93038,-67.02129,
-98.18182,-67.02535,
-98.42827,-67.02628,
-99.77363,-67.04636,
-100.0000,-67.04723,
-100.2281,-67.04459,
-101.5877,-67.04229,
-101.8182,-67.03957,
-102.0575,-67.03346,
-103.3747,-67.01111,
-103.6364,-67.00430,
-103.9151,-66.99400,
-105.1398,-66.95795,
-105.4546,-66.94616,
-105.7966,-66.93065,
-106.8883,-66.88825,
-107.2727,-66.87059,
-107.6963,-66.84915,
-108.6255,-66.80733,
-109.0909,-66.78349,
-109.6073,-66.75630,
-110.3568,-66.72047,
-110.9091,-66.69110,
-111.5221,-66.65968,
-112.0876,-66.63304,
-112.7273,-66.59995,
-113.4328,-66.56718,
-113.8232,-66.55047,
-114.5455,-66.51665,
-115.3315,-66.48672,
-115.5693,-66.47843,
-116.3636,-66.44796,
-117.2106,-66.42579,
-117.3321,-66.42297,
-118.1818,-66.40060,
-119.0633,-66.39121,
-119.1181,-66.39079,
-120.0000,-66.38135,
-120.8845,-66.38828,
-120.9343,-66.38881,
-121.8182,-66.39577,
-122.6725,-66.41843,
-122.7854,-66.42172,
-123.6364,-66.44440,
-124.4293,-66.47983,
-124.6731,-66.49133,
-125.4545,-66.52640,
-126.1572,-66.57014,
-126.5986,-66.59856,
-127.2727,-66.64069,
-127.8584,-66.68710,
-128.5622,-66.74405,
-129.0909,-66.78606,
-129.5351,-66.82849,
-130.5643,-66.92792,
-130.9091,-66.96092,
-131.1897,-66.99209,
-132.6042,-67.14968,
-132.7273,-67.16335,
-132.8244,-67.17558,
-133.6002,-67.27273,
-134.4525,-67.36573,
-134.5455,-67.37579,
-134.6624,-67.38969,
-136.0767,-67.55965,
-136.3636,-67.59364,
-136.7318,-67.64088,
-137.6890,-67.76557,
-138.1818,-67.82853,
-138.8257,-67.91663,
-139.2912,-67.98150,
-140.0000,-68.07789,
-140.8858,-68.20509,
-140.9399,-68.21261,
-141.8182,-68.33778,
-142.4753,-68.43377,
-143.0619,-68.51647,
-143.6364,-68.59963,
-144.0659,-68.66135,
-145.1785,-68.81484,
-145.4545,-68.85411,
-145.6629,-68.88258,
-147.2609,-69.09091,
-147.2715,-69.09216,
-147.2727,-69.09230,
-147.2743,-69.09246,
-148.9133,-69.26857,
-149.0909,-69.28674,
-149.3058,-69.30576,
-150.5760,-69.42397,
-150.9091,-69.45316,
-151.2987,-69.48053,
-152.2652,-69.55300,
-152.7273,-69.58513,
-153.2466,-69.61028,
-153.9866,-69.64977,
-154.5455,-69.67656,
-155.1450,-69.69049,
-155.7470,-69.70757,
-156.3636,-69.72174,
-156.9912,-69.71848,
-157.5542,-69.71852,
-158.1818,-69.71529,
-158.7841,-69.69315,
-159.4176,-69.67326,
-160.0000,-69.65207,
-160.5238,-69.61469,
-161.3488,-69.56031,
-161.8182,-69.52715,
-162.2116,-69.48430,
-163.3620,-69.36531,
-163.6364,-69.33572,
-163.8493,-69.30390,
-165.3295,-69.09091,
-165.4378,-69.07417,
-165.4545,-69.07170,
-165.4784,-69.06702,
-166.9530,-68.77120,
-167.2727,-68.70927,
-167.7785,-68.58516,
-168.4241,-68.42407,
-169.0909,-68.26219,
-169.8533,-68.03516,
-170.2672,-67.91463,
-170.9091,-67.72540,
-171.2436,-67.60728,
-172.2080,-67.27273,
-172.5854,-67.13091,
-172.7273,-67.07877,
-173.0708,-66.92919,
-173.8572,-66.58448,
-174.5455,-66.28793,
-175.1003,-66.00936,
-176.2203,-65.45455,
-176.3131,-65.40398,
-176.3636,-65.37685,
-176.5682,-65.24998,
-177.4369,-64.70965,
-178.1818,-64.25205,
-178.5435,-63.99806,
-179.0632,-63.63637,
-179.5890,-63.22536,
-180.0000,-62.90758
};

static torsion rcontour2b[] = {
-180.0000,-41.87515,
-179.9565,-41.86169,
-179.7872,-41.81819,
-178.4601,-41.53990,
-178.1818,-41.49411,
-177.8216,-41.45795,
-176.8499,-41.33192,
-176.3636,-41.28619,
-175.8100,-41.26459,
-175.1427,-41.22093,
-174.5455,-41.19887,
-173.9324,-41.20515,
-173.3480,-41.19749,
-172.7273,-41.20358,
-172.1421,-41.23297,
-171.4743,-41.25293,
-170.9091,-41.28024,
-170.4123,-41.32135,
-169.5301,-41.37900,
-169.0909,-41.41418,
-168.7267,-41.45395,
-167.5231,-41.56778,
-167.2727,-41.59439,
-167.0748,-41.62021,
-165.4613,-41.81146,
-165.4545,-41.81232,
-165.4494,-41.81306,
-165.4124,-41.81819,
-163.8860,-42.06781,
-163.6364,-42.10568,
-163.2883,-42.16629,
-162.3381,-42.33807,
-161.8182,-42.42717,
-161.0677,-42.56871,
-160.8019,-42.62010,
-160.0000,-42.76958,
-159.2768,-42.91321,
-158.8155,-43.00266,
-158.1818,-43.12755,
-157.7594,-43.21393,
-156.5397,-43.46031,
-156.3636,-43.49617,
-156.2474,-43.52014,
-155.6834,-43.63637,
-154.7683,-43.85922,
-154.5455,-43.91266,
-154.1813,-44.00056,
-153.3040,-44.21307,
-152.7273,-44.35194,
-151.8358,-44.56303,
-151.7897,-44.57399,
-150.9091,-44.78278,
-150.3618,-44.90726,
-149.4213,-45.12416,
-149.0909,-45.19971,
-148.8809,-45.24451,
-147.9207,-45.45454,
-147.4059,-45.58766,
-147.2727,-45.62233,
-147.0520,-45.67526,
-145.9392,-45.93915,
-145.4545,-46.05621,
-144.6889,-46.22017,
-144.4517,-46.26990,
-143.6364,-46.44652,
-142.9375,-46.57384,
-142.4174,-46.67354,
-141.8182,-46.78447,
-141.3911,-46.84564,
-140.2498,-47.02290,
-140.0000,-47.05945,
-139.8058,-47.07852,
-138.1944,-47.26013,
-138.1818,-47.26141,
-138.1711,-47.26198,
-138.0165,-47.27274,
-136.4889,-47.39798,
-136.3636,-47.41017,
-136.2193,-47.41707,
-134.7367,-47.46399,
-134.5455,-47.47343,
-134.3445,-47.47372,
-132.9018,-47.44725,
-132.7273,-47.44751,
-132.5600,-47.44000,
-130.9670,-47.33060,
-130.9091,-47.32788,
-130.8586,-47.32324,
-130.4376,-47.27274,
-129.2165,-47.14714,
-129.0909,-47.13048,
-128.9190,-47.10081,
-127.6352,-46.91025,
-127.2727,-46.84399,
-126.7225,-46.72253,
-126.1224,-46.60487,
-125.4545,-46.44774,
-124.6734,-46.23575,
-124.2998,-46.11797,
-123.6364,-45.92505,
-123.2812,-45.80971,
-122.3321,-45.45454,
-121.9464,-45.32635,
-121.8182,-45.27707,
-121.5164,-45.15280,
-120.6414,-44.81313,
-120.0000,-44.52686,
-119.3947,-44.24171,
-118.2609,-43.63637,
-118.2077,-43.61044,
-118.1818,-43.59604,
-118.0867,-43.54126,
-117.0409,-42.95914,
-116.3636,-42.53157,
-115.9321,-42.24968,
-115.3442,-41.81819,
-114.8712,-41.49243,
-114.5455,-41.23940,
-113.8549,-40.69060,
-113.0777,-40.00000,
-112.8888,-39.83846,
-112.7273,-39.68336,
-111.9661,-38.94302,
-111.2633,-38.18182,
-111.0923,-37.99864,
-110.9091,-37.77951,
-110.2657,-37.00699,
-109.7823,-36.36365,
-109.4883,-35.96628,
-109.0909,-35.37004,
-108.7601,-34.87622,
-108.5590,-34.54546,
-108.0854,-33.73274,
-107.8693,-33.32384,
-107.5446,-32.72728,
-107.4533,-32.54668,
-107.2727,-32.15445,
-106.8742,-31.30766,
-106.7014,-30.90910,
-106.3532,-30.01042,
-106.3416,-29.97801,
-106.0126,-29.09091,
-105.8791,-28.66635,
-105.4808,-27.29898,
-105.4728,-27.27274,
-105.4693,-27.25797,
-105.4546,-27.19095,
-105.1277,-25.78140,
-105.0553,-25.45454,
-104.9851,-24.98511,
-104.8685,-24.22240,
-104.7815,-23.63637,
-104.7340,-22.91582,
-104.7111,-22.56163,
-104.6619,-21.81819,
-104.6835,-21.04720,
-104.6937,-20.76089,
-104.7153,-20.00000,
-104.8009,-19.34636,
-104.8884,-18.74802,
-104.9645,-18.18182,
-105.0558,-17.78307,
-105.4014,-16.41676,
-105.4141,-16.36365,
-105.4239,-16.33299,
-105.4546,-16.24631,
-105.8613,-14.95216,
-105.9990,-14.54546,
-106.3682,-13.64096,
-106.3755,-13.62453,
-106.7596,-12.72728,
-106.9268,-12.38138,
-107.2727,-11.72530,
-107.5323,-11.16869,
-107.6625,-10.90910,
-108.1293,-10.05249,
-108.1658,-9.983963,
-108.6817,-9.090912,
-108.8360,-8.836044,
-109.0909,-8.451279,
-109.5270,-7.708862,
-109.8052,-7.272736,
-110.2423,-6.605896,
-110.9091,-5.677124,
-110.9964,-5.541824,
-111.0577,-5.454559,
-111.4255,-4.938141,
-111.7489,-4.476181,
-112.3997,-3.636368,
-112.5418,-3.450851,
-112.7273,-3.234528,
-113.3449,-2.435822,
-113.8780,-1.818192,
-114.1839,-1.456680,
-114.5455,-1.079025,
-115.0472,-0.5017395,
-115.5384,0.,
-80.75270,0.,
-80.36770,-0.3677063,
-80.00000,-0.5893097,
-79.25267,-1.070862,
-78.75864,-1.241364,
-78.18182,-1.498596,
-77.97644,-1.612808,
-77.33517,-1.818192,
-76.62411,-2.078674,
-76.36364,-2.130753,
-75.88340,-2.298431,
-75.28214,-2.554855,
-74.54546,-2.757431,
-73.94568,-3.036591,
-73.04188,-3.321762,
-72.72728,-3.441010,
-72.60469,-3.513794,
-72.33386,-3.636368,
-71.41236,-4.139648,
-70.90910,-4.352676,
-70.25875,-4.804214,
-69.10458,-5.454559,
-69.09651,-5.460144,
-69.09091,-5.463348,
-68.98927,-5.556183,
-68.14809,-6.329910,
-67.27273,-7.020706,
-67.15514,-7.155136,
-67.03708,-7.272736,
-66.32742,-8.145599,
-65.45455,-9.080597,
-65.45042,-9.086777,
-65.44725,-9.090912,
-65.43525,-9.110214,
-64.76806,-10.22261,
-64.28833,-10.90910,
-64.05447,-11.32719,
-63.63637,-11.96346,
-63.38741,-12.47832,
-63.24447,-12.72728,
-62.89293,-13.47072,
-62.79185,-13.70094,
-62.33781,-14.54546,
-62.17860,-14.90587,
-61.81818,-15.56731,
-61.58433,-16.12978,
-61.46213,-16.36365,
-61.16904,-17.01279,
-61.01843,-17.38206,
-60.59483,-18.18182,
-60.40627,-18.58809,
-60.00001,-19.26860,
-59.76455,-19.76454,
-59.61824,-20.00000,
-59.12524,-20.87477,
-59.10181,-20.92000,
-58.47819,-21.81819,
-58.36398,-22.00035,
-58.18182,-22.22110,
-57.60823,-23.06277,
-57.08932,-23.63637,
-56.76286,-24.03558,
-56.36364,-24.40744,
-55.86932,-24.96024,
-55.28920,-25.45454,
-54.90712,-25.81621,
-54.54546,-26.07831,
-53.91282,-26.64009,
-52.99097,-27.27274,
-52.84190,-27.38736,
-52.72728,-27.45552,
-51.96181,-28.03819,
-51.80069,-28.16434,
-50.90909,-28.73012,
-50.70840,-28.89021,
-50.40559,-29.09091,
-49.65364,-29.65364,
-49.09091,-30.00401,
-48.59172,-30.40990,
-47.87552,-30.90910,
-47.54048,-31.17685,
-47.27274,-31.36052,
-46.55980,-32.01434,
-45.68034,-32.72728,
-45.56435,-32.83707,
-45.45454,-32.92882,
-44.69250,-33.78342,
-43.94118,-34.54546,
-43.80313,-34.71222,
-43.63637,-34.89336,
-43.03394,-35.76122,
-42.57643,-36.36365,
-42.28464,-36.83009,
-41.81819,-37.50246,
-41.58186,-37.94550,
-41.44330,-38.18182,
-41.10013,-38.89989,
-40.98033,-39.16214,
-40.54613,-40.00000,
-40.39021,-40.39021,
-40.00000,-41.22289,
-39.83972,-41.65790,
-39.77025,-41.81819,
-39.64870,-42.16949,
-39.38521,-43.02156,
-39.14709,-43.63637,
-38.92711,-44.38165,
-38.72272,-44.91365,
-38.53951,-45.45454,
-38.47041,-45.74313,
-38.18182,-46.58488,
-38.03000,-47.12091,
-37.96985,-47.27274,
-37.87512,-47.57944,
-37.64163,-48.55072,
-37.43814,-49.09091,
-37.20839,-49.93565,
-37.11211,-50.16064
};

static torsion rcontour2c[] = {
-115.5384,0.,
-115.9422,0.4214478,
-116.3636,0.8065491,
-116.8681,1.313721,
-117.4377,1.818176,
-117.8299,2.170105,
-118.1818,2.444962,
-118.8205,2.997635,
-119.6605,3.636353,
-119.8527,3.783707,
-120.0000,3.882034,
-120.8982,4.556290,
-120.9625,4.598846,
-121.8182,5.179352,
-121.9750,5.297699,
-122.2063,5.454544,
-123.0564,6.034531,
-123.6364,6.388275,
-124.1614,6.747650,
-125.0105,7.272720,
-125.2836,7.443634,
-125.4545,7.539825,
-126.1867,8.004883,
-126.4014,8.144058,
-127.2727,8.659332,
-127.5331,8.830521,
-127.9643,9.090897,
-128.6621,9.519730,
-129.0909,9.761047,
-129.7971,10.20290,
-130.7537,10.75372,
-130.9091,10.84515,
-130.9479,10.87022,
-131.0129,10.90909,
-132.0755,11.56082,
-132.7273,11.93015,
-133.2195,12.23506,
-134.0782,12.72726,
-134.3714,12.90131,
-134.5455,12.99667,
-135.2109,13.39265,
-135.5142,13.57674,
-136.3636,14.05386,
-136.6703,14.23883,
-137.2204,14.54544,
-137.8277,14.89960,
-138.1818,15.09004,
-138.9918,15.55365,
-139.4098,15.77342,
-140.0000,16.09178,
-140.1732,16.19040,
-140.5047,16.36363,
-141.3498,16.83197,
-141.8182,17.06995,
-142.5428,17.45724,
-143.2636,17.80901,
-143.6364,17.99655,
-143.7575,18.06065,
-144.0080,18.18181,
-144.9583,18.67802,
-145.4545,18.91495,
-146.1763,19.27821,
-146.8690,19.59624,
-147.2727,19.78786,
-147.4141,19.85863,
-147.7226,20.00000,
-148.6319,20.45897,
-149.0909,20.67136,
-149.8601,21.04897,
-150.3687,21.27774,
-150.9091,21.52882,
-151.1028,21.62444,
-151.5294,21.81818,
-152.3261,22.21938,
-152.7273,22.40561,
-153.5496,22.81403,
-153.8699,22.96082,
-154.5455,23.27957,
-154.7825,23.39932,
-155.2884,23.63635,
-155.9958,24.00421,
-156.3636,24.18169,
-157.2007,24.61743,
-157.4796,24.75235,
-158.1818,25.10060,
-158.4124,25.22397,
-158.8737,25.45454,
-159.5983,25.85628,
-160.0000,26.06418,
-160.7737,26.49899,
-161.3443,26.79881,
-161.8182,27.05298,
-161.9571,27.13379,
-162.2113,27.27272,
-163.0991,27.80997,
-163.6364,28.11478,
-164.2395,28.48779,
-165.2779,29.09090,
-165.3854,29.16010,
-165.4545,29.20183,
-165.7808,29.41716,
-166.4795,29.88412,
-167.2727,30.38257,
-167.5850,30.59679,
-168.0687,30.90909,
-168.6654,31.33463,
-169.0909,31.61963,
-169.7302,32.08800,
-170.6587,32.72726,
-170.8008,32.83554,
-170.9091,32.91289,
-171.7627,33.58089,
-171.8247,33.62979,
-172.7273,34.29886,
-172.8635,34.40916,
-173.0425,34.54544,
-173.8584,35.23253,
-174.5455,35.77621,
-174.8605,36.04857,
-175.2484,36.36363,
-175.8338,36.89351,
-176.3636,37.34451,
-176.7975,37.74792,
-177.2937,38.18181,
-177.7407,38.62292,
-178.1818,39.03348,
-178.6611,39.52066,
-179.1611,39.99998,
-179.5601,40.43994,
-180.0000,40.89990,



-80.69077,40.69075,
-80.89693,39.99998,
-81.08976,39.27156,
-81.21564,38.78435,
-81.37355,38.18181,
-81.45620,37.81981,
-81.76650,36.41531,
-81.77816,36.36363,
-81.78465,36.33009,
-81.81818,36.14967,
-82.13252,34.85977,
-82.20613,34.54544,
-82.30042,34.06322,
-82.44320,33.35228,
-82.56380,32.72726,
-82.70357,31.84189,
-82.71018,31.80107,
-82.84962,30.90909,
-82.93676,30.20949,
-82.99482,29.73245,
-83.07432,29.09090,
-83.12321,28.57774,
-83.20703,27.70206,
-83.24797,27.27272,
-83.27326,26.90962,
-83.36044,25.73045,
-83.37982,25.45454,
-83.39141,25.20958,
-83.47029,23.80244,
-83.47828,23.63635,
-83.48257,23.48256,
-83.54854,21.90601,
-83.55105,21.81818,
-83.55199,21.73380,
-83.60506,20.03128,
-83.60542,20.00000,
-83.60530,19.96893,
-83.63637,18.64197,
-83.65058,18.19603,
-83.65143,18.18181,
-83.65227,18.16591,
-83.68951,16.41678,
-83.69253,16.36363,
-83.69537,16.30463,
-83.71104,14.62012,
-83.71497,14.54544,
-83.71841,14.46339,
-83.71030,12.80119,
-83.71373,12.72726,
-83.71642,12.64722,
-83.67850,10.95123,
-83.68009,10.90909,
-83.68105,10.86440,
-83.63637,9.864670,
-83.61096,9.116318,
-83.60800,9.090897,
-83.60365,9.058197,
-83.50868,7.400406,
-83.48848,7.272720,
-83.45698,7.093338,
-83.33587,5.755035,
-83.27095,5.454544,
-83.15889,4.977066,
-83.05271,4.220016,
-82.87716,3.636353,
-82.61965,2.834900,
-82.38709,2.387085,
-82.13986,1.818176,
-82.03886,1.597504,
-81.81818,1.295029,
-81.31012,0.5080719,
-80.75270,0.
};

static torsion rcontour2d[] = {
-180.0000,40.89990,
-180.0000,180.0000,
-56.58150,180.0000,
-56.49934,179.8643,
-56.36364,179.6690,
-55.80972,178.7357,
-55.43159,178.1818,
-55.09146,177.6358,
-54.54546,176.8704,
-54.35187,176.5572,
-54.21513,176.3636,
-53.63184,175.4590,
-53.60693,175.4251,
-52.97479,174.5454,
-52.87704,174.3957,
-52.72728,174.1951,
-52.15233,173.3022,
-51.73114,172.7273,
-51.40276,172.2336,
-50.90909,171.5790,
-50.64526,171.1729,
-50.45244,170.9091,
-49.90947,170.0905,
-49.38248,169.3824,
-49.16928,169.0909,
-49.13815,169.0437,
-49.09091,168.9801,
-48.43161,167.9320,
-47.96849,167.2727,
-47.69879,166.8466,
-47.27274,166.2427,
-46.97868,165.7486,
-46.78549,165.4545,
-46.29082,164.6183,
-46.01723,164.1990,
-45.65784,163.6364,
-45.58398,163.5069,
-45.45454,163.3022,
-44.94318,162.3295,
-44.64780,161.8182,
-44.30365,161.1509,
-43.67068,160.0343,
-43.65175,160.0000,
-43.64670,159.9897,
-43.63637,159.9705,
-43.08554,158.7326,
-42.81633,158.1818,
-42.51500,157.4850,
-42.12943,156.6748,
-41.98639,156.3636,
-41.93817,156.2436,
-41.81819,155.9745,
-41.43410,154.9295,
-41.27803,154.5454,
-40.97867,153.7059,
-40.94351,153.6019,
-40.61308,152.7273,
-40.46202,152.2652,
-40.00000,151.0065,
-39.97720,150.9319,
-39.96938,150.9091,
-39.95630,150.8654,
-39.57904,149.5118,
-39.44539,149.0909,
-39.23714,148.3280,
-39.17860,148.0941,
-38.93985,147.2727,
-38.79070,146.6638,
-38.54939,145.8221,
-38.45311,145.4545,
-38.40514,145.2312,
-38.18182,144.3669,
-38.05060,143.7676,
-38.01622,143.6364,
-37.96921,143.4238,
-37.74461,142.2554,
-37.64052,141.8182,
-37.50896,141.1453,
-37.44270,140.7391,
-37.28603,140.0000,
-37.15306,139.2106,
-37.08557,138.9037,
-36.95279,138.1818,
-36.87910,137.6664,
-36.68460,136.6846,
-36.63408,136.3636,
-36.60501,136.1223,
-36.36365,134.7806,
-36.33240,134.5767,
-36.32567,134.5454,
-36.31689,134.4987,
-36.10338,132.9875,
-36.04872,132.7273,
-35.97653,132.3401,
-35.85229,131.4204,
-35.74411,130.9091,
-35.59521,130.1407,
-35.56134,129.8932,
-35.38228,129.0909,
-35.23534,128.4010,
-35.03912,127.7664,
-34.91586,127.2727,
-34.84181,126.9763,
-34.54546,126.1585,
-34.38397,125.6160,
-34.31693,125.4545,
-34.15247,125.0616,
-33.87715,124.3047,
-33.53935,123.6364,
-33.26088,123.1028,
-32.72728,122.3252,
-32.55014,121.9953,
-32.42693,121.8182,
-31.79758,120.9297,
-31.46619,120.5571,
-30.97803,120.0000,
-30.94576,119.9633,
-30.90910,119.9302,
-30.12491,118.9660,
-29.33096,118.1818,
-29.21739,118.0553,
-29.09091,117.9411,
-28.38748,117.0670,
-27.69501,116.3636,
-27.51317,116.1232,
-27.27274,115.8649,
-26.73811,115.0800,
-26.29184,114.5454,
-26.00447,113.9955,
-25.45454,113.1649,
-25.31010,112.8717,
-25.22017,112.7273,
-25.14293,112.4156,
-24.95932,111.4043,
-24.81284,110.9091,
-24.94344,110.3980,
-25.42639,109.1190,
-25.43513,109.0909,
-25.44534,109.0817,
-25.45454,109.0748,
-25.48831,109.0571,
-26.61803,108.4362,
-27.27274,108.1311,
-27.93387,107.9339,
-28.59587,107.7677,
-29.09091,107.6305,
-29.40091,107.5827,
-30.77737,107.4044,
-30.90910,107.3850,
-31.01488,107.3785,
-32.70808,107.2919,
-32.72728,107.2907,
-32.74521,107.2907,
-34.53883,107.2794,
-34.54546,107.2793,
-34.55215,107.2794,
-36.34134,107.2950,
-36.36365,107.2954,
-36.38655,107.2956,
-38.16965,107.2849,
-38.18182,107.2850,
-38.19376,107.2846,
-38.41759,107.2727,
-39.94341,107.2161,
-40.00000,107.2124,
-40.06868,107.2040,
-41.60706,107.0616,
-41.81819,107.0342,
-42.11157,106.9793,
-43.17722,106.8136,
-43.63637,106.7208,
-44.37897,106.5301,
-44.65117,106.4694,
-45.45454,106.2436,
-46.04666,106.0467,
-47.10657,105.6207,
-47.27274,105.5594,
-47.34666,105.5285,
-47.49391,105.4545,
-48.64520,105.0089,
-49.09091,104.7928,
-49.85184,104.3973,
-50.66312,103.8823,
-50.90909,103.7336,
-50.96855,103.6958,
-51.04504,103.6364,
-52.07777,102.9868,
-52.72728,102.4684,
-53.08676,102.1776,
-53.44304,101.8182,
-54.04214,101.3148,
-54.54546,100.7687,
-54.91759,100.3721,
-55.19157,100.0000,
-55.73428,99.37064,
-56.36364,98.40469,
-56.45428,98.27243,
-56.50161,98.18179,
-56.71815,97.82727,
-57.15501,97.15500,
-57.55037,96.36362,
-57.78469,95.96652,
-58.18182,95.07523,
-58.35635,94.71997,
-58.42130,94.54544,
-58.62649,94.10077,
-58.93764,93.48309,
-59.23562,92.72726,
-59.48657,92.21384,
-59.97999,90.92908,
-59.98849,90.90909,
-59.99245,90.90152,
-60.00001,90.88382,
-60.59217,89.68307,
-60.83199,89.09091,
-61.16940,88.44214,
-61.56775,87.52316,
-61.68395,87.27271,
-61.73341,87.18793,
-61.81818,87.01898,
-62.39500,86.03134,
-62.68391,85.45453,
-63.05601,84.87418,
-63.63637,83.83035,
-63.71264,83.71262,
-63.75515,83.63635,
-64.05475,83.21799,
-64.46956,82.65137,
-65.00250,81.81818,
-65.20324,81.56686,
-65.45455,81.20804,
-65.99071,80.53616,
-66.36018,80.00000,
-66.77896,79.50623,
-67.27273,78.83075,
-67.56586,78.47495,
-67.77047,78.18182,
-68.36613,77.45703,
-69.09091,76.41013,
-69.11118,76.38391,
-69.12416,76.36362,
-69.21196,76.24258,
-69.88534,75.33987,
-70.38102,74.54544,
-70.59509,74.23145,
-70.90910,73.67728,
-71.27326,73.09142,
-71.45843,72.72726,
-71.90601,71.90601,
-72.04498,71.59137,
-72.37022,70.90909,
-72.48904,70.67085,
-72.72728,70.09024,
-73.03792,69.40154,
-73.15144,69.09090,
-73.41171,68.40645,
-73.54327,68.08870,
-73.82153,67.27272,
-74.00861,66.73589,
-74.30621,65.69380,
-74.38215,65.45454,
-74.42164,65.33072,
-74.54546,64.86722,
-74.82849,63.91939,
-74.89863,63.63635,
-75.01880,63.16299,
-75.20869,62.48140,
-75.36628,61.81818,
-75.55966,61.01421,
-75.61510,60.74854,
-75.78613,59.99998,
-75.89372,59.53008,
-76.12193,58.42351,
-76.17526,58.18181,
-76.20923,58.02739,
-76.36364,57.27319,
-76.53802,56.53799,
-76.57661,56.36363,
-76.64008,56.08719,
-76.88152,55.06332,
-76.99852,54.54544,
-77.18968,53.71939,
-77.22124,53.58487,
-77.41806,52.72726,
-77.56208,52.10753,
-77.73586,51.35504,
-77.83925,50.90909,
-77.90379,50.63106,
-78.18182,49.44011,
-78.25911,49.16820,
-78.28104,49.09090,
-78.32041,48.95232,
-78.66069,47.75160,
-78.79700,47.27272,
-79.03651,46.41801,
-79.06025,46.33298,
-79.30723,45.45454,
-79.45529,44.90982,
-79.73009,43.90625,
-79.80370,43.63635,
-79.84402,43.48036,
-80.00000,42.87894,
-80.26386,42.08205,
-80.35045,41.81818,
-80.50101,41.31715,
-80.69077,40.49075
};

static torsion rcontour3[] = {
180.0000,40.89990,
179.2591,41.07727,
178.8510,41.14896,
178.1818,41.29349,
177.8655,41.50189,
177.3324,41.81818,
176.7624,42.21692,
176.3636,42.47145,
175.8076,43.08038,
175.2695,43.63635,
174.9463,44.03719,
174.5454,44.50916,
174.1898,45.09885,
173.9667,45.45454,
173.5463,46.27361,
173.3414,46.65862,
173.0181,47.27272,
172.9318,47.47725,
172.7273,47.94499,
172.4354,48.79903,
172.3324,49.09090,
172.1808,49.63731,
172.0258,50.20760,
171.8283,50.90909,
171.6656,51.66562,
171.5779,52.05841,
171.4321,52.72726,
171.3596,53.17773,
171.1741,54.28041,
171.1309,54.54544,
171.1078,54.74417,
170.9099,56.36279,
170.9098,56.36363,
170.9097,56.36429,
170.9091,56.37212,
170.7880,58.06071,
170.7786,58.18181,
170.7711,58.31978,
170.6976,59.78850,
170.6860,59.99998,
170.6768,60.23228,
170.6300,61.53914,
170.6189,61.81818,
170.6108,62.11641,
170.5829,63.31012,
170.5740,63.63635,
170.5690,63.97646,
170.5558,65.10123,
170.5505,65.45454,
170.5493,65.81435,
170.5484,66.91208,
170.5472,67.27272,
170.5498,67.63199,
170.5604,68.74220,
170.5629,69.09090,
170.5687,69.43126,
170.5908,70.59076,
170.5962,70.90909,
170.6042,71.21397,
170.6386,72.45682,
170.6457,72.72726,
170.6544,72.98189,
170.7028,74.33917,
170.7099,74.54544,
170.7178,74.73668,
170.7819,76.23639,
170.7871,76.36362,
170.7927,76.47998,
170.8743,78.14700,
170.8759,78.18182,
170.8776,78.21329,
170.9091,78.79330,
170.9832,79.92590,
170.9881,80.00000,
170.9942,80.08514,
171.1032,81.62405,
171.1172,81.81818,
171.1342,82.04324,
171.2294,83.31601,
171.2537,83.63635,
171.2829,84.01013,
171.3598,85.00381,
171.3950,85.45453,
171.4367,85.98215,
171.4922,86.68954,
171.5384,87.27271,
171.5920,87.95566,
171.6248,88.37518,
171.6811,89.09091,
171.7451,89.92694,
171.7555,90.06268,
171.8204,90.90909,
171.8822,91.75412,
171.8924,91.89240,
171.9535,92.72726,
172.0031,93.45148,
172.0302,93.84842,
172.0779,94.54544,
172.1158,95.15689,
172.1552,95.79163,
172.1907,96.36362,
172.2184,96.87253,
172.2643,97.71884,
172.2894,98.18179,
172.3083,98.60080,
172.3544,99.62717,
172.3712,100.0000,
172.3831,100.3441,
172.4234,101.5143,
172.4339,101.8182,
172.4406,102.1048,
172.4703,103.3794,
172.4763,103.6364,
172.4792,103.8843,
172.4949,105.2222,
172.4976,105.4545,
172.4976,105.6842,
172.4971,107.0426,
172.4971,107.2727,
172.4941,107.5058,
172.4770,108.8406,
172.4738,109.0909,
172.4673,109.3509,
172.4347,110.6165,
172.4272,110.9091,
172.4151,111.2212,
172.3702,112.3702,
172.3564,112.7273,
172.3358,113.1187,
172.2839,114.1021,
172.2607,114.5454,
172.2274,115.0453,
172.1760,115.8123,
172.1393,116.3636,
172.0873,117.0035,
172.0467,117.5013,
171.9915,118.1818,
171.9132,118.9958,
171.8965,119.1692,
171.8167,120.0000,
171.7258,120.8167,
171.7028,121.0245,
171.6145,121.8182,
171.5357,122.4448,
171.4549,123.0905,
171.3864,123.6364,
171.3281,124.0554,
171.1706,125.1930,
171.1343,125.4545,
171.1047,125.6501,
170.9091,126.9471,
170.8728,127.2365,
170.8683,127.2727,
170.8620,127.3198,
170.6573,128.8391,
170.6235,129.0909,
170.5759,129.4241,
170.4314,130.4314,
170.3632,130.9091,
170.2664,131.5518,
170.1964,132.0146,
170.0891,132.7273,
169.9531,133.5895,
169.9356,133.7007,
169.8026,134.5454,
169.7023,135.1569,
169.5862,135.8684,
169.5050,136.3636,
169.4451,136.7178,
169.2199,138.0528,
169.1981,138.1818,
169.1822,138.2731,
169.0909,138.8001,
168.9337,139.8428,
168.9101,140.0000,
168.8773,140.2135,
168.6919,141.4191,
168.6307,141.8182,
168.5463,142.3628,
168.4483,142.9937,
168.3488,143.6364,
168.2130,144.5143,
168.2046,144.5682,
168.0676,145.4545,
167.9623,146.1441,
167.8835,146.6619,
167.7903,147.2727,
167.7233,147.7233,
167.5634,148.8002,
167.5201,149.0909,
167.4891,149.3073,
167.2727,150.8212,
167.2627,150.8991,
167.2614,150.9091,
167.2599,150.9219,
167.0652,152.5198,
167.0401,152.7273,
167.0103,152.9897,
166.8782,154.1509,
166.8335,154.5454,
166.7826,155.0356,
166.7036,155.7945,
166.6446,156.3636,
166.5804,157.0559,
166.5436,157.4527,
166.4760,158.1818,
166.4068,159.0477,
166.4004,159.1277,
166.3307,160.0000,
166.2767,160.8222,
166.2645,161.0082,
166.2113,161.8182,
166.1754,162.5391,
166.1557,162.9352,
166.1207,163.6364,
166.0998,164.2816,
166.0821,164.8270,
166.0617,165.4545,
166.0536,166.0536,
166.0450,166.6822,
166.0371,167.2727,
166.0412,167.8594,
166.0456,168.4998,
166.0497,169.0909,
166.0676,169.7039,
166.0842,170.2794,
166.1025,170.9091,
166.1386,171.5932,
166.1611,172.0207,
166.1985,172.7273,
166.2615,173.5342,
166.2763,173.7237,
166.3405,174.5454,
166.4292,175.3889,
166.4447,175.5356,
166.5319,176.3636,
166.6193,177.0171,
166.6987,177.6078,
166.7756,178.1818,
166.8456,178.6089,
167.0361,179.7634,
167.0750,180.0000,
180.0000,180.0000
};

static torsion rcontour4[] = {
180.0000,-62.90639,
179.4818,-63.11823,
178.2743,-63.54390,
178.1818,-63.57879,
178.0977,-63.55224,
176.8615,-63.13847,
176.3636,-62.98985,
175.7479,-62.43389,
175.0385,-61.81818,
174.7828,-61.58083,
174.5454,-61.37239,
173.9881,-60.55731,
173.5971,-60.00001,
173.2526,-59.47463,
172.7273,-58.69993,
172.5571,-58.35201,
172.4729,-58.18182,
172.2627,-57.71725,
171.9867,-57.10418,
171.6487,-56.36364,
171.4369,-55.83584,
170.9098,-54.54621,
170.9095,-54.54546,
170.9094,-54.54513,
170.9091,-54.54415,
170.5272,-53.10914,
170.4260,-52.72728,
170.3026,-52.12077,
170.2003,-51.61789,
170.0560,-50.90909,
169.9432,-50.05679,
169.9256,-49.92566,
169.8148,-49.09091,
169.7793,-48.40254,
169.7536,-47.93542,
169.7191,-47.27274,
169.7448,-46.61885,
169.7617,-46.12532,
169.7883,-45.45454,
169.9034,-44.64209,
169.9263,-44.47182,
170.0465,-43.63637,
170.2231,-42.95038,
170.3889,-42.33836,
170.5257,-41.81819,
170.6331,-41.54222,
170.9091,-40.86781,
171.2298,-40.32069,
171.4281,-40.00000,
172.0144,-39.28717,
172.7273,-38.46292,
172.9058,-38.36040,
173.2362,-38.18182,
174.1437,-37.78006,
174.5454,-37.61174,
175.0736,-37.65364,
175.8925,-37.71071,
176.3636,-37.74742,
176.6324,-37.91306,
177.0693,-38.18182,
177.7117,-38.65195,
178.1818,-38.98863,
178.5988,-39.58296,
178.8928,-40.00000,
179.2999,-40.70010,
179.9302,-41.74838,
179.9718,-41.81819,
179.9809,-41.83731,
180.0000,-41.87498
};

static torsion rcontour5[] = {
167.0750,-180.0000,
167.1125,-179.8397,
167.2727,-179.1621,
167.4785,-178.3876,
167.5337,-178.1818,
167.6502,-177.8043,
167.9001,-176.9910,
168.0945,-176.3636,
168.3510,-175.6237,
168.5327,-175.1037,
168.7270,-174.5455,
168.8273,-174.2819,
169.0909,-173.5949,
169.3589,-172.9953,
169.4797,-172.7273,
169.8443,-171.9738,
169.9457,-171.7639,
170.3614,-170.9091,
170.5476,-170.5476,
170.9091,-169.8511,
171.2052,-169.3870,
171.3956,-169.0909,
171.9312,-168.2948,
172.4057,-167.5943,
172.6233,-167.2727,
172.6661,-167.2116,
172.7273,-167.1249,
173.5413,-166.2686,
174.3210,-165.4545,
174.4322,-165.3413,
174.5454,-165.2269,
175.1476,-164.8524,
175.5258,-164.6167,
176.3636,-164.0993,
176.7502,-164.0229,
178.0456,-163.7725,
178.1818,-163.7458,
178.3289,-163.7835,
179.5401,-164.0962,
180.0000,-164.2132,
180.0000,-180.0000
};

static torsion rcontour6[] = {
25.45454,69.29698,
26.15288,70.21075,
26.71045,70.90909,
27.03404,71.14775,
27.27272,71.32526,
27.87082,71.50717,
28.34850,71.65149,
29.09090,71.87865,
29.97588,71.84232,
30.02234,71.84050,
30.90909,71.80386,
31.60014,71.60014,
32.22270,71.41365,
32.72726,71.26381,
32.97090,71.15273,
33.49690,70.90909,
34.15234,70.51596,
34.54544,70.29776,
35.28110,69.82657,
36.15216,69.30235,
36.36363,69.17316,
36.41571,69.14301,
36.50999,69.09090,
37.52176,68.43086,
38.18181,68.05869,
38.73213,67.82303,
39.87943,67.39330,
39.99998,67.34541,
40.06116,67.33386,
40.43071,67.27272,
41.61298,67.06750,
41.81818,67.04192,
42.04364,67.04726,
43.41602,67.05238,
43.63635,67.05740,
43.82756,67.08151,
45.35817,67.27272,
45.44370,67.28357,
45.45454,67.28506,
45.47054,67.28870,
46.94283,67.60262,
47.27272,67.68108,
47.84474,67.84473,
48.37784,67.98578,
49.09090,68.20250,
49.77156,68.41025,
50.48251,68.66435,
50.90909,68.80537,
51.13257,68.86740,
51.78827,69.09090,
52.48349,69.33469,
52.72726,69.43602,
53.21974,69.58337,
53.87968,69.75665,
54.54544,69.97777,
55.37012,70.08441,
55.57980,70.12526,
56.36363,70.23909,
57.16597,70.10675,
57.35783,70.08511,
58.18181,69.93111,
58.69670,69.60579,
59.39464,69.09090,
59.73679,68.82770,
59.99998,68.58575,
60.51979,67.79251,
60.82141,67.27272,
61.16940,66.62395,
61.61571,65.65701,
61.71422,65.45454,
61.74620,65.38257,
61.81818,65.18918,
62.16377,63.98195,
62.24966,63.63635,
62.36360,63.09093,
62.50137,62.50137,
62.63547,61.81818,
62.77094,60.95274,
62.78273,60.85362,
62.90796,59.99998,
62.97906,59.34270,
63.01773,58.80043,
63.08035,58.18181,
63.11555,57.66101,
63.14169,56.85829,
63.17299,56.36363,
63.18855,55.91582,
63.19106,54.99075,
63.20561,54.54544,
63.20938,54.11848,
63.19072,53.17290,
63.19443,52.72726,
63.18930,52.28023,
63.15712,51.38834,
63.15187,50.90909,
63.13837,50.41107,
63.10107,49.62616,
63.08714,49.09090,
63.06476,48.51930,
63.02969,47.87938,
63.00670,47.27272,
62.97482,46.61118,
62.94736,46.14355,
62.91487,45.45454,
62.87300,44.69119,
62.85655,44.41615,
62.81424,43.63635,
62.76219,42.76219,
62.75833,42.69618,
62.70593,41.81818,
62.65358,40.98279,
62.64209,40.82393,
62.58952,39.99998,
62.54155,39.27660,
62.50690,38.87054,
62.45956,38.18181,
62.41290,37.58707,
62.33661,36.88208,
62.29364,36.36363,
62.24930,35.93250,
62.08664,34.81393,
62.05682,34.54544,
62.02699,34.33664,
61.81818,33.30414,
61.71555,32.82990,
61.68301,32.72726,
61.59543,32.50452,
61.25624,31.47102,
60.98235,30.90909,
60.61565,30.29343,
59.99998,29.56630,
59.74522,29.34567,
59.24371,29.09090,
58.50308,28.76964,
58.18181,28.70076,
57.82014,28.72923,
56.81168,28.64287,
56.36363,28.66879,
56.04242,28.76970,
54.66489,28.97147,
54.54544,29.00050,
54.48405,29.02953,
54.28943,29.09090,
53.13673,29.50037,
52.72726,29.59050,
51.81938,30.00121,
51.81584,30.00232,
50.90909,30.34299,
50.55492,30.55492,
49.80896,30.90909,
49.34195,31.16013,
49.09090,31.26645,
48.21825,31.85461,
48.05180,31.94818,
47.27272,32.40747,
47.09877,32.55331,
46.86282,32.72726,
46.09862,33.37135,
45.45454,33.84837,
45.11221,34.20313,
44.74715,34.54544,
44.21599,35.12508,
43.63635,35.69545,
43.35097,36.07823,
43.11989,36.36363,
42.59146,37.13692,
41.81818,38.16956,
41.81375,38.17738,
41.81105,38.18181,
41.80360,38.19638,
41.21265,39.39447,
40.88223,39.99998,
40.61479,40.61479,
40.04214,41.77602,
40.02226,41.81818,
40.01637,41.83455,
39.99998,41.87312,
39.56566,43.20203,
39.39740,43.63635,
39.12904,44.50729,
39.11275,44.56729,
38.80910,45.45454,
38.67900,45.95172,
38.25410,47.20042,
38.23268,47.27272,
38.22371,47.31462,
38.18181,47.45297,
37.85498,48.76407,
37.74185,49.09090,
37.57307,49.69965,
37.46661,50.19389,
37.23117,50.90909,
37.05608,51.60153,
36.78923,52.30167,
36.65706,52.72726,
36.60344,52.96707,
36.36363,53.60640,
36.13403,54.31587,
36.01796,54.54544,
35.78595,55.12314,
35.62807,55.62807,
35.22940,56.36363,
35.03313,56.85130,
34.54544,57.58197,
34.32523,57.96158,
34.12280,58.18181,
33.55269,59.00725,
32.72726,59.77286,
32.61871,59.89143,
32.46736,59.99998,
31.68954,60.78047,
30.90909,61.29721,
30.62601,61.53511,
30.13521,61.81818,
29.57649,62.30376,
29.09090,62.59476,
28.52858,63.07402,
27.64061,63.63635,
27.46483,63.82848,
27.27272,63.98578,
26.62263,64.80446,
25.99210,65.45454,
25.84044,65.84044,
25.45454,66.62660,
25.29755,67.11572,
25.23988,67.27272,
25.25021,67.47705,
25.35721,68.99358,
25.36232,69.09090,
25.39056,69.15488,
25.45454,69.29698
};

static torsion rcontour7[] = {
63.63635,170.3314,
64.10123,170.4442,
64.81389,170.2684,
65.45454,170.3361,
65.81450,169.4509,
65.99817,169.0909,
66.30908,168.2364,
66.33495,168.1531,
66.71344,167.2727,
66.82997,166.8300,
67.27272,165.7047,
67.30623,165.4880,
67.31216,165.4545,
67.31697,165.4103,
67.45885,163.8225,
67.47984,163.6364,
67.48912,163.4200,
67.51755,162.0630,
67.52853,161.8182,
67.52202,161.5689,
67.45058,160.1779,
67.44569,160.0000,
67.43005,159.8427,
67.27272,158.6180,
67.00064,158.4539,
65.47731,158.2046,
65.45454,158.1967,
65.11330,159.6588,
64.99815,160.0000,
64.83902,160.6155,
64.74617,161.1098,
64.52448,161.8182,
64.36972,162.5515,
64.17485,163.0979,
64.03014,163.6364,
63.98466,163.9847,
63.63635,165.1039,
63.60275,165.4209,
63.59602,165.4545,
63.58961,165.5013,
63.49678,167.1331,
63.47365,167.2727,
63.45880,167.4503,
63.48918,168.9437,
63.47372,169.0909,
63.47464,169.2526,
63.63635,170.3314};
 
#define contoursize(i) sizeof(i)/sizeof(torsion)

#endif
