/* ****************************************************************
 *                            clr.h
 * ****************************************************************
 * include file for the geometric utilities
 */
#ifndef CLR_H
#define CLR_H

#ifndef TRUE
#define TRUE    1
#endif TRUE
#ifndef FALSE
#define FALSE   0
#endif FALSE

#define CLR_SAMPLE_MEYER        0
#define CLR_SAMPLE_HALL         1
#define CLR_SAMPLE_LIN_RAMP     2

/* common geometric constructs
 */
typedef struct {double  r, g, b;}       CLR_RGB;
typedef struct {double  x, y, z;}       CLR_XYZ;
typedef struct {double  l, a, b;}       CLR_LAB;
typedef struct {double  l, u, v;}       CLR_LUV;

/* color routine declarations
 */
int         CLR_init();
int         CLR_read_mtl();
int         CLR_add_spect();
int         CLR_mult_spect();
int         CLR_scale_spect();
double      CLR_area_spect();
CLR_XYZ     CLR_spect_to_xyz();
int         CLR_xyz_to_spect();
CLR_RGB     CLR_spect_to_rgb();
int         CLR_get_rgb();
int         CLR_get_min_wl();
int         CLR_get_max_wl();
int         CLR_get_xyz_rgb();
int         CLR_get_rgb_xyz();
int         CLR_get_yiq_rgb();
int         CLR_get_rgb_yiq();
int         CLR_rgb_to_aux_rgb();
CLR_LAB     CLR_xyz_to_lab();
CLR_LUV     CLR_xyz_to_luv();
int         CLR_t_concat();
int         CLR_t_inverse();

CLR_RGB     CLR_clamp_rgb();
CLR_RGB     CLR_scale_rgb();
CLR_RGB     CLR_clip_rgb();

int         CLR_init_samples();
int         CLR_num_samples();
int         CLR_spect_to_sample();
int         CLR_get_sample_rgb();
int         CLR_get_sample_xyz();
int         CLR_reconstruct();
int         CLR_exit_samples();

#endif CLR_H
/* ************************************************************* */
