 /*
  * Khoros: $Id$
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */


/*
 *   Copyright, 1991, The Regents of the University of California.
 *   This software was produced under a U.S. Government contract
 *   (W-7405-ENG-36) by the Los Alamos National Laboratory, which is
 *   operated by the University of California for the U.S. Department
 *   of Energy.  The U.S. Government is licensed to use, reproduce,
 *   and distribute this software.  Neither the Government nor the
 *   University makes any warranty, express or implied, or assumes
 *   any liability responsibility for the use of this software.
 */

#include <stdio.h>
/**  #include <malloc.h>  **/

/*
 *  contig_matrix()  Allocate a matrix with "num_rows" rows and "num_cols"
 *                   columns contiguously in memory.  This means that all
 *                   data in the matrix will be accessible also as a 1-D
 *                   array of length "num_rows" * "num_cols".
 *
 * The returned matrix is indexed as:  
 *
 *         returned [ 0 .. num_rows-1 ] [ 0 .. num_cols-1 ]
 *    OR
 *         returned [ 0 .. (num_rows * num_cols) - 1 ]
 *
 *  Written by:  Patrick M. Kelly
 *               Los Alamos National Laboratory
 *
 *  LAST MODIFICATION
 *       11/28/90   Patrick M. Kelly    Added error checks.
 */

float **contig_matrix ( num_rows, num_cols )

int num_rows, num_cols ;		/* Size of matrix to allocate */
{
	float *temp1d, **temp2d;
	int j;

	/*
	 *  (1)  Get contiguous memory for all values in matrix.
	 */
	temp1d = (float *) malloc ( (unsigned) 
			( num_rows * num_cols * sizeof (float) ) ) ;

	if ( temp1d == NULL ) {
		(void) fprintf ( stderr, "ERROR: contig_matrix()\n" );
		(void) fprintf ( stderr, "       MEMORY ALLOCATION FAILURE\n" );
		exit (-1);
	}

	/*
	 *  (2)  Get memory for row indices -- to point into temp1d.
	 */
	temp2d = (float **) malloc ( (unsigned)
			( num_rows * sizeof (float *) ) ) ;

	if ( temp2d == NULL ) {
		(void) fprintf ( stderr, "ERROR: contig_matrix()\n" );
		(void) fprintf ( stderr, "       MEMORY ALLOCATION FAILURE\n" );
		exit (-1);
	}
	
	/*
	 *  (3)  Set up the row pointers into temp1d.
	 */
	for ( j = 0 ; j < num_rows ; j ++ ) {
		temp2d [j] = & ( temp1d [j * num_cols] ) ;
	}

	return ( temp2d ) ;
}
