/* 
 *	FIG : Facility for Interactive Generation of figures
 *
 *	Copyright (c) 1985 by Supoj Sutanthavibul (supoj@sally.UTEXAS.EDU)
 *	January 1985.
 *	1st revision : Aug 1985.
 *
 *	%W%	%G%
*/
#include <pixrect/pixrect_hs.h>
#include <sunwindow/window_hs.h>
#include <suntool/tool_struct.h>
#include <suntool/icon.h>
#include <suntool/window.h>
#include <suntool/frame.h>
#include <suntool/canvas.h>
#include <stdio.h>
#include "const.h"
#include "font.h"
#include "paintop.h"

extern	double		ceil();

#define			INCH_MARK		12
#define			HALF_MARK		11
#define			QUARTER_MARK		8
#define			SIXTEENTH_MARK		6

#define			MARK_HT			5
#define			TRM_WID			15
#define			TRM_HT			8
#define			SRM_WID			8
#define			SRM_HT			15

extern Frame		base_frame;
extern Canvas		panel_frame;
extern Canvas		sideruler_frame;
extern Canvas		topruler_frame;
extern struct pixwin	*sideruler_pixwin;
extern struct pixwin	*topruler_pixwin;
extern struct cursor	bull_cursor;
extern int		srswfd;
extern int		trswfd;
extern int		SIDERULER_WIDTH, SIDERULER_HEIGHT;
extern int		TOPRULER_WIDTH, TOPRULER_HEIGHT;
extern int		SIDERULER_HEIGHT, SIDERULER_START;
extern			null_proc();
extern int		RHS_PANL;
extern int		DEBUG;
extern int		zoom_factor;

static			lasty = -100;
static			lastx = -100;
static int	 	start;
static int		troffx = -7, troffy = -10;
static short		tr_marker_image[8] = {
				0xFFFE,	/* *************** */
				0x7FFC,	/*  *************  */
				0x3FF8,	/*   ***********   */
				0x1FF0,	/*    *********    */
				0x0FE0,	/*     *******     */
				0x07C0,	/*      *****      */
				0x0380,	/*       ***       */
				0x0100	/*        *        */
				};
static			mpr_static(trm_pr, TRM_WID, TRM_HT, 1, tr_marker_image);
static int		srroffx = 2, srroffy = -7;
static short		srr_marker_image[15] = {
				0x0100,	/*          *  */
				0x0300,	/*         **  */
				0x0700,	/*        ***  */
				0x0F00,	/*       ****  */
				0x1F00,	/*      *****  */
				0x3F00,	/*     ******  */
				0x7F00,	/*    *******  */
				0xFF00, /*   ********  */
				0x7F00,	/*    *******  */
				0x3F00,	/*     ******  */
				0x1F00,	/*      *****  */
				0x0F00,	/*       ****  */
				0x0700,	/*        ***  */
				0x0300,	/*         **  */
				0x0100	/*          *  */
				};
static		mpr_static(srrm_pr, SRM_WID, SRM_HT, 1, srr_marker_image);

static int		srloffx = -10, srloffy = -7;
static short		srl_marker_image[15] = {
				0x8000,	/*  *          */
				0xC000,	/*  **         */
				0xE000,	/*  ***        */
				0xF000,	/*  ****       */
				0xF800,	/*  *****      */
				0xFC00,	/*  ******     */
				0xFE00,	/*  *******    */
				0xFF00,	/*  ********   */
				0xFE00,	/*  *******    */
				0xFC00,	/*  ******     */
				0xF800,	/*  *****      */
				0xF000,	/*  ****       */
				0xE000,	/*  ***        */
				0xC000,	/*  **         */
				0x8000	/*  *          */
				};
static		mpr_static(srlm_pr, SRM_WID, SRM_HT, 1, srl_marker_image);

set_toprulermark(x)
int	x;
{
	pw_write(topruler_pixwin, lastx + troffx, RULER_WIDTH + troffy, 
		TRM_WID, TRM_HT, INV_PAINT, &trm_pr, 0, 0);
	pw_write(topruler_pixwin, x + troffx, RULER_WIDTH + troffy, 
		TRM_WID, TRM_HT, INV_PAINT, &trm_pr, 0, 0);
	lastx = x;
	}

static
sideruler_eventproc(win, event)
Window win;
Event  *event;
{
	if (DEBUG)
	    printf("sideruler_eventproc: %s code = %d\n",
	      win_inputnegevent(event)? "neg": "pos", event_id(event));

	if (event->ie_code == WIN_RESIZE)
	    show_sideruler();
	}

int
make_sideruler_frame(rightof_frame)
Frame		rightof_frame;
{
	sideruler_frame = window_create(base_frame, CANVAS,
	    WIN_WIDTH,			SIDERULER_WIDTH,
	    WIN_HEIGHT,			SIDERULER_HEIGHT,
	    WIN_CURSOR,			&bull_cursor,
	    WIN_EVENT_PROC,		sideruler_eventproc,
	    WIN_CONSUME_KBD_EVENTS,	WIN_NO_EVENTS, 0,
	    WIN_CONSUME_PICK_EVENTS,	WIN_NO_EVENTS, 0,
	    CANVAS_FAST_MONO,		TRUE,
	    0);
	if (sideruler_frame == 0) exit(1);
	if (rightof_frame)
	    (void)window_set(sideruler_frame,
		WIN_RIGHT_OF, rightof_frame, WIN_Y, 0, 0);
	else
	    (void)window_set(sideruler_frame, WIN_X, 0, WIN_Y, 0, 0);

	srswfd = window_fd(sideruler_frame);
	sideruler_pixwin = canvas_pixwin(sideruler_frame);
	}

show_sideruler()
{
	int	ap0, i, p, qinch, sinch, charht, charx, end;
	char	buf[16];

	pw_writebackground(sideruler_pixwin, 0, 0, 2048, 2048, PIX_SRC);
	if (RHS_PANL){
	    start = RULER_WIDTH;
	    charx = RULER_WIDTH - INCH_MARK - bold_font->pf_defaultsize.x;
	    }
	else {
	    start = 0;
	    charx = INCH_MARK + 2;
	    }

	charht = bold_font->pf_defaultsize.y;
	ap0 = unzoomed_y(0);
	end = abs(start - INCH_MARK);
	i = (int) ceil((double)ap0 / (double)PIX_PER_INCH);
	p = zoomed_y(PIX_PER_INCH*i-1) + SIDERULER_START;
	while (p < CANVS_HEIGHT + SIDERULER_START) {
	    sprintf(buf, "%d", i);
	    pw_text(sideruler_pixwin, charx, p+charht/2-3, PAINT, bold_font, buf);
	    pw_vector(sideruler_pixwin, start, p, end, p, PIX_SRC, 1);
	    i++;
	    p = zoomed_y(PIX_PER_INCH*i-1)+SIDERULER_START;
	    }

	qinch = PIX_PER_INCH / 4;
	end = abs(start - QUARTER_MARK);
	i = (int) ceil((double)ap0 / (double)qinch);
	p = zoomed_y(qinch*i-1) + SIDERULER_START;
	while (p < CANVS_HEIGHT + SIDERULER_START) {
	    pw_vector(sideruler_pixwin, start, p, end, p, PIX_SRC, 1);
	    i++;
	    p = zoomed_y(qinch*i-1) + SIDERULER_START;
	    }

	sinch = PIX_PER_INCH / 16;
	end = abs(start - SIXTEENTH_MARK);
	i = (int) ceil((double)ap0 / (double)sinch);
	p = zoomed_y(sinch*i-1) + SIDERULER_START;
	while (p < CANVS_HEIGHT + SIDERULER_START) {
	    pw_vector(sideruler_pixwin, start, p, end, p, PIX_SRC, 1);
	    i++;
	    p = zoomed_y(sinch*i-1) + SIDERULER_START;
	    }

	end = abs(start - SIXTEENTH_MARK/2);
	p = CANVS_CENTER_Y + SIDERULER_START;
	pw_vector(sideruler_pixwin, start-2, p, end, p, INV_PAINT, 1);

	/*  Draw marker  */
	if (RHS_PANL) { /*  side ruler is on the LSH of canvas */
	    pw_write(sideruler_pixwin, RULER_WIDTH+srloffx, lasty+srloffy, 
			SRM_WID, SRM_HT, INV_PAINT, &srlm_pr, 0, 0);
	    }
	else { /*  side ruler is on the RSH of canvas */
	    pw_write(sideruler_pixwin, srroffx, lasty+srroffy, 
			SRM_WID, SRM_HT, INV_PAINT, &srrm_pr, 0, 0);
	    }
	}

static
topruler_eventproc(win, event)
Window win;
Event  *event;
{
	if (DEBUG)
	    printf("topruler_eventproc: %s code = %d\n",
	      win_inputnegevent(event)? "neg": "pos", event_id(event));

	if (event->ie_code == WIN_RESIZE)
		show_topruler();
	}

int
make_topruler_frame(rightof_frame)
Frame		rightof_frame;
{
	topruler_frame = window_create(base_frame, CANVAS,
	    WIN_RIGHT_OF,		rightof_frame,
	    WIN_Y,			0,
	    WIN_WIDTH,			TOPRULER_WIDTH,
	    WIN_HEIGHT,			TOPRULER_HEIGHT,
	    WIN_CURSOR,			&bull_cursor,
	    WIN_EVENT_PROC,		topruler_eventproc,
	    WIN_CONSUME_KBD_EVENTS,	WIN_NO_EVENTS, 0,
	    WIN_CONSUME_PICK_EVENTS,	WIN_NO_EVENTS, 0,
	    CANVAS_FAST_MONO,		TRUE,
	    0);
	if (topruler_frame == 0) exit(1);
	trswfd = window_fd(topruler_frame);
	topruler_pixwin = canvas_pixwin(topruler_frame);
	}

show_topruler()
{
	int	ap0, i, p, len, hinch, qinch, sinch, charwid;
	char	buf[16];

	pw_writebackground(topruler_pixwin, 0, 0, 2048, 2048, PIX_SRC);
	charwid = bold_font->pf_defaultsize.x;
	ap0 = unzoomed_x(0);

	len = RULER_WIDTH - INCH_MARK;
	i = (int) ceil((double)ap0 / (double)PIX_PER_INCH);
	p = zoomed_x(PIX_PER_INCH*i-1);
	while (p < CANVS_WIDTH) {
	    sprintf(buf, "%d", i);
	    pw_text(topruler_pixwin, p-charwid/2, len, PAINT, bold_font, buf);
	    pw_vector(topruler_pixwin, p, RULER_WIDTH, p, len, PIX_SRC, 1);
	    i++;
	    p = zoomed_x(PIX_PER_INCH*i-1);
	    }

	if (zoom_factor >= 4) {
	    hinch = PIX_PER_INCH / 2;
	    i = (int) ceil((double)ap0 / (double)hinch);
	    if (i % 2 == 0)
		i++;
	    p = zoomed_x(hinch*i-1);
	    while (p < CANVS_WIDTH) {
		sprintf(buf, "%3.1f", (double)i/2.0);
		pw_text(topruler_pixwin, p-3*charwid/2, len, PAINT, bold_font, buf);
		i += 2;
		p = zoomed_x(hinch*i-1);
		}
	    }

	qinch = PIX_PER_INCH / 4;
	len = RULER_WIDTH - QUARTER_MARK;
	i = (int) ceil((double)ap0 / (double)qinch);
	p = zoomed_x(qinch*i-1);
	while (p < CANVS_WIDTH) {
	    pw_vector(topruler_pixwin, p, RULER_WIDTH, p, len, PIX_SRC, 1);
	    i++;
	    p = zoomed_x(qinch*i-1);
	    }

	sinch = PIX_PER_INCH / 16;
	len = RULER_WIDTH - SIXTEENTH_MARK;
	i = (int) ceil((double)ap0 / (double)sinch);
	p = zoomed_x(sinch*i-1);
	while (p < CANVS_WIDTH) {
	    pw_vector(topruler_pixwin, p, RULER_WIDTH, p, len, PIX_SRC, 1);
	    i++;
	    p = zoomed_x(sinch*i-1);
	    }

	len = RULER_WIDTH - SIXTEENTH_MARK/2;
	p = CANVS_CENTER_X;
	pw_vector(topruler_pixwin, p, RULER_WIDTH, p, len, INV_PAINT, 1);

	/*  Draw marker  */
	pw_write(topruler_pixwin, lastx + troffx, RULER_WIDTH + troffy, 
		TRM_WID, TRM_HT, INV_PAINT, &trm_pr, 0, 0);
	}

set_rulermark(x, y)
int	x, y;
{
	set_siderulermark(y);
	set_toprulermark(x);
	}

set_siderulermark(y)
int	y;
{
	int	sy;

	sy = SIDERULER_START + y;
	if (RHS_PANL) { /*  side ruler is on the LSH of canvas */
	    pw_write(sideruler_pixwin, RULER_WIDTH+srloffx, lasty+srloffy, 
			SRM_WID, SRM_HT, INV_PAINT, &srlm_pr, 0, 0);
	    pw_write(sideruler_pixwin, RULER_WIDTH+srloffx, sy+srloffy, 
			SRM_WID, SRM_HT, INV_PAINT, &srlm_pr, 0, 0);
	    }
	else { /*  side ruler is on the RSH of canvas */
	    pw_write(sideruler_pixwin, srroffx, lasty+srroffy, 
			SRM_WID, SRM_HT, INV_PAINT, &srrm_pr, 0, 0);
	    pw_write(sideruler_pixwin, srroffx, sy+srroffy, 
			SRM_WID, SRM_HT, INV_PAINT, &srrm_pr, 0, 0);
	    }
	lasty = sy;
	}
