/*
 * Decompiled with CFR 0.152.
 */
package gnu.prolog.vm;

import gnu.prolog.term.AtomTerm;
import gnu.prolog.term.CompoundTerm;
import gnu.prolog.term.CompoundTermTag;
import gnu.prolog.term.Term;
import gnu.prolog.vm.ExecuteOnlyCode;
import gnu.prolog.vm.Interpreter;
import gnu.prolog.vm.PrologException;
import gnu.prolog.vm.TermConstants;

public class UndefinedPredicateCode
extends ExecuteOnlyCode {
    protected CompoundTerm predicateIndicator;
    protected CompoundTermTag predicateTag;
    public static final AtomTerm unknownAtom = AtomTerm.get("unknown");
    public static final AtomTerm errorAtom = AtomTerm.get("error");
    public static final AtomTerm warningAtom = AtomTerm.get("warning");
    public static final AtomTerm procedureAtom = AtomTerm.get("procedure");

    public UndefinedPredicateCode(CompoundTermTag predicateTag) {
        this.predicateTag = predicateTag;
    }

    @Override
    public int execute(Interpreter interpreter, boolean backtrackMode, Term[] args) throws PrologException {
        Term flg = interpreter.getEnvironment().getPrologFlag(unknownAtom);
        if (flg == errorAtom) {
            if (this.predicateIndicator == null) {
                this.predicateIndicator = this.predicateTag.getPredicateIndicator();
            }
            PrologException.existenceError(procedureAtom, this.predicateIndicator);
        } else {
            if (flg == TermConstants.failAtom) {
                return -1;
            }
            if (flg == warningAtom) {
                System.err.println("predicate " + this.predicateTag.functor.value + "/" + this.predicateTag.arity + " does not exist.");
                return -1;
            }
        }
        throw new PrologException(PrologException.systemErrorAtom, null);
    }
}

