/*
 * Decompiled with CFR 0.152.
 */
package gnu.prolog.database;

import gnu.prolog.database.Module;
import gnu.prolog.database.Predicate;
import gnu.prolog.database.PrologTextLoader;
import gnu.prolog.database.PrologTextLoaderError;
import gnu.prolog.database.PrologTextLoaderListener;
import gnu.prolog.io.CharConversionTable;
import gnu.prolog.io.ParseException;
import gnu.prolog.io.TermWriter;
import gnu.prolog.term.AtomTerm;
import gnu.prolog.term.CompoundTerm;
import gnu.prolog.term.CompoundTermTag;
import gnu.prolog.term.Term;
import gnu.prolog.vm.Environment;
import gnu.prolog.vm.HasEnvironment;
import gnu.prolog.vm.TermConstants;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrologTextLoaderState
implements PrologTextLoaderListener,
HasEnvironment {
    protected Module module = new Module();
    protected Map<Predicate, Map<String, Set<PrologTextLoader>>> predicate2options2loaders = new HashMap<Predicate, Map<String, Set<PrologTextLoader>>>();
    protected Predicate currentPredicate = null;
    protected List<PrologTextLoaderError> errorList = new ArrayList<PrologTextLoaderError>();
    protected Set<String> loadedFiles = new HashSet<String>();
    protected CharConversionTable convTable = new CharConversionTable();
    protected List<PrologTextLoaderListener> listeners = new ArrayList<PrologTextLoaderListener>();
    private Environment environment;
    protected static final CompoundTermTag resourceTag = CompoundTermTag.get("resource", 1);
    protected static final CompoundTermTag urlTag = CompoundTermTag.get("url", 1);
    protected static final CompoundTermTag fileTag = CompoundTermTag.get("file", 1);

    public PrologTextLoaderState(Environment env) {
        this.environment = env;
    }

    @Override
    public Environment getEnvironment() {
        return this.environment;
    }

    public List<PrologTextLoaderError> getErrors() {
        return this.errorList;
    }

    public Module getModule() {
        return this.module;
    }

    public CharConversionTable getConversionTable() {
        return this.convTable;
    }

    protected boolean testOption(PrologTextLoader loader, Predicate p, String option) {
        Map<String, Set<PrologTextLoader>> options2loaders = this.predicate2options2loaders.get(p);
        if (options2loaders == null) {
            return false;
        }
        Set<PrologTextLoader> loaders = options2loaders.get(option);
        if (loaders == null) {
            return false;
        }
        return loader == null || loaders.contains(loader);
    }

    protected void defineOption(PrologTextLoader loader, Predicate p, String option) {
        Set<PrologTextLoader> loaders;
        Map<String, Set<PrologTextLoader>> options2loaders = this.predicate2options2loaders.get(p);
        if (options2loaders == null) {
            options2loaders = new HashMap<String, Set<PrologTextLoader>>();
            this.predicate2options2loaders.put(p, options2loaders);
        }
        if ((loaders = options2loaders.get(option)) == null) {
            loaders = new HashSet<PrologTextLoader>();
            options2loaders.put(option, loaders);
        }
        if (!loaders.contains(loader)) {
            loaders.add(loader);
        }
    }

    protected void defineOptionAndDeclare(PrologTextLoader loader, Predicate p, String option) {
        this.defineOption(loader, p, option);
        this.defineOption(loader, p, "declared");
    }

    protected boolean isDeclaredInOtherLoaders(PrologTextLoader loader, Predicate p) {
        Map<String, Set<PrologTextLoader>> options2loaders = this.predicate2options2loaders.get(p);
        if (options2loaders == null) {
            return false;
        }
        Set<PrologTextLoader> loaders = options2loaders.get("declared");
        if (loaders == null || loaders.isEmpty()) {
            return false;
        }
        Iterator<PrologTextLoader> i = loaders.iterator();
        while (i.hasNext()) {
            if (loader == i.next()) continue;
            return true;
        }
        return false;
    }

    public boolean declareDynamic(PrologTextLoader loader, CompoundTermTag tag) {
        Predicate p = this.findOrCreatePredicate(tag);
        if (this.testOption(loader, p, "dynamic")) {
            return true;
        }
        if (this.isDeclaredInOtherLoaders(loader, p)) {
            if (!this.testOption(loader, p, "multifile")) {
                this.logError(loader, "non multifile predicate could not be changed in other prolog text.");
                return false;
            }
            if (!this.testOption(null, p, "dynamic")) {
                this.logError(loader, "predicate was not declared dynamic in other texts, dynamic option should be the same in each prolog text.");
                return false;
            }
        } else if (this.testOption(loader, p, "defined")) {
            this.logError(loader, "predicate was already defined and could not be declared dynamic.");
            return false;
        }
        if (p.getType() == Predicate.TYPE.UNDEFINED) {
            p.setType(Predicate.TYPE.USER_DEFINED);
        }
        p.setDynamic();
        this.defineOptionAndDeclare(loader, p, "dynamic");
        return true;
    }

    public void declareMultifile(PrologTextLoader loader, CompoundTermTag tag) {
        Predicate p = this.findOrCreatePredicate(tag);
        if (this.testOption(loader, p, "multifile")) {
            return;
        }
        if (this.isDeclaredInOtherLoaders(loader, p)) {
            if (!this.testOption(null, p, "multifile")) {
                this.logError(loader, "non multifile predicate could not be changed in other prolog text.");
                return;
            }
        } else if (this.testOption(loader, p, "defined")) {
            this.logError(loader, "predicate was already defined and could not be declared multifile.");
            return;
        }
        if (p.getType() == Predicate.TYPE.UNDEFINED) {
            p.setType(Predicate.TYPE.USER_DEFINED);
        }
        this.defineOptionAndDeclare(loader, p, "multifile");
    }

    public void declareDiscontiguous(PrologTextLoader loader, CompoundTermTag tag) {
        Predicate p = this.findOrCreatePredicate(tag);
        if (this.testOption(loader, p, "discontiguous")) {
            return;
        }
        if (this.isDeclaredInOtherLoaders(loader, p) && !this.testOption(null, p, "multifile")) {
            this.logError(loader, "non multifile predicate could not be changed in other prolog text.");
            return;
        }
        if (this.testOption(loader, p, "defined")) {
            this.logError(loader, "predicate was already defined and could not be declared discontiguous.");
            return;
        }
        if (p.getType() == Predicate.TYPE.UNDEFINED) {
            p.setType(Predicate.TYPE.USER_DEFINED);
        }
        this.defineOptionAndDeclare(loader, p, "discontiguous");
    }

    public void addClause(PrologTextLoader loader, Term term) {
        CompoundTermTag headTag;
        Term head = term;
        if (term instanceof CompoundTerm && ((CompoundTerm)term).tag == TermConstants.clauseTag) {
            head = ((CompoundTerm)term).args[0];
        }
        if (head instanceof AtomTerm) {
            headTag = CompoundTermTag.get((AtomTerm)head, 0);
        } else if (head instanceof CompoundTerm) {
            headTag = ((CompoundTerm)head).tag;
        } else {
            this.logError(loader, "predicate head is not a callable term.");
            return;
        }
        if (this.currentPredicate == null || headTag != this.currentPredicate.getTag()) {
            this.currentPredicate = null;
            Predicate p = this.findOrCreatePredicate(headTag);
            if (this.testOption(loader, p, "defined") && !this.testOption(loader, p, "discontiguous")) {
                this.logError(loader, "predicate is not discontiguous.");
                return;
            }
            if (!this.testOption(loader, p, "declared") && this.testOption(null, p, "declared") && !this.testOption(loader, p, "multifile")) {
                this.logError(loader, "predicate is not multifile.");
                return;
            }
            if (!this.testOption(loader, p, "dynamic") && this.testOption(null, p, "dynamic")) {
                this.logError(loader, "predicate is not declared dynamic in this prolog text.");
                return;
            }
            this.currentPredicate = p;
            if (!this.testOption(loader, p, "defined")) {
                if (p.getType() == Predicate.TYPE.UNDEFINED) {
                    p.setType(Predicate.TYPE.USER_DEFINED);
                }
                this.defineOptionAndDeclare(loader, p, "defined");
            }
        }
        try {
            this.currentPredicate.addClauseLast(Predicate.prepareClause(term));
        }
        catch (IllegalArgumentException ex) {
            this.logError(loader, ex.getMessage());
        }
    }

    public void defineExternal(PrologTextLoader loader, CompoundTerm pi, String javaClassName, Predicate.TYPE type) {
        if (!CompoundTermTag.isPredicateIndicator(pi)) {
            this.logError(loader, "predicate indicator is not valid.");
            return;
        }
        CompoundTermTag tag = CompoundTermTag.get(pi);
        Predicate p = this.findOrCreatePredicate(tag);
        if (p.getType() != Predicate.TYPE.UNDEFINED) {
            this.logError(loader, "predicate type could not be changed.");
            return;
        }
        p.setType(type);
        p.setJavaClassName(javaClassName);
        this.defineOptionAndDeclare(loader, p, "defined");
    }

    protected Predicate findOrCreatePredicate(CompoundTermTag tag) {
        Predicate p = this.module.getDefinedPredicate(tag);
        if (p == null) {
            p = this.module.createDefinedPredicate(tag);
        }
        return p;
    }

    public void logError(PrologTextLoader loader, ParseException ex) {
        this.errorList.add(new PrologTextLoaderError(loader, ex));
    }

    public void logError(PrologTextLoader loader, String message) {
        this.errorList.add(new PrologTextLoaderError(loader, message));
    }

    public void logError(PrologTextLoaderError partialError, String message) {
        this.errorList.add(new PrologTextLoaderError(partialError, message));
    }

    public void addInitialization(PrologTextLoader loader, Term term) {
        this.module.addInitialization(loader.getCurrentPartialLoaderError(), term);
    }

    public void ensureLoaded(Term term) {
        if (!this.loadedFiles.contains(this.getInputName(term))) {
            this.loadedFiles.add(this.getInputName(term));
            new PrologTextLoader(this, term);
        }
    }

    protected File resolveInputFile(String filename) {
        File fl = new File(filename);
        if (fl.exists()) {
            return fl;
        }
        if (!filename.endsWith(".pl") && !filename.endsWith(".pro")) {
            fl = new File(String.valueOf(filename) + ".pro");
            if (fl.exists()) {
                return fl;
            }
            fl = new File(String.valueOf(filename) + ".pl");
            if (fl.exists()) {
                return fl;
            }
        }
        return new File(filename);
    }

    protected String getInputName(Term term) {
        if (term instanceof AtomTerm) {
            return this.resolveInputFile(((AtomTerm)term).value).toString();
        }
        if (term instanceof CompoundTerm) {
            CompoundTerm ct = (CompoundTerm)term;
            if (ct.tag == fileTag) {
                if (ct.args[0] instanceof AtomTerm) {
                    return this.resolveInputFile(this.getInputName(ct.args[0])).toString();
                }
            } else if ((ct.tag == urlTag || ct.tag == resourceTag) && ct.args[0] instanceof AtomTerm) {
                AtomTerm arg = (AtomTerm)ct.args[0];
                if (ct.tag == urlTag) {
                    return "url:" + arg.value;
                }
                return "resource:" + arg.value;
            }
        }
        return "bad_input(" + TermWriter.toString(term) + ")";
    }

    protected InputStream getInputStream(Term term) throws IOException {
        if (term instanceof AtomTerm) {
            return new FileInputStream(this.resolveInputFile(((AtomTerm)term).value));
        }
        if (term instanceof CompoundTerm) {
            CompoundTerm ct = (CompoundTerm)term;
            if (ct.tag == fileTag) {
                if (!(ct.args[0] instanceof AtomTerm)) {
                    throw new IOException("unknown type of datasource");
                }
                return this.getInputStream(ct.args[0]);
            }
            if (ct.tag == urlTag || ct.tag == resourceTag) {
                URL url;
                if (!(ct.args[0] instanceof AtomTerm)) {
                    throw new IOException("unknown type of datasource");
                }
                AtomTerm arg = (AtomTerm)ct.args[0];
                if (ct.tag == urlTag) {
                    url = new URL(arg.value);
                } else {
                    url = this.getClass().getResource(arg.value);
                    if (url == null) {
                        throw new IOException("resource not found");
                    }
                }
                return url.openStream();
            }
        }
        throw new IOException("unknown type of datasource");
    }

    public boolean addPrologTextLoaderListener(PrologTextLoaderListener listener) {
        if (listener == null || listener == this) {
            return false;
        }
        return this.listeners.add(listener);
    }

    public boolean removePrologTextLoaderListener(PrologTextLoaderListener listener) {
        return this.listeners.remove(listener);
    }

    @Override
    public void afterIncludeFile(PrologTextLoader loader) {
        for (PrologTextLoaderListener listener : this.listeners) {
            listener.afterIncludeFile(loader);
        }
    }

    @Override
    public void afterProcessFile(PrologTextLoader loader) {
        for (PrologTextLoaderListener listener : this.listeners) {
            listener.afterProcessFile(loader);
        }
    }

    @Override
    public void beforeIncludeFile(PrologTextLoader loader, Term argument) {
        for (PrologTextLoaderListener listener : this.listeners) {
            listener.beforeIncludeFile(loader, argument);
        }
    }

    @Override
    public void beforeProcessFile(PrologTextLoader loader) {
        for (PrologTextLoaderListener listener : this.listeners) {
            listener.beforeProcessFile(loader);
        }
    }
}

