#ifdef DYNIX
$stdunit
#endif DYNIX
*********************************************************
*                                                       *
*  Copyright 1988, by D.M. Etter, All rights reserved;  *
*          EECE Dept, University of New Mexico          *
*         Albuquereque, New Mexico,  87131  USA         *
*                                                       *
*********************************************************



CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C
        SUBROUTINE center (string)

*********************************************************
*                                                       *
*   Subroutine Center_Character_String                  *
*                                                       *
*        This subroutine takes a character string,      *
*        finds the first and last non-blank chars,      *
*        and centers the string accordingly.            *
*                                                       *
*        NOTE:  Input string must be 100 characters     *
*               or less.                                *
*                                                       *
*********************************************************
        CHARACTER *(*) string
        CHARACTER *100 temp
        INTEGER lngth, beg, lst, numblk
*
        temp = ' '
        lngth = LEN (string)
*
*  Find first non-blank character.
*
        beg = 1
   10   IF (beg .LE. lngth) THEN
          IF (string(beg:beg) .EQ. ' ') THEN
            beg = beg + 1
            GOTO 10
          ENDIF
        ENDIF
*
*  Find last non-blank character.
*
        lst = lngth
   20   IF (lst .GT. 0) THEN
          IF (string(lst:lst) .EQ. ' ') THEN
            lst = lst - 1
            GOTO 20
          ENDIF
        ENDIF
*
*  If it was a non-blank character string, center it by distributing
*  the leading and trailing blanks evenly by using a temporary string.
*
        IF (lst .GE. beg) THEN
          numblk = beg - 1 + lngth - lst
          temp(1+numblk/2:) = string(beg:lst)
          string = temp
        ENDIF
*
        RETURN
        END
