#line 1/*ACE 4 0073 */

extern void *malloc();
extern char *suffix(), *basename(), *strdup();

typedef struct flist {
    char            *file;
    char            *name;
    char            *title;
    int             flags;
    struct flist    *next;
} FLIST;

typedef struct {
    unsigned version;
    unsigned headlen;
    unsigned nplanes;
    unsigned patlen;
    unsigned pixelw;
    unsigned pixelh;
    unsigned linew;
    unsigned lines;
    unsigned palette[16];
} IMGHEADER;

typedef unsigned char   uchar;
typedef unsigned int    uint;

extern long gemdos();
#define  Cconws(s)          gemdos(9,s)
#define  Dsetdrv(d)         gemdos(14,d)
#define  Dsetpath(path)     gemdos(59,path)
#define  Fcreate(fn,mode)   gemdos(60,fn,mode)
#define  Fopen(fn,mode)     gemdos(61,fn,mode)
#define  Fclose(h)          gemdos(62,h)
#define  Fread(h,cnt,buf)   gemdos(63,h,cnt,buf)
#define  Fwrite(h,cnt,buf)  gemdos(64,h,cnt,buf)
#define  Fseek(where,h,how) gemdos(66,where,h,how)
#define NL  "\r\n"

FLIST   *FBase = 0L;        // Base of the file-list
int     inhandle;           // Handle of the current input-file
uchar   inbuf[4096];        // File-buffer for input
uchar   *inptr;
long    inlen;
uchar   inpath[128];        // Path of the input-file
uchar   mainpath[128];      // Path of the main file
int     outhandle;          // Handle of the output-file
uchar   outbuf[4096];       // File-buffer for output
uchar   *outptr;
uint    maxlines;
uint    Lineno;
uchar   output[128];        // Name of the output-file
int     ExtCnt;
int     NeedNL;             // Output NL before warning
int     use_filenames;      // Use file-name as node-name
int     code;
int     quiet;
int     NoAuto;
char    *CurrFile;

/*
 * Report errors and terminate
 */
Message(str1, str2)
char *str1, *str2;
{
    Cconws(str1);
    if (str2) Cconws(str2);
    Cconws(NL);
}


error(s1, s2)
char *s1, *s2;
{
    Message(s1, s2);
    if (outhandle) Fclose(outhandle);
    if (inhandle) Fclose(inhandle);
    _exit(1);
}


/*
 * Open output-file
 */
Wopen(char *outfile)
{
    if ((outhandle=Fcreate(outfile, 0)) > 5)
        outptr = outbuf;
    else
        error("can't open ", outfile);
    Lineno = 0;
}


/*
 * Open file for reading
 */
Ropen()
{
    register FLIST  *p;
    register char   *suf;
    char            tmp[150];

again:
    p = FBase;
    while (p) {
        if (p->flags==0) break;         // Find first, that has 
        p = p->next;                    // not been read yet
    }
    if (p == 0L) return(0);             // End of list reached
    p->flags = 1;                       // Mark as read

    strcpy(inpath, p->file);            // Save input path
    *basename(inpath) = 0;

    if ((inhandle=Fopen(p->file, 0))<5) // Open file
        error("can't open ", p->file);

    CurrFile = p->file;
    if (quiet==0) {
        Cconws("reading ");
        Cconws(p->file);
        Cconws("\033K\r");
        NeedNL = 1;
    }

    if (p == FBase) {                       // First file?
        fputs("@options \"+x -s");
        if (NoAuto) fputs("a");
        fputs("\"" NL NL);
    }

    fputs("@node \"");                      // Name of the page
    strcpy(tmp, p->name);
    ConvKey(tmp);
    fputs(tmp);
    fputs("\"");
    if (p->title) {                         // Possible title
        fputs(" \"");
        strcpy(tmp, p->title);
        ConvKey(tmp);
        fputs(tmp);
        fputs("\"");
    }
    fputs(NL);

    inlen = -1;
    inptr = inbuf;                      // Initialise read-pointer

    /*
     * If it is an image that HCP can read,
     * then we will incorporate it.
     */
    suf = suffix(p->file);
    if (strcmp(suf, ".IMG") == 0) {
        ImagePage(p);
        goto again;
    }

    return(1);                          // OK
}


/*
 > Read INF-file for current 1stGuide-text
 */
OpenINF(char *path)
{
    char    line[128];

    strcpy(line, path);
    strcpy(suffix(line), ".prj");
    if ((inhandle=Fopen(line, 0)) > 0) {
        inlen = -1;
        inptr = inbuf;                      // Initialise read-pointer
        while (fgets(line)) {
            fputs(line);
            fputs(NL);
        }
        xclose(inhandle);
    }
}


/*
 * Close file, and if necessary flush buffer
 */
xclose(handle)
int handle;
{
    long len;

    if (handle == outhandle) {
        len = (long)(outptr-outbuf);
        if (len) {
            if (Fwrite(handle, len, outbuf) != len)
                error("write error", 0L);
        }
    }

    Fclose(handle);
}


int fgets(line)
register uchar *line;
{
    register uchar  *p = inptr;
    int             rv = 1;

    do {
        if (inlen <= 0L) {
            inlen = Fread(inhandle, 4096L, inbuf);
            if (inlen < 0L)                 // Error?
                error("read error", 0L);

            if (inlen == 0L) {              // Nothing read?
                rv = 0;                     // File-end
                break;
            }
            inptr = p = inbuf;
        }
        if (*p == 10) {             // NL
            --inlen;
            ++p;
            break;
        }

        if (*p != 13)               // Don't copy CR
            *line++ = *p;

        --inlen;                    // One less
        ++p;
    } while (1);

    *line = 0;                      // Close line
    inptr = p;                      // Position of next character
    return(rv);                     // and finished
}


fputs(line)
register uchar  *line;
{
    register uchar  *p = outptr;

    while (*line) {
        if (*line == '\n') ++Lineno;
        if ( (long)(p-outbuf) == 4096L) {
            if (Fwrite(outhandle, 4096L, outbuf) != 4096L)
                error("write error", 0L);
            p = outptr = outbuf;
        }
        *p++ = *line++;
    }
    outptr = p;
}


/*******************************************************************/

/*
 * Create page end
 * If file is too long, create a new one
 */
EndNode()
{
    char    file[128];

    fputs("@endnode" NL NL NL);
    xclose(inhandle);                   // Close input

    if (maxlines && Lineno>maxlines) {
        strcpy(file, output);
        itoa(++ExtCnt, suffix(file)+1, 10);
        xclose(outhandle);
        Wopen(file);
    }
}


ImagePage(p)
FLIST   *p;
{
    IMGHEADER   *img = (IMGHEADER *)inbuf;
    uchar       *str = inbuf+100;
    int         cnt;

    Fread(inhandle, (long)sizeof(IMGHEADER), img);
    cnt = (img->lines+15)/16;
    fputs("@image ");
    fputs(p->file);
    fputs(" 1 ");
    ltoa((long)((img->linew+7)/8), str, 10);    // Width in characters
    fputs(str);
    fputs(" ");
    ltoa((long)cnt, str, 10);                   // Height in characters
    fputs(str);
    fputs(NL);

    EndNode();
}

char *Find(char *key)
{
    register FLIST  *p;

    p = FBase;
    while (p) {
        if (strcmp(p->name, key)==0)
            return(0);
        p = p->next;
    }
    return(1);
}


char *GetName(name, key)
char    *name, *key;
{
    char buf[20], *rv;

    /*
     * If desired, then always use file-name as
     * the page-name
     */
    if (use_filenames) {
        rv = name;
        goto end;
    }

    if (Find(key)) {                    // Search for title
        rv = key;
    }
    else {
        strcpy(buf, basename(name));
        *suffix(buf) = 0;
        if (Find(buf))                  // File without extension
            rv = buf;
        else {
            strcpy(buf, basename(name));
            if (Find(buf))              // File with extension
                rv = buf;
            else {
                rv = name;
            }
        }
    }
end:
    return(strdup(rv));
}


#if 0
char *GetName(name, key, flg)
char    *name, *key;
int     flg;
{
    register FLIST  *p;
    char            buf[20];
    register char   *new;
    int             flag;

    flag=0;
    new = key;                      // First we test the keyword

again:
    p = FBase;
    while (p) {
        if (strcmp(p->name, new) == 0) {
            if (flag==2)            // Test for file-name?
                return(0L);         // Yes: It all won't work
chk:
            ++flag;                 // Was test for keyword
            new = buf;              // Now we try the file-name
            strcpy(new, basename(name));
            if (flag==1) *suffix(new) = 0;
            goto again;
        }
        p = p->next;
    }
    if (flg==0) {
        flg=1;
        goto chk;
    }
    return(strdup(new));            // Retrun found node-name
}
#endif

/*
 * Append new file-name to the list of
 * files to be read. if it doesn't exist
 * already
 */
FLIST *AddFile(name, key)
char    *name, *key;
{
    register FLIST  *p = FBase, *last = p;

    while (p) {
        if (strcmp(p->file, name) == 0) return(p);
        last = p;
        p = p->next;
    }
    p = malloc(sizeof(FLIST));
    if (p == 0L)                    // Error
        error("out of memory", 0L);
    p->name = GetName(name, key);
    p->file = strdup(name);         // Copy name
    if (strcmp(p->name, key)) {     // When nodename != key
        p->title = strdup(key);     // dthen use key as the title
    }
    else
        p->title = 0L;
    p->flags = 0;                   // Not yet read
    p->next = 0L;                   // Always the last

    if (last) {
        last->next = p;
    }
    else {                          // First element
        FBase = p;
    }
    return(p);
}

/**********************************************************/

#define IS_ASCII    1
#define NO_TYPE     2

int FileType(file, key)
char    *file, *key;
{
    char            path[128];
    register char   *p, *save;
    int             h;
    FLIST           *q;

    /*
     * Convert file-name to capitals 
     * and complete the path
     */
    strupr(file);
    strcpy(path, inpath);
    strcat(path, file);

    /*
     * The path could contain '...' portions; 
     * for comparing names we will delete
     * these portions
     */
again:
    p = path;
    save = p;
    while (*p) {
        if (*p == '\\') {
            if (p[1] == '.' && p[2] == '.') {
                h = *save == '\\' ? 3 : 4;
                strcpy(save, p+h);
                goto again;
            }
            save = p;   // Last slash
        }
        ++p;
    }

    /*
     * So that the file doesn't become too large, we
     * will now shorten the path until it is relative
     * to the main file
     */
    save = (char *)mainpath;
    p = path;
    while (*p == *save) {
        ++p;
        ++save;
    }

    strcpy(file, p);
    p = suffix(file);

    /*
     * Let's see if we are dealing with one of
     * the file-types supported by 1stView...
     * If so, then the compiler can do nothing
     * with it (not an ASCII-file) and we return
     * NO_TYPE
     */
    if (   strcmp(p, ".RSC") == 0
        || strcmp(p, ".GEM") == 0
        || strcmp(p, ".SAM") == 0
        || strcmp(p, ".SND") == 0
        || strcmp(p, ".OUT") == 0
        || strcmp(p, ".DOK") == 0//-
        || strcmp(p, ".IMG") == 0
        || strcmp(p, ".IFF") == 0 
        )
        return(NO_TYPE);

    /*
     * ...then it's no doubt an ASCII-file;
     * in that case we will want to read it later,
     * so it will be placed in the list, if it
     * can be opened
     */
    if ((h=Fopen(file, 0))>0)
        Fclose(h);
    else {
        if (NeedNL) {
            Cconws(NL);
            NeedNL = 0;
        }
        Cconws("*** warning in '");
        Cconws(CurrFile);
        Message("': missing file ", file);
        code = 2;
        return(NO_TYPE);
    }

    q = AddFile(file, key);
    strcpy(file, q->name);
    return(IS_ASCII);
}


/*
 * Convert visible cross-reference
 */
int ConvKey(key)
char *key;
{
    char    buf[100];
    register char   *src = key, *dst = buf;
    int             rv=1;

    if (*src == '@' || NoAuto) rv=0;      // Force link

    while (*src) {
        if (*src == '"' || *src == '\\') {
            *dst++ = '\\';
            rv=0;
        }
        *dst++ = *src++;
    }
    *dst = 0;
    strcpy(key, buf);
    return(rv);
}


int HasBlanks(p)
register char *p;
{
    while (*p) {
        if (*p == ' ') return(1);
        ++p;
    }
    return(0);
}

DoList()
{
    uchar           line[255], buf[255], file[128], key[100];
    register uchar  *src, *dst, *p;
    uchar           *save;
    int             cnt;

    while (Ropen()) {                       // Ovr all files
again:
        while (fgets(line)) {               // All lines
            src = line;
            dst = buf;

            /*
             * If the line is an Info-block, then we
             * simply ignore it
             */
            if (*src == 0x1F) goto again;

            /*
             * If there is a comment character at the start,
             * we will simply indent it. so that the compiler
             * will ignore it
             */
            if (*src == '#' && src[1] == '#')
                *dst++ = ' ';

            while (*src) {                  // All characters
                switch (*src) {
                    case 0x1C:              // Stretch-soace character
                    case 0x1D:              // Indent-space character
                    case 0x1E:              // Variable-space character
                        *dst++ = ' ';
                        ++src;
                        break;
                    case 27:
                        ++src;
                        if (*src>=0x80) {
                            *dst++ = '@';
                            *dst++ = '{';
                            *src -= 0x80;
                            if (*src==0)    *dst++ = '0';   // All off
                            if (*src & 1)   *dst++ = 'B';   // Bold
                            if (*src & 2)   *dst++ = 'G';   // Light/grey
                            if (*src & 4)   *dst++ = 'I';   // Italic
                            if (*src & 8)   *dst++ = 'U';   // Underlined
                            *dst++ = '}';
                        }
                        else {
                            *dst++ = 27;
                            *dst++ = *src;
                        }
                        ++src;
                        break;
                    case '@':
                        *dst++ = '@';
                        /* fall thru */
                    default:
                        *dst++ = *src++;
                        break;
                    case '':
                        p = key;
                        cnt=0;
                        save = dst;
                        do {
                            *dst++ = *src++;
                            if (*src == '') {
                                *p = 0;
                                if (cnt==1) {
                                    ++src;
                                    break;
                                }
                                else {
                                    p = file;
                                    *dst++ = *src++;
                                }
                                ++cnt;
                            }
                            if (*src == 0) goto more;
                            *p++ = *src;
                        } while (1);

                        dst = save;
                        if (FileType(file, key) != IS_ASCII)
                            p = (uchar *)"\\Main";
                        else {
                            p = 0L;
                            cnt = ConvKey(key);
                            /*
                             * If the auto-referencer finds this
                             * place on its own, we let it do so
                             */
                            if (cnt && *src < '0' && dst[-1] < '0'
                                && (HasBlanks(file)==0)
                                && strcmp(key, file) == 0) {
                                strcpy(dst, key);
                                while (*dst++);
                                --dst;
                                break;
                            }
                        }
                        *dst++ = '@';
                        *dst++ = '{';
                        *dst++ = '"';
                        strcpy(dst, key);
                        while (*dst++);
                        --dst;
                        strcpy(dst, "\" link ");
                        dst += 7;
                        if (cnt=HasBlanks(file))
                            *dst++ = '"';
                        strcpy(dst, file);
                        while (*dst++);
                        --dst;
                        if (p) {
                            strcpy(dst, p);
                            while (*dst++);
                            --dst;
                        }
                        if (cnt) *dst++ = '"';
                        *dst++ = '}';
                        break;
                }
            }
more:
            *dst=0;
            fputs(buf);
            fputs(NL);
        }
        EndNode();
    }
}


AddIncludes()
{
    char    buf[128];
    int     i;

    strcpy(buf, output);
    outhandle = Fopen(buf, 1);
    outptr = outbuf;
    Fseek(0L, outhandle, 2);

    for (i=1; i<=ExtCnt; i++) {
        strcpy(buf, output);
        itoa(i, suffix(buf)+1, 10);
        fputs(NL "@include ");
        fputs(buf);
    }
    fputs(NL);
    xclose(outhandle);
}



/**************************************************************/

extern int  _argc;
extern char **_argv;
_main()
{
    main(_argc, _argv);
}


main(argc, argv)
int argc;
char **argv;
{
    char            outfile[128];
    register char   *p;
    int             save;

    maxlines = 0;

    if (argc < 2) {
        error("usage: 1stConv [-NNN -f -q -a] file" NL
              "       -NNN: max lines per file" NL
              "       -f  : use filenames as nodenames" NL
              "       -q  : be quiet" NL
              "       -a  : explicit links only" NL
              , 0L);
        _exit(1);
    }

    save = 0;
    do {
        ++argv;
        --argc;
        if (**argv == '-') {
            p = *argv+1;
            if (*p == 'f') {
                save = 1;
            }
            else if (*p == 'q')
                ++quiet;
            else if (*p == 'a')
                ++NoAuto;
            else
                maxlines = atoi(p);
        }
        else {
            if (quiet==0) {
                Message("1stConv: V(" __DATE__ ") 1stGuide --> ST-Guide sources" NL
                        "         Written by Holger Weets using SOZOBON-C V2.00x10" NL
                        , 0L);
            }

            /*
             * Determine output-file
             */
            strupr(*argv);                      // If from CLI
            strcpy(outfile, *argv);
            AddFile(basename(outfile), "Main"); // Enter file-name only
            use_filenames = save;
            p = (char *)mainpath;               // Save path
            strcpy(p, outfile);
            *basename(p) = 0;

            /*
             * We set the directory of the main file as
             * the current directory, so that paths can
             * be specified as relative which makes the
             * output-file shorter and more transportable
             */
            if (p[1] == ':')
                Dsetdrv(*p-'A');
            Dsetpath(p);

            strcpy(suffix(outfile), ".stg");
            Wopen(outfile);
            OpenINF(outfile);
            strcpy(output, outfile);
            ExtCnt=0;
            DoList();
            xclose(outhandle);

            if (ExtCnt) AddIncludes();

            if (NeedNL) Cconws(NL);
            break;
        }
    } while (argc>1);
    _exit(code);
}





