Unit Repeats; {Gets in and Executes Repeats}

INTERFACE

Procedure ExecRpt(Var Com:Byte;          {Executes Repeat Entered}
                  Var x,y:real;
                  Var Angle,Colour:Integer;
                  Var Pendown,TurtleOn:Boolean;
                  Var Location:Word);

Procedure Rpt(Command:String;            {Main Routine}
          Var Com:Byte;
          Var x,y:real;
          Var Angle,Colour:Integer;
          Var Pendown,TurtleOn:Boolean;
          Var Location:Word);

Procedure GetRpt(                        {Gets user to enter Repeat}
          Var Com:Byte;
          Var x,y:real;
          Var Angle,Colour:Integer;
          Var Pendown,TurtleOn:Boolean;
          Var Location:Word;
          Var Abort:Boolean);

IMPLEMENTATION

Uses Stack,CRT,Graph,GetCom,ComChange,ComCarry,Queue,Tools,Builder,Error
     ,uservars;




Procedure ExecRpt(Var Com:Byte;
                  Var x,y:real;
                  Var Angle,Colour:Integer;
                  Var Pendown,TurtleOn:Boolean;
                  Var Location:Word);

Var
    Qpos,RptPos,Loops,Num:Word;
    Ch,Cb:Char;
    TurtleCond,Executed:Boolean;
    Code:Integer;
    Command,s:String;

Begin
If Building=True then begin                            {If Building, write }
                      Qpos:=1;                         {the routine about  }
                      Repeat;                          {to be executed to  }
                       Qcommand(S,Qpos);               {the current        }
                       if (S<>'STOP') and              {BuildFile          }
                          (Copy(S,1,6)<>'BUILD ')      {                   }
                           then Writeln(buildfile,S);  {    (????.BUI)     }
                       Inc(Qpos);
                      Until S='STOP';
                      end;

RptPos:=0; Ch:='`';
Loops:=0;
TurtleCond:=TurtleOn;
if TurtleCond=True then Carryout('HIDE',Com,x,y,Angle,Colour,Pendown,TurtleOn,Location);
TurtleOn:=False;
                 {If the Turtle is currently displayed, turn it off     }
                 {while the following repeat is executed, this makes the}
                 {repeat execute a lot faster.                          }

Repeat
 Executed:=False;
 Inc(RptPos);               {Moves down to then next command in the Repeat}

 QCommand(Command,RptPos);  {Gets the command at position "RptPos" on the }
                            {Queue.                                       }

 If Command='STOP' then Ch:=Chr(27);
                        {If the Command pulled off of the Queue is 'STOP',}
                        {this signifies the end of the repeat, and so the }
                        {Abort flag is set.                               }

 If Copy(Command,1,7)='REPEAT ' then Begin
                         Val(Copy(Command,8,Length(Command)-7),Num,Code);
                         Spush(Num);       {Stores Number of times to Repeat}
                         Spush(RptPos);    {Stores Current Position}
                         Executed:=True;
                         end;

 If Command='END' then begin
                       Num:=RptPos;        {Stores Current Position in Temporary Variable (NUM}
                       Spop(RptPos);       {Receives new "Current Position" off of Stack}
                       Spop(Loops);        {Receives Number of times left to Repeat}
                       Dec(Loops);         {Decrements Number of times left to Repeat}
                       If Loops>0 then begin             {If this Value is Greater than }
                                       Spush(Loops);     {zero, the procedure within the}
                                       Spush(RptPos);    {repeat needs re-executing, and}
                                       end               {current variables are stored. }
                                  else RptPos:=num; {otherwise...                }
                       Executed:=True;              {The Repeat has been executed}
                       end;                         {fully, and so can be wiped  }
                                                    {from the stack, the Current }
                                                    {position is set back to what}
                                                    {it was at the start of this }
                                                    {procedure.                  }

 If Command='SHOW' then begin
                        TurtleCond:=True;     {Show and Hide are Ignored}
                        Executed:=True;       {from within repeats, as  }
                        end;                  {turtle is automatically  }
                                              {switched off while a     }
 If Command='HIDE' then begin                 {repeat is being executed,}
                        TurtleCond:=False;    {although the turtles     }
                        Executed:=True;       {variables are still      }
                        end;                  {changed.                 }

 If Not Executed then Carryout(Command,Com,x,y,Angle,Colour,Pendown,
                               TurtleOn,Location);
                               {The Current Command is now carried out if }
                               {it hasn't already been flagged as executed}


 If Keypressed and (Ch<>chr(27)) then Ch:=Readkey;
                                 {Checks for the Abort Key being pressed }
 If Ch=';' then begin
                SlowMo:=Not SlowMo;
                ch:='`';
                end;
 If SlowMo=True then Begin
                     Carryout('SHOW',Com,x,y,Angle,Colour,Pendown,TurtleOn,Location);
                     ch:=Readkey;
                     Carryout('HIDE',Com,x,y,Angle,Colour,Pendown,TurtleOn,Location);
                     end;
Until Ch=chr(27); {Until Abort key is pressed or Repeat is Completed}

if TurtleCond=True then Carryout('SHOW',Com,x,y,Angle,Colour,Pendown,TurtleOn,Location);
TurtleOn:=TurtleCond;
                       {Re-Displays the Turtle if Necessary}

SClear; QClear;        {Clears the Stack and Queue}

end;






Procedure Rpt(Command:String;
          Var Com:Byte;
          Var x,y:real;
          Var Angle,Colour:Integer;
          Var Pendown,TurtleOn:Boolean;
          Var Location:Word);

Var Abort:Boolean;

Begin
Qclear; Sclear;  {Clear Stack and Queue before executing repeat}

QPush(Command);  {Push the Current command onto the stack, this command }
                 {will be of the "REPEAT XXXX" format.                  }

GetRpt(Com,x,y,Angle,Colour,Pendown,TurtleOn,Location,Abort);
                 {Gets in the procedure to be executed off of the user. }

if Abort=False then ExecRpt(Com,x,y,Angle,Colour,Pendown,TurtleOn,Location);
                 {If Abort=false, then the user has pressed the escape  }
                 {key signifying that he/she does not wish to continue  }
                 {with the current Repeat.                              }
End;




    {0  72}
Procedure GetRpt(
          Var Com:Byte;
          Var x,y:real;
          Var Angle,Colour:Integer;
          Var Pendown,TurtleOn:Boolean;
          Var Location:Word;
          Var Abort:Boolean);

Const ColTable:array[0..15] of string[15]=
      ('BLACK','BLUE','GREEN','CYAN','RED','MAGENTA'
      ,'BROWN','LIGHTGRAY','DARKGRAY','LIGHTBLUE','LIGHTGREEN'
      ,'LIGHTCYAN','LIGHTRED','LIGHTMAGENTA','YELLOW','WHITE');


Var Xpos,Ypos:Word;
    S,Comstr,Command,LastCommand:String;
    Code,za,Comval:Integer;
    Rpt,L:byte;
    ok:boolean;
    cb:char;

Begin
                                                 {1.... open repeat window}
Setfillstyle(Solidfill,Black);
Bar(451,1,638,478);
Ypos:=5;
Xpos:=453;
Rpt:=1;
Abort:=False;
Repeat
Repeat
ok:=true;
                                                 {2.... Get Command}
GetCommand(451,ypos,638,Command,Abort,Ok);
if Ok=false then begin
                        Bar(451,ypos,638,ypos+15);
                        ypos:=ypos-10;
                        Qpop(Command);
                        if Copy(Command,1,7)='REPEAT ' then Rpt:=Rpt-1;
                        if Copy(Command,1,3)='END' then Rpt:=Rpt+1;
                        end;
until ok=true;

Alter(Command);
                                                 {4.... Check Command}
Com:=0;
L:=Length(Command);
If Copy(Command,1,3)='FWD' then
               begin
               Comstr:=Copy(Command,4,L-3);
    Cb:=Comstr[1];
    if cb in (['A'..'Z']) then begin
                                   za:=Ord(cb)-65;
                                   Comval:=V[za];
                                   str(Comval,Comstr);
                                   end;
               Val(Comstr,Comval,code);
               if Code=0 then
                  if (Comval>=-30000) and (Comval<=30000) then com:=1;
               end;

If Copy(Command,1,4)='BACK' then
               begin
               Comstr:=Copy(Command,5,L-4);
    Cb:=Comstr[1];
    if cb in (['A'..'Z']) then begin
                                   za:=Ord(cb)-65;
                                   Comval:=V[za];
                                   str(Comval,Comstr);
                                   end;
               Val(Comstr,Comval,code);
               if Code=0 then
                  if (Comval>=-30000) and (Comval<=30000) then com:=1;
               end;

If Copy(Command,1,5)='SAVE ' then Com:=1;

If Copy(Command,1,5)='LOAD ' then Com:=1;

If Copy(Command,1,6)='ERASE ' then Com:=1;

If Copy(Command,1,5)='RIGHT' then
               Begin
               Comstr:=Copy(Command,6,L-5);
    Cb:=Comstr[1];
    if cb in (['A'..'Z']) then begin
                                   za:=Ord(cb)-65;
                                   Comval:=V[za];
                                   str(Comval,Comstr);
                                   end;
               Val(Comstr,Comval,code);
               if Code=0 then
                  if (Comval>=-30000) and (Comval<=30000) then com:=1;
               end;

If Copy(Command,1,4)='LEFT' then
               Begin
               Comstr:=Copy(Command,5,L-4);
    Cb:=Comstr[1];
    if cb in (['A'..'Z']) then begin
                                   za:=Ord(cb)-65;
                                   Comval:=V[za];
                                   str(Comval,Comstr);
                                   end;
               Val(Comstr,Comval,code);
               if Code=0 then
                  if (Comval>=-30000) and (Comval<=30000) then com:=1;
               end;

If Copy(Command,1,10)='SETHEADING' then
               begin
               Comstr:=Copy(Command,12,L-11);
    Cb:=Comstr[1];
    if cb in (['A'..'Z']) then begin
                                   za:=Ord(cb)-65;
                                   Comval:=V[za];
                                   str(Comval,Comstr);
                                   end;
               Val(Comstr,Comval,code);
               if Code=0 then
                  if (Comval>=-30000) and (Comval<=30000) then com:=1;
               end;

If Copy(Command,1,6)='COLOR ' then
    begin
    Comstr:=Copy(Command,7,L-6);
    Cb:=Comstr[1];
    if cb in (['A'..'Z']) then begin
                                   za:=Ord(cb)-65;
                                   Comval:=V[za];
                                   str(Comval,Comstr);
                                   end;
    Val(Comstr,Comval,code);
    If Code=0 then
              if (Comval<0) or (Comval>15) then Com:=0
              else begin
                   Colour:=Comval;
                   Com:=1;
                   end;
    if Code<>0 then begin
                    Com:=107;
                    Comval:=0;
                    repeat
                     if Comstr=ColTable[Comval] then begin
                                                 Colour:=Comval;
                                                 Com:=1;
                                                 end;
                     inc(Comval);
                    Until Comval=16;
                    end;
    end;


If Command='PU' then Com:=1;

If Command='PD' then Com:=1;

If Command='CLS' then Com:=1;

If Command='SHOW' then Com:=2;

If Command='HIDE' then Com:=2;

If Copy(Command,1,6)='MERGE ' then Com:=2;

If Copy(Command,1,5)='LOAD ' then Com:=2;

If Copy(Command,1,5)='SAVE ' then Com:=2;

If Copy(Command,1,5)='LIST ' then Com:=2;

If Copy(Command,1,5)='DIR ' then Com:=2;

If Copy(Command,1,6)='ERASE ' then Com:=2;

If Copy(Command,1,7)='REPEAT ' then
               begin
               Comstr:=Copy(Command,8,L-7);
    Cb:=Comstr[1];
    if cb in (['A'..'Z']) then begin
                                   za:=Ord(cb)-65;
                                   Comval:=V[za];
                                   str(Comval,Comstr);
                                   end;
               Val(Comstr,Comval,code);
               if code=0 then
                  if (Comval>=-30000) and (Comval<=30000) then
                                          begin
                                          com:=1;
                                          Rpt:=Rpt+1;
                                          end;
               end;

if Copy(Command,1,5)='MAKE ' then begin
                                 S:=Copy(Command,6,Length(Command)-1);
                                 S:=S+'.BUI';
                                 if Exists(S) then begin
                                    Assign(MakeFile,S);
                                    Reset(MakeFile);
                                    While Not Eof(MakeFile) do begin
                                          Readln(MakeFile,S);
                                          Qpush(S);
                                          end;         {Pushes routine  }
                                    Com:=3;            {within MAKE onto}
                                    Close(MakeFile);   {Queue.          }
                                    end;
                                 end;
if Command='END' then begin
                 Rpt:=Rpt-1;
                 Com:=1;
                 end;

if Command='CLS' then Com:=1;

if Command='CENTRE' then Com:=1;

if Command='FRESH' then Com:=1;

If Com=0 then begin
              EvalChk(Com,Command);
              if Com<>1 then com:=0;
              end;

if Com=0 then begin
                                 S:=Command;
                                 S:=S+'.BUI';
                                 if Exists(S) then begin
                                    Assign(MakeFile,S);
                                    Reset(MakeFile);
                                    While Not Eof(MakeFile) do begin
                                          Readln(MakeFile,S);
                                          Qpush(S);
                                          end;         {Pushes routine  }
                                    Com:=3;            {within MAKE onto}
                                    Close(MakeFile);   {Queue.          }
                                    end;
                                 end;

if com=1 then begin               {Com is set to 1 when a Command is     }
               Ypos:=Ypos+10;     {Checked and found to be correct.      }
               Qpush(Command);    {This Command is Pushed into the Queue.}
               end;

if Com=2 then ShowError(111);     {If Com is 2, then a Valid Command has }
                                  {been entered, but cannot be executed  }
                                  {within a repeat due to its nature, so }
                                  {an error will be displayed telling the}
                                  {user of this.                         }

if Com=3 then Ypos:=Ypos+10;      {If Com is set to 3, then the Command  }
                                  {entered was a valid MAKE, this make   }
                                  {Command will not be pushed into the   }
                                  {Queue as the entire routine contained }
                                  {within this MAKE, has already been    }
                                  {pushed (See above).                   }

if Abort=True then Begin          {If Escape has been Pressed then Clear }
                   Rpt:=0;        {the Queue, Set Repeats to zero, and   }
                   QClear;        {abort the routine.                    }
                   end;

Until (Rpt=0) or (ypos>470); {45 is Max Repeat Length}
end;
End.