.\"% nroff -man distribute.l
.\" distribute.l - man page for point-repulsion programs
.\" $Id: distribute.l,v 1.3 96/02/11 21:36:51 leech Exp $
.de LS
.sp
.nf
.in +0.5i
..
.de LE
.sp
.fi
.in -0.5i
..
.TH DISTRIBUTE 1L "February 11, 1996" " "
.ta 1i 2i
.SH NAME
distribute, points \- Evenly distribute points on a sphere

.ds DI \fBdistribute\fP
.ds PO \fBpoints\fP
.SH SYNOPSIS
\*(DI [options]
.br
\*(PO [options]

.SH DESCRIPTION
\*(DI and \*(PO attempt to solve the problem of
``evenly distributing'' N points on a sphere by simulating
a system of mutually repulsive points with damping. \*(DI is a batch-mode
program when results for specific N are needed; \*(PO is an interactive
graphical frontend which allows experimentation with parameters of the
simulation. \*(DI will terminate after satisfying a specified stopping
critera.

.SH OPTIONS
All the options are accepted by both \*(DI and \*(PO and have the same
effect, except where noted.

The first group of options affect simulation parameters:

\fI-nbody nbody\fP sets the number of bodies (default 4).

\fI-critical\fP causes ``critical damping'' to be used (this is the
default).

\fI-damping d\fP disables critical damping, using a damping factor \fId\fP
instead. Values of \fId\fP in the range 1-10 (larger for larger N) are
usually appropriate.

\fI-dt t\fP uses a timestep \fIt\fP. By default, the timestep is chosen for
rapid convergence. Values of \fIt\fP not exceeding 0.1 (smaller for larger
N) are usually appropriate.

\fI-softening s\fP sets the softening parameter. This affects force
computations by treating particles as further apart than they actually are,
helping avoid chaotic behavior (which the Euler method used for the
simulation can easily produce). Values of \fIs\fP around 0.05 are usually
appropriate.

\fI-k f\fP sets the force constant to \fIf\fP. This controls how strongly
points repel each other. Increasing \fIf\fP makes the simulation converge
more rapidly from the initial random placement, but also makes it noisier.
The default value is 1.


The following options control the stopping criteria used to terminate \*(DI.
They are mutually exclusive with the exception of \fI-steps\fP.

\fI-rstop r\fP stops when the ratio of the ideal nearest neighbor distance
to the smallest actual nearest neighbor distance is less than \fIr\fP.
The ideal distance function is an approximation that needs to be better
tuned.

\fI-kestop e\fP stops when the kinetic energy (1/2 sum of particle velocity
squared for each particle) drops below \fIe\fP.

\fI-pestop e\fP stops when the potential energy (sum(1/r(i,j)) for all
interparticle distances r(i,j)) drops below \fIe\fP. (Note that potential
energy and kinetic energy are not computed to the same scale at present, so
don't despair if you notice the system doesn't satisfy the Virial theorem).

\fI-vstop v\fP stops when the maximum velocity of all points is less than
\fIv\fP.

\fI-neverstop\fP causes the simulation not to stop based on any energy
criteria.

\fI-steps s\fP stops after \fIs\fP iterations, whether or not any of the
previous stopping criteria are satisfied.

If no stopping criterion is specified, \*(DI stops when kinetic energy drops
below \fInbody * 10**-5\fP (this criterion is not expressible with
\fI-kestop\fP).



These options control the initial state of the simulation and how to store
the final state:

\fI-load file\fP loads the initial number and distribution of points
from \fIfile\fP, which should look like this:
.LS
n
X1 Y1 Z1
\ ...
Xn Yn Zn
.LE

For \*(PO, this is the file used by the ``Load'' menu item.

\fI-save file\fP saves the final distribution in \fIfile\fP in the same
format used by \fI-load\fP. For \*(PO, this is the file used by the
``Save Coords'' menu item.

\fI-vrml file\fP saves the convex hull of the final distribution in
\fIfile\fP in VRML format. For \*(PO, this is the file used by the ``Save
VRML'' menu item.


The remaining miscellaneous options (for \*(DI only) are:

.\"fI-stop\fP brings up the simulation in a `not running' state. This
.\"is only useful for \*(PO, where it allows examining a saved
.\"configuration or initial random state.

\fI-trace [format]\fP prints the values of various simulation
parameters at each step according to the \fIformat\fP string, which
may include any of the following characters (not case-significant):
.LS
K	kinetic energy
P	potential energy
V	maximum point velocity
R	ratio of smallest near-neighbor distance to ideal
.LE
If \fIformat\fP is not supplied, \fIKR\fP is assumed, e.g. the
kinetic energy, and distance ratio are printed for each timestep.

\fI-help\fP briefly describes each option.


Unrecognized options to \*(DI are errors; they may be parsed as standard Tk
toolkit options by \*(PO.

.SH USING THE INTERACTIVE PROGRAM
Starting up \*(PO will bring up a window with a variety of controls
and displays, described below.

.SH MENUS
The \fIFile\fP menu has \fILoad\fP, \fISave Coords\fP, \fISave VRML\fP,
and \fIQuit\fP items. \fILoad\fP reloads from the file specified to
\fB-load\fP on the command line. \fISave Coords\fP and \fISave VRML\fP write
the current simulation state or the convex hull of the points to the file
specified to the \fB-save\fP or \fB-vrml\fP options. \fIQuit\fP terminates
the simulation.

The \fIDistance\fP menu controls how distance between points on the sphere
is measured. The possibilities are \fIArc\fP, measured along the great
circle connecting the points, and \fIEuclid\fP, measured along the straight
line connecting the points. The default is \fIArc\fP.

The \fIForce Law\fP menu controls the repulsion force between two points
based on the distance \fBr\fP between them. The possiblities are
\fILinear\fP (f = \fB1/r\fP), \fISquare\fP (f = \fB1/r**2\fP),
\fILennart-Jones\fP (f = \fB1/r**6 - 1/r**12\fP), and
\fIMorse\fP (which is too bloody complicated to do in raw nroff!).
The default (and almost always the preferred law) is \fISquare\fP.

.SH RADIO BUTTONS
Several panels of radio buttons appear below the menu bar. The
\fISimulation\fP panel controls whether the simulation \fIRun\fPs
continuously or single-steps with each click on the \fIStep\fP button.

The \fIDamping\fP panel controls whether \fICritical\fP damping or damping
by the interactively specified value (\fIUser\fP) is done when updating
point velocities. When critical damping is enabled, the \fIDamping
Coefficient\fP scrollbar (see below) is disabled.

The \fITimestep\fP panel controls whether the timestep is selected
automatically (\fIAuto\fP) as the number of bodies is changed, or the
interactively-specified timestep (\fIUser\fP) is used.

.SH BUTTONS
The \fIRandomize Points\fP button slightly perturbs all point locations,
making a nearly-stable simulation return to dynamic behavior.

.SH DISPLAY AREAS
Two \fIcanvases\fP (graphics display areas) appear below the radio buttons.
The first shows a cylindrical projection of point positions on the sphere.
Each point appears as a black dot on a red background.

The text fields immediately below the first canvas display the kinetic
energy, potential energy, maximum point velocity, number of pair
interactions in the previous timestep, closest, furthest, and ideal
near-neighbor distances, and the ratio of the closest to the ideal distance.

The second canvas shows a perspective view of the sphere tesselation
obtained by taking the convex hull of the points; it is updated by pressing
the ``Update Hull'' button underneath the canvas.

.SH SCROLLBARS
Finally, a number of labelled scrollbars controlling simulation parameters
appear below the canvases. Some correspond to program options, including
\fIPoints\fP (\fB-nbody\fP), \fITimestep\fP (\fB-dt\fP), \fIDamping
Coefficient\fP (\fB-damping\fP), \fISpring Constant\fP (\fB-k\fP), and
\fISoftening\fP (\fB-softening\fP) parameters. There are also scrollbars
controlling \fIR0\fP (a distance parameter used by the Lennart-Jones and
Morse force laws) and the \fIDistance Cutoff\fP. The cutoff causes forces
from particles further than the specified arc length away to be ignored;
it's initially set to the maximum possible distance, so all \fBnbody ** 2\fP
interactions are computed.

The \fITimestep\fP, \fIDamping Coefficient\fP, and \fISpring Constant\fP
scrollbars use logarithmic scales; the others use linear scales.

.SH EXAMPLES
To find a distribution of 53 points on a sphere, placing the result in
`dist.53':

.LS
$ distribute -nbody 53 -save dist.53
.LE

.SH AUTHOR
Jon Leech (leech@cs.unc.edu)

.SH COPYRIGHT NOTICE
Copyright (C) 1996, Jonathan P. Leech.

This software may be freely copied, modified, and redistributed,
provided that this copyright notice is preserved on all copies.

There is no warranty or other guarantee of fitness for this software,
it is provided solely ``as is''. Bug reports or fixes may be sent
to the author, who may or may not act on them as he desires.

You may not include this software in a program or other software product
without supplying the source, or without informing the end-user that the
source is available for no extra charge.

If you modify this software, you should include a notice giving the
name of the person performing the modification, the date of modification,
and the reason for such modification.

.SH OTHER COMMENTS
I hope this is fun for people to play with, and that it addresses the
needs (or curiosity, or whatever makes this a FAQ) of some of the many
people who have posted to comp.graphics over the years on this topic.
