/* text.c - batch (command line) interface for point-repulsion simulation
 *
 * $Id: text.c,v 1.1 92/04/27 04:25:14 leech Exp $
 *
 * Copyright (C) 1992, Jonathan P. Leech
 *
 * This software may be freely copied, modified, and redistributed,
 * provided that this copyright notice is preserved on all copies.
 *
 * There is no warranty or other guarantee of fitness for this software,
 * it is provided solely "as is". Bug reports or fixes may be sent
 * to the author, who may or may not act on them as he desires.
 *
 * You may not include this software in a program or other software product
 * without supplying the source, or without informing the end-user that the
 * source is available for no extra charge.
 *
 * If you modify this software, you should include a notice giving the
 * name of the person performing the modification, the date of modification,
 * and the reason for such modification.
 *
 * $Log:	text.c,v $
 * Revision 1.1  92/04/27  04:25:14  leech
 * Initial revision
 * 
 */

#include <SphereState.h>
#include <Interface.h>

// A batch mode interface
class TextInterface : public Interface {
public:
    TextInterface(int &ac, char **av);
   ~TextInterface();

    virtual int Done();
    virtual int HandleEvent();
    virtual void UpdatePoints();
};

// Create an interface object for the InterViews interface
Interface *Interface::MakeInterface(int &ac, char **av) {
    return new TextInterface(ac, av);
}

TextInterface::TextInterface(int &ac, char **av)
  : Interface(false, ac, av)
{ }

TextInterface::~TextInterface() {
}

int TextInterface::Done() {
    return 0;
}

int TextInterface::HandleEvent() {
    return 0;
}

void TextInterface::UpdatePoints() {
}
