(*^
*)
 
RadioGastropography[whorls_, stepsperwhorl_:16]:= 
Module[{data, t, y, z, h, v, r0, t0, h0, v0, offset, translation, 
horizontalexpansion, verticalexpansion, rat, raeg, slinky, shell, 
ypoints, zpoints, hpoints, vpoints, yeqn, zeqn, heqn, veqn, ay, by, az, bz, 
ah, bh, av, bv}, 
data = ReadRadiograph[whorls]; 
t = Flatten[2 Pi #[[{1}]]& /@ data]; 
y = Flatten[#[[{2}]]& /@ data]; 
z = Flatten[#[[{3}]]& /@ data]; 
h = Flatten[#[[{4}]]& /@ data]; 
v = Flatten[#[[{5}]]& /@ data]; 
r0 = Drop[y, -1]; 
t0 = Drop[z, -1]; 
h0 = Drop[h, -1]; 
v0 = Drop[v, -1]; 
offset = Drop[y, 1] / Drop[y, -1]; 
translation = Drop[z, 1] / Drop[z, -1]; 
horizontalexpansion = Drop[h, 1] / Drop[h, -1]; 
verticalexpansion = Drop[v, 1] / Drop[v, -1]; 
rat = 	Flatten[Join[ 
		Table[ 
			RadiographApertureTrajectory[ 
				r0[[i]], offset[[i]], t0[[i]], translation[[i]], 
				stepsperwhorl 
			],  
			{i, 1, whorls - 1} 
		]], 
		1 
	]; 
raeg = Flatten[Join[ 
		Table[ 
			RadiographApertureExpansionGeometric[ 
				h0[[j]], horizontalexpansion[[j]],  
				v0[[j]], verticalexpansion[[j]], 
				stepsperwhorl 
			], 
		{j, 1, whorls - 1} 
		]], 
		1 
	]; 
slinky = Table[ 
		{ 
		(Line /@  Partition[rat, 2, 1])[[m]], 
		 raeg[[m]] 
		}, 
		{m,1,(whorls - 1) stepsperwhorl} 
	] ; 
shell = Map[PreDraw3D[WheelEllipse @@ #]&, slinky]; 
ypoints = Table[{t[[k]],y[[k]]},{k, 1, whorls}]; 
zpoints = Table[{t[[k]],z[[k]]},{k, 1, whorls}]; 
hpoints = Table[{t[[k]],h[[k]]},{k, 1, whorls}]; 
vpoints = Table[{t[[k]],v[[k]]},{k, 1, whorls}]; 
yeqn = Fit[Log[ypoints], {1, logtheta}, logtheta]; 
zeqn = Fit[Log[zpoints], {1, logtheta}, logtheta]; 
heqn = Fit[Log[hpoints], {1, logtheta}, logtheta]; 
veqn = Fit[Log[vpoints], {1, logtheta}, logtheta]; 
ay = Exp[yeqn /. logtheta -> 0]; 
by = (yeqn /. logtheta -> 1) - Log[ay]; 
az = Exp[zeqn /. logtheta -> 0]; 
bz = (zeqn /. logtheta -> 1) - Log[az]; 
ah = Exp[heqn /. logtheta -> 0]; 
bh = (heqn /. logtheta -> 1) - Log[ah]; 
av = Exp[veqn /. logtheta -> 0]; 
bv = (veqn /. logtheta -> 1) - Log[av]; 
Print  @ StringJoin[ 
		ToString @ {ay, by}, 
		" are the allometric coefficient and exponent for the radial 
component of the aperture trajectory." 
]; 
Print  @ StringJoin[ 
		ToString @ {az, bz}, 
		" are the allometric coefficient and exponent for the abapical 
component of the aperture trajectory." 
]; 
Print  @ StringJoin[ 
	ToString @ {ah, bh}, 
		" are the allometric coefficient and exponent for the radial 
component of the aperture scaling." 
]; 
Print  @ StringJoin[ 
		ToString @ {av, bv}, 
		" are the allometric coefficient and exponent for the abapical 
component of the aperture scaling." 
]; 
Draw3D @ shell;  
] 


(*


^*)