if { [catch {

    # Load the LDAP package.
    package require LDAP
  
    # Connect to the LDAP Server and TCP Port.
    set result [LDAP_Connect "INSERT_SERVER_NAME" "389"]
    puts $result
    
    # Set the LDAP username and password (Optional, not needed for most directories)
    set result [LDAP_SetNamePassword "" ""]
    puts $result
    
    # Perform a search against a valid search base and search filter.
    set result [LDAP_Search "INSERT_DIRECTORY_BASE" (mail=*nichols*)]
    puts $result
    puts ""
    
    # Parse the LDAP record(s) returned in the TCL list.
    for {set j 0} {$j <[llength $result]} {incr j} {
        set myRecord [lindex $result $j]
        for {set i 0} {$i <[llength $myRecord] } {incr i 2} {
            puts "[lindex $myRecord $i]=[lindex $myRecord [expr $i + 1]]"
        }
        puts ""
    }

    # Unbind from the LDAP directory.
    set result [LDAP_Disconnect]
    puts $result
    
} doRequestCatch] } {
    puts $doRequestCatch"
}