# mxedit.search --
#	Definitions for the mxedit search/replace entry
#
# Copyright (c) 1992 Xerox Corporation.
# Use and copying of this software and preparation of derivative works based
# upon this software are permitted. Any distribution of this software or
# derivative works must comply with all applicmxFindable United States export
# control laws. This software is made available AS IS, and Xerox Corporation
# makes no warranty about the software, its performance or its conformity to
# any specification.

# File Globals
# mxFind - the name of the search/replace entry widget
# mxFindParent - needed to repack the find widget when making it visible
#	We assume this is the last child widget of the parent (pack append)
# mxSearchState - whether or not the search entry is visible

# Imported Globals
# focus - used to change the focus after a search command
# paleBackground - color for frame

proc mxSearchInit {} {
    global mxSearchState mxSearchString mxReplaceString
    set mxSearchState noFindTool
    set mxSearchString ""
    set mxReplaceString ""
}

# mxMakeFindTool --
#	This makes the search/replace entries

proc mxMakeFindTool { parent } {
    global paleBackground
    global mxFind mxFindParent
    set mxFind [selfName $parent ".find"]
    set mxFindParent $parent
    frame $mxFind -background $paleBackground -relief sunken -borderwidth 2
    mxPackFindTool
    labeledEntry $mxFind .target "Search:"  5 { left expand fillx frame w }
    mxSearchBindings $mxFind.target.entry
    labeledEntry $mxFind .replace "Replace:"  5 { right expand fillx frame w }
    mxReplaceBindings $mxFind.replace.entry
}

# mxPackFindTool --
proc mxPackFindTool {} {
    global mxFind mxFindParent
    pack append $mxFindParent $mxFind { bottom fillx }
}

# mxHideFindTool --
proc mxHideFindTool { } {
    global mxFind mxFindParent
    pack unpack $mxFind
}

# mxFind --
#	This ensures that the find window is visible
#	The find window can be either a popUp or a packed set of entries.

proc mxFind { } {
    global mxFocus
    global mxFind

    mxShowFind
    focus $mxFind.target.entry
    set mxFocus $mxFind.target.entry
    $mxFind.target.entry delete 0 end
}

proc mxFindClear { } {
    mxFind 
}

# searchFocus --
#	Set the focus on the search entry

proc mxSearchFocus { } {
    global mxFind
    if [catch {focus $mxFind.target.entry}] {
	mxShowFind
    }
}

# mxReplaceClear --
#	Clear the replace entry and move the focus there

proc mxReplaceClear { } {
    global mxFind
    mxShowFind
    focus $mxFind.replace.entry
    set focus $mxFind.replace.entry
    $mxFind.replace.entry delete 0 end
}

# mxReplaceFocus --
#	Focus on the replace entry

proc mxReplaceFocus { } {
    global mxFind
    if [catch {focus $mxFind.replace.entry}] {
	mxShowFind
    }
}

# mxShowFind --
#	Make sure the find window is visible
proc mxShowFind { } {
    global mxSearchState
    global mxFind 
    case $mxSearchState in {
	noFindTool {
	    set mxSearchState findTool
	    mxMakeFindTool "."
	    focus $mxFind.target.entry
	    return
	}
	findToolHidden {
	    set mxSearchState findTool
	    mxPackFindTool
	    focus $mxFind.target.entry
	    return
	}
	noPopUp {
	    set mxSearchState popUp
	    mxMakePopUp
	    focus $mxFind.target.entry
	    return
	}
	popUpHidden {
	    set mxSearchState popUp
	    wm deiconify $mxFind
	    mxPlacePopUp $mxFind off
	    focus $mxFind.target.entry
	    return
	}
	default {
#		mxEditFocus
	}
    }
}

# mxHideFind --
#	Hide the find window

proc mxHideFind {} {
    global mxSearchState
    case $mxSearchState in {
	popUp {
	    set mxSearchState popUpHidden
	    mxHidePopUp
	}
	findTool {
	    set mxSearchState findToolHidden
	    mxHideFindTool
	}
    }
}

# mxFindInner --
#	This makes calls to the search and replace mxedit functions
#	Because it is invoked from menus, it also makes sure that
#	the find window is visible

proc mxFindInner { op }  {
    global mxSearchState
    global mxFind
    global mxSearchString mxReplaceString

    # If we are not searching for the selection,
    # then make sure the find tool is visible
    if { ! [string match {[fb]*Sel} $op] } {
	mxShowFind
	set mxSearchString [$mxFind.target.entry get]
	if {[llength "$mxSearchString"] == 0} {
	    focus $mxFind.target.entry
	    mxFeedback "Enter search string"
	    return
	}
    }
    if [string match {repl*} $op] {
	set mxReplaceString [$mxFind.replace.entry get]
	if {[llength "$mxReplaceString"] == 0} {
	    focus $mxFind.replace.entry
	    mxFeedback "Enter replace string"
	    return
	}
    }
    mxEditFocus
    catch {
	case $op in {
	    forwSel {
		mxApplyToSelection {mxSearch forward}
	    }
	    backSel {
		mxApplyToSelection {mxSearch backward}
	    }
	    forward {
		mxSearch forward $mxSearchString
	    }
	    backward {
		mxSearch backward $mxSearchString
	    }
	    replace {
		mxReplace selection $mxReplaceString
	    }
	    replaceSel {
		mxReplace range sel.left sel.right $mxSearchString $mxReplaceString
	    }
	    replaceEverywhere {
		mxReplace range 1.0 [mxMark eof] $mxSearchString $mxReplaceString
	    }
	}
    } msg
    mxFeedback $msg
}

# mxMakePopUp --
#	This creates a search/replace dialog box
#	(THIS IS UNUSED - it should be moved into a separate
#	application that can be aimed at any mxedit window)

proc mxMakePopUp { } {
    global paleBackground
    global mxFile
    global mxFind

    set mxFind ".find"
    toplevel $mxFind -background $paleBackground -relief flat
    wm title $mxFind "Find in $mxFile"
    wm transient $mxFind

    buttonFrame $mxFind .buttons
    packedButton $mxFind.buttons .forward "Forward" 	{ mxFindInner forward }
    packedButton $mxFind.buttons .backward "Backward" 	{ mxFindInner backward }
    packedButton $mxFind.buttons .replace "Replace" 	{ mxFindInner replace }
    packedButton $mxFind.buttons .replaceSel "Rep. in Select." 	{ mxFindInner replaceSel }
    packedButton $mxFind.buttons .quit "Dismiss" 	{ mxHidePopUp } right
    labeledEntry $mxFind .target "Search for:"  42 { top frame w }
    mxSearchBindings $mxFind.target.entry
    labeledEntry $mxFind .replace "Replace with:"  40 { bottom frame w }
    mxReplaceBindings $mxFind.replace.entry

    mxPlacePopUp $mxFind off
}
proc mxHidePopUp {} {
    global mxSearchState
    global mxFind
    set mxSearchState popUpHidden
    wm withdraw $mxFind
}

