
// Simple test case for the objectify program.  Two objects are defined -- Foo,
// which has a few slots and methods, and Bar, which is a widget that doesn't
// do anything.  objectify will read this file and produce a file called
// test_objects.cc

extern "C" {
#include "tcl.h"
#include "tk.h"
#include "tkConfig.h"
#include "tkInt.h"
}

// This file is required to be able to interpret the TCL_ macros correctly for
// C++.

#include "objectify.h"

class TCL_OBJECT("foo", Foo, object, "This is a foo object.  It has no \
particular value in life.") {
  public:
    Foo(Tcl_Interp* interp) { }
    ~Foo() { }

    TCL_SLOT1(INT, int, i, "-i", "17", NULL, "number",
	      "A random integer value");
    TCL_SLOT1(DOUBLE, double, f, "-f", "13.31", NULL, "float value",
	      "A random floating-point value");
    
    TCL_METHOD("printall", PrintAllCmd, 0, 0, "", "Print some useful things") {
	char buf[64];
	sprintf(buf, "-i %d -f %f diff %f", i, f, d);
	Tcl_AppendResult(interp, buf, 0);
	return (TCL_OK);
    }
    TCL_METHOD("echo", EchoCmd, 0, -1, "word ...", "Print arguments");
 
    // There is no configure option for this object.
    
    TCL_METHOD("delete", DeleteCmd, 0, 0, "", "Delete the object");
    TCL_METHOD("help", HelpCmd, 0, -1, "topic ...", "Provide help.  \
This command takes the information given in the various documentation strings \
and returns it as a result, depending on the topic argument.  The same \
information is also written to the file test_objects.doc.");
    
    int AfterConfigure(Tcl_Interp* interp);
    
  private:
    float d;
};

class TCL_OBJECT("bar", Bar, widget, "This is a bar widget") {
  public:
    Bar(Tcl_Interp* interp, Tk_Window win) {
	tkwin = win;
	bgBorder = NULL;
	bgColor = NULL;
	cursor = NULL;
	redraw_pending = 0;
    }
    ~Bar() { }
    
    TCL_SLOT1(BORDER, Tk_3DBorder, bgBorder, "-bg", "black", NULL,
	      "color", "Color of the border");
    TCL_SLOT1(COLOR,  XColor*, bgColor, NULL, NULL, NULL, "", "");
    TCL_SLOT(RELIEF, int, relief, "-relief", "relief", "Relief", "flat", 0,
	     NULL, "relief-value", "The relief to use for the object");
    TCL_SLOT1(PIXELS, int, borderwidth, "-bw", "0", NULL, "pixels",
	      "Width of the border");
    TCL_SLOT1(PIXELS, int, height, "-height", "100", NULL, "pixels",
	      "Height of the window");
    TCL_SLOT1(PIXELS, int, width, "-width", "100", NULL, "pixels",
	      "Width of the window");
    TCL_SLOT(ACTIVE_CURSOR, Cursor, cursor, "-cursor", "cursor", "Cursor",
	     NULL, TK_CONFIG_NULL_OK, NULL, "cursor spec",
	     "Cursor to use in the window");
    
    TCL_METHOD("configure", ConfigureCmd, 0, -1, "option ...",
	       "Configure the widget");
    
    // No delete method for this object -- we can use destroy instead.

    TCL_METHOD("help", HelpCmd, 0, -1, "topic ...", "Provide help");
    
    int AfterConfigure(Tcl_Interp* interp);
    
    friend static void DisplayBar(ClientData cl);
    
  private:
    Tk_Window tkwin;
    int redraw_pending;

    void Draw();
};

