/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.util.Hashtable;
import tcl.lang.Channel;
import tcl.lang.Interp;
import tcl.lang.StdChannel;
import tcl.lang.TclRuntimeError;

class TclIO {
    static final int READ_ALL = 1;
    static final int READ_LINE = 2;
    static final int READ_N_BYTES = 3;
    static final int SEEK_SET = 1;
    static final int SEEK_CUR = 2;
    static final int SEEK_END = 3;
    static final int RDONLY = 1;
    static final int WRONLY = 2;
    static final int RDWR = 4;
    static final int APPEND = 8;
    static final int CREAT = 16;
    private static StdChannel stdinChan = null;
    private static StdChannel stdoutChan = null;
    private static StdChannel stderrChan = null;

    static Channel getChannel(Interp interp, String chanName) {
        Channel chan = null;
        if (chanName.length() > 0 && chanName.charAt(0) == 's') {
            if (chanName.equals("stdin")) {
                chan = TclIO.getStdChannel(0);
            } else if (chanName.equals("stdout")) {
                chan = TclIO.getStdChannel(1);
            } else if (chanName.equals("stderr")) {
                chan = TclIO.getStdChannel(2);
            }
            if (chan != null) {
                chanName = chan.getChanName();
            }
        }
        Hashtable chanTable = TclIO.getInterpChanTable(interp);
        return (Channel)chanTable.get(chanName);
    }

    static void registerChannel(Interp interp, Channel chan) {
        if (interp != null) {
            Hashtable chanTable = TclIO.getInterpChanTable(interp);
            chanTable.put(chan.getChanName(), chan);
        }
    }

    static void unregisterChannel(Interp interp, Channel chan) {
        Hashtable chanTable = TclIO.getInterpChanTable(interp);
        chanTable.remove(chan.getChanName());
    }

    static Hashtable getInterpChanTable(Interp interp) {
        if (interp.interpChanTable == null) {
            interp.interpChanTable = new Hashtable();
            Channel chan = TclIO.getStdChannel(0);
            TclIO.registerChannel(interp, chan);
            chan = TclIO.getStdChannel(1);
            TclIO.registerChannel(interp, chan);
            chan = TclIO.getStdChannel(2);
            TclIO.registerChannel(interp, chan);
        }
        return interp.interpChanTable;
    }

    static Channel getStdChannel(int type) {
        StdChannel chan = null;
        switch (type) {
            case 0: {
                if (stdinChan == null) {
                    stdinChan = new StdChannel(0);
                }
                chan = stdinChan;
                break;
            }
            case 1: {
                if (stdoutChan == null) {
                    stdoutChan = new StdChannel(1);
                }
                chan = stdoutChan;
                break;
            }
            case 2: {
                if (stderrChan == null) {
                    stderrChan = new StdChannel(2);
                }
                chan = stderrChan;
                break;
            }
            default: {
                throw new TclRuntimeError("Invalid type for StdChannel");
            }
        }
        return chan;
    }

    TclIO() {
    }
}

