/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.beans.BeanInfo;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import tcl.lang.InternalRep;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclObject;
import tcl.lang.reflect.PkgInvoker;

class PropertySig
extends InternalRep {
    Class targetCls;
    PropertyDescriptor desc;
    PkgInvoker pkgInvoker;

    PropertySig(Class c, PkgInvoker i, PropertyDescriptor d) {
        this.targetCls = c;
        this.pkgInvoker = i;
        this.desc = d;
    }

    protected InternalRep duplicate() {
        return new PropertySig(this.targetCls, this.pkgInvoker, this.desc);
    }

    static PropertySig get(Interp interp, Class targetCls, TclObject signature) throws TclException {
        PropertyDescriptor desc;
        String propName;
        block8: {
            BeanInfo beanInfo;
            InternalRep rep = signature.getInternalRep();
            if (rep instanceof PropertySig && targetCls == ((PropertySig)rep).targetCls) {
                return (PropertySig)rep;
            }
            propName = signature.toString();
            desc = null;
            try {
                beanInfo = Introspector.getBeanInfo(targetCls);
            }
            catch (IntrospectionException introspectionException) {
                break block8;
            }
            PropertyDescriptor[] descriptors = beanInfo.getPropertyDescriptors();
            if (descriptors != null) {
                int i = 0;
                while (i < descriptors.length) {
                    if (descriptors[i].getName().equals(propName)) {
                        if (descriptors[i] instanceof IndexedPropertyDescriptor) {
                            throw new TclException(interp, "can't access indexed property \"" + propName + "\": not implemented");
                        }
                        desc = descriptors[i];
                        break;
                    }
                    ++i;
                }
            }
        }
        if (desc == null) {
            throw new TclException(interp, "unknown property \"" + propName + "\"");
        }
        PropertySig sig = new PropertySig(targetCls, PkgInvoker.getPkgInvoker(targetCls), desc);
        signature.setInternalRep(sig);
        return sig;
    }
}

