/* const.h - constants for db */

/* general constants */

#define FALSE 0
#define NULL  0
#define TRUE  1

/* C tricks */

#define EXTERN  extern
#define FORWARD
#define PRIVATE static
#define PUBLIC

/* ASCII codes */

#define CAN  24
#define CR   13
#define EOF  (-1)
#define LF   10
#define XOFF 19

/* hardware processor-specific for 8088 through 80386 */

#define CLICK_SIZE     0x10
#define IF           0x0200     /* interrupt disable bit in flags */
#define INT_BREAKPOINT 0xcc     /* byte for breakpoint interrupt */
#define TF           0x0100     /* trap bit in flags */

/* use hardware codes for segments for simplest decoding */

#define CSEG 0x2E               /* 8088 through 80386 */
#define DSEG 0x3E
#define ESEG 0x26
#define FSEG 0x64
#define GSEG 0x65               /* 80386 only */
#define SSEG 0x36

/* hardware machine-specific for PC family */

#define I_COMMAND_PORT 0x20     /* interrupt command port (attached to 8259) */
#  define I_DATA_READY 0x80     /* bit to signal polled data ready */
#  define I_EOI        0x20     /* bits to signal end of interrupt (or poll) */
#  define I_KBD           2     /* 2^(interrupt number of keyboard for 8259) */
#  define I_OCW3          8     /* bit to select OCW3 */
#  define I_POLL          4     /* bit to select polling in OCW3 */
#define I_MASK_PORT    0x21     /* interrupt mask port */

/* software machine-specific for PC family */

#define BIOS_DATA_SEG  0x40
#  define KB_FLAG      0x17     /* offset to 16-bits of keyboard shift flags */

/* switches to handle non-conforming compilers */

#define void int                /* compiler has no void type */
#define UCHAR_BUG		/* compiler converts unsigned chars wrong */

#ifdef UCHAR_BUG
#  define UCHAR( x )   ((x) & 0xFF)
#endif
