\ object.f for advtr.f  Leo Wong 10 June 02003 fyj +
\ Do things to an object

: carry-object ( object where -- )
   \ Start toting an object, removing it from the list of things at its
   \ former location.  Incr holdng unless it was already being toted.
   \ If object>100 (moving "fixed" second loc), don't change place or
   \ holdng.
   >R 
   DUP 100 > 0= IF DUP place @ -1 = IF R> 2DROP EXIT THEN
                   -1 OVER place !  holdng 1+ TO holdng
                THEN  
   DUP R@ atloc @ = IF link @ R> atloc ! EXIT THEN 
   R> atloc @ SWAP >R 
   BEGIN DUP link @ R@ <> WHILE link @ REPEAT R> link @ SWAP link ! ;

: drop-object  ( object where -- )
   \ Place an object at a given loc, prefixing it onto the atloc list.
   \ Decr holdng if the object is being toted.
   >R  DUP 100 >
   IF DUP 100 - fixed
   ELSE DUP place @ -1 = IF holdng 1- TO holdng THEN DUP place THEN
   R@ SWAP !
   R@ 0> IF R@ atloc @ OVER link !  R> atloc ! ELSE R> 2DROP THEN ;

: move-object  ( object where -- )
   \ Place any object anywhere by picking it up and dropping it.  May
   \ already be toting, in which case the carry is a noop.  Musn't
   \ pick up objects which are not at any loc, since carry wants to
   \ remove objects from atloc chains.
   >R DUP DUP 100 > IF 100 - fixed ELSE place THEN @
   DUP 1 300 WITHIN IF OVER SWAP carry-object ELSE DROP THEN
   R> drop-object ;

: put-object ( object where pval )
   \ Same as move, but returns a value used to set up the negated prop
   \ values for the repository objects
   >R move-object -1 R> - ;

\ destroy-object Permanently eliminate object by moving to a
\   non-existent location.
: destroy-object ( object -- )
   0 move-object ;

\ juggle-object Pick up object and put it down again to get it to the
\   front of the chain of things at its loc.
: juggle-object ( object -- )
   >R 
   R@ place @ R@ fixed @ R@ ROT move-object R> 100 + SWAP move-object ;

      