//
//  GlkWriteBufferedStream.m
//  CocoaGlk
//
//  Created by Andrew Hunter on Mon Jun 16 2003.
//  Copyright (c) 2003 __MyCompanyName__. All rights reserved.
//

#import "GlkWriteBufferedStream.h"
#define maxWriteLen 1024

@implementation GlkWriteBufferedStream

- (id) initWithStream: (GlkStream*) stream {
    self = [super init];

    if (self) {
        writeBuffer = [[NSMutableData allocWithZone: [self zone]] init];
        bufferedStream = [stream retain];

        [[NSNotificationCenter defaultCenter] addObserver: self
                                                 selector: @selector(flushBuffers)
                                                     name: GlkFlushYourBuffers
                                                   object: nil]; 
    }

    return self;
}

- (void) dealloc {
    [bufferedStream release];
    [writeBuffer release];

    [[NSNotificationCenter defaultCenter] removeObserver: self];

    [super dealloc];
}

- (void) flushBuffers {
    if ([writeBuffer length] > 0) {
        [bufferedStream putBuffer: writeBuffer];
        [writeBuffer release];
        writeBuffer = [[NSMutableData allocWithZone: [self zone]] init];
    }
}

- (stream_result_t) close {
    [self flushBuffers];
    return [bufferedStream close];
}

- (glui32) rock {
    return [bufferedStream rock];
}

- (void) setPosition: (glsi32) pos
            withMode: (glui32) seekMode {
    [self flushBuffers];
    [bufferedStream setPosition: pos
                       withMode: seekMode];
}

- (glui32) getPosition {
    return [bufferedStream getPosition];
}

- (void) putChar: (unsigned char) ch {
    [writeBuffer appendBytes: &ch
                      length: 1];
}

- (void)       putBuffer: (NSData*) buffer {
    [writeBuffer appendData: buffer];

    if ([writeBuffer length] > maxWriteLen) {
        [self flushBuffers];
    }
}

- (void)       setGlkStyle: (glui32) styl {
    [self flushBuffers];
    [bufferedStream setGlkStyle: styl];
}

- (glsi32) getChar {
    return [bufferedStream getChar];
}

- (NSData*) getLineInBuffer: (int) length {
    return [bufferedStream getLineInBuffer: length];
}

- (NSData*) getBuffer: (int) length {
    return [bufferedStream getBuffer: length];
}

@end

