{ ------------------------------------------------------------------------ }
{ --------------------------- Unidad U_CUTRA ----------------------------- }
{ ------------------------ Alberto Salazar Palomo ------------------------ }
{ ------------------------- Navigator Soft 1997 -------------------------- }
{ ------------------------------------------------------------------------ }
UNIT U_CUTRA;

INTERFACE

USES CRT,VGA256,U_PRINT,U_FUENTE;

CONST
 MAXPSI=100;
 MAXOBJ=100;  {  CAMBIA ESTOS NUMEROS SEGUN TU AVENTURA !!! }
 MAXLOC=150;

TYPE
 OBJETO = RECORD
             NOMBRE:STRING[40];
             PESO:INTEGER;
             LOCALIDAD:INTEGER;
            END;

 PSI = RECORD
          NOMBRE:STRING[40];
          PESO:INTEGER;
          LOCALIDAD:INTEGER;
         END;

 DIRECCIONES = RECORD
                NORTE,SUR,ESTE,OESTE:BYTE;
               END;

 PSIs=ARRAY [1..MAXPSI] OF PSI;
 OBJS=ARRAY [1..MAXOBJ] OF OBJETO;
 CARDINALES=ARRAY [0..MAXLOC] OF DIRECCIONES;

VAR
 CACA:STRING;                           { PARA LO QUE NO NOS INTERESE... }
 OTOTAL:INTEGER;                        { N TOTAL DE OBJETOS }
 PTOTAL:INTEGER;                        { N TOTAL DE PSIs }

PROCEDURE A_COGER(N,PANTALLA,PMAXIMO:INTEGER; VAR PESO:INTEGER; VAR OBJETOS:OBJS; FUENTE:T_FUENTE);
{ ESTA SIRVE PARA COGER EL OBJETO N A, PMAXIMO ES EL PESO MAXIMO, PESO ES EL PESO QUE LLEVAS Y OBJETOS ES LA LISTA DE OBJETOS}
{HEY! FIJATE EN UNA AVENTURA .PAS Y AHI TE ENTERAS!}

PROCEDURE A_DEJAR(N,PANTALLA,PMAXIMO:INTEGER; VAR PESO:INTEGER; VAR OBJETOS:OBJS; FUENTE:T_FUENTE);
{ CASI IGUAL QUE LO DE ARRIBA EXCEPTO QUE ESTO DEJA LOS OBJETOS }

PROCEDURE INI_OBJETO(ONUMERO:INTEGER; ONOMBRE:STRING; OPESO,OLOCALIDAD:INTEGER; VAR OBJETOS:OBJS);
{ ESTO INICIA LAS VARIABLES DEL OBJETO QUE SE INDIQUE }

PROCEDURE INI_PSI(PNUMERO:INTEGER; PNOMBRE:STRING; PLOCALIDAD:INTEGER; VAR TIOS:PSIs);
{ ESTO INICIA LAS VARIABLES DEL PSI QUE SE INDIQUE }

PROCEDURE LEE(VAR CADENA:STRING; PU:POINTER; FUENTE:T_FUENTE);
{ ESTO ES UNA ESPECIE DE INPUT }

FUNCTION  VER (PANTALLA:INTEGER; OBJETOS:OBJS; TIOS:PSIs):BOOLEAN;
{ SI ES TRUE QUIERE DECIR QUE HAY "ALGO" EN LA LOCALIDAD N PANTALLA }

PROCEDURE LISTA (PANTALLA:INTEGER; OBJETOS:OBJS; TIOS:PSIs; FUENTE:T_FUENTE);
{ ESTO LISTA TODO LO QUE HAYA EN UNA LOCALIDAD }

PROCEDURE PREPARA_CADENA (VAR CADENA,VERVO,NOMBRE:STRING);
{ NOS PREPARA LA CADENA, LE QUITA LOS ARTICULOS, LO PONE EN MAYUSCULAS... }

PROCEDURE ACTU_HORA (VAR HORAS,MINUTOS,DIA:INTEGER);
{ NOS ACTUALIZA LA HORA }

PROCEDURE DEFINIR_SALIDAS(LOCALIDAD:INTEGER; N,S,E,O:BYTE; VAR SALIDAS:CARDINALES);
{ PARA DEFINIR LAS SALIDAS DE UNA LOCALIDAD }

PROCEDURE RESPUESTAS_SALIDAS (S:STRING; VAR FALLA,MIRAR,PANTALLA:BYTE; SALIDAS:CARDINALES);
{ NOS SIRVE PARA LAS REPUESTAS REFERENTES A LAS DIRECCIONES ( NORTE,SUR... ) }

IMPLEMENTATION

{-----------------------------------------------------------------------------}
PROCEDURE A_COGER(N,PANTALLA,PMAXIMO:INTEGER; VAR PESO:INTEGER; VAR OBJETOS:OBJS; FUENTE:T_FUENTE);
VAR
  CONTA:INTEGER;

BEGIN
 PESO:=0;
 FOR CONTA:=1 TO OTOTAL DO
 BEGIN
  IF OBJETOS[CONTA].LOCALIDAD=200 THEN PESO:=PESO+OBJETOS[CONTA].PESO;
 END;

 IF OBJETOS[N].LOCALIDAD=PANTALLA THEN
   BEGIN
    IF (PESO+OBJETOS[N].PESO)<PMAXIMO THEN
     BEGIN
      OBJETOS[N].LOCALIDAD:=200;
      PRINT('Coges '+OBJETOS[N].NOMBRE+'.',x,y,fuente);
     END ELSE PRINT('No puedes llevar mas cosas.',x,y,fuente);
   END ELSE
 IF OBJETOS[N].LOCALIDAD=200 THEN PRINT('Ya tenias '+OBJETOS[N].NOMBRE+'.',x,y,fuente) ELSE
 PRINT('Aqui no hay '+OBJETOS[N].NOMBRE+'.',x,y,fuente);
END;
{-----------------------------------------------------------------------------}
PROCEDURE A_DEJAR(N,PANTALLA,PMAXIMO:INTEGER; VAR PESO:INTEGER; VAR OBJETOS:OBJS; FUENTE:T_FUENTE);
VAR
 CONTA:INTEGER;

BEGIN
 PESO:=0;
 FOR CONTA:=1 TO OTOTAL DO
 BEGIN
  IF OBJETOS[CONTA].LOCALIDAD=200 THEN PESO:=PESO+OBJETOS[CONTA].PESO;
 END;

 IF OBJETOS[N].LOCALIDAD=200 THEN
  BEGIN
   OBJETOS[N].LOCALIDAD:=PANTALLA;
   PRINT('Dejas '+OBJETOS[N].NOMBRE+'.',x,y,fuente);
  END ELSE
  PRINT('No puedes dejar '+OBJETOS[N].NOMBRE+'.',x,y,fuente);
END;
{-----------------------------------------------------------------------------}
PROCEDURE INI_OBJETO(ONUMERO:INTEGER; ONOMBRE:STRING; OPESO,OLOCALIDAD:INTEGER; VAR OBJETOS:OBJS);
BEGIN
 WITH OBJETOS[ONUMERO] DO
   BEGIN
    NOMBRE:=ONOMBRE;
    PESO:=OPESO;
    LOCALIDAD:=OLOCALIDAD;
   END;
END;
{-----------------------------------------------------------------------------}
PROCEDURE INI_PSI(PNUMERO:INTEGER; PNOMBRE:STRING; PLOCALIDAD:INTEGER; VAR TIOS:PSIs);
BEGIN
 WITH TIOS[PNUMERO] DO
   BEGIN
    NOMBRE:=PNOMBRE;
    LOCALIDAD:=PLOCALIDAD;
   END;
END;
{-----------------------------------------------------------------------------}
PROCEDURE LEE(VAR CADENA:STRING; PU:POINTER; FUENTE:T_FUENTE);
VAR
 CH:CHAR;

BEGIN
 CADENA:='';
 Y:=Y_CURSOR;
 X:=1;
 PRINTLN('> ',X,Y,FUENTE);
 SAVESCREEN(PU);

 REPEAT
  Y:=Y_CURSOR;
  CH:=READKEY;

  SETVGAOUT(PU);
   BOX(1,CONV(Y_CURSOR),319,CONV(Y_CURSOR+1),0);

   IF (ORD(CH)=8) THEN DELETE(CADENA,(LENGTH(CADENA)),1) ELSE
   IF (ORD(CH)<>13) AND (ORD(CH)<>8) THEN CADENA:=CADENA+CH;

   PRINTLN('>'+CADENA+'',X,Y,FUENTE);

   WAITVBL;
   RESTOREVGAOUT;
   RESTORESCREEN(PU);

 UNTIL (ORD(CH)=13) AND (CADENA<>'');

 SETVGAOUT(PU);
  BOX(0,CONV(Y_TEXTO),319,CONV(Y_CURSOR+1),0);
  WAITVBL;
 RESTOREVGAOUT;
 RESTORESCREEN(PU);
 Y:=Y_TEXTO;
END;
{-----------------------------------------------------------------------------}
FUNCTION VER (PANTALLA:INTEGER; OBJETOS:OBJS; TIOS:PSIs):BOOLEAN;
VAR
 CONTA:INTEGER;

BEGIN
 VER:=FALSE;
 FOR CONTA:=1 TO OTOTAL DO WITH OBJETOS[CONTA] DO IF (LOCALIDAD=PANTALLA) THEN
 VER:=TRUE;

 FOR CONTA:=1 TO PTOTAL DO WITH TIOS[CONTA] DO IF (LOCALIDAD=PANTALLA) THEN
 VER:=TRUE;
END;
{-----------------------------------------------------------------------------}
PROCEDURE LISTA (PANTALLA:INTEGER; OBJETOS:OBJS; TIOS:PSIs; FUENTE:T_FUENTE);
VAR
 CONTA,LONGITUD:INTEGER;

BEGIN
 FOR CONTA:=1 TO OTOTAL DO
    BEGIN
     WITH OBJETOS[CONTA] DO
      BEGIN
       IF LOCALIDAD=PANTALLA THEN
         BEGIN
          LONGITUD:=39-X;
          IF LENGTH(NOMBRE)<=LONGITUD THEN PRINT(NOMBRE+',',X,Y,FUENTE) ELSE
            BEGIN
             X:=1;
             Y:=Y+1;
             PRINT(NOMBRE+',',X,Y,FUENTE);
            END;
         END;
      END;
    END;

 FOR CONTA:=1 TO PTOTAL DO
    BEGIN
     WITH TIOS[CONTA] DO
      BEGIN
       IF LOCALIDAD=PANTALLA THEN
         BEGIN
          LONGITUD:=39-X;
          IF LENGTH(NOMBRE)<=LONGITUD THEN PRINT(NOMBRE+',',X,Y,FUENTE) ELSE
            BEGIN
             X:=1;
             Y:=Y+1;
             PRINT(NOMBRE+',',X,Y,FUENTE);
            END;
         END;
      END;
    END;

 X:=X-1;
 BOX(CONV(X),CONV(Y),CONV(X+1),CONV(Y+1),0);
 PRINT('.',X,Y,FUENTE);
END;
{-----------------------------------------------------------------------------}
PROCEDURE PREPARA_CADENA (VAR CADENA,VERVO,NOMBRE:STRING);
VAR
 RESULTADO:STRING;
 CONTA:INTEGER;
 AUX:STRING;

BEGIN
 AUX:='';
 RESULTADO:='';
 FOR CONTA:=1 TO LENGTH(CADENA) DO CADENA[CONTA]:=UPCASE(CADENA[CONTA]);
 { PONEMOS EN MAYUSCULAS }

 IF POS(' ',CADENA)<>0 THEN VERVO:=COPY(CADENA,1,POS(' ',CADENA)-1) ELSE VERVO:=CADENA;
 { SACAMOS EL VERVO }

  REPEAT
   AUX:=COPY(CADENA,1,POS(' ',CADENA));
   DELETE(CADENA,1,POS(' ',CADENA));

   IF (AUX='UN ') OR (AUX='UNA ') OR (AUX='UNOS ') OR (AUX='UNAS ') OR
   (AUX='LA ') OR (AUX='EL ') OR (AUX='LAS ') OR (AUX='LOS ') OR (AUX='AL ')
   OR (AUX='DEL ')OR (AUX='A ') OR (AUX='CON ') OR (AUX='DE ') OR (AUX='EN ')
   OR (AUX='PARA ') OR (AUX='POR ') OR (AUX='SIN ') THEN AUX:='';
   { AADE TODAS LAS QUE QUIERAS... }

   RESULTADO:=RESULTADO+AUX;
  UNTIL (POS(' ',CADENA)=0);

 RESULTADO:=RESULTADO+CADENA;
 AUX:=RESULTADO;
 DELETE(AUX,1,POS(' ',AUX));
 IF POS(' ',CADENA)<>0 THEN NOMBRE:=COPY(AUX,1,POS(' ',AUX)-1) ELSE NOMBRE:=AUX;
 CADENA:=RESULTADO;
END;
{-----------------------------------------------------------------------------}
PROCEDURE ACTU_HORA(VAR HORAS,MINUTOS,DIA:INTEGER);
BEGIN
 IF MINUTOS<>59 THEN
   BEGIN
    MINUTOS:=MINUTOS+1;
   END ELSE
   BEGIN
    IF HORAS=23 THEN
      BEGIN
       HORAS:=0;
       DIA:=DIA+1;
      END ELSE HORAS:=HORAS+1;
    MINUTOS:=0;
   END;
END;
{-----------------------------------------------------------------------------}
PROCEDURE DEFINIR_SALIDAS(LOCALIDAD:INTEGER; N,S,E,O:BYTE; VAR SALIDAS:CARDINALES);
BEGIN
 WITH SALIDAS[LOCALIDAD] DO
  BEGIN
   NORTE:=N;
   SUR:=S;
   ESTE:=E;
   OESTE:=O;
  END;
END;
{-----------------------------------------------------------------------------}
PROCEDURE RESPUESTAS_SALIDAS(S:STRING; VAR FALLA,MIRAR,PANTALLA:BYTE; SALIDAS:CARDINALES);
BEGIN
 WITH SALIDAS[PANTALLA] DO
  BEGIN
   IF NORTE<>0 THEN IF (S='NORTE') OR (S='N') THEN BEGIN PANTALLA:=NORTE; FALLA:=1; MIRAR:=0; END;
   IF SUR<>0 THEN IF (S='SUR') OR (S='S') THEN BEGIN PANTALLA:=SUR; FALLA:=1;  MIRAR:=0; END;
   IF ESTE<>0 THEN IF (S='ESTE') OR (S='E') THEN BEGIN PANTALLA:=ESTE; FALLA:=1; MIRAR:=0; END;
   IF OESTE<>0 THEN IF (S='OESTE') OR (S='O') THEN BEGIN PANTALLA:=OESTE; FALLA:=1; MIRAR:=0; END;
  END;
END;
{-----------------------------------------------------------------------------}
END.