/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.parsers;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public abstract class SAXParserFactory {
    private static final String defaultPropName = "javax.xml.parsers.SAXParserFactory";
    private boolean validating = false;
    private boolean namespaceAware = false;
    private static String foundFactory = null;
    private static boolean debug = false;
    static /* synthetic */ Class class$javax$xml$parsers$SAXParserFactory;

    protected SAXParserFactory() {
    }

    public static SAXParserFactory newInstance() {
        String factoryImplName = SAXParserFactory.findFactory(defaultPropName, "org.apache.crimson.jaxp.SAXParserFactoryImpl");
        if (factoryImplName == null) {
            throw new FactoryConfigurationError("No default implementation found");
        }
        SAXParserFactory factoryImpl = null;
        try {
            Class<?> clazz = Class.forName(factoryImplName);
            factoryImpl = (SAXParserFactory)clazz.newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            throw new FactoryConfigurationError(cnfe);
        }
        catch (IllegalAccessException iae) {
            throw new FactoryConfigurationError(iae);
        }
        catch (InstantiationException ie) {
            throw new FactoryConfigurationError(ie);
        }
        return factoryImpl;
    }

    public abstract SAXParser newSAXParser() throws ParserConfigurationException, SAXException;

    public void setNamespaceAware(boolean awareness) {
        this.namespaceAware = awareness;
    }

    public void setValidating(boolean validating) {
        this.validating = validating;
    }

    public boolean isNamespaceAware() {
        return this.namespaceAware;
    }

    public boolean isValidating() {
        return this.validating;
    }

    public abstract void setFeature(String var1, boolean var2) throws ParserConfigurationException, SAXNotRecognizedException, SAXNotSupportedException;

    public abstract boolean getFeature(String var1) throws ParserConfigurationException, SAXNotRecognizedException, SAXNotSupportedException;

    private static String findFactory(String factoryId, String defaultFactory) {
        block17: {
            block16: {
                if (foundFactory != null) {
                    return foundFactory;
                }
                try {
                    foundFactory = System.getProperty(factoryId);
                    if (foundFactory != null) {
                        if (debug) {
                            System.err.println("JAXP: found system property" + foundFactory);
                        }
                        return foundFactory;
                    }
                }
                catch (SecurityException se) {
                    // empty catch block
                }
                try {
                    String javah = System.getProperty("java.home");
                    String configFile = javah + File.separator + "lib" + File.separator + "jaxp.properties";
                    File f = new File(configFile);
                    if (f.exists()) {
                        Properties props = new Properties();
                        props.load(new FileInputStream(f));
                        foundFactory = props.getProperty(factoryId);
                        if (debug) {
                            System.err.println("JAXP: found java.home property " + foundFactory);
                        }
                        if (foundFactory != null) {
                            return foundFactory;
                        }
                    }
                }
                catch (Exception ex) {
                    if (!debug) break block16;
                    ex.printStackTrace();
                }
            }
            String serviceId = "META-INF/services/" + factoryId;
            try {
                ClassLoader cl = (class$javax$xml$parsers$SAXParserFactory == null ? (class$javax$xml$parsers$SAXParserFactory = SAXParserFactory.class$(defaultPropName)) : class$javax$xml$parsers$SAXParserFactory).getClassLoader();
                InputStream is = null;
                is = cl == null ? ClassLoader.getSystemResourceAsStream(serviceId) : cl.getResourceAsStream(serviceId);
                if (is != null) {
                    if (debug) {
                        System.err.println("JAXP: found  " + serviceId);
                    }
                    BufferedReader rd = new BufferedReader(new InputStreamReader(is));
                    foundFactory = rd.readLine();
                    rd.close();
                    if (debug) {
                        System.err.println("JAXP: loaded from services: " + foundFactory);
                    }
                    if (foundFactory != null && !"".equals(foundFactory)) {
                        return foundFactory;
                    }
                }
            }
            catch (Exception ex) {
                if (!debug) break block17;
                ex.printStackTrace();
            }
        }
        return defaultFactory;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            debug = System.getProperty("jaxp.debug") != null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

