/*
 * Decompiled with CFR 0.152.
 */
package unity.predicates;

import java.io.IOException;
import java.util.Comparator;
import unity.relational.Relation;
import unity.relational.Tuple;

public class SortComparator
implements Comparator {
    protected int[] attrLocs;
    protected boolean[] sortAsc;
    protected int numAttrs;

    public SortComparator() {
    }

    public SortComparator(int[] idx, boolean[] sa) {
        this.attrLocs = idx;
        this.sortAsc = sa;
        this.numAttrs = idx.length;
    }

    public void shiftComparator(int i) {
        int j = 0;
        while (j < this.numAttrs) {
            int n = j++;
            this.attrLocs[n] = this.attrLocs[n] + i;
        }
    }

    public int compare(Object o1, Object o2) {
        try {
            return this.sqlcompare(o1, o2);
        }
        catch (IOException e) {
            System.out.println(e);
            return 0;
        }
    }

    public int sqlcompare(Object o1, Object o2) throws IOException {
        Tuple t1 = (Tuple)o1;
        Tuple t2 = (Tuple)o2;
        int i = 0;
        while (i < this.numAttrs) {
            int val;
            Comparable c1 = (Comparable)t1.getObject(this.attrLocs[i]);
            Comparable c2 = (Comparable)t2.getObject(this.attrLocs[i]);
            if (c1 == null || c2 == null) {
                if (c1 == null && c2 == null) {
                    return 0;
                }
                val = 1;
                val = c1 == null ? -1 : 1;
                if (!this.sortAsc[i]) {
                    val *= -1;
                }
                return val;
            }
            val = c1.compareTo(c2);
            if (this.sortAsc[i]) {
                if (val > 0) {
                    return 1;
                }
                if (val < 0) {
                    return -1;
                }
            } else {
                if (val < 0) {
                    return 1;
                }
                if (val > 0) {
                    return -1;
                }
            }
            ++i;
        }
        return 0;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(100);
        sb.append("Attr: " + this.attrLocs[0]);
        if (this.sortAsc[0]) {
            sb.append(" ASC");
        } else {
            sb.append(" DESC");
        }
        int i = 1;
        while (i < this.attrLocs.length) {
            sb.append(", Attr: " + this.attrLocs[i]);
            if (this.sortAsc[i]) {
                sb.append(" ASC");
            } else {
                sb.append(" DESC");
            }
            ++i;
        }
        return sb.toString();
    }

    public String toString(Relation relation) {
        StringBuffer sb = new StringBuffer(100);
        sb.append(relation.getAttribute(this.attrLocs[0]).getName());
        if (this.sortAsc[0]) {
            sb.append(" ASC");
        } else {
            sb.append(" DESC");
        }
        int i = 1;
        while (i < this.attrLocs.length) {
            sb.append(", " + relation.getAttribute(this.attrLocs[i]).getName());
            if (this.sortAsc[i]) {
                sb.append(" ASC");
            } else {
                sb.append(" DESC");
            }
            ++i;
        }
        return sb.toString();
    }
}

