#define INCL_RXFUNC       /* external function values */
#define INCL_VIO
#include <rexxsaa.h>
#include <iostream.h>
#include <string.h>



ULONG _System SysCls(UCHAR *name, ULONG numargs, RXSTRING args[],
                    PSZ *queuename, RXSTRING *retstr);


ULONG _System SysCls(UCHAR *name, ULONG numargs, RXSTRING args[],
                    PSZ *queuename, RXSTRING *retstr)
{
  BYTE bCell[2];

// If arguments, return non-zero to indicate error
  if (numargs)
    return 1;

  bCell[0] = 0x20;                     /* Space Character            */
  bCell[1] = 0x07;                     /* Default Attrib             */
  VioScrollDn( 0, 0, (USHORT)0xFFFF, (USHORT)0XFFFF,
                     (USHORT)0xFFFF, bCell, (HVIO) 0);/* CLS         */
  VioSetCurPos(0, 0, (HVIO) 0);        /*                Pos cursor  */

//return "0" to the caller
  retstr->strlength=1;
  strcpy(retstr->strptr,"0");


  return 0;
}


int main(){
  char Input[200];
  LONG      return_code;  /* interpreter return code    */
  RXSTRING  argv[1];      /* program argument string    */
  RXSTRING  retstr;       /* program return value       */
  SHORT     rc;           /* converted return code      */
  RXSTRING  INSTORE[2];
  char      Prog[]=
       "/* RexxSamp.cmd   */\r\n" 
       "/* Sample EDM/2 REXX program by Gordon Zeglinski */\r\n" 
       "\r\n" 
       "Call RxFuncAdd \'SysSleep\', \'REXXUTIL\', \'SysSleep\'\r\n"
       "\r\n" 
       "say \"Sample EDM/2 REXX program started\"\r\n" 
       "\r\n"
       "/*execute a cmd based command */\r\n" 
       "\'dir /w\'\r\n" 
       "\r\n" 
       "/* wait 5 seconds */\r\n" 
       "Call SysSleep 5\r\n" 
       "\r\n" 
       "/*clear screen using sample function */\r\n" 
       "call EDM_SysCls\r\n" 
       "\r\n" 
       "say\r\n" 
       "say\r\n" 
       "say \"Screen cleared by sample external REXX function\"\r\n\x1A";


  RexxRegisterFunctionExe((PSZ)"EDM_SysCls",(PFN) &SysCls);


  INSTORE[0].strptr=Prog;
  INSTORE[0].strlength=strlen(Prog);
  INSTORE[1].strptr=NULL;
  INSTORE[1].strlength=0;


  cout<<"Sample EDM/2 Rexx Demonstration Program Part 1"<<endl<<"by Gordon Zeglinski"<<endl;
  cout<<"Executing REXX programs via INSTORE parameter"<<endl;
  cout<<endl<<"INSTORE[1].strptr\t"<<(void*)INSTORE[1].strptr;
  cout<<endl<<"INSTORE[1].strlength\t"<<INSTORE[1].strlength<<endl;


  if(!strlen(Input))
     strcpy(Input,"RexxSamp.cmd");

  cout<<"Executing Sample Program "<<endl;
  cout<<"-----------------"<<endl;


  retstr.strptr=new char [1024];
  retstr.strlength=1024;

  return_code = RexxStart(0,             // No arguments
                        argv,            // dummy entry
                        Input,           // File name
                        INSTORE,         // InStore
                        "CMD",           // use the "CMD" command processor
                        RXCOMMAND,       // execute as a command
                        NULL,            // No exit handlers
                        &rc,             // return code from REXX routine
                        &retstr);        // return string from REXX routine

  delete [] retstr.strptr;

  cout<<"After Execution";
  cout<<endl<<"INSTORE[1].strptr\t"<<(void*)INSTORE[1].strptr;
  cout<<endl<<"INSTORE[1].strlength\t"<<INSTORE[1].strlength<<endl;

return 0;
}
