# This file is encoded in UTF-8.
die "This file is not encoded in UTF-8.\n" if 'あ' ne "\xe3\x81\x82";
die "This script is for perl only. You are using $^X.\n" if $^X =~ /jperl/i;

use strict;
use FindBin;
use lib "$FindBin::Bin/../lib";
use UTF8::R2 qw(*mb);
use vars qw(@test);

BEGIN {
    $SIG{__WARN__} = sub {
        local($_) = @_;
        /\AReplacement list is longer than search list at /             ? return :
        /\AUseless use of \/d modifier in transliteration operator at / ? return :
        warn $_[0];
    };
}

@test = (
##############################################################################
# 1
    sub { $_='AAA';             my $r=    $_ =~ tr/A/1/;          $r == 3                 },
    sub { $_='AAA';             my $r=    $_ =~ tr/A/1/;          $_ eq '111'             },
    sub { $_='AAA';             my $r=    $_ =~ tr/AA/12/;        $r == 3                 },
    sub { $_='AAA';             my $r=    $_ =~ tr/AA/12/;        $_ eq '111'             },
    sub { $_='AAA';             my $r=    $_ =~ tr/AAA/123/;      $r == 3                 },
    sub { $_='AAA';             my $r=    $_ =~ tr/AAA/123/;      $_ eq '111'             },
    sub { $_='AAABBBCCC';       my $r=    $_ =~ tr/AB/12/;        $r == 6                 },
    sub { $_='AAABBBCCC';       my $r=    $_ =~ tr/AB/12/;        $_ eq '111222CCC'       },
    sub { $_='ABCABCABC';       my $r=    $_ =~ tr/AB/12/;        $r == 6                 },
    sub { $_='ABCABCABC';       my $r=    $_ =~ tr/AB/12/;        $_ eq '12C12C12C'       },
# 11
    sub { $_='ABCABCABC';       my $r=    $_ =~ tr/AB/1/;         $r == 6                 },
    sub { $_='ABCABCABC';       my $r=    $_ =~ tr/AB/1/;         $_ eq '11C11C11C'       },
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
#-----------------------------------------------------------------------------
# 21
    sub { $_='AAA';             my $r=mb::tr($_,'A','1');          $r == 3                 },
    sub { $_='AAA';             my $r=mb::tr($_,'A','1');          $_ eq '111'             },
    sub { $_='AAA';             my $r=mb::tr($_,'AA','12');        $r == 3                 },
    sub { $_='AAA';             my $r=mb::tr($_,'AA','12');        $_ eq '111'             },
    sub { $_='AAA';             my $r=mb::tr($_,'AAA','123');      $r == 3                 },
    sub { $_='AAA';             my $r=mb::tr($_,'AAA','123');      $_ eq '111'             },
    sub { $_='AAABBBCCC';       my $r=mb::tr($_,'AB','12');        $r == 6                 },
    sub { $_='AAABBBCCC';       my $r=mb::tr($_,'AB','12');        $_ eq '111222CCC'       },
    sub { $_='ABCABCABC';       my $r=mb::tr($_,'AB','12');        $r == 6                 },
    sub { $_='ABCABCABC';       my $r=mb::tr($_,'AB','12');        $_ eq '12C12C12C'       },
# 31
    sub { $_='ABCABCABC';       my $r=mb::tr($_,'AB','1');         $r == 6                 },
    sub { $_='ABCABCABC';       my $r=mb::tr($_,'AB','1');         $_ eq '11C11C11C'       },
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
#-----------------------------------------------------------------------------
# 41
    sub { $_='ＡＡＡ';             my $r=mb::tr($_,'Ａ','１');         $r == 3                    },
    sub { $_='ＡＡＡ';             my $r=mb::tr($_,'Ａ','１');         $_ eq '１１１'             },
    sub { $_='ＡＡＡ';             my $r=mb::tr($_,'ＡＡ','１２');     $r == 3                    },
    sub { $_='ＡＡＡ';             my $r=mb::tr($_,'ＡＡ','１２');     $_ eq '１１１'             },
    sub { $_='ＡＡＡ';             my $r=mb::tr($_,'ＡＡＡ','１２３'); $r == 3                    },
    sub { $_='ＡＡＡ';             my $r=mb::tr($_,'ＡＡＡ','１２３'); $_ eq '１１１'             },
    sub { $_='ＡＡＡＢＢＢＣＣＣ'; my $r=mb::tr($_,'ＡＢ','１２');     $r == 6                    },
    sub { $_='ＡＡＡＢＢＢＣＣＣ'; my $r=mb::tr($_,'ＡＢ','１２');     $_ eq '１１１２２２ＣＣＣ' },
    sub { $_='ＡＢＣＡＢＣＡＢＣ'; my $r=mb::tr($_,'ＡＢ','１２');     $r == 6                    },
    sub { $_='ＡＢＣＡＢＣＡＢＣ'; my $r=mb::tr($_,'ＡＢ','１２');     $_ eq '１２Ｃ１２Ｃ１２Ｃ' },
# 51
    sub { $_='ＡＢＣＡＢＣＡＢＣ'; my $r=mb::tr($_,'ＡＢ','１');       $r == 6                    },
    sub { $_='ＡＢＣＡＢＣＡＢＣ'; my $r=mb::tr($_,'ＡＢ','１');       $_ eq '１１Ｃ１１Ｃ１１Ｃ' },
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
##############################################################################
# 61
    sub { $_='ABCABCABC';       my $r=    $_ =~ tr/AB/1/d;        $r == 6                 },
    sub { $_='ABCABCABC';       my $r=    $_ =~ tr/AB/1/d;        $_ eq '1C1C1C'          },
    sub { $_='ABCABCABC';       my $r=    $_ =~ tr/AB/1/s;        $r == 6                 },
    sub { $_='ABCABCABC';       my $r=    $_ =~ tr/AB/1/s;        $_ eq '1C1C1C'          },
    sub { $_='ABCABCABC';       my $r=    $_ =~ tr/AB/11/s;       $r == 6                 },
    sub { $_='ABCABCABC';       my $r=    $_ =~ tr/AB/11/s;       $_ eq '1C1C1C'          },
    sub { $_='ABCABCABC';       my $r=    $_ =~ tr/AB/1/ds;       $r == 6                 },
    sub { $_='ABCABCABC';       my $r=    $_ =~ tr/AB/1/ds;       $_ eq '1C1C1C'          },
    sub { $_='ABCABCABC';       my $r=    $_ =~ tr/AB/11/ds;      $r == 6                 },
    sub { $_='ABCABCABC';       my $r=    $_ =~ tr/AB/11/ds;      $_ eq '1C1C1C'          },
# 71
    sub { $_='ABCABCABC';       my $r=    $_ =~ tr/ABC/11/ds;     $r == 9                 },
    sub { $_='ABCABCABC';       my $r=    $_ =~ tr/ABC/11/ds;     $_ eq '1'               },
    sub { $_='ABCABCABC';       my $r=    $_ =~ tr/ABC/1/ds;      $r == 9                 },
    sub { $_='ABCABCABC';       my $r=    $_ =~ tr/ABC/1/ds;      $_ eq '1'               },
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
#-----------------------------------------------------------------------------
# 81
    sub { $_='ABCABCABC';       my $r=mb::tr($_,'AB','1','d');        $r == 6                 },
    sub { $_='ABCABCABC';       my $r=mb::tr($_,'AB','1','d');        $_ eq '1C1C1C'          },
    sub { $_='ABCABCABC';       my $r=mb::tr($_,'AB','1','s');        $r == 6                 },
    sub { $_='ABCABCABC';       my $r=mb::tr($_,'AB','1','s');        $_ eq '1C1C1C'          },
    sub { $_='ABCABCABC';       my $r=mb::tr($_,'AB','11','s');       $r == 6                 },
    sub { $_='ABCABCABC';       my $r=mb::tr($_,'AB','11','s');       $_ eq '1C1C1C'          },
    sub { $_='ABCABCABC';       my $r=mb::tr($_,'AB','1','ds');       $r == 6                 },
    sub { $_='ABCABCABC';       my $r=mb::tr($_,'AB','1','ds');       $_ eq '1C1C1C'          },
    sub { $_='ABCABCABC';       my $r=mb::tr($_,'AB','11','ds');      $r == 6                 },
    sub { $_='ABCABCABC';       my $r=mb::tr($_,'AB','11','ds');      $_ eq '1C1C1C'          },
# 91
    sub { $_='ABCABCABC';       my $r=mb::tr($_,'ABC','11','ds');     $r == 9                 },
    sub { $_='ABCABCABC';       my $r=mb::tr($_,'ABC','11','ds');     $_ eq '1'               },
    sub { $_='ABCABCABC';       my $r=mb::tr($_,'ABC','1','ds');      $r == 9                 },
    sub { $_='ABCABCABC';       my $r=mb::tr($_,'ABC','1','ds');      $_ eq '1'               },
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
#-----------------------------------------------------------------------------
# 101
    sub { $_='ＡＢＣＡＢＣＡＢＣ'; my $r=mb::tr($_,'ＡＢ','１','d');      $r == 6              },
    sub { $_='ＡＢＣＡＢＣＡＢＣ'; my $r=mb::tr($_,'ＡＢ','１','d');      $_ eq '１Ｃ１Ｃ１Ｃ' },
    sub { $_='ＡＢＣＡＢＣＡＢＣ'; my $r=mb::tr($_,'ＡＢ','１','s');      $r == 6              },
    sub { $_='ＡＢＣＡＢＣＡＢＣ'; my $r=mb::tr($_,'ＡＢ','１','s');      $_ eq '１Ｃ１Ｃ１Ｃ' },
    sub { $_='ＡＢＣＡＢＣＡＢＣ'; my $r=mb::tr($_,'ＡＢ','１１','s');    $r == 6              },
    sub { $_='ＡＢＣＡＢＣＡＢＣ'; my $r=mb::tr($_,'ＡＢ','１１','s');    $_ eq '１Ｃ１Ｃ１Ｃ' },
    sub { $_='ＡＢＣＡＢＣＡＢＣ'; my $r=mb::tr($_,'ＡＢ','１','ds');     $r == 6              },
    sub { $_='ＡＢＣＡＢＣＡＢＣ'; my $r=mb::tr($_,'ＡＢ','１','ds');     $_ eq '１Ｃ１Ｃ１Ｃ' },
    sub { $_='ＡＢＣＡＢＣＡＢＣ'; my $r=mb::tr($_,'ＡＢ','１１','ds');   $r == 6              },
    sub { $_='ＡＢＣＡＢＣＡＢＣ'; my $r=mb::tr($_,'ＡＢ','１１','ds');   $_ eq '１Ｃ１Ｃ１Ｃ' },
# 111
    sub { $_='ＡＢＣＡＢＣＡＢＣ'; my $r=mb::tr($_,'ＡＢＣ','１１','ds'); $r == 9              },
    sub { $_='ＡＢＣＡＢＣＡＢＣ'; my $r=mb::tr($_,'ＡＢＣ','１１','ds'); $_ eq '１'           },
    sub { $_='ＡＢＣＡＢＣＡＢＣ'; my $r=mb::tr($_,'ＡＢＣ','１','ds');   $r == 9              },
    sub { $_='ＡＢＣＡＢＣＡＢＣ'; my $r=mb::tr($_,'ＡＢＣ','１','ds');   $_ eq '１'           },
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
##############################################################################
# 121
    sub { $_='AAA';             my $r=    $_ =~ tr/A/1/c;         $r == 0                 },
    sub { $_='AAA';             my $r=    $_ =~ tr/A/1/c;         $_ eq 'AAA'             },
    sub { $_='AAA';             my $r=    $_ =~ tr/AA/12/c;       $r == 0                 },
    sub { $_='AAA';             my $r=    $_ =~ tr/AA/12/c;       $_ eq 'AAA'             },
    sub { $_='AAA';             my $r=    $_ =~ tr/AAA/123/c;     $r == 0                 },
    sub { $_='AAA';             my $r=    $_ =~ tr/AAA/123/c;     $_ eq 'AAA'             },
    sub { $_='AAABBBCCC';       my $r=    $_ =~ tr/AB/12/c;       $r == 3                 },
    sub { $_='AAABBBCCC';       my $r=    $_ =~ tr/AB/12/c;       $_ eq 'AAABBB222'       },
    sub { $_='ABCABCABC';       my $r=    $_ =~ tr/AB/12/c;       $r == 3                 },
    sub { $_='ABCABCABC';       my $r=    $_ =~ tr/AB/12/c;       $_ eq 'AB2AB2AB2'       },
# 131
    sub { $_='ABCABCABC';       my $r=    $_ =~ tr/AB/1/c;        $r == 3                 },
    sub { $_='ABCABCABC';       my $r=    $_ =~ tr/AB/1/c;        $_ eq 'AB1AB1AB1'       },
    sub { $_='ABCABCABC';       my $r=    $_ =~ tr/AB/1/cd;       $r == 3                 },
    sub { $_='ABCABCABC';       my $r=    $_ =~ tr/AB/1/cd;       $_ eq 'ABABAB'          },
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
#-----------------------------------------------------------------------------
# 141
    sub { $_='AAA';             my $r=mb::tr($_,'A','1','c');         $r == 0                 },
    sub { $_='AAA';             my $r=mb::tr($_,'A','1','c');         $_ eq 'AAA'             },
    sub { $_='AAA';             my $r=mb::tr($_,'AA','12','c');       $r == 0                 },
    sub { $_='AAA';             my $r=mb::tr($_,'AA','12','c');       $_ eq 'AAA'             },
    sub { $_='AAA';             my $r=mb::tr($_,'AAA','123','c');     $r == 0                 },
    sub { $_='AAA';             my $r=mb::tr($_,'AAA','123','c');     $_ eq 'AAA'             },
    sub { $_='AAABBBCCC';       my $r=mb::tr($_,'AB','12','c');       $r == 3                 },
    sub { $_='AAABBBCCC';       my $r=mb::tr($_,'AB','12','c');       $_ eq 'AAABBB222'       },
    sub { $_='ABCABCABC';       my $r=mb::tr($_,'AB','12','c');       $r == 3                 },
    sub { $_='ABCABCABC';       my $r=mb::tr($_,'AB','12','c');       $_ eq 'AB2AB2AB2'       },
# 151
    sub { $_='ABCABCABC';       my $r=mb::tr($_,'AB','1','c');        $r == 3                 },
    sub { $_='ABCABCABC';       my $r=mb::tr($_,'AB','1','c');        $_ eq 'AB1AB1AB1'       },
    sub { $_='ABCABCABC';       my $r=mb::tr($_,'AB','1','cd');       $r == 3                 },
    sub { $_='ABCABCABC';       my $r=mb::tr($_,'AB','1','cd');       $_ eq 'ABABAB'          },
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
#-----------------------------------------------------------------------------
# 161
    sub { $_='ＡＡＡ';             my $r=mb::tr($_,'Ａ','１','c');         $r == 0                    },
    sub { $_='ＡＡＡ';             my $r=mb::tr($_,'Ａ','１','c');         $_ eq 'ＡＡＡ'             },
    sub { $_='ＡＡＡ';             my $r=mb::tr($_,'ＡＡ','１２','c');     $r == 0                    },
    sub { $_='ＡＡＡ';             my $r=mb::tr($_,'ＡＡ','１２','c');     $_ eq 'ＡＡＡ'             },
    sub { $_='ＡＡＡ';             my $r=mb::tr($_,'ＡＡＡ','１２３','c'); $r == 0                    },
    sub { $_='ＡＡＡ';             my $r=mb::tr($_,'ＡＡＡ','１２３','c'); $_ eq 'ＡＡＡ'             },
    sub { $_='ＡＡＡＢＢＢＣＣＣ'; my $r=mb::tr($_,'ＡＢ','１２','c');     $r == 3                    },
    sub { $_='ＡＡＡＢＢＢＣＣＣ'; my $r=mb::tr($_,'ＡＢ','１２','c');     $_ eq 'ＡＡＡＢＢＢ２２２' },
    sub { $_='ＡＢＣＡＢＣＡＢＣ'; my $r=mb::tr($_,'ＡＢ','１２','c');     $r == 3                    },
    sub { $_='ＡＢＣＡＢＣＡＢＣ'; my $r=mb::tr($_,'ＡＢ','１２','c');     $_ eq 'ＡＢ２ＡＢ２ＡＢ２' },
# 171
    sub { $_='ＡＢＣＡＢＣＡＢＣ'; my $r=mb::tr($_,'ＡＢ','１','c');       $r == 3                    },
    sub { $_='ＡＢＣＡＢＣＡＢＣ'; my $r=mb::tr($_,'ＡＢ','１','c');       $_ eq 'ＡＢ１ＡＢ１ＡＢ１' },
    sub { $_='ＡＢＣＡＢＣＡＢＣ'; my $r=mb::tr($_,'ＡＢ','１','cd');      $r == 3                    },
    sub { $_='ＡＢＣＡＢＣＡＢＣ'; my $r=mb::tr($_,'ＡＢ','１','cd');      $_ eq 'ＡＢＡＢＡＢ'       },
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
##############################################################################
# 181
    sub { $_='ABCABCABC';       my $r=    $_ =~ tr/AB/1/cs;       $r == 3                 },
    sub { $_='ABCABCABC';       my $r=    $_ =~ tr/AB/1/cs;       $_ eq 'AB1AB1AB1'       },
    sub { $_='ABCABCABC';       my $r=    $_ =~ tr/AB/11/cs;      $r == 3                 },
    sub { $_='ABCABCABC';       my $r=    $_ =~ tr/AB/11/cs;      $_ eq 'AB1AB1AB1'       },
    sub { $_='ABCABCABC';       my $r=    $_ =~ tr/B/1/cds;       $r == 6                 },
    sub { $_='ABCABCABC';       my $r=    $_ =~ tr/B/1/cds;       $_ eq 'BBB'             },
    sub { $_='ABCABCABC';       my $r=    $_ =~ tr/B/12/cds;      $r == 6                 },
    sub { $_='ABCABCABC';       my $r=    $_ =~ tr/B/12/cds;      $_ eq 'BBB'             },
    sub { $_='ABCABCABC';       my $r=    $_ =~ tr/BC/11/cds;     $r == 3                 },
    sub { $_='ABCABCABC';       my $r=    $_ =~ tr/BC/11/cds;     $_ eq 'BCBCBC'          },
# 191
    sub { $_='ABCABCABC';       my $r=    $_ =~ tr/BC/1/cds;      $r == 3                 },
    sub { $_='ABCABCABC';       my $r=    $_ =~ tr/BC/1/cds;      $_ eq 'BCBCBC'          },
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
#-----------------------------------------------------------------------------
# 201
    sub { $_='ABCABCABC';       my $r=mb::tr($_,'AB','1','cs');       $r == 3                 },
    sub { $_='ABCABCABC';       my $r=mb::tr($_,'AB','1','cs');       $_ eq 'AB1AB1AB1'       },
    sub { $_='ABCABCABC';       my $r=mb::tr($_,'AB','11','cs');      $r == 3                 },
    sub { $_='ABCABCABC';       my $r=mb::tr($_,'AB','11','cs');      $_ eq 'AB1AB1AB1'       },
    sub { $_='ABCABCABC';       my $r=mb::tr($_,'B','1','cds');       $r == 6                 },
    sub { $_='ABCABCABC';       my $r=mb::tr($_,'B','1','cds');       $_ eq 'BBB'             },
    sub { $_='ABCABCABC';       my $r=mb::tr($_,'B','12','cds');      $r == 6                 },
    sub { $_='ABCABCABC';       my $r=mb::tr($_,'B','12','cds');      $_ eq 'BBB'             },
    sub { $_='ABCABCABC';       my $r=mb::tr($_,'BC','11','cds');     $r == 3                 },
    sub { $_='ABCABCABC';       my $r=mb::tr($_,'BC','11','cds');     $_ eq 'BCBCBC'          },
# 211
    sub { $_='ABCABCABC';       my $r=mb::tr($_,'BC','1','cds');      $r == 3                 },
    sub { $_='ABCABCABC';       my $r=mb::tr($_,'BC','1','cds');      $_ eq 'BCBCBC'          },
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
#-----------------------------------------------------------------------------
# 221
    sub { $_='ＡＢＣＡＢＣＡＢＣ'; my $r=mb::tr($_,'ＡＢ','１','cs');    $r == 3                    },
    sub { $_='ＡＢＣＡＢＣＡＢＣ'; my $r=mb::tr($_,'ＡＢ','１','cs');    $_ eq 'ＡＢ１ＡＢ１ＡＢ１' },
    sub { $_='ＡＢＣＡＢＣＡＢＣ'; my $r=mb::tr($_,'ＡＢ','１１','cs');  $r == 3                    },
    sub { $_='ＡＢＣＡＢＣＡＢＣ'; my $r=mb::tr($_,'ＡＢ','１１','cs');  $_ eq 'ＡＢ１ＡＢ１ＡＢ１' },
    sub { $_='ＡＢＣＡＢＣＡＢＣ'; my $r=mb::tr($_,'Ｂ','１','cds');     $r == 6                    },
    sub { $_='ＡＢＣＡＢＣＡＢＣ'; my $r=mb::tr($_,'Ｂ','１','cds');     $_ eq 'ＢＢＢ'             },
    sub { $_='ＡＢＣＡＢＣＡＢＣ'; my $r=mb::tr($_,'Ｂ','１２','cds');   $r == 6                    },
    sub { $_='ＡＢＣＡＢＣＡＢＣ'; my $r=mb::tr($_,'Ｂ','１２','cds');   $_ eq 'ＢＢＢ'             },
    sub { $_='ＡＢＣＡＢＣＡＢＣ'; my $r=mb::tr($_,'ＢＣ','１１','cds'); $r == 3                    },
    sub { $_='ＡＢＣＡＢＣＡＢＣ'; my $r=mb::tr($_,'ＢＣ','１１','cds'); $_ eq 'ＢＣＢＣＢＣ'       },
# 231
    sub { $_='ＡＢＣＡＢＣＡＢＣ'; my $r=mb::tr($_,'ＢＣ','１','cds');   $r == 3                    },
    sub { $_='ＡＢＣＡＢＣＡＢＣ'; my $r=mb::tr($_,'ＢＣ','１','cds');   $_ eq 'ＢＣＢＣＢＣ'       },
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
##############################################################################
# 241
    sub { ($] < 5.014) or eval q{ $_='AAA';             my $r=    $_ =~ tr/A/1/r;         $r eq '111'             }},
    sub { ($] < 5.014) or eval q{ $_='AAA';             my $r=    $_ =~ tr/AA/12/r;       $r eq '111'             }},
    sub { ($] < 5.014) or eval q{ $_='AAA';             my $r=    $_ =~ tr/AAA/123/r;     $r eq '111'             }},
    sub { ($] < 5.014) or eval q{ $_='AAABBBCCC';       my $r=    $_ =~ tr/AB/12/r;       $r eq '111222CCC'       }},
    sub { ($] < 5.014) or eval q{ $_='ABCABCABC';       my $r=    $_ =~ tr/AB/12/r;       $r eq '12C12C12C'       }},
    sub { ($] < 5.014) or eval q{ $_='ABCABCABC';       my $r=    $_ =~ tr/AB/1/r;        $r eq '11C11C11C'       }},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
# 251
    sub { ($] < 5.014) or eval q{ $_='ABCABCABC';       my $r=    $_ =~ tr/AB/1/dr;       $r eq '1C1C1C'          }},
    sub { ($] < 5.014) or eval q{ $_='ABCABCABC';       my $r=    $_ =~ tr/AB/1/sr;       $r eq '1C1C1C'          }},
    sub { ($] < 5.014) or eval q{ $_='ABCABCABC';       my $r=    $_ =~ tr/AB/11/sr;      $r eq '1C1C1C'          }},
    sub { ($] < 5.014) or eval q{ $_='ABCABCABC';       my $r=    $_ =~ tr/AB/1/dsr;      $r eq '1C1C1C'          }},
    sub { ($] < 5.014) or eval q{ $_='ABCABCABC';       my $r=    $_ =~ tr/AB/11/dsr;     $r eq '1C1C1C'          }},
    sub { ($] < 5.014) or eval q{ $_='ABCABCABC';       my $r=    $_ =~ tr/ABC/11/dsr;    $r eq '1'               }},
    sub { ($] < 5.014) or eval q{ $_='ABCABCABC';       my $r=    $_ =~ tr/ABC/1/dsr;     $r eq '1'               }},
    sub {1},
    sub {1},
    sub {1},
#-----------------------------------------------------------------------------
# 261
    sub { $_='AAA';             my $r=mb::tr($_,'A','1','r');         $r eq '111'             },
    sub { $_='AAA';             my $r=mb::tr($_,'AA','12','r');       $r eq '111'             },
    sub { $_='AAA';             my $r=mb::tr($_,'AAA','123','r');     $r eq '111'             },
    sub { $_='AAABBBCCC';       my $r=mb::tr($_,'AB','12','r');       $r eq '111222CCC'       },
    sub { $_='ABCABCABC';       my $r=mb::tr($_,'AB','12','r');       $r eq '12C12C12C'       },
    sub { $_='ABCABCABC';       my $r=mb::tr($_,'AB','1','r');        $r eq '11C11C11C'       },
    sub {1},
    sub {1},
    sub {1},
    sub {1},
# 271
    sub { $_='ABCABCABC';       my $r=mb::tr($_,'AB','1','dr');       $r eq '1C1C1C'          },
    sub { $_='ABCABCABC';       my $r=mb::tr($_,'AB','1','sr');       $r eq '1C1C1C'          },
    sub { $_='ABCABCABC';       my $r=mb::tr($_,'AB','11','sr');      $r eq '1C1C1C'          },
    sub { $_='ABCABCABC';       my $r=mb::tr($_,'AB','1','dsr');      $r eq '1C1C1C'          },
    sub { $_='ABCABCABC';       my $r=mb::tr($_,'AB','11','dsr');     $r eq '1C1C1C'          },
    sub { $_='ABCABCABC';       my $r=mb::tr($_,'ABC','11','dsr');    $r eq '1'               },
    sub { $_='ABCABCABC';       my $r=mb::tr($_,'ABC','1','dsr');     $r eq '1'               },
    sub {1},
    sub {1},
    sub {1},
#-----------------------------------------------------------------------------
# 281
    sub { $_='ＡＡＡ';             my $r=mb::tr($_,'Ａ','１','r');         $r eq '１１１'             },
    sub { $_='ＡＡＡ';             my $r=mb::tr($_,'ＡＡ','１２','r');     $r eq '１１１'             },
    sub { $_='ＡＡＡ';             my $r=mb::tr($_,'ＡＡＡ','１２３','r'); $r eq '１１１'             },
    sub { $_='ＡＡＡＢＢＢＣＣＣ'; my $r=mb::tr($_,'ＡＢ','１２','r');     $r eq '１１１２２２ＣＣＣ' },
    sub { $_='ＡＢＣＡＢＣＡＢＣ'; my $r=mb::tr($_,'ＡＢ','１２','r');     $r eq '１２Ｃ１２Ｃ１２Ｃ' },
    sub { $_='ＡＢＣＡＢＣＡＢＣ'; my $r=mb::tr($_,'ＡＢ','１','r');       $r eq '１１Ｃ１１Ｃ１１Ｃ' },
    sub {1},
    sub {1},
    sub {1},
    sub {1},
# 291
    sub { $_='ＡＢＣＡＢＣＡＢＣ'; my $r=mb::tr($_,'ＡＢ','１','dr');      $r eq '１Ｃ１Ｃ１Ｃ'       },
    sub { $_='ＡＢＣＡＢＣＡＢＣ'; my $r=mb::tr($_,'ＡＢ','１','sr');      $r eq '１Ｃ１Ｃ１Ｃ'       },
    sub { $_='ＡＢＣＡＢＣＡＢＣ'; my $r=mb::tr($_,'ＡＢ','１１','sr');    $r eq '１Ｃ１Ｃ１Ｃ'       },
    sub { $_='ＡＢＣＡＢＣＡＢＣ'; my $r=mb::tr($_,'ＡＢ','１','dsr');     $r eq '１Ｃ１Ｃ１Ｃ'       },
    sub { $_='ＡＢＣＡＢＣＡＢＣ'; my $r=mb::tr($_,'ＡＢ','１１','dsr');   $r eq '１Ｃ１Ｃ１Ｃ'       },
    sub { $_='ＡＢＣＡＢＣＡＢＣ'; my $r=mb::tr($_,'ＡＢＣ','１１','dsr'); $r eq '１'                 },
    sub { $_='ＡＢＣＡＢＣＡＢＣ'; my $r=mb::tr($_,'ＡＢＣ','１','dsr');   $r eq '１'                 },
    sub {1},
    sub {1},
    sub {1},
##############################################################################
# 301
    sub { ($] < 5.014) or eval q{ $_='AAA';             my $r=    $_ =~ tr/A/1/cr;        $r eq 'AAA'             }},
    sub { ($] < 5.014) or eval q{ $_='AAA';             my $r=    $_ =~ tr/AA/12/cr;      $r eq 'AAA'             }},
    sub { ($] < 5.014) or eval q{ $_='AAA';             my $r=    $_ =~ tr/AAA/123/cr;    $r eq 'AAA'             }},
    sub { ($] < 5.014) or eval q{ $_='AAABBBCCC';       my $r=    $_ =~ tr/AB/12/cr;      $r eq 'AAABBB222'       }},
    sub { ($] < 5.014) or eval q{ $_='ABCABCABC';       my $r=    $_ =~ tr/AB/12/cr;      $r eq 'AB2AB2AB2'       }},
    sub { ($] < 5.014) or eval q{ $_='ABCABCABC';       my $r=    $_ =~ tr/AB/1/cr;       $r eq 'AB1AB1AB1'       }},
    sub { ($] < 5.014) or eval q{ $_='ABCABCABC';       my $r=    $_ =~ tr/AB/1/cdr;      $r eq 'ABABAB'          }},
    sub {1},
    sub {1},
    sub {1},
# 311
    sub { ($] < 5.014) or eval q{ $_='ABCABCABC';       my $r=    $_ =~ tr/AB/1/csr;      $r eq 'AB1AB1AB1'       }},
    sub { ($] < 5.014) or eval q{ $_='ABCABCABC';       my $r=    $_ =~ tr/AB/11/csr;     $r eq 'AB1AB1AB1'       }},
    sub { ($] < 5.014) or eval q{ $_='ABCABCABC';       my $r=    $_ =~ tr/B/1/cdsr;      $r eq 'BBB'             }},
    sub { ($] < 5.014) or eval q{ $_='ABCABCABC';       my $r=    $_ =~ tr/B/11/cdsr;     $r eq 'BBB'             }},
    sub { ($] < 5.014) or eval q{ $_='ABCABCABC';       my $r=    $_ =~ tr/BC/11/cdsr;    $r eq 'BCBCBC'          }},
    sub { ($] < 5.014) or eval q{ $_='ABCABCABC';       my $r=    $_ =~ tr/BC/1/cdsr;     $r eq 'BCBCBC'          }},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
#-----------------------------------------------------------------------------
# 321
    sub { $_='AAA';             my $r=mb::tr($_,'A','1','cr');        $r eq 'AAA'             },
    sub { $_='AAA';             my $r=mb::tr($_,'AA','12','cr');      $r eq 'AAA'             },
    sub { $_='AAA';             my $r=mb::tr($_,'AAA','123','cr');    $r eq 'AAA'             },
    sub { $_='AAABBBCCC';       my $r=mb::tr($_,'AB','12','cr');      $r eq 'AAABBB222'       },
    sub { $_='ABCABCABC';       my $r=mb::tr($_,'AB','12','cr');      $r eq 'AB2AB2AB2'       },
    sub { $_='ABCABCABC';       my $r=mb::tr($_,'AB','1','cr');       $r eq 'AB1AB1AB1'       },
    sub {1},
    sub {1},
    sub {1},
    sub {1},
# 331
    sub { $_='ABCABCABC';       my $r=mb::tr($_,'AB','1','cdr');      $r eq 'ABABAB'          },
    sub { $_='ABCABCABC';       my $r=mb::tr($_,'AB','1','csr');      $r eq 'AB1AB1AB1'       },
    sub { $_='ABCABCABC';       my $r=mb::tr($_,'AB','11','csr');     $r eq 'AB1AB1AB1'       },
    sub { $_='ABCABCABC';       my $r=mb::tr($_,'B','1','cdsr');      $r eq 'BBB'             },
    sub { $_='ABCABCABC';       my $r=mb::tr($_,'B','11','cdsr');     $r eq 'BBB'             },
    sub { $_='ABCABCABC';       my $r=mb::tr($_,'BC','11','cdsr');    $r eq 'BCBCBC'          },
    sub { $_='ABCABCABC';       my $r=mb::tr($_,'BC','1','cdsr');     $r eq 'BCBCBC'          },
    sub {1},
    sub {1},
    sub {1},
#-----------------------------------------------------------------------------
# 341
    sub { $_='ＡＡＡ';             my $r=mb::tr($_,'Ａ','１','cr');         $r eq 'ＡＡＡ'             },
    sub { $_='ＡＡＡ';             my $r=mb::tr($_,'ＡＡ','１２','cr');     $r eq 'ＡＡＡ'             },
    sub { $_='ＡＡＡ';             my $r=mb::tr($_,'ＡＡＡ','１２３','cr'); $r eq 'ＡＡＡ'             },
    sub { $_='ＡＡＡＢＢＢＣＣＣ'; my $r=mb::tr($_,'ＡＢ','１２','cr');     $r eq 'ＡＡＡＢＢＢ２２２' },
    sub { $_='ＡＢＣＡＢＣＡＢＣ'; my $r=mb::tr($_,'ＡＢ','１２','cr');     $r eq 'ＡＢ２ＡＢ２ＡＢ２' },
    sub { $_='ＡＢＣＡＢＣＡＢＣ'; my $r=mb::tr($_,'ＡＢ','１','cr');       $r eq 'ＡＢ１ＡＢ１ＡＢ１' },
    sub {1},
    sub {1},
    sub {1},
    sub {1},
# 351
    sub { $_='ＡＢＣＡＢＣＡＢＣ'; my $r=mb::tr($_,'ＡＢ','１','cdr');      $r eq 'ＡＢＡＢＡＢ'       },
    sub { $_='ＡＢＣＡＢＣＡＢＣ'; my $r=mb::tr($_,'ＡＢ','１','csr');      $r eq 'ＡＢ１ＡＢ１ＡＢ１' },
    sub { $_='ＡＢＣＡＢＣＡＢＣ'; my $r=mb::tr($_,'ＡＢ','１１','csr');    $r eq 'ＡＢ１ＡＢ１ＡＢ１' },
    sub { $_='ＡＢＣＡＢＣＡＢＣ'; my $r=mb::tr($_,'Ｂ','１','cdsr');       $r eq 'ＢＢＢ'             },
    sub { $_='ＡＢＣＡＢＣＡＢＣ'; my $r=mb::tr($_,'Ｂ','１１','cdsr');     $r eq 'ＢＢＢ'             },
    sub { $_='ＡＢＣＡＢＣＡＢＣ'; my $r=mb::tr($_,'ＢＣ','１１','cdsr');   $r eq 'ＢＣＢＣＢＣ'       },
    sub { $_='ＡＢＣＡＢＣＡＢＣ'; my $r=mb::tr($_,'ＢＣ','１','cdsr');     $r eq 'ＢＣＢＣＢＣ'       },
    sub {1},
    sub {1},
    sub {1},
##############################################################################
# 361
    sub { $_='1AB';             my $r=    $_ =~ tr/AB/11/s;       $r == 2                 },
    sub { $_='1AB';             my $r=    $_ =~ tr/AB/11/s;       $_ eq '11'              },
    sub { $_='AB1';             my $r=    $_ =~ tr/AB/11/s;       $r == 2                 },
    sub { $_='AB1';             my $r=    $_ =~ tr/AB/11/s;       $_ eq '11'              },
    sub { $_='1AB1';            my $r=    $_ =~ tr/AB/11/s;       $r == 2                 },
    sub { $_='1AB1';            my $r=    $_ =~ tr/AB/11/s;       $_ eq '111'             },
    sub { $_='111';             my $r=    $_ =~ tr/AB/23/s;       $r == 0                 },
    sub { $_='111';             my $r=    $_ =~ tr/AB/23/s;       $_ eq '111'             },
    sub { $_='11AB';            my $r=    $_ =~ tr/AB/11/s;       $r == 2                 },
    sub { $_='11AB';            my $r=    $_ =~ tr/AB/11/s;       $_ eq '111'             },
# 371
    sub { $_='AB11';            my $r=    $_ =~ tr/AB/11/s;       $r == 2                 },
    sub { $_='AB11';            my $r=    $_ =~ tr/AB/11/s;       $_ eq '111'             },
    sub { $_='11AB11';          my $r=    $_ =~ tr/AB/11/s;       $r == 2                 },
    sub { $_='11AB11';          my $r=    $_ =~ tr/AB/11/s;       $_ eq '11111'           },
    sub { $_='ABAB';            my $r=    $_ =~ tr/AB/11/;        $r == 4                 },
    sub { $_='ABAB';            my $r=    $_ =~ tr/AB/11/;        $_ eq '1111'            },
    sub { $_='ABAB';            my $r=    $_ =~ tr/AB/11/s;       $r == 4                 },
    sub { $_='ABAB';            my $r=    $_ =~ tr/AB/11/s;       $_ eq '1'               },
    sub {1},
    sub {1},
#-----------------------------------------------------------------------------
# 381
    sub { $_='1AB';             my $r=mb::tr($_,'AB','11','s');       $r == 2                 },
    sub { $_='1AB';             my $r=mb::tr($_,'AB','11','s');       $_ eq '11'              },
    sub { $_='AB1';             my $r=mb::tr($_,'AB','11','s');       $r == 2                 },
    sub { $_='AB1';             my $r=mb::tr($_,'AB','11','s');       $_ eq '11'              },
    sub { $_='1AB1';            my $r=mb::tr($_,'AB','11','s');       $r == 2                 },
    sub { $_='1AB1';            my $r=mb::tr($_,'AB','11','s');       $_ eq '111'             },
    sub { $_='111';             my $r=mb::tr($_,'AB','23','s');       $r == 0                 },
    sub { $_='111';             my $r=mb::tr($_,'AB','23','s');       $_ eq '111'             },
    sub { $_='11AB';            my $r=mb::tr($_,'AB','11','s');       $r == 2                 },
    sub { $_='11AB';            my $r=mb::tr($_,'AB','11','s');       $_ eq '111'             },
# 391
    sub { $_='AB11';            my $r=mb::tr($_,'AB','11','s');       $r == 2                 },
    sub { $_='AB11';            my $r=mb::tr($_,'AB','11','s');       $_ eq '111'             },
    sub { $_='11AB11';          my $r=mb::tr($_,'AB','11','s');       $r == 2                 },
    sub { $_='11AB11';          my $r=mb::tr($_,'AB','11','s');       $_ eq '11111'           },
    sub { $_='ABAB';            my $r=mb::tr($_,'AB','11');           $r == 4                 },
    sub { $_='ABAB';            my $r=mb::tr($_,'AB','11');           $_ eq '1111'            },
    sub { $_='ABAB';            my $r=mb::tr($_,'AB','11','s');       $r == 4                 },
    sub { $_='ABAB';            my $r=mb::tr($_,'AB','11','s');       $_ eq '1'               },
    sub {1},
    sub {1},
#-----------------------------------------------------------------------------
# 401
    sub { $_='１ＡＢ';          my $r=mb::tr($_,'ＡＢ','１１','s');       $r == 2                 },
    sub { $_='１ＡＢ';          my $r=mb::tr($_,'ＡＢ','１１','s');       $_ eq '１１'            },
    sub { $_='ＡＢ１';          my $r=mb::tr($_,'ＡＢ','１１','s');       $r == 2                 },
    sub { $_='ＡＢ１';          my $r=mb::tr($_,'ＡＢ','１１','s');       $_ eq '１１'            },
    sub { $_='１ＡＢ１';        my $r=mb::tr($_,'ＡＢ','１１','s');       $r == 2                 },
    sub { $_='１ＡＢ１';        my $r=mb::tr($_,'ＡＢ','１１','s');       $_ eq '１１１'          },
    sub { $_='１１１';          my $r=mb::tr($_,'ＡＢ','２３','s');       $r == 0                 },
    sub { $_='１１１';          my $r=mb::tr($_,'ＡＢ','２３','s');       $_ eq '１１１'          },
    sub { $_='１１ＡＢ';        my $r=mb::tr($_,'ＡＢ','１１','s');       $r == 2                 },
    sub { $_='１１ＡＢ';        my $r=mb::tr($_,'ＡＢ','１１','s');       $_ eq '１１１'          },
# 411
    sub { $_='ＡＢ１１';        my $r=mb::tr($_,'ＡＢ','１１','s');       $r == 2                 },
    sub { $_='ＡＢ１１';        my $r=mb::tr($_,'ＡＢ','１１','s');       $_ eq '１１１'          },
    sub { $_='１１ＡＢ１１';    my $r=mb::tr($_,'ＡＢ','１１','s');       $r == 2                 },
    sub { $_='１１ＡＢ１１';    my $r=mb::tr($_,'ＡＢ','１１','s');       $_ eq '１１１１１'      },
    sub { $_='ＡＢＡＢ';        my $r=mb::tr($_,'ＡＢ','１１');           $r == 4                 },
    sub { $_='ＡＢＡＢ';        my $r=mb::tr($_,'ＡＢ','１１');           $_ eq '１１１１'        },
    sub { $_='ＡＢＡＢ';        my $r=mb::tr($_,'ＡＢ','１１','s');       $r == 4                 },
    sub { $_='ＡＢＡＢ';        my $r=mb::tr($_,'ＡＢ','１１','s');       $_ eq '１'              },
    sub {1},
    sub {1},
##############################################################################
# 421
    sub { $_='transliteratee';  my $r=    $_ =~ tr/aaret/1234/;   $_ eq '431nsli4431444'          },
    sub { $_='transliteratee';  my $r=    $_ =~ tr/aaret/1234/d;  $_ eq '31nsli43144'             },
    sub { $_='transliteratee';  my $r=    $_ =~ tr/aaret/1234/s;  $_ eq '431nsli4314'             },
    sub { $_='transliteratee';  my $r=    $_ =~ tr/aaret/1234/ds; $_ eq '31nsli4314'              },
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
#-----------------------------------------------------------------------------
# 431
    sub { $_='transliteratee';  my $r=mb::tr($_,'aaret','1234');      $_ eq '431nsli4431444'          },
    sub { $_='transliteratee';  my $r=mb::tr($_,'aaret','1234','d');  $_ eq '31nsli43144'             },
    sub { $_='transliteratee';  my $r=mb::tr($_,'aaret','1234','s');  $_ eq '431nsli4314'             },
    sub { $_='transliteratee';  my $r=mb::tr($_,'aaret','1234','ds'); $_ eq '31nsli4314'              },
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
#-----------------------------------------------------------------------------
# 441
    sub { $_='ｔｒａｎｓｌｉｔｅｒａｔｅｅ';  my $r=mb::tr($_,'ａａｒｅｔ','１２３４');      $_ eq '４３１ｎｓｌｉ４４３１４４４' },
    sub { $_='ｔｒａｎｓｌｉｔｅｒａｔｅｅ';  my $r=mb::tr($_,'ａａｒｅｔ','１２３４','d');  $_ eq '３１ｎｓｌｉ４３１４４'       },
    sub { $_='ｔｒａｎｓｌｉｔｅｒａｔｅｅ';  my $r=mb::tr($_,'ａａｒｅｔ','１２３４','s');  $_ eq '４３１ｎｓｌｉ４３１４'       },
    sub { $_='ｔｒａｎｓｌｉｔｅｒａｔｅｅ';  my $r=mb::tr($_,'ａａｒｅｔ','１２３４','ds'); $_ eq '３１ｎｓｌｉ４３１４'         },
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
##############################################################################
# 451
    sub { $_='transliteratee';  my $r=    $_ =~ tr/ae//;          $r == 5                        },
    sub { $_='transliteratee';  my $r=    $_ =~ tr/ae//;          $_ eq 'transliteratee'         },
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
#-----------------------------------------------------------------------------
# 461
    sub { $_='transliteratee';  my $r=mb::tr($_,'ae','');   $r == 5                        },
    sub { $_='transliteratee';  my $r=mb::tr($_,'ae','');   $_ eq 'transliteratee'         },
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
#-----------------------------------------------------------------------------
# 471
    sub { $_='ｔｒａｎｓｌｉｔｅｒａｔｅｅ';  my $r=mb::tr($_,'ａｅ','');   $r == 5                              },
    sub { $_='ｔｒａｎｓｌｉｔｅｒａｔｅｅ';  my $r=mb::tr($_,'ａｅ','');   $_ eq 'ｔｒａｎｓｌｉｔｅｒａｔｅｅ' },
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
##############################################################################
# 481
    sub { $_=qq{\a\b\e\f\n\r\t\053\cC};  my $r=    $_ =~ tr/\a\b\e\f\n\r\t\053\cC/ABCDEFGHI/;          $r == 9                         },
    sub { $_=qq{\a\b\e\f\n\r\t\053\cC};  my $r=    $_ =~ tr/\a\b\e\f\n\r\t\053\cC/ABCDEFGHI/;          $_ eq 'ABCDEFGHI'               },
    sub { $_=qq{ABCDEFGHI};              my $r=    $_ =~ tr/ABCDEFGHI/\a\b\e\f\n\r\t\053\cC/;          $r == 9                         },
    sub { $_=qq{ABCDEFGHI};              my $r=    $_ =~ tr/ABCDEFGHI/\a\b\e\f\n\r\t\053\cC/;          $_ eq qq{\a\b\e\f\n\r\t\053\cC} },
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
#-----------------------------------------------------------------------------
# 491
    sub { $_=qq{\a\b\e\f\n\r\t\053\cC};  my $r=mb::tr($_,qq{\a\b\e\f\n\r\t\053\cC},qq{ABCDEFGHI});          $r == 9                         },
    sub { $_=qq{\a\b\e\f\n\r\t\053\cC};  my $r=mb::tr($_,qq{\a\b\e\f\n\r\t\053\cC},qq{ABCDEFGHI});          $_ eq 'ABCDEFGHI'               },
    sub { $_=qq{ABCDEFGHI};              my $r=mb::tr($_,qq{ABCDEFGHI},qq{\a\b\e\f\n\r\t\053\cC});          $r == 9                         },
    sub { $_=qq{ABCDEFGHI};              my $r=mb::tr($_,qq{ABCDEFGHI},qq{\a\b\e\f\n\r\t\053\cC});          $_ eq qq{\a\b\e\f\n\r\t\053\cC} },
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
#-----------------------------------------------------------------------------
# 501
    sub { $_=qq{\a\b\e\f\n\r\t\053\cC};  my $r=mb::tr($_,qq{\a\b\e\f\n\r\t\053\cC},qq{ＡＢＣＤＥＦＧＨＩ});          $r == 9                         },
    sub { $_=qq{\a\b\e\f\n\r\t\053\cC};  my $r=mb::tr($_,qq{\a\b\e\f\n\r\t\053\cC},qq{ＡＢＣＤＥＦＧＨＩ});          $_ eq 'ＡＢＣＤＥＦＧＨＩ'      },
    sub { $_=qq{ＡＢＣＤＥＦＧＨＩ};     my $r=mb::tr($_,qq{ＡＢＣＤＥＦＧＨＩ},qq{\a\b\e\f\n\r\t\053\cC});          $r == 9                         },
    sub { $_=qq{ＡＢＣＤＥＦＧＨＩ};     my $r=mb::tr($_,qq{ＡＢＣＤＥＦＧＨＩ},qq{\a\b\e\f\n\r\t\053\cC});          $_ eq qq{\a\b\e\f\n\r\t\053\cC} },
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
##############################################################################
#
);

$|=1; print "1..",scalar(@test),"\n"; my $testno=1; sub ok { print $_[0]?'ok ':'not ok ',$testno++,$_[1]?" - $_[1]\n":"\n" } ok($_->()) for @test;

__END__
