#!/bin/sh

# panic: freevnode: cannot lock vp 0xfffffe01634e4de0 for pollinfo destroy
# cpuid = 7
# time = 1762875612
# KDB: stack backtrace:
# db_trace_self_wrapper() at db_trace_self_wrapper+0x2b/frame 0xfffffe00ffce8bd0
# vpanic() at vpanic+0x136/frame 0xfffffe00ffce8d00
# panic() at panic+0x43/frame 0xfffffe00ffce8d60
# freevnode() at freevnode+0x536/frame 0xfffffe00ffce8dc0
# vput_final() at vput_final+0x96/frame 0xfffffe00ffce8e10
# inotify_reap() at inotify_reap+0x6e/frame 0xfffffe00ffce8e40
# taskqueue_run_locked() at taskqueue_run_locked+0x1c2/frame 0xfffffe00ffce8ec0
# taskqueue_thread_loop() at taskqueue_thread_loop+0xd3/frame 0xfffffe00ffce8ef0
# fork_exit() at fork_exit+0x82/frame 0xfffffe00ffce8f30
# fork_trampoline() at fork_trampoline+0xe/frame 0xfffffe00ffce8f30
# --- trap 0, rip = 0, rsp = 0, rbp = 0 ---
# KDB: enter: panic
# [ thread pid 0 tid 100045 ]
# Stopped at      $0,0x12129d2(%rip)
# db> x/s version
# version: FreeBSD 16.0-CURRENT #0 main-n281796-e1c6f4cb9bd2-dirty: Tue Nov 11 10:53:40 CET 2025
# pho@mercat1.netperf.freebsd.org:/usr/src/sys/amd64/compile/PHO
# db> 

[ `id -u ` -ne 0 ] && echo "Must be root!" && exit 1

. ../default.cfg
set -u
prog=$(basename "$0" .sh)
cat > /tmp/$prog.c <<EOF
// https://syzkaller.appspot.com/bug?id=8a22955cd068cf454dd8062d24e826c72b1c4542
// autogenerated by syzkaller (https://github.com/google/syzkaller)
// syzbot+6676b3ff282d590b0fb3@syzkaller.appspotmail.com

#define _GNU_SOURCE

#include <sys/types.h>

#include <dirent.h>
#include <errno.h>
#include <pwd.h>
#include <setjmp.h>
#include <signal.h>
#include <stdarg.h>
#include <stdbool.h>
#include <stdint.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/endian.h>
#include <sys/stat.h>
#include <sys/syscall.h>
#include <sys/wait.h>
#include <time.h>
#include <unistd.h>

#ifndef SYS___specialfd
#define SYS___specialfd 577
#endif
#ifndef SYS_inotify_add_watch_at
#define SYS_inotify_add_watch_at 593
#endif

static __thread int clone_ongoing;
static __thread int skip_segv;
static __thread jmp_buf segv_env;

static void segv_handler(int sig, siginfo_t* info, void* ctx __unused)
{
  if (__atomic_load_n(&clone_ongoing, __ATOMIC_RELAXED) != 0) {
    exit(sig);
  }
  uintptr_t addr = (uintptr_t)info->si_addr;
  const uintptr_t prog_start = 1 << 20;
  const uintptr_t prog_end = 100 << 20;
  int skip = __atomic_load_n(&skip_segv, __ATOMIC_RELAXED) != 0;
  int valid = addr < prog_start || addr > prog_end;
  if (sig == SIGBUS)
    valid = 1;
  if (skip && valid) {
    _longjmp(segv_env, 1);
  }
  exit(sig);
}

static void install_segv_handler(void)
{
  struct sigaction sa;
  memset(&sa, 0, sizeof(sa));
  sa.sa_sigaction = segv_handler;
  sa.sa_flags = SA_NODEFER | SA_SIGINFO;
  sigaction(SIGSEGV, &sa, NULL);
  sigaction(SIGBUS, &sa, NULL);
}

#define NONFAILING(...)                                                        \
  ({                                                                           \
    int ok = 1;                                                                \
    __atomic_fetch_add(&skip_segv, 1, __ATOMIC_SEQ_CST);                       \
    if (_setjmp(segv_env) == 0) {                                              \
      __VA_ARGS__;                                                             \
    } else                                                                     \
      ok = 0;                                                                  \
    __atomic_fetch_sub(&skip_segv, 1, __ATOMIC_SEQ_CST);                       \
    ok;                                                                        \
  })

static void kill_and_wait(int pid, int* status)
{
  kill(pid, SIGKILL);
  while (waitpid(-1, status, 0) != pid) {
  }
}

static void sleep_ms(uint64_t ms)
{
  usleep(ms * 1000);
}

static uint64_t current_time_ms(void)
{
  struct timespec ts;
  if (clock_gettime(CLOCK_MONOTONIC, &ts))
    exit(1);
  return (uint64_t)ts.tv_sec * 1000 + (uint64_t)ts.tv_nsec / 1000000;
}

static void use_temporary_dir(void)
{
  char tmpdir_template[] = "./syzkaller.XXXXXX";
  char* tmpdir = mkdtemp(tmpdir_template);
  if (!tmpdir)
    exit(1);
  if (chmod(tmpdir, 0777))
    exit(1);
  if (chdir(tmpdir))
    exit(1);
}

static void reset_flags(const char* filename)
{
  struct stat st;
  if (lstat(filename, &st))
    exit(1);
  st.st_flags &= ~(SF_NOUNLINK | UF_NOUNLINK | SF_IMMUTABLE | UF_IMMUTABLE |
                   SF_APPEND | UF_APPEND);
  if (lchflags(filename, st.st_flags))
    exit(1);
}
static void __attribute__((noinline)) remove_dir(const char* dir)
{
  DIR* dp = opendir(dir);
  if (dp == NULL) {
    if (errno == EACCES) {
      if (rmdir(dir))
        exit(1);
      return;
    }
    exit(1);
  }
  struct dirent* ep = 0;
  while ((ep = readdir(dp))) {
    if (strcmp(ep->d_name, ".") == 0 || strcmp(ep->d_name, "..") == 0)
      continue;
    char filename[FILENAME_MAX];
    snprintf(filename, sizeof(filename), "%s/%s", dir, ep->d_name);
    struct stat st;
    if (lstat(filename, &st))
      exit(1);
    if (S_ISDIR(st.st_mode)) {
      remove_dir(filename);
      continue;
    }
    if (unlink(filename)) {
      if (errno == EPERM) {
        reset_flags(filename);
        reset_flags(dir);
        if (unlink(filename) == 0)
          continue;
      }
      exit(1);
    }
  }
  closedir(dp);
  while (rmdir(dir)) {
    if (errno == EPERM) {
      reset_flags(dir);
      if (rmdir(dir) == 0)
        break;
    }
    exit(1);
  }
}

static void execute_one(void);

#define WAIT_FLAGS 0

static void loop(void)
{
  int iter = 0;
  for (;; iter++) {
    char cwdbuf[32];
    sprintf(cwdbuf, "./%d", iter);
    if (mkdir(cwdbuf, 0777))
      exit(1);
    int pid = fork();
    if (pid < 0)
      exit(1);
    if (pid == 0) {
      if (chdir(cwdbuf))
        exit(1);
      execute_one();
      exit(0);
    }
    int status = 0;
    uint64_t start = current_time_ms();
    for (;;) {
      sleep_ms(10);
      if (waitpid(-1, &status, WNOHANG | WAIT_FLAGS) == pid)
        break;
      if (current_time_ms() - start < 5000)
        continue;
      kill_and_wait(pid, &status);
      break;
    }
    remove_dir(cwdbuf);
  }
}

uint64_t r[1] = {0xffffffffffffffff};

void execute_one(void)
{
  intptr_t res = 0;
  if (write(1, "executing program\n", sizeof("executing program\n") - 1)) {
  }
  //  openat\$evdev arguments: [
  //    fd: const = 0xffffffffffffff9c (8 bytes)
  //    file: ptr[in, buffer] {
  //      buffer: {2f 64 65 76 2f 69 6e 70 75 74 2f 65 76 65 6e 74 4e 00}
  //      (length 0x12)
  //    }
  //    flags: open_flags = 0x100 (8 bytes)
  //    mode: const = 0x0 (8 bytes)
  //  ]
  //  returns fd_evdev
  NONFAILING(memcpy((void*)0x200000000040, "/dev/input/eventN\000", 18));
  syscall(SYS_openat, /*fd=*/0xffffffffffffff9cul, /*file=*/0x200000000040ul,
          /*flags=O_NOFOLLOW*/ 0x100ul, /*mode=*/0ul);
  //  kqueue arguments: [
  //  ]
  //  returns kqueue
  syscall(SYS_kqueue);
  //  pipe2 arguments: [
  //    pipefd: ptr[out, pipefd] {
  //      pipefd {
  //        rfd: fd (resource)
  //        wfd: fd (resource)
  //      }
  //    }
  //    flags: pipe_flags = 0x0 (8 bytes)
  //  ]
  syscall(SYS_pipe2, /*pipefd=*/0x200000000480ul, /*flags=*/0ul);
  //  socket\$unix arguments: [
  //    domain: const = 0x1 (8 bytes)
  //    type: unix_socket_type = 0x5 (8 bytes)
  //    proto: const = 0x0 (1 bytes)
  //  ]
  //  returns sock_unix
  syscall(SYS_socket, /*domain=*/1ul, /*type=SOCK_SEQPACKET*/ 5ul, /*proto=*/0);
  //  kqueue arguments: [
  //  ]
  //  returns kqueue
  syscall(SYS_kqueue);
  //  mprotect arguments: [
  //    addr: VMA[0x2000]
  //    len: len = 0x2000 (8 bytes)
  //    prot: mmap_prot = 0x5 (8 bytes)
  //  ]
  syscall(SYS_mprotect, /*addr=*/0x200000000000ul, /*len=*/0x2000ul,
          /*prot=PROT_READ|PROT_EXEC*/ 5ul);
  //  symlink arguments: [
  //    old: ptr[in, buffer] {
  //      buffer: {2e 00} (length 0x2)
  //    }
  //    new: ptr[in, buffer] {
  //      buffer: {2e 2f 66 69 6c 65 30 00} (length 0x8)
  //    }
  //  ]
  NONFAILING(memcpy((void*)0x200000000000, ".\000", 2));
  NONFAILING(memcpy((void*)0x200000000040, "./file0\000", 8));
  syscall(SYS_symlink, /*old=*/0x200000000000ul, /*new=*/0x200000000040ul);
  //  __specialfd\$inotify arguments: [
  //    type: const = 0x2 (8 bytes)
  //    req: ptr[in, specialfd_inotify] {
  //      specialfd_inotify {
  //        flags: inotify_flags = 0x0 (4 bytes)
  //      }
  //    }
  //    len: len = 0x4 (8 bytes)
  //  ]
  //  returns fd_inotify
  NONFAILING(*(uint32_t*)0x200000000180 = 0);
  res = syscall(SYS___specialfd, /*type=*/2ul, /*req=*/0x200000000180ul,
                /*len=*/4ul);
  if (res != -1)
    r[0] = res;
  //  inotify_add_watch_at arguments: [
  //    fd: fd_inotify (resource)
  //    dfd: fd_dir (resource)
  //    file: ptr[in, buffer] {
  //      buffer: {2e 2f 66 69 6c 65 30 61 61 61 61 61 61 61 61 61 61 61 61 61
  //      61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61
  //      61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61
  //      61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61
  //      61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61
  //      61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61
  //      61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61
  //      61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61
  //      61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61
  //      61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61
  //      61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 2f 66
  //      69 6c 65 30 00} (length 0xff)
  //    }
  //    mask: inotify_mask = 0x82000204 (8 bytes)
  //  ]
  //  returns inotifydesc
  NONFAILING(
      memcpy((void*)0x200000000040,
             "./"
             "file0aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
             "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
             "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
             "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa/file0\000",
             255));
  syscall(SYS_inotify_add_watch_at, /*fd=*/r[0], /*dfd=*/(intptr_t)-1,
          /*file=*/0x200000000040ul,
          /*mask=IN_ONESHOT|IN_DONT_FOLLOW|IN_DELETE|IN_ATTRIB*/ 0x82000204ul);
  //  unlink arguments: [
  //    path: ptr[in, buffer] {
  //      buffer: {2e 2f 66 69 6c 65 30 00} (length 0x8)
  //    }
  //  ]
  NONFAILING(memcpy((void*)0x200000000040, "./file0\000", 8));
  syscall(SYS_unlink, /*path=*/0x200000000040ul);
}
int main(void)
{
  syscall(SYS_mmap, /*addr=*/0x200000000000ul, /*len=*/0x1000000ul,
          /*prot=PROT_WRITE|PROT_READ|PROT_EXEC*/ 7ul,
          /*flags=MAP_FIXED|MAP_ANONYMOUS|MAP_PRIVATE*/ 0x1012ul,
          /*fd=*/(intptr_t)-1, /*offset=*/0ul);
  const char* reason;
  (void)reason;
  install_segv_handler();
  use_temporary_dir();
  loop();
  return 0;
}
EOF
mycc -o /tmp/$prog -Wall -Wextra -O0 /tmp/$prog.c -lpthread || exit 1

(cd ../testcases/swap; ./swap -t 3m -i 30 -l 100 > /dev/null 2>&1) &
sleep 5

work=/tmp/$prog.dir
rm -rf $work
mkdir $work
cd /tmp/$prog.dir
for i in `jot 30`; do
	(
		mkdir d$i
		cd d$i
		timeout 3m /tmp/$prog > /dev/null 2>&1 &
	)
done
while pgrep -q $prog; do sleep 2; done
while pkill swap; do :; done
wait

rm -rf /tmp/$prog /tmp/$prog.c /tmp/$prog.core /tmp/syzkaller.?????? $work
exit 0
