.\"
.\" xarchie : X11 browser interface to archie
.\"
.\" George Ferguson, ferguson@cs.rochester.edu, 12 Nov 1991.
.\"
.TH XARCHIE 1 "12 Nov 1991"
.ds ]W U of Rochester
.SH NAME
xarchie \- X11 browser interface to archie
.SH SYNOPSIS
.na
.in +8n
.ti -8n
.I xarchie
[X\ Toolkit\ options]
[\-search\ type\ |\ \-cers]
[\-sort\ type\ |\ \-t]
[\-host\ host]
[\-maxHits\ num]
[\-offset\ num]
[\-nice lev\ |\ \-N\ lev]
[\-debug\ num\ |\ \-D\ num]
[\-expert ]
[\-help\ |\ -?]
.in -8n
.ad
.SH DESCRIPTION
.PP
.I Xarchie
is an X11 browser interface to the
.I Archie
network information service using the
.I Prospero
virtual filesystem protocol.
.I Archie
provides information about files available for ftp anywhere on the Internet;
.I xarchie
displays this information using an easy-to-use, point-and-click
interface.
.I Xarchie
is designed (like most X applications) to be highly customizable.
Almost all details of the interface, including display appearance and
command interface, can be customized using X resources.
.PP
Users should be aware that the
.I xarchie
client accesses a server that is shared with users on other hosts.  As
such, submitting long or large numbers of queries during peak periods
not only increases the time that they have to wait for a response, but
it increases the time that others have to wait too. Please read about
the
.B -nice
option, the
.B niceLevel
resource, and the "Nice Level" button on the Settings panel before
making large queries. Also, you should use the closest possible host
to save long-distance network traffic.
.PP
If you have any questions about
.I Archie
itself, write to archie-l@cs.mcgill.ca. If you have questions about
.IR Prospero ,
write to info-prospero@isi.edu.
.PP
When reporting bugs, problems, suggestions or contributions, please
be sure to send them to the right place. Issues dealing with the X
interface should be sent to George Ferguson (ferguson@cs.rochester.edu).
Brendan Kehoe (brendan@cs.widener.edu) is charge of the archie clients
and the network stuff underlying
.IR xarchie ,
Cliff Neuman (bcn@isi.edu) is in charge of Prospero, and Alan Emtage
(bajan@cs.mcgill.edu) and the others are in charge of the
.I Archie
service itself.
.SH USAGE
.PP
This section describes how to use
.I xarchie
in its default configuration.
Subsequent sections provide all the information needed to customize it to
your liking.
.SH "Command and Status Area"
.PP
.IR Xarchie 's
display is divided into three horizontal areas. The top pane is a
control panel. The "Quit" button exits
.IR xarchie
after prompting for confirmation (but see the
.B \-expert
option, below, or use Shift while clicking),
the "Query" button sends your search term (see below) to
.IR Archie ,
the "Abort" button allows to you to abort a long-running query,
and the "Settings" button pops up a panel from which you can change
various parameters of your queries. The buttons labelled "Search
Type", "Sort Type", and "Nice Level" allow you to modify aspects of
your search without using the Settings panel. Their use is described
below under "The Settings Panel".  The area labelled "Status" is
updated to reflect the progress of your query when one is progress.
The "Save" and "Ftp" buttons are described below under "Retrieving
Files".
.SH "Querying"
.PP
You enter your "search term" (the string or expression you want to
search for) in the appropriately labelled text item in the bottom
pane.  These text items provide emacs-like editing controls (see the
Athena widgets manual for a complete description). Hitting Return in
the text item or clicking on the top pane button labelled "Query" will
send your request to
.IR archie .
Entries matching your search term will be displayed in middle pane of
.IR xarchie 's
display, which functions as a host-location-file browser.
.PP
If you find that your query is taking too long, you can abort it by
clicking on the "Abort" button when it is sensitive. Your query will
be aborted as soon as possible. You should note that while aborting a
query will allow you to enter a new query, it does not currently
remove the query from the server's queue. Thus aborting queries does
not reduce the load on the server -- just the opposite probably. Use
with discretion, like the rest of the service.
.SH "The Browser"
.PP
The left-hand pane of the browser contains the names of hosts that have a
file matching your search term. Clicking on a hostname will highlight it
and cause the middle browser pane to be filled with a list of locations on
that host where files matching your search term can be found. The selected
hostname will also be displayed in the item labelled "Host" in the bottom
pane of the
.I xarchie
display. Similarly, selecting a location from the middle browser pane will
cause the right browser pane to be filled with a list of the files
available from the selected host in the selected location, and the location
will be displayed in the bottom pane item labelled "Location". Finally,
selecting a file from the right browser pane causes its name, size,
permission modes and last-modification date to be displayed in the
correspondingly-labelled bottom pane items. Clicking on a selected item
will unselect it and will clear any "lesser" panes and information items.
.PP
Note that if a browser pane has only one item, then that item will be
automatically selected and its "lesser" panes and information items filled
in. This saves time and effort in the common case where there is only one
host, location, or file that matches.
.SH "Retrieving Files"
The button labelled "Ftp" in the top
.I xarchie
pane lets you retrieve the file currently selected in the browser by
anonymous ftp. This service is presently quite rudimentary. You must
have selected a host, location, and file in the browser, and the
selection must not be a directory. The destination directory and mode
of the file transfer can be set on the Settings panel, described below.
This functionality will be improved in the near future.
.PP
To allow you to save the results of a query for later use, the button
labelled "Save" in the top pane causes
.I xarchie
to write a file containing the information currently displayed in the
browser. Clicking on this button prompts for the filename to save to,
then writes the file.  When clicked on with "Shift" held down, it uses
the current search term with ".lst" appended.  The format of the
output file is controlled by the
.B saveFormatOneLine
resource, and the operation is actually performed by the
.B save-to-file()
action. Both of these are described below. Judicious use of "Save"
will obviously help reduce the load on the
.I Archie
servers.
.SH "The Settings Panel"
.PP
The panel popped up by clicking on the "Settings" button in the top
.I xarchie
pane allows you to change the parameters of your queries to
.IR archie .
The "Search Mode" and "Sort Mode" items allow you to change how
.I archie
interprets your search term and how
.I xarchie
sorts the results, respectively.
Holding down a mouse button while the mouse cursor is in the item
displays a menu from which you can choose the desired search or sort
type. The label to the right of the item is updated to reflect the
choice. The item labelled "Host" similarly provides a menu of known
.I Archie
hosts. You should choose one appropriate to your site. In addition
however, you can enter an arbitrary hostname in the Text item next to
the "Host" item.  The other items on the Settings panel are Text items
that allow you to edit their values.  "Host" is what machine to
contact with the query, "Max Hits" is the limit on the number of
successful matches that will be returned, "Initial Timeout" is the
length of the first timeout interval in seconds, and "Retries" is the
number of times to retry the query if it times out, doubling the
timeout each retry.
.PP
The "Nice Level" item deserves special mention. As mentioned above,
.I Archie
servers run on machines that must be shared between other
.I Archie
users and even other "real" users. This item allows you to voluntarily
lower the priority of your request, just like the Unix(tm)
.I nice
command. The menu provides some recommended values and you can enter
arbitrary values in the text item. If you are searching with a large
number of matches requested, please increase your nice level.
Note that, like
.IR nice (1),
nicing a job does not mean your job won't affect others.
In particular, once your job begins it is not pre-empted, thus you
should still avoid long jobs during peak periods. You should
especially avoid queries for items of only personal interest (you know
what we mean) during these periods.
.PP
Clicking on the "Apply" button will apply the settings on the panel to
.IR xarchie .
Clicking on "Default" will reset the settings to the values they had
when
.I xarchie
started (but note that you will still have to apply them to have
them take effect). Clicking on "Done" closes the Settings panel. A
popup confirmer will appear if you did not apply your changes,
allowing you to discard the changes or go back and apply them. Note
that the "Apply" button is inactive until a change is made.
.PP
The menus available from the "Search Type", "Sort Type", and "Nice
Level" buttons on the
.I xarchie
top pane have effects corresponding to those of the buttons on the
Settings panel. However, they do not require that the "Apply" button
be clicked on to take effect, and do not affect the behaviour of the
"Done" button confirmer.
.PP
The functions of the items labelled "Local Ftp Directory" and "Ftp
Transfer Type" affect how files are retrieved, as described in the
previous section. The "Local Ftp Directory" item specifies the
directory on the local machine that you wish the retrieved file to end
up in. The "Ftp Transfer Type" item allows you to specify whether the
file should be retrieved in "ascii" or "binary" mode. (Actually, you
can enter whatever you want there, but I doubt that many other values
are meaningful). Note that since ftp support is so rudimentary, errors
resulting from incorrect values in these items will probably go
unreported, except that you won't get the file.
.SH OPTIONS
.PP
The following non-widget resources can be set from the command-line 
or in a resource file. As usual, when given on the command line they can be
abbreviated to their shortest unique prefix, often the first letter.
Furthermore
.I xarchie
accepts all the standard X Toolkit options (see
.IR X (1)).
.IP "\fB-search\fP type"
Sets the search mode for
.I archie
queries. The type can be one of
.IR exact ,
.IR substr ,
.IR subcase ,
.IR regexp ,
.IR exactSubstr ,
.IR exactSubcase ,
or
.IR exactRegexp .
The
.I exact
mode is fastest and returns files exactly matching your search term.
The
.I substr
and
.I subcase
modes return substring and case-sensitive substring matches
respectively (ie.,
.I substr
means case-insensitive). The
.I regexp
mode allows you to specify a regular expression to select files.
The
.I exact*
forms of these last three try an exact match first and then fall back
on the more costly search type if the exact match fails.
The default search mode is
.IR exact .
This option corresponds to the
.B searchType
resource.
.IP "\fB-e\fP"
Equivalent to "\fB-search exact\fP".
.IP "\fB-s\fP"
Equivalent to "\fB-search substr\fP".
.IP "\fB-c\fP"
Equivalent to "\fB-search subcase\fP".
.IP "\fB-r\fP"
Equivalent to "\fB-search regexp\fP".
.IP "\fB-es\fP"
Equivalent to "\fB-search exactSubstr\fP".
.IP "\fB-ec\fP"
Equivalent to "\fB-search exactSsubcase\fP".
.IP "\fB-er\fP"
Equivalent to "\fB-search exactRegexp\fP".
.IP "\fB-sort\fP type"
Sets the sort mode for displaying
.I archie
responses. The type can be one of
.I default
(sort by host and file name) or
.IR invdate ,
meaning "sort inverted by date".
This option corresponds to the
.B sortType
resource.
.IP "\fB-t\fP"
Equivalent to "\fB-sort invdate\fP".
.IP "\fB-host\fP host"
Sets the host to which
.I archie
queries will be sent. Please be careful to use the nearest possible
host.  The default is "archie.mcgill.ca". This option corresponds to
the
.B archieHost
resource.
.IP "\fB-maxHits\fP num"
Sets the maximum number of matches allowed per query. This option
corresponds to the
.B maxHits
resource.
.IP "\fB-offset\fP num"
Sets the offset of the Prospero query. This option corresponds to the
.B offset
resource.
.IP "\fB-nice\fP level or \fB-N\fP level"
Sets the query niceness level. Higher numbers are nicer, up to a
maximum niceness of 32765. The default niceness is 0. This option
corresponds to the
.B niceLevel
resource.
.IP "\fB-debug\fP level or \fB-D\fP level"
Sets the Prospero debugging level. Higher numbers mean more verbose
messages. For this option to have any effect,
.I xarchie
must have been compiled with the
.B \-DDEBUG
flag. This option corresponds to the
.B debugLevel
resource.
.IP "\fB-expert\fP"
Tells
.I xarchie
not to confirm operations like quitting. This option corresponds to
the
.B expert
resource.
.IP "\fB-help\fP or \fB-?\fP"
Prints the usage message summarizing
.I xarchie
options.
.SH "CUSTOMIZING XARCHIE"
.PP
.I Xarchie
has a default set of resources built in. If you wish to customize the
tool, take a copy of the default application defaults file (see
FILES below) and modify it. Then, before invoking
.IR xarchie ,
set the environment variable
.B XAPPLRESDIR
to the directory containing your private copy. Alternatively, you can place
entries in your .Xdefaults file or provide them with the
.B -xrm
toolkit option.
.SH "Non-Widget Resources"
.PP
Most of the following resources can also be set using the command-line
options described in the previous section.
.IP "\fBsearchType\fP"
Sets the search mode for
.I archie
queries. This can be one of
.IR exact ,
.IR substr ,
.IR subcase ,
or
.IR regexp .
The default search mode is
.IR exact .
This resource can be set with the
.B \-search
option, or its abbreviations
.BR \-e ,
.BR \-s ,
.BR \-c ,
.BR \-r ,
.BR \-es ,
.BR \-ec ,
or
.BR \-er ,
or on the Settings panel.
.IP "\fBsortType\fP"
Sets the sort mode for displaying
.I archie
responses. This can be one of
.I default
or
.IR invdate ,
meaning "sort inverted by date". This resource can be set with the
.B \-sort
option, or its abbreviation
.BR \-t ,
or on the Settings panel
.IP "\fBarchieHost\fP"
Sets the host to which
.I archie
queries will be sent. The default is "archie.mcgill.ca". Please be
careful to use the nearest possible host. This resource can be set
with the
.B \-host
option or on the Settings panel.
.IP "\fBmaxHits\fP"
Sets the maximum number of matches allowed per query. The default is 99.
This resource can be set with the
.B \-maxHits
option or on the Settings panel.
.IP "\fBoffset\fP"
Sets the Prospero offset. The default is 0.  This resource can be set
with the
.B \-offset
option or on the Settings panel.
.IP "\fBniceLevel\fP"
Sets the query niceness level. Higher numbers are nicer, up to a
maximum niceness of 32765. The default is 0. This resource can be set
with the
.B \-nice
option or on the Settings panel.
.IP "\fBdebugLevel\fP"
Sets the Prospero debugging level. Higher numbers mean more verbose
messages. For this option to have any effect,
.I xarchie
must have been compiled with the
.B \-DDEBUG
flag. This resource can be set with the
.B \-debug
or
.B \-D
options.
.IP "\fBexpert\fP"
Tells
.I xarchie
not to confirm operations like quitting. This resource can be set with
the
.B \-expert
option.
.IP "\fBtimeout\fP"
Sets the initial timeout value, in seconds. The default is 4. This
resource can be set on the Settings panel.
.IP "\fBretries\fP"
Sets the number of retries, where the timeout doubles every retry.
This resource can be set on the Settings panel.
.IP "\fBftpDir\fP"
Sets the local destination directory for ftp transfers. The
.B ftp()
action will use the "lcd" command to switch this directory before
retrieving the file.
This resource can be set on the Settings panel.
.IP "\fBftpType\fP"
Sets the transfer type for ftp transfers. The
.B ftp()
action will use the "type" command to set the transfer type before
retrieving the file.
This resource can be set on the Settings panel.
.IP "\fBsaveFormatOneLine\fP"
If True, then the file written by the
.B save-to-file()
action will have one line per entry, in the format
.ce
mode size date host:location/file
If False (the default), then the file format has hostnames starting at
the start of the line, location names indented one tab, and file
entries indented two tabs, all on separate lines. Hostnames and
locations are only printed once.  The latter is more readable, the
former may be more useful if the output is to be used by a program.
.IP "\fBwidgets\fP"
Specifies the widget hierarchy, as described below. This should be a
whitespace-separated list of
.ce
\fIparent\fP \fIClass\fP \fIname\fP
triples. Certain widgets must be created;
.I xarchie
will fail with an error message if they are not. These are described
in the next section.
.IP "\fBmenus\fP"
Due to problems with some versions of X, widgets of class EzMenu
must be created separately from the others. Thus any entries that
would normally go in the
.B widgets
resource with class EzMenu must instead be listed here. The format is
the same as for the
.B widgets
resource.
.IP "\fBsettingsWidgets\fP"
Specifies the widget hierarchy for the popup settings pane. These
widgets are not created until they are needed. The format is the same
as for the
.B widgets
resource.
.SH "Widget Hierarchy"
.PP
.I Xarchie
uses standard Athena widgets that can be customized as usual.
As mentioned above, even
.IR xarchie 's
widget hierarchy can be specified using resources, thus providing
complete control over widget creation and placement. The default
widget hierarchy, given by the
.B widgets
resource, is as follows:

.ta 8,12,16,20,24,28,32,36,40
.na
.nf
	TopLevelShell Xarchie
		Paned outerPaned
			Form buttonForm
				Command quitButton,queryButton
				Command abortButton
				Command saveButton,ftpButton
				Command searchButton,sortButton
				Command niceButton,settingButton
				Label,AsciiText status{Label,Text}
			Paned innerPaned
				Viewport hostView
					List hostList
				Viewport locView
					List locList
				Viewport fileView
					List fileList
			Form stringForm
				Label,AsciiText search{Label,Text}
				Label,AsciiText host{Label,Text}
				Label,AsciiText location{Label,Text}
				Label,AsciiText file{Label,Text}
				Label,AsciiText size{Label,Text}
				Label,AsciiText mode{Label,Text}
				Label,AsciiText date{Label,Text}
.fi
.ad

Note that this description of the widget hierarchy is condensed and
does not correspond to the explicit "parent Class name" format of the
hierarchy resources.
.PP
To describe these briefly,
.I outerPaned
controls the relative sizes of the three horizontal display areas while
.I innerPaned
allows the browser panels to be resized independently. Each browser panel
consists of a Viewport to allow it to scroll and a List to display the
entries. The three List widgets must be created with those names.
.PP
The default widget hierarchy creates several buttons across the top of
the top
.I xarchie
pane. All of these widgets are optional. The
.I quitButton
widget invokes the
.B quit()
action (see below) and exits the tool. The
.I queryButton
widget invokes the
.B query()
action and sends the current contents of
.I searchText
off to
.I archie .
The
.I abortButton
invokes the
.B abort()
action to interrupt the current query. (Note that
.I xarchie
looks for a widget with this name to sensitize and desensitize, so if
you want the button be active only during queries, be sure to create it
with this name.)
The
.I saveButton
widget invokes the
.B save-to-file()
action which writes the currently displayed results to a file.
Without "Shift", it prompts for the filename. With "Shift" it uses the
current search term with ".lst" appended.  The
.I ftpButton
invokes the
.B ftp()
action to fetch the selected file. The
.IR searchButton ,
.IR sortButton ,
and
.I niceButton
provide menus to set search parameters without using the Settings
panel. These specification of these menus is described below under
"EzMenus". The
.I settingsButton
widget invokes the
.B settings()
action to pop up the Settings panel. This panel uses the
following widget hierarchy, given by the
.B settingsWidget
resource:

.na
.nf
	TopLevelShell settingsShell
		Form settingsForm
			Command doneButton,applyButton,defaultButton
			MenuButton,Label search{Button,Label}
			MenuButton,Label sort{Button,Label}
			MenuButton,AsciiText host{Button,Text}
			Label,AsciiText maxHits{Label,Text}
			Label,AsciiText timeout{Label,Text}
			Label,AsciiText retries{Label,Text}
			MenuButton,AsciiText niceLevel{Button,Text}
			Label,AsciiText ftpDir{Label,Text}
			Label,AsciiText ftpType{Label,Text}
.fi
.ad

All the widgets on the Settings panel are optional. If they are not
created then the corresponding parameters will obviously not be
visible or changeable.
The
.I doneButton
invokes the
.B done\-settings()
action, the
.I applyButton
invokes
.BR apply\-settings() ,
and the
.I defaultButton
invokes
.BR default\-settings() .
While these Command widgets are optional, you will need some way
of invoking
.B apply\-settings()
if you want your changes to take effect.
The actions are described below.
The MenuButton widgets pop up menus described below under "EzMenus".
The remaining AsciiText widgets are used to display and edit the
corresponding parameters.
.PP
Returning to the main
.I xarchie
display, the
.I statusText
widget is updated during queries to show the progress (or lack
thereof) of the query. If this widget is not created, status updates
will not be done.  In the bottom pane, the
.I searchText
widget is used to enter the search term, and by default it binds Return
to the
.B query()
action to send the query to
.IR archie .
It must be created. Finally, all the other AsciiText items in the
.I stringForm
are used to display information about the current browser selection.
They are all optional; if they are not created the corresponding
information will not be displayed. In the future perhaps these will be
used for input also, to restrict searches or indicate other actions.
.SH "EzMenus"
The MenuButton widgets on both the main
.I xarchie
display and on the Settings panel use the EzMenu package to specify
their menus in resource files. The format of these resources is, for
example:

.nf
.na
    Xarchie*sortMenu.label:		Sort Mode
    Xarchie*sortMenu.menu:\e
	(line) \e
	(item "Default"	(action "set-sort-type(default)")) \e
	(item "Invdate"	(action "set-sort-type(invdate)"))
.ad
.fi

The label of the menu is given by the
.B label
resource and the menu specification by the
.B menu
resource.  Each menu entry is described by a parenthesized expression.
In this example, the first expression specifies an unselectable line,
like an
.IR SmeLineObject .
The other expressions specify items with their labels and the action
procedure to invoke when the item is selected. Entries are separated
by whitespace. Action procedures are described in the next section.
.PP
On the settings panel, the
.IR searchButton ,
.IR sortButton ,
.IR hostButton ,
and
.IR niceLevelButton
widgets each pop up menus that allow the searchType, sortType,
archieHost and niceLevel, respectively, to be changed.  When selected,
each item in the
.I searchMenu
invokes the
.B set\-search\-type()
action (see below) with the appropriate search type as argument.
Similarly, the items in the
.I sortMenu
invoke the
.B set\-sort\-type()
action, the items in the
.I hostMenu
invoke the
.B set\-host()
action, and the items in the
.I niceLevelMenu
invoke the
.B set\-nice\-level()
action.
These menus are children of their respective MenuButtons.
.PP
On the main
.I xarchie
top pane, the corresponding buttons pop up menus that invoke the
"-now" forms of these actions (see below), thereby removing the need
to "Apply" the changes.
.PP
Finally, three types of popup windows can appear. An Alert box signals
an error and blocks until clicked in, a Confirm box allows the user to
make a Yes/No decision, and a Dialog box allows the user to enter a
string. These have widget hierarchies:

.na
.nf
	TransientShell alertShell
		Dialog alertDialog
			Command okButton

	TransientShell confirmShell
		Dialog confirmDialog
			Command yesButton,noButton

	TransientShell dialogShell
		Dialog dialogDialog
			Command okButton,cancelButton
.fi
.ad
respectively.
.SH "Translation Actions"
.PP
The following action procedures are registered for
.I xarchie
and can be bound to widget events using the
.B translations
resource (see the Xt manual, Appendix C). The actions of the browser
widgets are hard-coded since they are so essential to correct behaviour.
They can however be bound to different events using the
.B notify()
action (that is, you could notify on some other event than mouse clicks).
.IP \fBquit()\fP
Exit
.IR xarchie .
Prompts for confirmation unless either an argument is passed to the
action procedure or the
.B expert
resource is True. By default this is called without arguments by
clicking on the "Quit" button (\fIquitButton\fP), and is called with
an argument to force exit if Shift-"Quit" is used.
.IP \fBquery()\fP
Send the current contents of the "Search Term" text widget
(\fIsearchText\fP) to
.IR xarchie .
By default this is performed by clicking on the "Query" button
(\fIqueryButton\fP).
.IP \fBabort()\fP
Aborts the current query at the soonest possible time. Has no effect
is a query is not currently being processed. By default, this is
performed by clicking on the "Abort" button (\fIabortButton\fP).
.IP \fBsave-to-file()\fP
Writes a file containing the information displayed in the browser.
With no arguments, this action prompts for the filename to write to.
With one argument, the argument is passed to
.IR sprintf (3)
together with the current search term to form the filename. By
default, the "Save" button invokes \fBsave-to-file()\fP to prompt for
the filename and Shift-"Save" invokes
\fBsave-to-file(\fP"%s.lst"\fB)\fP.
.IP \fBftp()\fP
Attempts to fetch the currently selected file by anonymous ftp. It is
currently an error if a file is not selected, and the selected file
must not refer to a directory.  By default this is performed by
clicking on the "Ftp" button (\fIftpButton\fP).
.IP \fBsettings()\fP
Pops up the Settings panel, and resets its values to those currently
in effect. Raises the Settings panel is it is already popped up. By
default this is performed by clicking on the "Settings" button
(\fIsettingsButton\fP).
.IP \fBapply-settings()\fP
Sets the current settings from the values on the Settings panel.
.IP \fBdefault-settings()\fP
Resets the values on the Settings panel to the default settings,
but does not affect the current settings until the
.B apply\-settings()
action is invoked.
.IP \fBdone-settings()\fP
Pops down the Settings panel. If there are changes that have not be
applied, then a popup confirm box allows the user to discard the
settings or go back and apply them.
.IP \fBset-search-type()\fP
This action sets the searchType as indicated on the Settings panel,
but does not affect the current settings until the
.B apply\-settings()
action is invoked.
.IP \fBset-search-type-now()\fP
Sets the searchType immediately without waiting for
.BR apply\-settings() .
.IP \fBset-sort-type()\fP
This action sets the sortType as indicated on the Settings panel,
but does not affect the current settings until the
.B apply\-settings()
action is invoked.
.IP \fBset-sort-type-now()\fP
Sets the sortType immediately without waiting for
.BR apply\-settings() .
.IP \fBset-host()\fP
This action sets the archieHost as indicated on the Settings panel,
but does not affect the current settings until the
.B apply\-settings()
action is invoked.
.IP \fBset-host-now()\fP
Sets the archieHost immediately without waiting for
.BR apply\-settings() .
.IP \fBset-nice-level()\fP
This action sets the niceLevel as indicated on the Settings panel,
but does not affect the current settings until the
.B apply\-settings()
action is invoked.
.IP \fBset-nice-level-now()\fP
Sets the niceLevel immediately without waiting for
.BR apply\-settings() .
.PP
\fBalert-ok()\fP
.br
\fBconfirm-yes()\fP
.br
\fBconfirm-no()\fP
.br
\fBdialog-ok()\fP
.br
\fBdialog-cancel()\fP
.in +\n(INu
These actions are registered for use with the Alert, Confirm, and
Dialog popups.  Registering them for widgets that are not popups will
at best have no effect.  These actions are invoked by default by the
buttons on the popups.  As well, by default pressing Return in a
Dialog popup's "value" sub-widget (where the value is entered) invokes
\fBdialog-ok()\fP.
.in
.SH ENVIRONMENT
.PP
XAPPLRESDIR	- Directory containing
.I xarchie
resource file
.SH FILES
.PP
$XAPPLRESDIR/Xarchie	- default
.I xarchie
resource file
.SH DIAGNOSTICS
.PP
.I Xarchie
indicates X errors using the ever-popular default X error handler that
prints a message and dies, possibly leaving a large core dump somewhere.
.PP
Errors due to incorrect resource specifications cause an error message on
stderr, but do not kill
.I xarchie
(usually).
.PP
Errors due to incorrect user commands or problems with the connection to
.I archie
result in a popup alert box being displayed. Clicking on the indicated
button in the alert box will make it go away and allow you to continue.
.SH BUGS
.PP
The current searchType, sortType, etc., are not indicated in the
menus. This is because the specification is so flexible that it's hard
to figure out which item to highlight.
.PP
The current ftp service is primitive. In particular,
.I xarchie
will not signal an error if the file is not found, since the ftp
sub-process itself did not signal an error upon termination. Rather, a
message will appear on stderr. This should improve as we redo the ftp
services.
.SH "SEE ALSO"
.PP
X(1),
archie(1),
ftp(1).
.SH AUTHOR
.PP
George Ferguson, University of Rochester,
.br
(ferguson@cs.rochester.edu)
.PP
Original standalone
.I archie
program by Brendan Kehoe,
.br
(brendan@cs.widener.edu).
.PP
Original Prospero
.I archie
program by Clifford Neuman,
.br
(bcn@isi.edu).
.PP
The
.I archie
service was conceived of and implemented by Alan Emtage
(bajan@cs.mcgill.ca), Peter Deutsch (peterd@expresso.cc.mcgill.ca),
and Bill Heelan (wheelan@cs.mcgill.ca).

