.\" $XConsortium: X386.man,v 1.3 91/08/26 15:31:19 gildea Exp $
.TH X386 1 "Release 5"  "X Version 11"
.SH NAME
X386 - X Window System server for UNIX System V/386
.SH SYNOPSIS
.B X386
[:displaynumber] [ option ] ...
.SH DESCRIPTION
.I X386
is the generic sample server for the X Window System, Version 11 Release 5
on i386 hardware.  It is normally started by the \fIxdm(1)\fP daemon or by
a script that runs the program \fIxinit(1)\fP such as \fIstartx\fP.

New extensions supported by \fIX386\fP in X11R5 include X3D-PEX
(PHIGS/+ Extension to X) and XTestExtension1 (Input Synthesis Extension).
.SH CONFIGURATIONS
.PP
.I X386
operates under ISC, SCO, ESIX & AT&T UNIX System V/3.2 and UHC, ESIX, Dell
& AT&T UNIX System V/4.0. The server supports the following popular
SuperVGA boards in 256 color mode:
.sp
.ta 3.5i +1.2i
.nf
SuperVGA Cards	Max Res 	ChipSet
--------------------------------	--------	-------
Compuadd Hi-Rez card w/1meg	1024x768	ET4000
Diamond SpeedStar	1024x768	ET4000
EIZO MD-10	800x600	ET3000
GENOA 5300/5400	800x600	ET3000
GENOA 6400	800x600	GVGA
Optima Mega/1024	1024x768	ET4000
Orchid ProDesigner	800x600	ET3000
Orchid ProDesigner II/1024	1024x768	ET4000
Paradise VGA Professional	640x480	PVGA1A
Paradise VGA 1024	640x480	WD90C00
Sigma Legend	1024x768	ET4000
STB PowerGraph w/1meg	1024x768	ET4000
Swan SVGA equipped with VCO chip	1024x768	ET4000
TRICOM Mega/1024	1024x768	ET4000
.fi
.sp
The core X11R5 source tree as supplied in the public release was compiled and
tested under ISC 2.2.1 (UNIX System V/3.2), Dell and AT&T UNIX System V/4.0.

.SH "NETWORK CONNECTIONS"
\fIX386\fP supports connections made using the following reliable
byte-streams:
.TP 4
.I "Unix Domain"
\fIX386\fP uses \fI/tmp/.X11-unix/X\fBn\fR as the filename for the socket,
where \fIn\fP is the display number, (SVR4).
.TP 4
.I TCP\/IP
.br
\fIX386\fP listens on port htons(6000+\fIn\fP), where \fIn\fP is the display
number, (SVR3 and SVR4).
.SH OPTIONS
See the command line switches described in the \fIXserver(1)\fP manual page.
\fIX386\fP does not accept any additional switches.
.SH "KEYBOARD"
Multiple key presses recognized directly by \fIX386\fP are:
.TP 8
.B Ctrl+Alt+Backspace
Immediately kills the server -- no questions asked.  (Can be disabled by
specifying "dontzap" in the configuration file.)
.TP 8
.B Ctrl+Alt+Keypad-Plus
Change video mode to next one specified in the configuration file,
(increasing video resolution order).
.TP 8
.B Ctrl+Alt+Keypad-Minus
Change video mode to previous one specified in the configuration file,
(decreasing video resolution order).
.SH SETUP
.I
X386
uses the configuration file /usr/X386/Xconfig for its initial setup.
This file is composed of the following sections:
.sp
.in 8
.nf
General Server Parameters
Keyboard Configuration
Mouse Configuration
Video Mode Setup
Table of Known Video Modes
.fi
.in -8
.PP
The \fBGeneral Server Parameters\fP section lets you adjust some generic server
parameter which seldom change for a given site.  (The \fBfontpath\fP
parameter can also be set from the command line, see \fIXserver(1)\fP.):
.TP 8
.B fontpath
sets the search path for fonts.  This path is a comma separated list of
directories which the sample server searches for font databases.
.TP 8
.B rgbpath
sets the name of RGB color database.
.PP
The \fBKeyboard Configuration\fP section starts with a keyword describing
which kind of driver should be used:  \fBkeyboard\fP (the normal device) or 
\fBxqueue\fP (the eventque driver).  Note that the latter one exists only for
compatibility with older releases and shouldn't be used.  Following this 
keyword the following options can be specified:
.TP 8
.B autorepeat \fIdelay rate\fP
changes the behavior of the autorepeat of the keyboard.
.TP 8
.B dontzap
disallows the use of the \fBCtrl+Alt+Backspace\fP sequence.  This sequence
allows you to terminate the server.
.TP 8
.B servernum
forces the server to handle the numlock key internally.  The server sends
virtual key-events so applications can use the numberpad.
.TP 8
.B xleds \fIled\fP ...
makes \fIled\fP available for clients instead of using the traditional function
(Scroll Lock, Caps Lock & Num Lock)
.PP
Similar to above, the \fBMouse Configuration\fP section starts with a special
keyword, but here we must select the type of mouse (i.e. it's protocol) that
is connected to the computer.  (Using the \fIxqueue\fP driver this section is
obsolete since mouse I/O is handled by the xqueue-driver.)  The mouse types
available are:
.sp
.in 8
.nf
.B busmouse
.B logitech
.B microsoft
.B mmseries
.B mouseman
.B mousesystems
.fi
.in -8
.PP
(One should specify \fBbusmouse\fP for the Logitech bus mouse.)
.PP
The following options can be specified after this keyword:
.TP 8
.B baudrate \fIrate\fP
sets the baudrate of the serial mouse to \fIrate\fP. For mice that allow
dynamic speed adjustments (like logitech) the baudrate is changed in the mouse.
Otherwise the rate is simply set on the computer's side to allow mice with
non-standard rates.
.TP 8
.B emulate3buttons
enables the emulation of the third mouse button for mice which only have
two physical buttons.  The third button is emulated by pressing both
buttons simultaneously.
.TP 8
.B samplerate \fIrate\fP
sets the number of motion/button-events the mouse sends per second. This is
currently only supported for logitech mice.
.PP
The \fBGraphics Driver Setup\fP section starts with the keyword \fBvga256\fP.
After this keyword a variety of options may be specified:
.TP 8 
.B staticgray,grayscale,staticcolor,pseudocolor,truecolor,directcolor
sets the visual class for the root window of the screen.
.TP 8
.B chipset  \fI"name"\fP
specifies a chipset so the correct driver can be used.  Possible chipsets are:
.sp
.in 20
.nf
et3000
et4000
gvga
pvga
.fi
.in -20
.TP 8
.B clocks \fIclock\fP  ...
specifies the dotclocks that are on your graphics board.
.TP 8
.B displaysize \fIxdim\fP \fIydim\fP
sets the display size (internal) to \fIxdim\fP x \fIydim\fP (measured in mm).
.TP 8
.B modes \fI"mode"\fP ...
selects the display modes for this screen.  The first one in the list will
be the default display mode for startup.  Internally this list is converted
into a circular list.  With \fBCtrl+Alt+Keypad-Plus\fP and
\fBCtrl+Alt+Keypad-Minus\fP the current display mode may be changed, and
the next (upward/downward) entry in the list will be used.
.TP 8
.B vendor \fI"vendorstring"\fP
allows the server to select a special behavior for *special* hardware.
Currently the following strings are recognized:
.sp
.in 20
.nf
legend
.fi
.in -20
.TP 8
.B videoram \fImem\fP
specifies the amount of videoram that is installed on the graphics board. This
is measured in kBytes.
.TP 8
.B viewport \fIx0\fP \fIy0\fP
sets the upper left corner of the initial display.  If the virtual
resolution is larger than what is physically displayed, then the initial
display will be centered if \fBviewport\fP is not specified.
.TP 8
.B virtual \fIxdim\fP \fIydim\fP
sets the virtual resolution. For example one might use a display with 800x600,
but a virtual resolution of 1152x900. If the mouse touches the borders of the
display the image scrolls accordingly. This is called panning.
.PP
Note that \fIX386\fP has some internal capabilities to determine what hardware
it is running on. Thus normally the keywords \fIchipset\fP, \fIclocks\fP,
\fIvendor\fP and \fIvideoram\fP don't have to be specified.  But there
may be occasions when this autodetection mechanism fails, (for example, too
high of load on the machine when you start the server).  For cases like this,
one should first run \fIX386\fP on an unloaded machine, look at the
results of the autodetection (that are printed out during server startup)
and then explicitly specify these parameters in the configuration file.
.PP
The last section is the \fBTable of Video Modes\fP which starts with the
keyword \fBmodedb\fP.  A list of possible mode-records follows this keyword.
For every mode string in the previously specified \fBmodes\fP line, the server
scans the list of mode-records looking for a matching \fImodename\fP.  When a
match occurs, then the \fIdotclock\fP value is compared to those found on
the graphics board.  If the \fIdotclock\fP value matches, then the rest
of the values in the mode-record will be used for that display mode.  If
there is more than one matching mode-record (for a given \fImodename\fP and
\fIdotclock\fP), then the last one matched will be used.

A mode-record consists of seven parts:
.TP 8
.I modename
is the string that identifies this mode. If one is not specified, then the
\fImodename\fP string of the last valid mode-record is used.
.TP 8
.I dotclock
is the dotclock this mode uses. This is the basic timer for all video signals.
.TP 8
.I hdisp, hsyncstart, hsyncend, htotal
is the horizontal timing
.TP 8
.I vdisp, vsyncstart, vsyncend, vtotal
is the vertical timing
.TP 8
.B interlace
sets interlace display mode.
.TP 8
.B +hsync, -hsync
selects polarity of HSYNC signal
.TP 8
.B +vsync, -vsync
selects polarity of VSYNC signal
.PP
For details on how to build your own video modes please refer to the tutorial
written by Chin Fang.
.PP
A sample config file might look like this:
.sp
.in 10
\fB
.nf
RGBPath         "/usr/X386/lib/X11/rgb"
FontPath        "/usr/X386/lib/X11/fonts/misc/,:zok:7000"

Keyboard
  AutoRepeat 500 5
  Xleds      1 2 3
  ServerNumLock
  DontZap

Logitech	"/dev/tty00"
  BaudRate	9600
  SampleRate	150
  Emulate3Buttons

vga256
  Chipset       "et4000"
  Vendor        "legend"
  Clocks        25 28 36 62
  Virtual       1152 900
  ViewPort      0 0
  Modes         "1024x768" "640x480"

ModeDB
 "640x480"   25     640  672  768  800    480  490  492  525
             28     640  672  768  800    480  490  492  525
 "1024x768"  62    1024 1092 1220 1344    768  786  791  810
.fi
\fP
.in -10
Note that a new feature of X11R5 is the ability of the X server to
request fonts from a \fIfont server\fP.  One specifies a \fIfont
server\fP by placing a ":<hostname>:<tcp_port_number>" into the fontpath.
In the above example, the fontpath "/usr/X386/lib/X11/fonts/misc/,:zok:7000"
tells \fIX386\fP to first try to locate the font in the local directory
/usr/X386/lib/X11/fonts/misc.  If that fails, then request the font from
the \fIfont server\fP running on machine zok listening for connections on
TCP port number 7000.

.SH FILES
.TP 30
/usr/X386/bin/X386
The X server
.TP 30
/usr/X386/lib/X11/Xconfig
Server configuration file
.TP 30
/usr/X386/lib/X11/etc
Additional \fIX386\fP support files
.TP 30
/usr/X386/bin/*
Client binaries
.TP 30
/usr/X386/include/*
Header files
.TP 30
/usr/X386/lib/*
Libraries
.TP 30
/usr/X386/lib/X11/fonts/*
Fonts
.TP 30
/usr/X386/lib/X11/rgb.{dir,pag,txt}
Color names to RGB mapping
.TP 30
/usr/X386/lib/X11/XErrorDB
Client error message database
.TP 30
/usr/X386//lib/X11/app-defaults/*
Client resource specifications
.TP 30
/usr/X386/man/man?/*
Manual pages
.TP 30
/etc/X0.hosts
Initial access control list
.SH "SEE ALSO"
X(1), Xserver(1), xdm(1), xinit(1)
.SH BUGS
Starting clients while on another virtual screen may destroy the contents
of the original screen or may even kill the server. The workaround is to use
\fIxrefresh(1)\fP to refresh the screen.
.SH AUTHORS
.TP 8
Thomas Roell,      \fIroell@informatik.tu-muenchen.de\fP
TU-Muenchen:  Server and SVR4 stuff
.TP 8
Mark W. Snitily,   \fImark@zok.sgcs.com\fP
SGCS:  SVR3 support, X Consortium Sponsor
.PP
 ... and many more people out there on the net who helped with ideas and
bug-fixes.

\fIX386\fP X11R5 source and binaries are available from SGCS.
Send email to \fImark@zok.sgcs.com\fP or \fI...!mips!zok!mark\fP
for details.
